/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import com.razorpay.RazorpayException;
import com.razorpay.ValidationConfig;
import com.razorpay.ValidationType;
import java.util.Arrays;
import java.util.List;
import org.json.JSONObject;

public class PayloadValidator {
    public void validate(JSONObject request, List<ValidationConfig> validationConfig) throws RazorpayException {
        for (ValidationConfig config : validationConfig) {
            String fieldName = config.getFieldName();
            for (ValidationType validationType : config.getValidations()) {
                this.applyValidation(request, fieldName, validationType);
            }
        }
    }

    private void applyValidation(JSONObject payload, String field, ValidationType validationType) throws RazorpayException {
        switch (validationType) {
            case NON_NULL: {
                this.validateNonNull(payload, field);
                break;
            }
            case NON_EMPTY_STRING: {
                this.validateNonEmptyString(payload, field);
                break;
            }
            case URL: {
                this.validateUrl(payload, field);
                break;
            }
            case ID: {
                this.validateID(payload, field);
                break;
            }
            case MODE: {
                this.validateMode(payload, field);
                break;
            }
            case TOKEN_GRANT: {
                this.validateGrantType(payload, field);
            }
        }
    }

    private void validateMode(JSONObject payload, String field) throws RazorpayException {
        this.validateNonNull(payload, field);
        String mode = payload.getString(field);
        if (!Arrays.asList("test", "live").contains(mode)) {
            String errorMessage = "Invalid value provided for field %s";
            throw new RazorpayException(String.format(errorMessage, field));
        }
    }

    private void validateNonNull(JSONObject payload, String field) throws RazorpayException {
        if (!payload.has(field) || payload.isNull(field)) {
            String errorMessage = "Field %s cannot be null";
            throw new RazorpayException(String.format(errorMessage, field));
        }
    }

    private void validateNonEmptyString(JSONObject payload, String field) throws RazorpayException {
        if (payload.optString(field).trim().isEmpty()) {
            String errorMessage = "Field %s cannot be empty";
            throw new RazorpayException(String.format(errorMessage, field));
        }
    }

    private void validateUrl(JSONObject payload, String field) throws RazorpayException {
        String urlRegex;
        String url = payload.optString(field);
        if (!url.matches(urlRegex = "^(http[s]?):\\/\\/[^\\s/$.?#].[^\\s]*$")) {
            String errorMessage = "Field %s is not a valid URL";
            throw new RazorpayException(String.format(errorMessage, field));
        }
    }

    private void validateID(JSONObject payload, String field) throws RazorpayException {
        this.validateNonNull(payload, field);
        this.validateNonEmptyString(payload, field);
        String value = payload.getString(field);
        String idRegex = "[A-Za-z0-9]{1,14}";
        if (!value.matches(idRegex)) {
            String errorMessage = "Field %s is not a valid ID";
            throw new RazorpayException(String.format(errorMessage, field));
        }
    }

    private void validateGrantType(JSONObject payload, String field) throws RazorpayException {
        String grantType;
        this.validateNonNull(payload, field);
        switch (grantType = payload.getString(field)) {
            case "authorization_code": {
                this.validateNonNull(payload, "code");
                break;
            }
            case "refresh_token": {
                this.validateNonNull(payload, "refresh_token");
                break;
            }
        }
    }
}

