/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import com.razorpay.ApiUtils;
import com.razorpay.Entity;
import com.razorpay.RazorpayException;
import java.io.IOException;
import java.util.ArrayList;
import okhttp3.Response;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ApiClient {
    private String auth;
    private final String ENTITY = "entity";
    private final String COLLECTION = "collection";
    private final String ERROR = "error";
    private final String DESCRIPTION = "description";
    private final String STATUS_CODE = "code";
    private final int STATUS_OK = 200;
    private final int STATUS_MULTIPLE_CHOICE = 300;

    ApiClient(String auth) {
        this.auth = auth;
    }

    <T extends Entity> T get(String path, JSONObject requestObject) throws RazorpayException {
        Response response = ApiUtils.getRequest(path, requestObject, this.auth);
        return this.processResponse(response);
    }

    <T extends Entity> T post(String path, JSONObject requestObject) throws RazorpayException {
        Response response = ApiUtils.postRequest(path, requestObject, this.auth);
        return this.processResponse(response);
    }

    <T extends Entity> T put(String path, JSONObject requestObject) throws RazorpayException {
        Response response = ApiUtils.putRequest(path, requestObject, this.auth);
        return this.processResponse(response);
    }

    <T extends Entity> ArrayList<T> getCollection(String path, JSONObject requestObject) throws RazorpayException {
        Response response = ApiUtils.getRequest(path, requestObject, this.auth);
        return this.processCollectionResponse(response);
    }

    private <T extends Entity> T parseResponse(JSONObject jsonObject) throws RazorpayException {
        if (jsonObject.has("entity")) {
            Class cls = this.getClass(jsonObject.getString("entity"));
            try {
                return (T)((Entity)cls.getConstructor(JSONObject.class).newInstance(jsonObject));
            }
            catch (Exception e) {
                throw new RazorpayException("Unable to parse response because of " + e.getMessage());
            }
        }
        throw new RazorpayException("Unable to parse response");
    }

    private <T extends Entity> ArrayList<T> parseCollectionResponse(JSONObject jsonObject) throws RazorpayException {
        ArrayList<T> modelList = new ArrayList<T>();
        if (jsonObject.has("entity") && "collection".equals(jsonObject.getString("entity"))) {
            JSONArray jsonArray = jsonObject.getJSONArray("items");
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject refundJson = jsonArray.getJSONObject(i);
                T t = this.parseResponse(refundJson);
                modelList.add(t);
            }
            return modelList;
        }
        throw new RazorpayException("Unable to parse response");
    }

    private <T extends Entity> T processResponse(Response response) throws RazorpayException {
        if (response == null) {
            throw new RazorpayException("Invalid Response from server");
        }
        int statusCode = response.code();
        String responseBody = null;
        JSONObject responseJson = null;
        try {
            responseBody = response.body().string();
            responseJson = new JSONObject(responseBody);
        }
        catch (IOException e) {
            throw new RazorpayException(e.getMessage());
        }
        if (statusCode >= 200 && statusCode < 300) {
            return this.parseResponse(responseJson);
        }
        this.throwException(statusCode, responseJson);
        return null;
    }

    private <T extends Entity> ArrayList<T> processCollectionResponse(Response response) throws RazorpayException {
        if (response == null) {
            throw new RazorpayException("Invalid Response from server");
        }
        int statusCode = response.code();
        String responseBody = null;
        JSONObject responseJson = null;
        try {
            responseBody = response.body().string();
            responseJson = new JSONObject(responseBody);
        }
        catch (IOException e) {
            throw new RazorpayException(e.getMessage());
        }
        if (statusCode >= 200 && statusCode < 300) {
            return this.parseCollectionResponse(responseJson);
        }
        this.throwException(statusCode, responseJson);
        return null;
    }

    private void throwException(int statusCode, JSONObject responseJson) throws RazorpayException {
        if (responseJson.has("error")) {
            JSONObject errorResponse = responseJson.getJSONObject("error");
            String code = errorResponse.getString("code");
            String description = errorResponse.getString("description");
            throw new RazorpayException(code + ":" + description);
        }
        this.throwServerException(statusCode, responseJson.toString());
    }

    private void throwServerException(int statusCode, String responseBody) throws RazorpayException {
        StringBuilder sb = new StringBuilder();
        sb.append("Status Code: ").append(statusCode).append("\n");
        sb.append("Server response: ").append(responseBody);
        throw new RazorpayException(sb.toString());
    }

    private Class getClass(String entity) {
        try {
            String entityClass = "com.razorpay." + Character.toUpperCase(entity.charAt(0)) + entity.substring(1);
            return Class.forName(entityClass);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

