/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Fragment;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.text.TextUtils;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Toast;
import com.razorpay.AnalyticsEvent;
import com.razorpay.AnalyticsProperty;
import com.razorpay.AnalyticsUtil;
import com.razorpay.BaseUtils;
import com.razorpay.CheckoutUtils;
import com.razorpay.Config;
import com.razorpay.ExternalWalletListener;
import com.razorpay.Logger;
import com.razorpay.PaymentData;
import com.razorpay.PaymentResultListener;
import com.razorpay.PaymentResultWithDataListener;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class Checkout
extends Fragment {
    public static final int NETWORK_ERROR = 2;
    public static final int INVALID_OPTIONS = 3;
    public static final int PAYMENT_CANCELED = 0;
    public static final int TLS_ERROR = 6;
    public static final int INCOMPATIBLE_PLUGIN = 7;
    public static final int RZP_REQUEST_CODE = 62442;
    static final int PAYMENT_SUCCESS = 1;
    static final int EXTERNAL_WALLET = 4;
    static final int INTEGRATION_ONE = 1;
    static final int INTEGRATION_TWO = 2;
    static final int INTEGRATION_THREE = 3;
    static final String EVENT_CALLBACK_DNE = "dne";
    static final String EVENT_CALLBACK_THREW_ERROR = "threw_error";
    @SuppressLint(value={"StaticFieldLeak"})
    private static WebView sPreloadView;
    private static long sPreloadCompleteDuration;
    private static long sPreloadAbortDuration;
    private static boolean sPreloadFailed;
    private String key;
    private JSONObject options;
    private Activity merchantActivity;
    private String merchantClassName;
    private boolean disableFullScreen;
    private int checkoutImage;
    private static PaymentData paymentData;
    private boolean isMethodOverridden;

    @Deprecated
    public final void setPublicKey(String public_key) {
        this.key = public_key;
    }

    public final void setImage(int image) {
        this.checkoutImage = image;
    }

    public final void setKeyID(String public_key) {
        this.setPublicKey(public_key);
    }

    public final void setFullScreenDisable(boolean isDisable) {
        this.disableFullScreen = isDisable;
    }

    public final void open(Activity a, JSONObject o) {
        if (TextUtils.isEmpty((CharSequence)this.key)) {
            this.key = BaseUtils.getKeyId((Context)a);
        }
        Config.getAdvertisingIdFromUtil((Context)a);
        if (TextUtils.isEmpty((CharSequence)this.key)) {
            throw new RuntimeException("Please set your Razorpay API key in AndroidManifest.xml");
        }
        if (o == null || o.length() == 0) {
            throw new RuntimeException("Checkout options cannot be null or empty");
        }
        try {
            o.put("key", (Object)this.key);
        }
        catch (JSONException e) {
            AnalyticsUtil.reportError((Exception)((Object)e), "warning", e.getMessage());
        }
        Checkout.abortPreloadIfRequired();
        this.options = o;
        this.merchantClassName = a.getClass().getName();
        this.merchantActivity = a;
        a.getFragmentManager().beginTransaction().add((Fragment)this, null).commitAllowingStateLoss();
    }

    public static void preload(Context context) {
        sPreloadCompleteDuration = 0L;
        sPreloadAbortDuration = 0L;
        sPreloadFailed = false;
        context = context.getApplicationContext();
        sPreloadView = new WebView(context);
        BaseUtils.setWebViewSettings(context, sPreloadView, false);
        sPreloadView.setWebViewClient(new WebViewClient(){
            long pageStartAt;

            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                this.pageStartAt = System.nanoTime();
                if (sPreloadView == null) {
                    HashMap<String, Object> eventProperties = new HashMap<String, Object>();
                    eventProperties.put("error_location", "Checkout->Preload()->onPageStarted");
                    AnalyticsUtil.trackEvent(AnalyticsEvent.WEB_VIEW_UNEXPECTED_NULL, eventProperties);
                    return;
                }
                sPreloadView.setTag((Object)this.pageStartAt);
                Logger.d("Preload started!");
            }

            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                Logger.d("onReceivedError OLD while pre-loading!");
                Checkout.failPreload();
            }

            public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
                super.onReceivedError(view, request, error);
                Logger.d("onReceivedError NEW while pre-loading!");
                Checkout.failPreload();
            }

            public void onPageFinished(WebView view, String url) {
                long now = System.nanoTime();
                if (!sPreloadFailed) {
                    sPreloadCompleteDuration = now - this.pageStartAt;
                    String message = "Preload finished in " + BaseUtils.nanoTimeToSecondsString(sPreloadCompleteDuration, 2) + " sec.";
                    Logger.d(message);
                }
                Checkout.destroyPreloadView();
            }
        });
        sPreloadView.setWebChromeClient(new WebChromeClient(){

            public void onProgressChanged(WebView view, int newProgress) {
                Logger.d("Preload progress: " + newProgress);
            }
        });
        sPreloadView.loadUrl("https://api.razorpay.com/v1/checkout/public");
    }

    private static void failPreload() {
        sPreloadFailed = true;
    }

    private static void destroyPreloadView() {
        try {
            sPreloadView.stopLoading();
        }
        catch (Exception exception) {
            // empty catch block
        }
        sPreloadView = null;
    }

    private static void abortPreloadIfRequired() {
        long now = System.nanoTime();
        try {
            if (sPreloadView != null) {
                long pageStartAt = (Long)sPreloadView.getTag();
                sPreloadAbortDuration = now - pageStartAt;
                String message = "Preload aborted in " + BaseUtils.nanoTimeToSecondsString(sPreloadAbortDuration, 2) + " sec.";
                Logger.d(message);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Checkout.destroyPreloadView();
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.options != null) {
            Intent intent = new Intent();
            intent.setComponent(new ComponentName(this.getActivity().getPackageName(), "com.razorpay.CheckoutActivity"));
            if (sPreloadCompleteDuration > 0L) {
                intent.putExtra("PRELOAD_COMPLETE_DURATION", sPreloadCompleteDuration);
            } else if (sPreloadAbortDuration > 0L) {
                intent.putExtra("PRELOAD_ABORT_DURATION", sPreloadAbortDuration);
            }
            intent.putExtra("OPTIONS", this.options.toString());
            intent.putExtra("IMAGE", this.checkoutImage);
            intent.putExtra("DISABLE_FULL_SCREEN", this.disableFullScreen);
            this.options = null;
            this.startActivityForResult(intent, 62442);
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode != 62442) {
            return;
        }
        this.merchantActivity = this.getActivity();
        this.merchantClassName = this.merchantActivity.getClass().getName();
        String result = Checkout.getPaymentResult(data);
        if (result == null) {
            result = "Payment Error";
        } else if (result.contains("cancelled")) {
            result = BaseUtils.getPaymentCancelledResponse("");
        }
        Checkout.trackOnActivityResultEvent(resultCode, result);
        if (resultCode == 1) {
            Checkout.createPaymentData(this.merchantActivity, result);
            this.handleOnSuccess();
        } else if (resultCode == 4) {
            this.handleExternalWalletSelected();
        } else {
            this.handleOnError(resultCode, result);
        }
        try {
            this.getActivity().getFragmentManager().beginTransaction().remove((Fragment)this).commit();
        }
        catch (Exception e) {
            AnalyticsUtil.reportError(e, "error", e.getMessage());
        }
    }

    private void handleExternalWalletSelected() {
        if (this.getActivity() instanceof ExternalWalletListener) {
            try {
                ExternalWalletListener externalWalletListener = (ExternalWalletListener)this.getActivity();
                String externalWallet = paymentData.getExternalWallet();
                if (!TextUtils.isEmpty((CharSequence)externalWallet)) {
                    externalWalletListener.onExternalWalletSelected(externalWallet, paymentData);
                    AnalyticsUtil.trackEvent(AnalyticsEvent.MERCHANT_EXTERNAL_WALLET_SELECTED_CALLED);
                    AnalyticsUtil.postData();
                }
            }
            catch (Exception e) {
                Checkout.handleMerchantCallbackError(this.merchantActivity, 4, EVENT_CALLBACK_THREW_ERROR, e);
            }
        } else {
            Checkout.handleMerchantCallbackError(this.merchantActivity, 4, EVENT_CALLBACK_DNE, new Exception());
        }
    }

    private void handleOnError(int resultCode, String result) {
        this.isMethodOverridden = true;
        this.onError(resultCode, result);
        if (this.isMethodOverridden) {
            Checkout.trackIntegrationType(resultCode, 1);
        }
    }

    private void handleOnSuccess() {
        String payment_id = paymentData.getPaymentId();
        if (payment_id != null) {
            this.isMethodOverridden = true;
            this.onSuccess(payment_id);
        }
        if (this.isMethodOverridden) {
            Checkout.trackIntegrationType(1, 1);
        }
    }

    public void onSuccess(String razorpayPaymentID) {
        this.isMethodOverridden = false;
        boolean handled = this.handleOnSuccessViaInterface(razorpayPaymentID);
        if (!handled) {
            this.handleOnSuccessViaReflection(razorpayPaymentID);
        }
    }

    public void onError(int code, String message) {
        this.isMethodOverridden = false;
        boolean handled = this.handleOnErrorViaInterface(code, message);
        if (!handled) {
            this.handleOnErrorViaReflection(code, message);
        }
    }

    private void handleOnErrorViaReflection(int code, String message) {
        Method method = null;
        try {
            method = this.getMerchantClassMethod("onPaymentError", Integer.TYPE, String.class);
        }
        catch (Exception e) {
            Checkout.handleMerchantCallbackError(this.merchantActivity, code, EVENT_CALLBACK_DNE, e);
        }
        try {
            this.invokeMethod(method, code, message);
            Checkout.trackIntegrationType(code, 2);
        }
        catch (Exception e) {
            Checkout.handleMerchantCallbackError(this.merchantActivity, code, EVENT_CALLBACK_THREW_ERROR, e);
        }
    }

    private boolean handleOnErrorViaInterface(int code, String message) {
        if (this.getActivity() instanceof PaymentResultListener) {
            try {
                PaymentResultListener paymentResultListener = (PaymentResultListener)this.getActivity();
                paymentResultListener.onPaymentError(code, message);
                Checkout.trackIntegrationType(code, 3);
            }
            catch (Exception e) {
                Checkout.handleMerchantCallbackError(this.merchantActivity, code, EVENT_CALLBACK_THREW_ERROR, e);
            }
            return true;
        }
        if (this.getActivity() instanceof PaymentResultWithDataListener) {
            try {
                PaymentResultWithDataListener paymentResultWithDataListener = (PaymentResultWithDataListener)this.getActivity();
                paymentResultWithDataListener.onPaymentError(code, message, paymentData);
                Checkout.trackIntegrationType(code, 3);
            }
            catch (Exception e) {
                Checkout.handleMerchantCallbackError(this.merchantActivity, code, EVENT_CALLBACK_THREW_ERROR, e);
            }
            return true;
        }
        return false;
    }

    private boolean handleOnSuccessViaInterface(String razorpayPaymentID) {
        if (this.getActivity() instanceof PaymentResultListener) {
            try {
                PaymentResultListener paymentResultListener = (PaymentResultListener)this.getActivity();
                paymentResultListener.onPaymentSuccess(razorpayPaymentID);
                Checkout.trackIntegrationType(1, 3);
            }
            catch (Exception e) {
                Checkout.handleMerchantCallbackError(this.merchantActivity, 1, EVENT_CALLBACK_THREW_ERROR, e);
            }
            return true;
        }
        if (this.getActivity() instanceof PaymentResultWithDataListener) {
            try {
                PaymentResultWithDataListener paymentResultWithDataListener = (PaymentResultWithDataListener)this.getActivity();
                paymentResultWithDataListener.onPaymentSuccess(razorpayPaymentID, paymentData);
                Checkout.trackIntegrationType(1, 3);
            }
            catch (Exception e) {
                Checkout.handleMerchantCallbackError(this.merchantActivity, 1, EVENT_CALLBACK_THREW_ERROR, e);
            }
            return true;
        }
        return false;
    }

    private void handleOnSuccessViaReflection(String razorpayPaymentID) {
        Method method = null;
        try {
            method = this.getMerchantClassMethod("onPaymentSuccess", String.class);
        }
        catch (Exception e) {
            Checkout.handleMerchantCallbackError(this.merchantActivity, 1, EVENT_CALLBACK_DNE, e);
        }
        try {
            this.invokeMethod(method, razorpayPaymentID);
            Checkout.trackIntegrationType(1, 2);
        }
        catch (Exception e) {
            Checkout.handleMerchantCallbackError(this.merchantActivity, 1, EVENT_CALLBACK_THREW_ERROR, e);
        }
    }

    private void invokeMethod(Method method, Object ... params) throws Exception {
        if (method == null) {
            return;
        }
        method.invoke((Object)this.merchantActivity, params);
    }

    private Method getMerchantClassMethod(String methodName, Class ... paramTypes) throws Exception {
        Class<?> merchantClass = Class.forName(this.merchantClassName);
        Method method = merchantClass.getMethod(methodName, paramTypes);
        return method;
    }

    private static void trackIntegrationType(int resultCode, int integration_type) {
        try {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("integration_type", Integer.toString(integration_type));
            if (resultCode == 1) {
                AnalyticsUtil.trackEvent(AnalyticsEvent.MERCHANT_ON_SUCCESS_CALLED, properties);
            } else {
                AnalyticsUtil.trackEvent(AnalyticsEvent.MERCHANT_ON_ERROR_CALLED, properties);
            }
            AnalyticsUtil.postData();
        }
        catch (Exception e) {
            AnalyticsUtil.reportError(e, "warning", e.getMessage());
        }
    }

    private static void trackOnActivityResultEvent(int resultCode, String result) {
        try {
            AnalyticsUtil.addProperty("onActivityResult result", new AnalyticsProperty(result, AnalyticsProperty.Scope.ORDER));
            AnalyticsUtil.addProperty("onActivityResult resultCode", new AnalyticsProperty(String.valueOf(resultCode), AnalyticsProperty.Scope.ORDER));
            if (resultCode == 1) {
                AnalyticsUtil.trackEvent(AnalyticsEvent.CALLING_ON_SUCCESS);
            } else if (resultCode == 4) {
                AnalyticsUtil.trackEvent(AnalyticsEvent.CALLING_EXTERNAL_WALLET_SELECTED);
            } else {
                AnalyticsUtil.trackEvent(AnalyticsEvent.CALLING_ON_ERROR);
            }
            AnalyticsUtil.postData();
        }
        catch (Exception e) {
            AnalyticsUtil.reportError(e, "warning", e.getMessage());
        }
    }

    private static void handleMerchantCallbackError(Activity activity, int resultCode, String eventType, Exception e) {
        String paymentStatus;
        String methodName;
        if (resultCode == 1) {
            methodName = "onPaymentSuccess";
            paymentStatus = "success";
        } else if (resultCode == 4) {
            methodName = "onExternalWalletSelected";
            paymentStatus = "redirected";
        } else {
            methodName = "onPaymentError";
            paymentStatus = "error";
        }
        try {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("event_details", e.getMessage());
            properties.put("event_type", e.getMessage());
            properties.put("payment_status", paymentStatus);
            AnalyticsUtil.trackEvent(AnalyticsEvent.HANDOVER_ERROR, properties);
            AnalyticsUtil.postData();
        }
        catch (Exception exception) {
            AnalyticsUtil.reportError(exception, "error", exception.getMessage());
        }
        if (eventType.equals(EVENT_CALLBACK_DNE)) {
            if (resultCode == 4) {
                Toast.makeText((Context)activity, (CharSequence)"Error: ExternalWalletListener probably not implemented in your activity", (int)0).show();
            } else {
                Toast.makeText((Context)activity, (CharSequence)("Error: " + methodName + " probably not implemented in your activity"), (int)0).show();
            }
        } else if (eventType.equals(EVENT_CALLBACK_THREW_ERROR)) {
            Toast.makeText((Context)activity, (CharSequence)("Your " + methodName + " method is throwing an error. Wrap the entire code of the method inside a try catch."), (int)0).show();
        }
        AnalyticsUtil.reportError(e, "error", e.getMessage());
    }

    private static void createPaymentData(Activity merchantActivity, String result) {
        paymentData = new PaymentData();
        paymentData.setUserContact(CheckoutUtils.getUserContact((Context)merchantActivity));
        paymentData.setUserEmail(CheckoutUtils.getUserEmail((Context)merchantActivity));
        try {
            JSONObject resultJSON = new JSONObject(result);
            paymentData.setData(resultJSON);
            if (resultJSON.has("razorpay_payment_id")) {
                paymentData.setPaymentId(resultJSON.getString("razorpay_payment_id"));
            }
            if (resultJSON.has("razorpay_order_id")) {
                paymentData.setOrderId(resultJSON.getString("razorpay_order_id"));
            }
            if (resultJSON.has("razorpay_signature")) {
                paymentData.setSignature(resultJSON.getString("razorpay_signature"));
            }
            if (resultJSON.has("external_wallet")) {
                paymentData.setExternalWallet(resultJSON.getString("external_wallet"));
            }
        }
        catch (JSONException e) {
            AnalyticsUtil.reportError((Exception)((Object)e), "error", e.getMessage());
        }
    }

    public static void handleActivityResult(Activity activity, int requestCode, int resultCode, Intent data, PaymentResultWithDataListener listener, ExternalWalletListener externalWalletListener) {
        if (requestCode != 62442) {
            return;
        }
        String result = Checkout.getPaymentResult(data);
        if (result.contains("cancelled")) {
            result = BaseUtils.getPaymentCancelledResponse("");
        }
        Checkout.createPaymentData(activity, result);
        Checkout.trackOnActivityResultEvent(resultCode, result);
        if (resultCode == 1) {
            try {
                String payment_id = paymentData.getPaymentId();
                listener.onPaymentSuccess(payment_id, paymentData);
            }
            catch (Exception e) {
                Checkout.handleMerchantCallbackError(activity, resultCode, EVENT_CALLBACK_THREW_ERROR, e);
            }
        } else if (resultCode == 4) {
            if (externalWalletListener != null) {
                try {
                    externalWalletListener.onExternalWalletSelected(paymentData.getExternalWallet(), paymentData);
                }
                catch (Exception e) {
                    Checkout.handleMerchantCallbackError(activity, resultCode, EVENT_CALLBACK_THREW_ERROR, e);
                }
            }
        } else {
            try {
                listener.onPaymentError(resultCode, result, paymentData);
            }
            catch (Exception e) {
                Checkout.handleMerchantCallbackError(activity, resultCode, EVENT_CALLBACK_THREW_ERROR, e);
            }
        }
    }

    public static void clearUserData(Context context) {
        CheckoutUtils.clearUserData(context);
    }

    private static String getPaymentResult(Intent data) {
        Bundle extras;
        if (data != null && (extras = data.getExtras()) != null) {
            return extras.getString("RESULT");
        }
        return null;
    }

    public static class Builder {
        private String builderKey;
        private int builderCheckoutImage;
        private boolean builderDisableFullScreen;

        public Builder setKeyId(String public_key) {
            this.builderKey = public_key;
            return this;
        }

        public Builder setImage(int image) {
            this.builderCheckoutImage = image;
            return this;
        }

        public Builder disableFullscreen(boolean isDisable) {
            this.builderDisableFullScreen = isDisable;
            return this;
        }

        public Checkout build() {
            Checkout checkout = new Checkout();
            checkout.setFullScreenDisable(this.builderDisableFullScreen);
            checkout.setImage(this.builderCheckoutImage);
            if (this.builderKey != null) {
                checkout.setKeyID(this.builderKey);
            }
            return checkout;
        }
    }
}

