/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.content.Context;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import com.razorpay.AnalyticsProperty;
import com.razorpay.AnalyticsUtil;
import com.razorpay.BaseConfig;
import com.razorpay.BaseUtils;
import com.razorpay.Callback;
import com.razorpay.CoreConfig;
import com.razorpay.Logger;
import com.razorpay.Owl;
import com.razorpay.ResponseObject;
import com.razorpay.SharedPreferenceUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

final class Lumberjack {
    private static final String SAVED_EVENTS_DATA = "SavedEventsData";
    private static String DEVICE_MANUFACTURER = Build.MANUFACTURER;
    private static String DEVICE_MODEL = Build.MODEL;
    private static String DEVICE_NAME = Build.DEVICE;
    private static String NETWORK_CELLULAR_TYPE;
    private static String NETWORK_CARRIER;
    private static boolean NETWORK_CELLULAR;
    private static boolean NETWORK_BLUETOOTH;
    private static boolean NETWORK_WIFI;
    private static float SCREEN_DENSITY;
    private static int SCREEN_WIDTH;
    private static int SCREEN_HEIGHT;
    private static JSONObject lumberjackPayload;
    private static JSONObject contextJsonData;
    private static boolean isLumberjackInitialized;
    private static String sdkType;
    private static String sdkVersion;
    private static ArrayList<JSONObject> preInitBatch;
    private static Map<String, Object> paymentProperties;
    private static Map<String, Object> orderProperties;

    Lumberjack() {
    }

    private static boolean hasPermission(Context context, String permission2) {
        return context.checkCallingOrSelfPermission(permission2) == 0;
    }

    private static CharSequence getUserAgent() {
        return AnalyticsUtil.returnUndefinedIfNull(System.getProperty("http.agent"));
    }

    private static CharSequence getTimeZone() {
        return AnalyticsUtil.returnUndefinedIfNull(TimeZone.getDefault().getID());
    }

    private static void setNetworkDetails(Context context) {
        NETWORK_CELLULAR_TYPE = BaseUtils.getCellularNetworkType(context);
        NETWORK_CARRIER = BaseUtils.getCellularNetworkProviderName(context);
        switch (BaseUtils.getDataNetworkType(context)) {
            case WIFI: {
                NETWORK_WIFI = true;
                break;
            }
            case CELLULAR: {
                NETWORK_CELLULAR = true;
                break;
            }
            case BLUETOOTH: {
                NETWORK_BLUETOOTH = true;
            }
        }
    }

    private static void setDisplayDetails(Context context) {
        WindowManager manager = (WindowManager)BaseUtils.getSystemService(context, "window");
        Display display = manager.getDefaultDisplay();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        display.getMetrics(displayMetrics);
        SCREEN_DENSITY = displayMetrics.density;
        SCREEN_HEIGHT = displayMetrics.heightPixels;
        SCREEN_WIDTH = displayMetrics.widthPixels;
    }

    private static String getTimestamp() {
        return String.valueOf(System.currentTimeMillis() / 1000L);
    }

    private static JSONObject getDeviceDataJson(Context context) throws Exception {
        JSONObject device = new JSONObject();
        device.put("id", (Object)BaseConfig.getAdvertisingId(context));
        device.put("manufacturer", (Object)DEVICE_MANUFACTURER);
        device.put("model", (Object)DEVICE_MODEL);
        device.put("name", (Object)DEVICE_NAME);
        device.put("type", (Object)"phone");
        device.put("version", (Object)("Android" + Build.VERSION.RELEASE));
        device.put(DEVICE_MANUFACTURER, (Object)Build.MANUFACTURER);
        device.put(DEVICE_MODEL, (Object)Build.MODEL);
        device.put("device_size", (Object)(BaseUtils.getDisplayWidth(context) + "w X " + BaseUtils.getDisplayHeight(context) + "h"));
        device.put("device_resolution", (Object)BaseUtils.getDisplayResolution(context));
        return device;
    }

    private static JSONObject getSdkDataJson() throws Exception {
        JSONObject sdk = new JSONObject();
        sdk.put("version", (Object)sdkVersion);
        sdk.put("type", (Object)sdkType);
        return sdk;
    }

    private static JSONObject getNetworkDataJson(Context context) throws Exception {
        JSONObject network = new JSONObject();
        network.put("bluetooth", NETWORK_BLUETOOTH);
        network.put("carrier", (Object)NETWORK_CARRIER);
        network.put("cellular", NETWORK_CELLULAR);
        network.put("cellular_network_type", (Object)NETWORK_CELLULAR_TYPE);
        network.put("wifi", NETWORK_WIFI);
        network.put("carrier_network", (Object)BaseUtils.getCarrierOperatorName(context));
        network.put("network_type", BaseUtils.getNetworkType(context));
        network.put("ip_address", (Object)BaseUtils.ipAddress);
        network.put("is_roming", BaseUtils.isNetworkRoaming(context));
        Map<String, String> deviceParamMap = BaseUtils.getDeviceAttributes(context);
        network.put("device_Id", (Object)deviceParamMap.get("device_Id"));
        network.put(DEVICE_MANUFACTURER, (Object)deviceParamMap.get(DEVICE_MANUFACTURER));
        network.put(DEVICE_MODEL, (Object)deviceParamMap.get(DEVICE_MODEL));
        return network;
    }

    private static JSONObject getScreenDataJson() throws Exception {
        JSONObject screen = new JSONObject();
        screen.put("density", (double)SCREEN_DENSITY);
        screen.put("width", SCREEN_WIDTH);
        screen.put("height", SCREEN_HEIGHT);
        return screen;
    }

    private static JSONObject getContextDataJson(Context context) throws Exception {
        JSONObject contextJson = new JSONObject();
        contextJson.put("mode", (Object)AnalyticsUtil.getKeyType());
        contextJson.put("device", (Object)Lumberjack.getDeviceDataJson(context));
        contextJson.put("sdk", (Object)Lumberjack.getSdkDataJson());
        contextJson.put("network", (Object)Lumberjack.getNetworkDataJson(context));
        contextJson.put("screen", (Object)Lumberjack.getScreenDataJson());
        contextJson.put("locale", (Object)BaseUtils.getLocale());
        contextJson.put("timezone", (Object)Lumberjack.getTimeZone());
        contextJson.put("user_agent", (Object)Lumberjack.getUserAgent());
        contextJson.put("webview_user_agent", (Object)BaseUtils.getWebViewUserAgent(context));
        return contextJson;
    }

    static void setBaseImportJSON(Context context) {
        try {
            Lumberjack.setNetworkDetails(context);
            Lumberjack.setDisplayDetails(context);
            JSONObject data = new JSONObject();
            data.put("key", (Object)CoreConfig.getInstance().getLumberjackKey());
            data.put("events", (Object)new JSONArray());
            contextJsonData = Lumberjack.getContextDataJson(context);
            data.put("context", (Object)contextJsonData);
            lumberjackPayload = data;
            Logger.d(data.toString());
        }
        catch (Exception e) {
            AnalyticsUtil.reportError(e, "critical", "Error in creating BaseImportJSON");
            lumberjackPayload = new JSONObject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addToBatch(JSONObject data) {
        if (!isLumberjackInitialized) {
            preInitBatch.add(data);
            return;
        }
        try {
            data = Lumberjack.addGlobalProperties(data);
            JSONObject jSONObject = lumberjackPayload;
            synchronized (jSONObject) {
                JSONArray events = lumberjackPayload.getJSONArray("events");
                events.put((Object)data);
            }
        }
        catch (Exception e) {
            AnalyticsUtil.reportError(e, "critical", e.getMessage());
        }
    }

    static void addPaymentProperty(String key, Object value) {
        paymentProperties.put(key, value);
    }

    static void addOrderProperty(String key, Object value) {
        orderProperties.put(key, value);
    }

    static JSONObject createBaseTrackEvent(String event) {
        try {
            return new JSONObject("{event: '" + event + "',timestamp: '" + Lumberjack.getTimestamp() + "'}");
        }
        catch (Exception e) {
            AnalyticsUtil.reportError(e, "critical", "Error in creating base for trackEvent");
            return null;
        }
    }

    static void trackEvent(String event, Map<String, Object> properties) {
        JSONObject propertiesJson = new JSONObject();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            try {
                propertiesJson.put(entry.getKey(), entry.getValue());
            }
            catch (JSONException e) {
                AnalyticsUtil.reportError((Exception)((Object)e), "critical", "Error adding analytics property " + entry.getKey() + " to JSONObject");
            }
        }
        Lumberjack.trackEvent(event, propertiesJson);
    }

    static void trackEvent(String event, JSONObject properties) {
        try {
            JSONObject data = Lumberjack.createBaseTrackEvent(event);
            if (data == null) {
                data = new JSONObject();
            }
            if (properties == null) {
                properties = new JSONObject();
            }
            properties.put("local_order_id", (Object)AnalyticsUtil.getLocalOrderId());
            properties.put("local_payment_id", (Object)AnalyticsUtil.getLocalPaymentId());
            data.put("properties", (Object)properties);
            Lumberjack.addToBatch(data);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void trackEvent(String event) {
        Lumberjack.trackEvent(event, new JSONObject());
    }

    static void trackPage(String page, String url) {
        String event_name = "Viewed " + page + " Page";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("url", url);
        Lumberjack.trackEvent(event_name, properties);
    }

    static JSONObject addGlobalProperties(JSONObject jsonObject) {
        try {
            JSONObject propertiesJSON = null;
            if (jsonObject.has("properties")) {
                propertiesJSON = jsonObject.getJSONObject("properties");
            }
            if (propertiesJSON == null) {
                propertiesJSON = new JSONObject();
            }
            propertiesJSON.put("merchant_app_name", (Object)AnalyticsUtil.MERCHANT_APP_NAME);
            propertiesJSON.put("merchant_app_version", (Object)AnalyticsUtil.MERCHANT_APP_VERSION);
            propertiesJSON.put("merchant_app_build", AnalyticsUtil.MERCHANT_APP_BUILD);
            for (Map.Entry<String, Object> entry : paymentProperties.entrySet()) {
                try {
                    propertiesJSON.put(entry.getKey(), entry.getValue());
                }
                catch (Exception e) {
                    AnalyticsUtil.reportError(e, "critical", "Error adding analytics property " + entry.getKey() + " to JSONObject");
                }
            }
            for (Map.Entry<String, Object> entry : orderProperties.entrySet()) {
                try {
                    propertiesJSON.put(entry.getKey(), entry.getValue());
                }
                catch (Exception e) {
                    AnalyticsUtil.reportError(e, "critical", "Error adding analytics property " + entry.getKey() + " to JSONObject");
                }
            }
            jsonObject.put("properties", (Object)propertiesJSON);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jsonObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void postData() {
        JSONObject jSONObject = lumberjackPayload;
        synchronized (jSONObject) {
            lumberjackPayload = Lumberjack.filterPayload(lumberjackPayload);
            Logger.d(lumberjackPayload.toString());
            Lumberjack.makePostRequest(lumberjackPayload);
        }
        Lumberjack.clearEvents();
    }

    private static void makePostRequest(JSONObject payload) {
        if (CoreConfig.getInstance().isLumberJackEnabled().booleanValue()) {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-identifier", CoreConfig.getInstance().getLumberjackSdkIdentifier());
            headers.put("Content-Type", "application/json");
            Logger.d("Sending data to lumberjack");
            String payloadString = payload.toString();
            Owl.post(CoreConfig.getInstance().getLumberjackEndpoint(), payloadString, headers, new Callback(){

                @Override
                public void run(ResponseObject response) {
                    Logger.d("Response from lumberjack: " + response.getResponseResult());
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearEvents() {
        try {
            if (lumberjackPayload == null) {
                return;
            }
            JSONObject jSONObject = lumberjackPayload;
            synchronized (jSONObject) {
                lumberjackPayload.put("events", (Object)new JSONArray());
            }
        }
        catch (Exception e) {
            AnalyticsUtil.reportError(e, "critical", e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void init(Context context, String sdkType, String sdkVersion) {
        Lumberjack.sdkType = sdkType;
        Lumberjack.sdkVersion = sdkVersion;
        Lumberjack.setBaseImportJSON(context);
        isLumberjackInitialized = true;
        Lumberjack.addQueuedDataToBatch();
        String savedEventsData = SharedPreferenceUtil.getProtectedValue(context, SAVED_EVENTS_DATA, sdkVersion);
        if (savedEventsData != null && savedEventsData.length() != 0) {
            try {
                Lumberjack.makePostRequest(new JSONObject(savedEventsData));
            }
            catch (Exception e) {
                AnalyticsUtil.reportError(e, "error", e.getMessage());
            }
            finally {
                SharedPreferenceUtil.setValue(context, SAVED_EVENTS_DATA, null);
            }
        }
    }

    private static void addQueuedDataToBatch() {
        for (JSONObject data : preInitBatch) {
            Lumberjack.addToBatch(data);
        }
        Lumberjack.clearPreInitData();
    }

    private static void clearPreInitData() {
        preInitBatch = new ArrayList();
    }

    private static void addPropertyFromJSONObject(JSONObject jsonObject, String property, AnalyticsProperty.Scope scope) {
        try {
            Object value = Lumberjack.getValueFromJsonObject(jsonObject, property);
            if (value != null) {
                if (scope == AnalyticsProperty.Scope.PAYMENT) {
                    Lumberjack.addPaymentProperty(property, value);
                } else if (scope == AnalyticsProperty.Scope.ORDER) {
                    Lumberjack.addOrderProperty(property, value);
                }
            }
        }
        catch (Exception e) {
            AnalyticsUtil.reportError(e, "warning", e.getMessage());
        }
    }

    static Object getValueFromJsonObject(JSONObject jsonObject, String string2) {
        try {
            return jsonObject.get(string2);
        }
        catch (Exception e) {
            AnalyticsUtil.reportError(e, "warning", e.getMessage());
            return null;
        }
    }

    static String getStringFromJsonObject(JSONObject jsonObject, String string2) {
        try {
            return jsonObject.getString(string2);
        }
        catch (Exception e) {
            AnalyticsUtil.reportError(e, "warning", e.getMessage());
            return null;
        }
    }

    static boolean getBooleanFromJsonObject(JSONObject jsonObject, String string2) {
        try {
            return jsonObject.getBoolean(string2);
        }
        catch (Exception e) {
            AnalyticsUtil.reportError(e, "warning", e.getMessage());
            return false;
        }
    }

    static void addAmountToProperties(JSONObject payload) {
        try {
            String amountString = Lumberjack.getStringFromJsonObject(payload, "amount");
            long amountLong = Long.parseLong(amountString);
            Lumberjack.addOrderProperty("amount", amountLong);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void addFilteredPropertiesFromPayload(JSONObject payload) {
        try {
            Lumberjack.addAmountToProperties(payload);
            Lumberjack.addPropertyFromJSONObject(payload, "contact", AnalyticsProperty.Scope.ORDER);
            Lumberjack.addPropertyFromJSONObject(payload, "email", AnalyticsProperty.Scope.ORDER);
            Lumberjack.addPropertyFromJSONObject(payload, "order_id", AnalyticsProperty.Scope.ORDER);
            String method = Lumberjack.getStringFromJsonObject(payload, "method");
            if (method == null) {
                return;
            }
            if (payload.has("token")) {
                method = "saved card";
            }
            Lumberjack.addPaymentProperty("method", method);
            if (method.equals("card")) {
                String cardNumber = Lumberjack.getStringFromJsonObject(payload, "card[number]");
                if (!AnalyticsUtil.isNullOrEmpty(cardNumber) && cardNumber.length() >= 6) {
                    cardNumber = cardNumber.substring(0, 6);
                    Lumberjack.addPaymentProperty("card_number", cardNumber);
                }
            } else if (method.equals("saved card")) {
                boolean receivedRazorpayOtp = Lumberjack.getBooleanFromJsonObject(payload, "razorpay_otp");
                Lumberjack.addOrderProperty("Checkout Login", !receivedRazorpayOtp + "");
            } else if (method.equals("netbanking")) {
                Lumberjack.addPropertyFromJSONObject(payload, "bank", AnalyticsProperty.Scope.PAYMENT);
            } else if (method.equals("wallet")) {
                Lumberjack.addPropertyFromJSONObject(payload, "wallet", AnalyticsProperty.Scope.PAYMENT);
            } else if (method.equals("upi")) {
                Lumberjack.addPaymentProperty("flow", Lumberjack.getStringFromJsonObject(payload, "_[flow]"));
            }
        }
        catch (Exception e) {
            Logger.d("Failed to add props to lumberjack: " + e.getMessage());
            AnalyticsUtil.reportError(e, "warning", e.getMessage());
        }
    }

    static void destroy() {
        Lumberjack.clearOrderProperties();
        Lumberjack.clearPaymentProperties();
        Lumberjack.clearEventData();
        isLumberjackInitialized = false;
    }

    static void clearPaymentProperties() {
        paymentProperties = new HashMap<String, Object>();
    }

    static void clearOrderProperties() {
        orderProperties = new HashMap<String, Object>();
    }

    private static void clearEventData() {
        Lumberjack.clearEvents();
        Lumberjack.clearPreInitData();
    }

    static JSONObject filterPayload(JSONObject payload) {
        try {
            JSONArray events = payload.getJSONArray("events");
            for (int i = 0; i < events.length(); ++i) {
                events.put(i, (Object)Lumberjack.filterEvent(events.getJSONObject(i)));
            }
            payload.put("events", (Object)events);
        }
        catch (JSONException e) {
            Logger.e("Error in filtering payload", e);
        }
        return payload;
    }

    static JSONObject filterEvent(JSONObject event) throws JSONException {
        if (event.has("properties")) {
            JSONObject properties = event.getJSONObject("properties");
            if (properties.has("url")) {
                String url = properties.getString("url");
                properties.put("url", (Object)Lumberjack.filterUrl(url));
            }
            event.put("properties", (Object)properties);
        }
        return event;
    }

    static String filterUrl(String url) {
        if (url.startsWith("data:")) {
            url = "Data present in url";
        }
        return url;
    }

    static JSONObject getLumberjackPayload() {
        return lumberjackPayload;
    }

    static JSONObject getContextPayload() {
        return contextJsonData;
    }

    static ArrayList<JSONObject> getPreInitBatch() {
        return preInitBatch;
    }

    static Map<String, Object> getPaymentProperties() {
        return paymentProperties;
    }

    static Map<String, Object> getOrderProperties() {
        return orderProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void saveEventsToPreferences(Context context) {
        JSONObject jSONObject = lumberjackPayload;
        synchronized (jSONObject) {
            JSONObject filteredPayload = Lumberjack.filterPayload(lumberjackPayload);
            String filteredPayloadString = filteredPayload.toString();
            SharedPreferenceUtil.setProtectedValue(context, SAVED_EVENTS_DATA, filteredPayloadString, sdkVersion);
        }
    }

    static {
        isLumberjackInitialized = false;
        sdkType = "standalone";
        preInitBatch = new ArrayList();
    }
}

