/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.content.Context;
import android.net.Uri;
import com.razorpay.AnalyticsUtil;
import com.razorpay.BaseConfig;
import com.razorpay.BaseUtils;
import com.razorpay.CoreConfig;
import com.razorpay.Logger;
import com.razorpay.R;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

class Config
extends BaseConfig {
    private static Config sConfig;
    static String SDK_TYPE;
    static String SDK_VERSION;
    static int SDK_VERSION_CODE;
    static String CONFIG_AUTH_KEY;
    static String CONFIG_VERSION;
    static boolean IS_MAGIC_ENABLED;
    private ArrayList<String> mCheckoutAppendKeys = new ArrayList();
    private Map<String, String> mCheckoutUrlConfig = new HashMap<String, String>();
    private boolean mCardSavingBroadcastReceiverFlowEnabled;
    private boolean mCardSavingSharedPreferencesFlowEnabled;
    private boolean mCardSavingLocalEnabled;
    private String mNativeLoaderColor;
    private boolean mNativeLoaderEnabled;
    private Boolean mRetryEnabled;
    private int mRetryMaxCount;
    private boolean mBackButtonAlertEnabled;
    private String mBackButtonAlertMessage;
    private String mBackButtonNegativeText;
    private String mBackButtonPositiveText;

    private Config() {
    }

    public static Config getInstance() {
        if (sConfig == null) {
            sConfig = new Config();
            CoreConfig.setInstance(sConfig);
        }
        return sConfig;
    }

    public void init(Context context) {
        JSONObject configJson = Config.getConfigJson(context);
        this.setConfig(configJson);
    }

    public void setRetryConfigFromOptions(JSONObject jsonObject) {
        try {
            this.setRetryConfig(jsonObject);
        }
        catch (Exception e) {
            AnalyticsUtil.reportError(e, "error", e.getLocalizedMessage());
        }
    }

    private static JSONObject getConfigJson(Context context) {
        return BaseConfig.getConfig(context, R.raw.rzp_config);
    }

    private void setCheckoutConfig(JSONObject jsonObject) throws Exception {
        JSONArray appendKeys = (JSONArray)BaseUtils.getJsonValue("checkout.append_keys", jsonObject, new JSONArray());
        this.mCheckoutAppendKeys = BaseUtils.jsonStringArrayToArrayList(appendKeys);
        JSONObject urlConfigJson = (JSONObject)BaseUtils.getJsonValue("checkout.url_config", jsonObject, new JSONObject());
        Iterator stringIterator = urlConfigJson.keys();
        while (stringIterator.hasNext()) {
            String key = (String)stringIterator.next();
            this.mCheckoutUrlConfig.put(key, urlConfigJson.getString(key));
        }
    }

    private void setCardSavingConfig(JSONObject jsonObject) throws Exception {
        this.mCardSavingBroadcastReceiverFlowEnabled = (Boolean)BaseUtils.getJsonValue("card_saving.broadcast_receiver_flow", jsonObject, false);
        this.mCardSavingSharedPreferencesFlowEnabled = (Boolean)BaseUtils.getJsonValue("card_saving.shared_preferences_flow", jsonObject, false);
        this.mCardSavingLocalEnabled = (Boolean)BaseUtils.getJsonValue("card_saving.local", jsonObject, false);
    }

    private void setNativeLoaderConfig(JSONObject jsonObject) throws Exception {
        this.mNativeLoaderColor = (String)BaseUtils.getJsonValue("native_loader.color", jsonObject, "");
        this.mNativeLoaderEnabled = (Boolean)BaseUtils.getJsonValue("native_loader.enable", jsonObject, "");
    }

    private void setRetryConfig(JSONObject jsonObject) throws Exception {
        if (this.mRetryEnabled == null) {
            this.mRetryEnabled = (boolean)((Boolean)BaseUtils.getJsonValue("retry.enabled", jsonObject, true));
            this.mRetryMaxCount = (Integer)BaseUtils.getJsonValue("retry.max_count", jsonObject, (Object)-1);
        }
    }

    private void setBankButtonConfig(JSONObject jsonObject) throws Exception {
        this.mBackButtonAlertMessage = (String)BaseUtils.getJsonValue("back_button.alert_message", jsonObject, "");
        this.mBackButtonAlertEnabled = (Boolean)BaseUtils.getJsonValue("back_button.enable", jsonObject, false);
        this.mBackButtonPositiveText = (String)BaseUtils.getJsonValue("back_button.positive_text", jsonObject, "");
        this.mBackButtonNegativeText = (String)BaseUtils.getJsonValue("back_button.negative_text", jsonObject, "");
    }

    @Override
    public void setConfig(JSONObject jsonObject) {
        try {
            this.setCheckoutConfig(jsonObject);
            this.setCardSavingConfig(jsonObject);
            this.setNativeLoaderConfig(jsonObject);
            this.setRetryConfig(jsonObject);
            this.setBankButtonConfig(jsonObject);
        }
        catch (Exception e) {
            AnalyticsUtil.reportError(e, "warning", e.getMessage());
            Logger.e("Error in setting Config, ErrorMessage=" + e.getMessage());
            e.printStackTrace();
        }
        super.setConfig(jsonObject);
    }

    public boolean isCardSavingLocalEnabled() {
        return this.mCardSavingLocalEnabled;
    }

    public String getNativeLoaderColor() {
        return this.mNativeLoaderColor;
    }

    public boolean isNativeLoaderEnabled() {
        return this.mNativeLoaderEnabled;
    }

    public boolean isRetryEnabled() {
        return this.mRetryEnabled;
    }

    public int getRetryMaxCount() {
        return this.mRetryMaxCount;
    }

    public Map<String, String> getCheckoutUrlConfig() {
        return this.mCheckoutUrlConfig;
    }

    public ArrayList<String> getCheckoutAppendKeys() {
        return this.mCheckoutAppendKeys;
    }

    public String getBackButtonNegativeText() {
        return this.mBackButtonNegativeText;
    }

    public String getBackButtonPositiveText() {
        return this.mBackButtonPositiveText;
    }

    public boolean isBackButtonAlertEnabled() {
        return this.mBackButtonAlertEnabled;
    }

    public String getBackButtonAlertMessage() {
        return this.mBackButtonAlertMessage;
    }

    public boolean isCardSavingBroadcastReceiverFlowEnabled() {
        return this.mCardSavingBroadcastReceiverFlowEnabled;
    }

    public boolean isCardSavingSharedPreferencesFlowEnabled() {
        return this.mCardSavingSharedPreferencesFlowEnabled;
    }

    static void fetchConfig(Context context, String key) {
        if (!Config.getInstance().isConfigEnabled()) {
            return;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("AuthKey", CONFIG_AUTH_KEY);
        headers.put("Content-type", "application/json");
        headers.put("CurrentSettingVersion", Config.getCurrentConfigVersion(context));
        BaseConfig.fetchConfig(Config.getFetchConfigUrl(context, key), headers, context);
    }

    private static String getFetchConfigUrl(Context context, String key) {
        Uri.Builder builder = Uri.parse((String)Config.getInstance().getConfigEndpoint()).buildUpon().appendQueryParameter("tenant", "android_" + SDK_TYPE).appendQueryParameter("sdk_version", SDK_VERSION).appendQueryParameter("sdk_type", SDK_TYPE).appendQueryParameter("magic_enabled", String.valueOf(IS_MAGIC_ENABLED)).appendQueryParameter("sdk_version_code", String.valueOf(SDK_VERSION_CODE)).appendQueryParameter("app_version", "1.6.7").appendQueryParameter("version", Config.getCurrentConfigVersionTag(Config.getCurrentConfigVersion(context)));
        BaseConfig.getFetchConfigBuilder(builder, context, key);
        return builder.build().toString();
    }

    private static String getCurrentConfigVersion(Context context) {
        String configVersion = BaseConfig.getBaseCurrentConfigVersion(context);
        if (configVersion == null) {
            configVersion = CONFIG_VERSION;
        }
        return configVersion;
    }

    static {
        SDK_TYPE = "checkout";
        SDK_VERSION = "1.6.7";
        SDK_VERSION_CODE = 36;
        CONFIG_AUTH_KEY = "2HujvzmUo2nuRLLqhIHIV4sCEmRw9FIc";
        CONFIG_VERSION = "3.0.5";
        IS_MAGIC_ENABLED = true;
    }
}

