/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import com.razorpay.AnalyticsUtil;
import com.razorpay.BaseUtils;
import com.razorpay.CryptLib;
import com.razorpay.Logger;
import org.json.JSONObject;

class SharedPreferenceUtil {
    private static final String NAME_PUBLIC = "rzp_preference_public";
    private static final String NAME_PRIVATE = "rzp_preference_private";
    private static final String NAME_STORAGE_BRIDGE = "rzp_preferences_storage_bridge";
    private static final String KEY_DATA = "data";
    private static final String KEY_IV = "iv";
    private static final String KEY_SDK_VERSION = "sdk_version";
    private static SharedPreferences privatePrefs;
    private static SharedPreferences.Editor privateEditor;

    SharedPreferenceUtil() {
    }

    static SharedPreferences getPrivatePrefs(Context context) {
        if (privatePrefs == null) {
            privatePrefs = context.getSharedPreferences(NAME_PRIVATE, 0);
        }
        return privatePrefs;
    }

    @SuppressLint(value={"CommitPrefEdits"})
    static SharedPreferences.Editor getPrivateEditor(Context context) {
        if (privateEditor == null) {
            privateEditor = SharedPreferenceUtil.getPrivatePrefs(context).edit();
        }
        return privateEditor;
    }

    static SharedPreferences getPublicPrefs(Context context) {
        try {
            return context.getSharedPreferences(NAME_PUBLIC, 1);
        }
        catch (Exception e) {
            AnalyticsUtil.reportError(e, "critical", e.getMessage());
            return context.getSharedPreferences(NAME_PUBLIC, 0);
        }
    }

    @SuppressLint(value={"CommitPrefEdits"})
    static SharedPreferences.Editor getPublicEditor(Context context) {
        return SharedPreferenceUtil.getPublicPrefs(context).edit();
    }

    static SharedPreferences.Editor getStorageBridgeEditor(Context context) {
        return SharedPreferenceUtil.getStorageBridgePrefs(context).edit();
    }

    static SharedPreferences getStorageBridgePrefs(Context context) {
        return context.getSharedPreferences(NAME_STORAGE_BRIDGE, 0);
    }

    static void handleSdkUpdate(Context context, String sdkVersion) {
        try {
            String storedSdkVersion = SharedPreferenceUtil.getValue(context, KEY_SDK_VERSION);
            String currentSdkVersion = sdkVersion;
            if (!currentSdkVersion.equalsIgnoreCase(storedSdkVersion)) {
                SharedPreferenceUtil.setValue(context, "rzp_config_json", null);
                SharedPreferenceUtil.setValue(context, "rzp_config_version", null);
                SharedPreferenceUtil.setValue(context, KEY_SDK_VERSION, currentSdkVersion);
            }
        }
        catch (NullPointerException e) {
            SharedPreferenceUtil.setValue(context, "rzp_config_json", null);
            SharedPreferenceUtil.setValue(context, "rzp_config_version", null);
            SharedPreferenceUtil.setValue(context, KEY_SDK_VERSION, sdkVersion);
        }
    }

    static String getProtectedValue(Context context, String key, String sdkVersion) {
        try {
            String value = SharedPreferenceUtil.getValue(context, key);
            if (value == null) {
                return null;
            }
            JSONObject jsonObject = new JSONObject(value);
            CryptLib cryptLib = new CryptLib();
            if (!sdkVersion.equals(jsonObject.getString(KEY_SDK_VERSION))) {
                return null;
            }
            String plainText = cryptLib.decrypt(jsonObject.getString(KEY_DATA), "c89TV2vbYJvvRkSSgx3dZZZu28EmcqCJ", jsonObject.getString(KEY_IV));
            return plainText;
        }
        catch (Exception e) {
            AnalyticsUtil.reportError(e, "error", "Unable to decrypt value");
            Logger.e("Unable to decrypt value", e);
            return null;
        }
    }

    static void setProtectedValue(Context context, String key, String value, String sdkVersion) {
        try {
            String iv = BaseUtils.getRandomString();
            CryptLib crypto = new CryptLib();
            String encryptedValue = crypto.encrypt(value, "c89TV2vbYJvvRkSSgx3dZZZu28EmcqCJ", iv);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put(KEY_DATA, (Object)encryptedValue);
            jsonObject.put(KEY_IV, (Object)iv);
            jsonObject.put(KEY_SDK_VERSION, (Object)sdkVersion);
            SharedPreferenceUtil.setValue(context, key, jsonObject.toString());
        }
        catch (Exception e) {
            AnalyticsUtil.reportError(e, "error", "Unable to encrypt value");
            Logger.e("Unable to encrypt value", e);
        }
    }

    static String getValue(Context context, String key) {
        SharedPreferences sharedPref = SharedPreferenceUtil.getPrivatePrefs(context);
        return sharedPref.getString(key, null);
    }

    static void setValue(Context context, String key, String value) {
        SharedPreferences.Editor editor = SharedPreferenceUtil.getPrivateEditor(context);
        editor.putString(key, value);
        editor.commit();
    }
}

