/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.app.Activity;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import android.widget.Toast;
import com.razorpay.AnalyticsEvent;
import com.razorpay.AnalyticsProperty;
import com.razorpay.AnalyticsUtil;
import com.razorpay.AutoOtpUtils;
import com.razorpay.BaseUtils;
import com.razorpay.Callback;
import com.razorpay.CoreConfig;
import com.razorpay.Logger;
import com.razorpay.OTP;
import com.razorpay.OtpElfData;
import com.razorpay.Owl;
import com.razorpay.ResourceUtils;
import com.razorpay.ResponseObject;
import com.razorpay.SmsAgent;
import com.razorpay.SmsAgentInterface;
import java.util.HashMap;
import org.json.JSONObject;

public final class RzpAssist
implements SmsAgentInterface {
    private WebView webview;
    private boolean hasOtpPermission = false;
    private String lastURL = "";
    private String currentLoadingUrl = "";
    private long pageStartTime;
    private boolean isMagic = false;
    private boolean isRazorpayOtpReceived = false;
    private Activity activity;
    private String merchantKey;
    private SmsAgent smsAgent;
    private OtpElfData elfData;
    private JSONObject otpElfPreferences = new JSONObject();
    private JSONObject paymentData = new JSONObject();
    private String paymentId;
    private boolean isRzpAssistEnabled = false;
    private boolean otpRead = false;
    private String sdkType = "standalone";
    private int sdkVersionCode;
    String lastSms;
    private boolean jsInsertedInCurrentPage = false;

    public RzpAssist(String merchantKey, Activity activity, WebView webview, String sdkType, int sdkVersionCode, String sdkVersion) {
        if (!CoreConfig.getInstance().isOTPElfEnabled().booleanValue()) {
            return;
        }
        if (merchantKey == null || merchantKey.isEmpty()) {
            throw new RuntimeException("merchantKey cannot be null or empty");
        }
        this.sdkType = sdkType;
        this.sdkVersionCode = sdkVersionCode;
        Logger.d("OTPElf Constructor");
        if (sdkType.equals("standalone")) {
            AnalyticsUtil.setup((Context)activity, merchantKey, sdkType, sdkVersionCode, sdkVersion);
        }
        this.webview = webview;
        this.merchantKey = merchantKey;
        this.activity = activity;
        this.elfData = new OtpElfData(activity);
        this.elfData.checkForUpdates();
        this.setup();
        AnalyticsUtil.addProperty("OTPElf Version", new AnalyticsProperty(BaseUtils.getLocalVersion(activity, OtpElfData.versionKey), AnalyticsProperty.Scope.ORDER));
    }

    private void setup() {
        this.smsAgent = SmsAgent.getSmsAgentInstance();
        this.smsAgent.registerForCallbacks(this);
        this.smsAgent.takeActionsIfPermissionsAreGranted(this.activity);
        this.webview.addJavascriptInterface((Object)this, "OTPElfBridge");
        this.webview.getSettings().setUseWideViewPort(true);
    }

    void enableMagic() {
        this.isMagic = true;
    }

    void setPaymentData(JSONObject jsonObject) {
        this.paymentData = jsonObject;
    }

    public void setOtpElfPreferences(JSONObject preferences) {
        this.otpElfPreferences = preferences;
    }

    public void onPageFinished(WebView webview, String url) {
        long timeInterval = System.nanoTime() - this.pageStartTime;
        AnalyticsUtil.trackPageLoadEnd(url, timeInterval);
        this.lastURL = url;
        this.currentLoadingUrl = "";
        if (!CoreConfig.getInstance().isOTPElfEnabled().booleanValue()) {
            return;
        }
        if (!this.jsInsertedInCurrentPage) {
            this.handleJsInsertion();
            this.jsInsertedInCurrentPage = true;
        }
    }

    private void handleJsInsertion() {
        try {
            JSONObject settings = CoreConfig.getInstance().getOTPElfSettings();
            settings.put("merchant_key", (Object)this.merchantKey);
            settings.put("otp_permission", this.hasOtpPermission);
            JSONObject sdk = new JSONObject();
            sdk.put("type", (Object)this.sdkType);
            sdk.put("version_code", this.sdkVersionCode);
            settings.put("sdk", (Object)sdk);
            JSONObject plugin = new JSONObject();
            if (!this.isMagic) {
                Logger.d("not magic");
                plugin.put("type", (Object)"rzpassist");
                plugin.put("version_code", ResourceUtils.getRzpAssistVersionCode());
            } else {
                Logger.d("This is Magic");
                plugin.put("type", (Object)"magic");
                plugin.put("version_code", ResourceUtils.getMagicVersionCode());
            }
            settings.put("plugin", (Object)plugin);
            settings.put("payment_data", (Object)this.paymentData);
            settings.put("preferences", (Object)this.otpElfPreferences);
            this.injectJs("window.__rzp_options = " + settings.toString());
        }
        catch (Exception e) {
            Logger.e("Unable to load otpelf settings", e);
        }
        this.injectJs(this.elfData.getOtpElfJs());
        if (this.lastSms != null) {
            this.injectJs(String.format("OTPElf.elfBridge.setSms(%s)", this.lastSms));
            this.lastSms = null;
        }
    }

    public void onProgressChanged(int progress) {
        if (!CoreConfig.getInstance().isOTPElfEnabled().booleanValue()) {
            return;
        }
    }

    public void onPageStarted(WebView view, String url) {
        Logger.d("RzpAssist onPageStarted: " + url);
        AnalyticsUtil.trackPageLoadStart(url);
        this.pageStartTime = System.nanoTime();
        this.currentLoadingUrl = url;
        this.jsInsertedInCurrentPage = false;
    }

    public void paymentFlowEnd() {
        if (this.sdkType.equals("standalone")) {
            AnalyticsUtil.postData();
        }
        if (!CoreConfig.getInstance().isOTPElfEnabled().booleanValue()) {
            return;
        }
        this.smsAgent.removeSMSBroadcastReceiver(this.activity);
        this.smsAgent.deregisterForCallbacks(this);
    }

    @Override
    public void postSms(String sender, String message) {
        if (!this.isRzpAssistEnabled) {
            return;
        }
        try {
            JSONObject sms = new JSONObject();
            sms.put("sender", (Object)sender);
            sms.put("message", (Object)message);
            this.lastSms = sms.toString();
            this.injectJs(String.format("OTPElf.elfBridge.setSms(%s)", this.lastSms));
        }
        catch (Exception e) {
            Logger.e("Exception", e);
        }
    }

    @Override
    public void setSmsPermission(boolean hasSmsPermission) {
        this.setOTPEnabled(hasSmsPermission);
    }

    void setPaymentId(String paymentId) {
        this.paymentId = paymentId;
    }

    private void postStatsToAPI() {
        try {
            String auth = BaseUtils.constructBasicAuth(this.merchantKey);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", "Basic " + auth);
            headers.put("Content-Type", "application/json");
            if (this.paymentId == null) {
                return;
            }
            String endpoint = "https://api.razorpay.com/v1/payments/" + this.paymentId + "/metadata";
            Logger.d("Sending Stats Request");
            JSONObject payload = AutoOtpUtils.createStatsPayload(this.otpRead);
            Logger.d("PAYLOAD");
            Logger.d(payload.toString());
            Logger.d(endpoint);
            Owl.post(endpoint, payload.toString(), headers, new Callback(){

                @Override
                public void run(ResponseObject response) {
                    Logger.d("API Metadata: " + response.getResponseResult());
                }
            });
        }
        catch (Exception e) {
            AnalyticsUtil.reportError(e, "critical", e.getMessage());
        }
    }

    private void injectJs(String js) {
        this.webview.loadUrl(String.format("javascript: %s", js));
    }

    void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        this.smsAgent.handleRequestPermissionsResult(this.activity, requestCode, permissions, grantResults);
    }

    String getLastLoadedUrl() {
        return this.lastURL;
    }

    String getCurrentLoadingUrl() {
        return this.currentLoadingUrl;
    }

    public final void reset() {
        this.postStatsToAPI();
        this.lastURL = "";
        this.currentLoadingUrl = "";
        this.otpRead = false;
    }

    boolean isRazorpayOtpReceived() {
        return this.isRazorpayOtpReceived;
    }

    void setOTPEnabled(boolean enabled) {
        this.hasOtpPermission = enabled;
        AnalyticsUtil.addProperty("otp_autoreading_access", new AnalyticsProperty(enabled, AnalyticsProperty.Scope.ORDER));
    }

    void setRzpAssistEnabled(boolean enabled) {
        this.isRzpAssistEnabled = enabled;
    }

    @JavascriptInterface
    public final void setUseWideViewPort(final boolean shouldUse) {
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                RzpAssist.this.webview.getSettings().setUseWideViewPort(shouldUse);
            }
        });
    }

    @JavascriptInterface
    public final void openKeyboard() {
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                InputMethodManager imm = (InputMethodManager)RzpAssist.this.activity.getSystemService("input_method");
                imm.showSoftInput((View)RzpAssist.this.webview, 0);
            }
        });
    }

    @JavascriptInterface
    public final void toast(final String message) {
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Toast.makeText((Context)RzpAssist.this.activity, (CharSequence)message, (int)1).show();
            }
        });
    }

    @JavascriptInterface
    public void trackEvent(String eventName, String properties) {
        try {
            AnalyticsEvent jsEvent = AnalyticsEvent.JS_EVENT;
            jsEvent.setEventName(eventName);
            JSONObject propertiesJson = new JSONObject(properties);
            AnalyticsUtil.trackEvent(jsEvent, propertiesJson);
        }
        catch (Exception e) {
            Logger.e("Error in tracking JS Event", e);
        }
    }

    @JavascriptInterface
    public final void trackEvent(String eventName) {
        AnalyticsEvent jsEvent = AnalyticsEvent.JS_EVENT;
        jsEvent.setEventName(eventName);
        AnalyticsUtil.trackEvent(jsEvent);
    }

    @JavascriptInterface
    public void onOtpParsed(final String otpJson) {
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    JSONObject jsonObject = new JSONObject(otpJson);
                    String pin = jsonObject.getString("otp");
                    String sender = jsonObject.getString("sender");
                    String bank = jsonObject.getString("bank");
                    OTP otp = new OTP(pin, sender, bank);
                    HashMap<String, Object> properties = new HashMap<String, Object>();
                    properties.put("sender", otp.getSender());
                    if (otp.getSender().contains("RZRPAY")) {
                        RzpAssist.this.isRazorpayOtpReceived = true;
                        properties.put("razorpay_otp", true);
                    } else {
                        properties.put("razorpay_otp", false);
                        RzpAssist.this.otpRead = true;
                        AnalyticsUtil.addProperty("payment_otp_received", new AnalyticsProperty(true, AnalyticsProperty.Scope.PAYMENT));
                    }
                    AnalyticsUtil.trackEvent(AnalyticsEvent.OTP_RECEIVED, properties);
                }
                catch (Exception e) {
                    Logger.e("Error in parsing json", e);
                }
            }
        });
    }

    @JavascriptInterface
    public void copyToClipboard(String value) {
        ClipboardManager clipboard = (ClipboardManager)this.activity.getSystemService("clipboard");
        ClipData clip = ClipData.newPlainText((CharSequence)"rzp_clip_data", (CharSequence)value);
        clipboard.setPrimaryClip(clip);
    }
}

