/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.view.View;
import android.view.animation.Animation;
import android.view.animation.Transformation;

class ResizeWidthAnimation
extends Animation {
    private int mWidth;
    private int mStartWidth;
    private View mView;

    ResizeWidthAnimation(View view, int width) {
        this.mView = view;
        this.mWidth = width;
        this.mStartWidth = view.getWidth();
    }

    protected void applyTransformation(float interpolatedTime, Transformation t) {
        int newWidth;
        this.mView.getLayoutParams().width = newWidth = this.mStartWidth + (int)((float)(this.mWidth - this.mStartWidth) * interpolatedTime);
        this.mView.requestLayout();
    }

    public void initialize(int width, int height, int parentWidth, int parentHeight) {
        super.initialize(width, height, parentWidth, parentHeight);
    }

    public boolean willChangeBounds() {
        return true;
    }
}

