/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.widget.RelativeLayout;
import com.razorpay.ResizeWidthAnimation;

final class RZPProgressBar {
    private Context context;
    private ViewGroup container;
    private View progressBar;
    private float screenWidth;
    private int defaultHeight;
    private String color;

    public RZPProgressBar(Context context, ViewGroup container) {
        this(context, container, null);
    }

    public RZPProgressBar(Context context, ViewGroup container, String color) {
        this.color = color;
        this.context = context;
        this.container = container;
        this.getScreenDimensions();
        this.defaultHeight = this.convertDPtoInt(4);
        this.insertView();
    }

    private void getScreenDimensions() {
        DisplayMetrics displayMetrics = this.context.getResources().getDisplayMetrics();
        this.screenWidth = (float)displayMetrics.widthPixels / displayMetrics.density;
    }

    private int getThemeAccentColor() {
        int colorAttr = Build.VERSION.SDK_INT >= 21 ? 16843829 : this.context.getResources().getIdentifier("colorAccent", "attr", this.context.getPackageName());
        TypedValue outValue = new TypedValue();
        boolean found = this.context.getTheme().resolveAttribute(colorAttr, outValue, true);
        if (found) {
            return outValue.data;
        }
        return Color.parseColor((String)"#4aa3df");
    }

    private void insertView() {
        this.progressBar = new View(this.context);
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(0, this.defaultHeight);
        this.progressBar.setLayoutParams((ViewGroup.LayoutParams)lp);
        int colorInt = TextUtils.isEmpty((CharSequence)this.color) ? this.getThemeAccentColor() : Color.parseColor((String)this.color);
        float[] hsv = new float[3];
        Color.colorToHSV((int)colorInt, (float[])hsv);
        hsv[2] = hsv[2] * 0.8f;
        int colorDarkInt = Color.HSVToColor((float[])hsv);
        GradientDrawable gradientDrawable = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{colorInt, colorDarkInt});
        gradientDrawable.setCornerRadius(0.0f);
        this.progressBar.setBackgroundDrawable((Drawable)gradientDrawable);
        this.container.addView(this.progressBar);
    }

    private int convertDPtoInt(int DP) {
        return (int)TypedValue.applyDimension((int)1, (float)DP, (DisplayMetrics)this.context.getResources().getDisplayMetrics());
    }

    void show(int percentage) {
        if (percentage == 100) {
            this.hide();
        } else {
            this.animateTo(percentage, 500);
        }
    }

    void hide() {
        this.animateToEnd(200);
    }

    private void animateTo(int percentage, int duration) {
        int width = (int)(this.screenWidth * (float)percentage / 100.0f);
        width = this.convertDPtoInt(width);
        ResizeWidthAnimation anim = new ResizeWidthAnimation(this.progressBar, width);
        anim.setDuration(duration);
        this.progressBar.startAnimation((Animation)anim);
        anim.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationEnd(Animation animation) {
            }

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
    }

    private void animateToEnd(int duration) {
        int width = (int)this.screenWidth;
        width = this.convertDPtoInt(width);
        ResizeWidthAnimation anim = new ResizeWidthAnimation(this.progressBar, width);
        anim.setDuration(duration);
        this.progressBar.startAnimation((Animation)anim);
        anim.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationEnd(Animation animation) {
                RZPProgressBar.this.animateTo(0, 10);
            }

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
    }
}

