/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.os.AsyncTask;
import com.razorpay.AnalyticsUtil;
import com.razorpay.Callback;
import com.razorpay.Logger;
import com.razorpay.ResponseObject;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;

class Owl
extends AsyncTask<String, Void, ResponseObject> {
    private Callback cb;
    private String method = null;
    private Map<String, String> headers = new HashMap<String, String>();
    private String data = null;

    private Owl(Callback cb) {
        this.cb = cb;
    }

    static AsyncTask get(String url, Callback cb) {
        return new Owl(cb).method("GET").execute(new String[]{url});
    }

    static AsyncTask get(String url, Map<String, String> headers, Callback cb) {
        return new Owl(cb).method("GET").headers(headers).execute(new String[]{url});
    }

    static AsyncTask get(String url, String data, Map<String, String> headers, Callback cb) {
        return new Owl(cb).method("GET").data(data).headers(headers).execute(new String[]{url});
    }

    static AsyncTask post(String url, String data, Callback cb) {
        return new Owl(cb).method("POST").data(data).execute(new String[]{url});
    }

    public static AsyncTask post(String url, String data, Map<String, String> headers, Callback cb) {
        return new Owl(cb).method("POST").data(data).headers(headers).execute(new String[]{url});
    }

    Owl headers(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    Owl method(String method) {
        this.method = method;
        return this;
    }

    Owl data(String data) {
        this.data = data;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResponseObject doInBackground(String ... urls) {
        InputStream is = null;
        ResponseObject responseObject = new ResponseObject();
        try {
            URL url = new URL(urls[0]);
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            for (Map.Entry<String, String> element : this.headers.entrySet()) {
                String key = element.getKey();
                String value = element.getValue();
                conn.setRequestProperty(key, value);
            }
            conn.setRequestMethod(this.method);
            if (this.data != null) {
                conn.setDoOutput(true);
                conn.getOutputStream().write(this.data.getBytes(StandardCharsets.UTF_8));
            }
            conn.setConnectTimeout(15000);
            conn.setReadTimeout(20000);
            conn.connect();
            int status = conn.getResponseCode();
            responseObject.setResponseCode(status);
            is = status >= 400 ? conn.getErrorStream() : conn.getInputStream();
            responseObject.setHeaders(conn.getHeaderFields());
            responseObject.setResponseResult(this.readIt(is));
        }
        catch (Exception e) {
            Logger.e("Input Stream: " + e.getLocalizedMessage());
            AnalyticsUtil.reportError(e, "error", e.getMessage());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e) {
                    AnalyticsUtil.reportError(e, "error", e.getMessage());
                }
            }
        }
        return responseObject;
    }

    protected void onPostExecute(ResponseObject result) {
        if (this.cb != null) {
            this.cb.run(result);
        }
    }

    private String readIt(InputStream stream) throws Exception {
        String line;
        BufferedReader in = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
        StringBuilder body = new StringBuilder();
        while ((line = in.readLine()) != null) {
            body.append(line);
        }
        in.close();
        return body.toString();
    }
}

