/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.WallpaperManager;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.location.Location;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.net.http.SslCertificate;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.StatFs;
import android.os.SystemClock;
import android.provider.Settings;
import android.telephony.PhoneStateListener;
import android.telephony.SignalStrength;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Base64;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.webkit.CookieManager;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.widget.Toast;
import com.razorpay.AdvertisingIdUtil;
import com.razorpay.AnalyticsUtil;
import com.razorpay.BaseConfig;
import com.razorpay.ConfigDroid;
import com.razorpay.CoreConfig;
import com.razorpay.CryptLib;
import com.razorpay.Logger;
import com.razorpay.NetworkType;
import com.razorpay.RzpJSONCallback;
import com.razorpay.SharedPreferenceUtil;
import com.razorpay.StorageBridge;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import proguard.annotation.Keep;
import proguard.annotation.KeepClassMembers;

@Keep
@KeepClassMembers
class BaseUtils {
    private static String PERMISSION_DISABLED = "permission disabled";
    private static boolean sWebViewDebuggingEnabled = ConfigDroid.ENABLE_WEBVIEW_DEBUGGING;
    private static boolean isCompatibleWithGooglePay = true;
    static String ipAddress;

    BaseUtils() {
    }

    static String constructBasicAuth(String merchantKey) throws UnsupportedEncodingException {
        String key = merchantKey;
        String basicAuthKey = key + ":";
        byte[] data = basicAuthKey.getBytes("UTF-8");
        String auth = Base64.encodeToString((byte[])data, (int)2);
        return auth;
    }

    static boolean hasPermission(Context context, String permission2) {
        try {
            return 0 == context.checkCallingOrSelfPermission(permission2);
        }
        catch (Exception e) {
            AnalyticsUtil.reportError(e, "critical", e.getMessage());
            return false;
        }
    }

    static String getKeyId(Context context) {
        try {
            ApplicationInfo appInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            if (appInfo.metaData == null) {
                return null;
            }
            String keyId = appInfo.metaData.getString("com.razorpay.ApiKey");
            Logger.d(keyId);
            return keyId;
        }
        catch (PackageManager.NameNotFoundException e) {
            AnalyticsUtil.reportError((Exception)((Object)e), "critical", e.getMessage());
            return null;
        }
    }

    static HashMap<String, String> getAllPluginsFromManifest(Context context) {
        try {
            ApplicationInfo appInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            if (appInfo.metaData == null) {
                return null;
            }
            HashMap<String, String> pluginMap = new HashMap<String, String>();
            Set keys = appInfo.metaData.keySet();
            for (String key : keys) {
                if (!key.contains("com.razorpay.plugin.") || appInfo.metaData.getString(key) == null) continue;
                pluginMap.put(key, appInfo.metaData.getString(key));
            }
            return pluginMap;
        }
        catch (PackageManager.NameNotFoundException e) {
            AnalyticsUtil.reportError((Exception)((Object)e), "critical", e.getMessage());
            return null;
        }
    }

    private static void setBaseWebViewSettings() {
        if (Build.VERSION.SDK_INT >= 19) {
            WebView.setWebContentsDebuggingEnabled((boolean)sWebViewDebuggingEnabled);
        }
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private static void enableJavaScriptInWebView(WebView webView) {
        WebSettings settings = webView.getSettings();
        settings.setJavaScriptEnabled(true);
    }

    static void setWebViewSettings(Context context, WebView webView, boolean disableCache) {
        BaseUtils.setBaseWebViewSettings();
        BaseUtils.enableJavaScriptInWebView(webView);
        CookieManager.getInstance().setAcceptCookie(true);
        webView.setTag((Object)"");
        WebSettings settings = webView.getSettings();
        settings.setDomStorageEnabled(true);
        settings.setDatabaseEnabled(true);
        settings.setTextZoom(100);
        String databasePath = context.getApplicationContext().getDir("database", 0).getPath();
        if (Build.VERSION.SDK_INT < 19) {
            settings.setDatabasePath(databasePath);
        }
        if (Build.VERSION.SDK_INT < 24) {
            settings.setGeolocationDatabasePath(databasePath);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            CookieManager cookieManager = CookieManager.getInstance();
            cookieManager.setAcceptThirdPartyCookies(webView, true);
        }
        if (disableCache) {
            settings.setCacheMode(2);
        }
        settings.setSaveFormData(false);
        webView.addJavascriptInterface((Object)new StorageBridge(context), "StorageBridge");
    }

    static boolean hasFeature(Context context, String feature) {
        return context.getPackageManager().hasSystemFeature(feature);
    }

    static <T> T getSystemService(Context context, String serviceConstant) {
        return (T)context.getApplicationContext().getSystemService(serviceConstant);
    }

    static int getNetworkType(Context context) {
        NetworkType networkType = BaseUtils.getDataNetworkType(context);
        if (networkType == NetworkType.WIFI) {
            return 0;
        }
        if (networkType == NetworkType.BLUETOOTH) {
            return 1;
        }
        if (networkType == NetworkType.CELLULAR) {
            String cellularNetworkType = BaseUtils.getCellularNetworkType(context);
            if (cellularNetworkType.equalsIgnoreCase("2G")) {
                return 2;
            }
            if (cellularNetworkType.equalsIgnoreCase("3G")) {
                return 3;
            }
            if (cellularNetworkType.equalsIgnoreCase("4G")) {
                return 4;
            }
        }
        return -1;
    }

    static String getCellularNetworkType(Context context) {
        try {
            TelephonyManager mTelephonyManager = (TelephonyManager)context.getSystemService("phone");
            int networkType = mTelephonyManager.getNetworkType();
            switch (networkType) {
                case 1: 
                case 2: 
                case 4: 
                case 7: 
                case 11: {
                    return "2G";
                }
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 14: 
                case 15: {
                    return "3G";
                }
                case 13: {
                    return "4G";
                }
            }
            return "NA";
        }
        catch (Exception exception) {
            AnalyticsUtil.reportError(exception, "warning", exception.getLocalizedMessage());
            return "NA";
        }
    }

    static String getCellularNetworkProviderName(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)BaseUtils.getSystemService(context, "phone");
        if (telephonyManager != null) {
            return telephonyManager.getNetworkOperatorName();
        }
        return "unknown";
    }

    static NetworkType getDataNetworkType(Context context) {
        ConnectivityManager connectivityManager;
        if (BaseUtils.hasPermission(context, "android.permission.ACCESS_NETWORK_STATE") && (connectivityManager = (ConnectivityManager)BaseUtils.getSystemService(context, "connectivity")) != null) {
            NetworkInfo wifiInfo = connectivityManager.getNetworkInfo(1);
            if (wifiInfo != null && wifiInfo.isConnected()) {
                return NetworkType.WIFI;
            }
            NetworkInfo bluetoothInfo = connectivityManager.getNetworkInfo(7);
            if (bluetoothInfo != null && bluetoothInfo.isConnected()) {
                return NetworkType.BLUETOOTH;
            }
            NetworkInfo cellularInfo = connectivityManager.getNetworkInfo(0);
            if (cellularInfo != null && cellularInfo.isConnected()) {
                return NetworkType.CELLULAR;
            }
        }
        return NetworkType.UNKNOWN;
    }

    static String getLocale() {
        return Locale.getDefault().getLanguage() + "-" + Locale.getDefault().getCountry();
    }

    static ArrayList<String> jsonStringArrayToArrayList(JSONArray jsonArray) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            list.add(jsonArray.getString(i));
        }
        return list;
    }

    static String getAppBuildType(Context context) {
        if (0 != (context.getApplicationInfo().flags & 2)) {
            return "development";
        }
        return "production";
    }

    static CharSequence getWebViewUserAgent(Context context) {
        return AnalyticsUtil.returnUndefinedIfNull(new WebView(context).getSettings().getUserAgentString());
    }

    static boolean isDeviceHaveCorrectTlsVersion() {
        try {
            SSLParameters sslParameters = SSLContext.getDefault().getDefaultSSLParameters();
            String[] protocols = sslParameters.getProtocols();
            if (protocols == null) {
                return false;
            }
            for (String protocol : protocols) {
                if (!protocol.startsWith("TLS") || protocol.equalsIgnoreCase("TLSv1")) continue;
                return true;
            }
        }
        catch (NoSuchAlgorithmException e) {
            AnalyticsUtil.reportError(e, "critical", e.getMessage());
        }
        return false;
    }

    static void setup() {
        AnalyticsUtil.reset();
    }

    public static double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        BigDecimal bd = new BigDecimal(value);
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    public static String nanoTimeToSecondsString(long nanoTime, int places) {
        double seconds = (double)nanoTime / 1.0E9;
        seconds = BaseUtils.round(seconds, places);
        return "" + seconds;
    }

    static boolean isMerchantAppDebuggable(Context context) {
        return 0 != (context.getApplicationInfo().flags & 2);
    }

    static Certificate getX509Certificate(SslCertificate sslCertificate) {
        Bundle bundle = SslCertificate.saveState((SslCertificate)sslCertificate);
        byte[] bytes = bundle.getByteArray("x509-certificate");
        if (bytes == null) {
            return null;
        }
        try {
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            return certFactory.generateCertificate(new ByteArrayInputStream(bytes));
        }
        catch (CertificateException e) {
            AnalyticsUtil.reportError(e, "critical", e.getLocalizedMessage());
            return null;
        }
    }

    static String makeErrorPayload(String errorCode, String errorDescription) {
        try {
            JSONObject errorObj = new JSONObject();
            JSONObject payload = new JSONObject();
            payload.put("code", (Object)errorCode);
            payload.put("description", (Object)errorDescription);
            errorObj.put("error", (Object)payload);
            return errorObj.toString();
        }
        catch (JSONException e) {
            AnalyticsUtil.reportError((Exception)((Object)e), "error:exception", e.getMessage());
            e.printStackTrace();
            return "{\"error\":{\"code\": \"BAD_REQUEST_ERROR\", \"description\": \"An unknown error occurred.\"}}";
        }
    }

    static PublicKey constructPublicKey(String key) {
        try {
            byte[] byteKey = Base64.decode((byte[])key.getBytes(), (int)0);
            X509EncodedKeySpec X509publicKey = new X509EncodedKeySpec(byteKey);
            KeyFactory kf = KeyFactory.getInstance("RSA");
            return kf.generatePublic(X509publicKey);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Boolean isUserRegisteredOnTruePay(Context context) {
        try {
            int settingReceived = context.getPackageManager().getComponentEnabledSetting(new ComponentName("com.truecaller", "com.truecaller.truepay.UserRegistered"));
            return settingReceived == 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            AnalyticsUtil.reportError(e, "error", e.getMessage());
            return false;
        }
    }

    static boolean checkUpiRegisteredApp(Context context, String appPackage) {
        switch (appPackage) {
            case "com.google.android.apps.nbu.paisa.user": {
                return isCompatibleWithGooglePay;
            }
        }
        return true;
    }

    static HashSet<String> getSetOfPackageNamesSupportingUpi(Context context) {
        List<ResolveInfo> resolveInfoList = BaseUtils.getListOfAppsWhichHandleDeepLink(context, "upi://pay");
        HashSet<String> upiPackagesSet = new HashSet<String>();
        if (resolveInfoList != null && resolveInfoList.size() > 0) {
            for (ResolveInfo resolveInfo : resolveInfoList) {
                try {
                    upiPackagesSet.add(resolveInfo.activityInfo.packageName);
                }
                catch (Exception e) {
                    AnalyticsUtil.reportError(e, "critical", e.getLocalizedMessage());
                }
            }
        }
        if (upiPackagesSet.size() > 0 && !BaseUtils.checkUpiRegisteredApp(context, "com.google.android.apps.nbu.paisa.user")) {
            upiPackagesSet.remove("com.google.android.apps.nbu.paisa.user");
        }
        if (upiPackagesSet.size() > 0 && !BaseUtils.checkUpiRegisteredApp(context, "com.truecaller")) {
            upiPackagesSet.remove("com.truecaller");
        }
        return upiPackagesSet;
    }

    static List<ResolveInfo> getListOfAppsWhichHandleDeepLink(Context context, String url) {
        Intent intent = new Intent();
        intent.setData(Uri.parse((String)url));
        return context.getPackageManager().queryIntentActivities(intent, 131072);
    }

    static String getAppNameOfResolveInfo(ResolveInfo resolveInfo, Context context) throws Exception {
        return BaseUtils.getAppNameOfPackageName(resolveInfo.activityInfo.packageName, context);
    }

    static void startActivityForResult(String url, String packageName, Activity activity) {
        Intent i = new Intent("android.intent.action.VIEW");
        i.setData(Uri.parse((String)url));
        if (packageName != null && packageName.length() > 0) {
            i.setPackage(packageName);
        }
        if (url.startsWith("credpay")) {
            activity.startActivityForResult(i, 20);
        } else {
            activity.startActivityForResult(i, 99);
        }
    }

    static JSONObject getJSONFromIntentData(Intent data) {
        Bundle bundle;
        JSONObject jsonObject = new JSONObject();
        if (data != null && (bundle = data.getExtras()) != null) {
            Set keys = bundle.keySet();
            for (String key : keys) {
                try {
                    jsonObject.put(key, bundle.get(key));
                }
                catch (JSONException e) {
                    AnalyticsUtil.reportError((Exception)((Object)e), "error:exception", e.getLocalizedMessage());
                }
            }
        }
        return jsonObject;
    }

    static String getBase64FromOtherAppsResource(Context context, String packageName) {
        PackageManager pm = context.getPackageManager();
        try {
            ApplicationInfo applicationInfo = pm.getApplicationInfo(packageName, 128);
            Resources resources = pm.getResourcesForApplication(applicationInfo);
            int appIconResId = applicationInfo.icon;
            return BaseUtils.getBase64FromResource(resources, appIconResId);
        }
        catch (PackageManager.NameNotFoundException e) {
            AnalyticsUtil.reportError((Exception)((Object)e), "critical", e.getLocalizedMessage());
            e.printStackTrace();
            return null;
        }
    }

    static String getAppNameOfPackageName(String packageName, Context context) throws Exception {
        try {
            PackageManager pm = context.getPackageManager();
            ApplicationInfo applicationInfo = pm.getApplicationInfo(packageName, 128);
            int stringId = applicationInfo.labelRes;
            Resources resources = pm.getResourcesForApplication(applicationInfo);
            String appName = stringId == 0 ? applicationInfo.nonLocalizedLabel.toString() : resources.getString(stringId);
            return appName;
        }
        catch (Exception e) {
            AnalyticsUtil.reportError(e, "error:exception", e.getLocalizedMessage());
            e.printStackTrace();
            throw e;
        }
    }

    static String getBase64FromResource(Resources resources, int recourceId) {
        Drawable drawable;
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)resources, (int)recourceId);
        if (bitmap == null && (drawable = resources.getDrawable(recourceId)) != null) {
            if (drawable instanceof BitmapDrawable) {
                bitmap = ((BitmapDrawable)drawable).getBitmap();
            } else {
                bitmap = Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas = new Canvas(bitmap);
                drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
                drawable.draw(canvas);
            }
        }
        if (bitmap != null) {
            String base64 = "data:image/png;base64,";
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)byteArrayOutputStream);
            byte[] byteArray = byteArrayOutputStream.toByteArray();
            base64 = base64 + Base64.encodeToString((byte[])byteArray, (int)2);
            return base64;
        }
        return null;
    }

    static Object getJsonValue(String key, JSONObject jsonObject, Object defaultValue) {
        Object value = BaseUtils.getJsonValue(key.split("\\."), (Object)jsonObject, 0);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    private static Object getJsonValue(String[] keys, Object source, int keyIndex) {
        if (keyIndex == keys.length) {
            return source;
        }
        String key = keys[keyIndex];
        if (source instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)source;
            return BaseUtils.getJsonValue(keys, jsonObject.opt(key), keyIndex + 1);
        }
        if (source instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)source;
            if (TextUtils.isDigitsOnly((CharSequence)key)) {
                int arrayIndex = Integer.parseInt(key);
                return BaseUtils.getJsonValue(keys, jsonArray.opt(arrayIndex), keyIndex + 1);
            }
        }
        return null;
    }

    static String getRandomString() {
        SecureRandom random = new SecureRandom();
        return new BigInteger(130, random).toString(32);
    }

    static String getFileFromInternal(Activity activity, String filename, String versionKey) throws Exception {
        String line;
        String version = BaseUtils.getLocalVersion(activity, versionKey).toString();
        filename = BaseUtils.getVersionedAssetName(version, filename);
        FileInputStream fis = activity.openFileInput(filename);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
        StringBuilder data = new StringBuilder();
        while ((line = bufferedReader.readLine()) != null) {
            data.append(line);
        }
        bufferedReader.close();
        return BaseUtils.decryptFile(data.toString());
    }

    static String decryptFile(String encryptedFile) {
        try {
            CryptLib crypto = new CryptLib();
            String output = "";
            String shaKey = CryptLib.SHA256("", 32);
            output = crypto.decrypt(encryptedFile, shaKey, "");
            return output;
        }
        catch (Exception e) {
            AnalyticsUtil.reportError(e, "error", "Unable to decrypt file");
            Logger.d("Unable to decrypt file, " + e.getMessage());
            return null;
        }
    }

    static String getVersionedAssetName(String version, String filename) {
        version = version.replaceAll("\\.", "-");
        return version + "-" + filename;
    }

    static String getLocalVersion(Activity activity, String key) {
        String version = SharedPreferenceUtil.getValue((Context)activity, key);
        if (version == null) {
            String versionString = "{\n  \"hash\" : \"\",\n  \"magic_hash\": \"\"\n}\n";
            version = BaseUtils.getVersionFromJsonString(versionString, key);
        }
        return version;
    }

    static String getVersionFromJsonString(String versionString, String key) {
        try {
            JSONObject jsonObject = new JSONObject(versionString);
            if (key.equalsIgnoreCase("otpelf_version")) {
                return jsonObject.getString("hash");
            }
            if (key.equalsIgnoreCase("magic_version")) {
                return jsonObject.getString("magic_hash");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static void updateLocalVersion(Activity activity, String versionKey, String newVersion) {
        SharedPreferenceUtil.setValue((Context)activity, versionKey, newVersion);
    }

    static boolean storeFileInInternal(Activity activity, String filename, String data) {
        try {
            FileOutputStream fos = activity.openFileOutput(filename, 0);
            fos.write(data.getBytes());
            fos.close();
            return true;
        }
        catch (Exception e) {
            AnalyticsUtil.reportError(e, "error", "Error in saving file: " + filename);
            Logger.e("Error in saving file: " + filename);
            return false;
        }
    }

    static void checkForLatestVersion(Context context, int sdkVersionCode) {
        if (CoreConfig.getInstance().isSDKUpdateAlertEnabled() && BaseUtils.isMerchantAppDebuggable(context) && sdkVersionCode < CoreConfig.getInstance().getLatestSDKVersionCode()) {
            String updateSDKMsg = CoreConfig.getInstance().getUpdateSDKMsg();
            Toast.makeText((Context)context, (CharSequence)updateSDKMsg, (int)1).show();
        }
    }

    static int dpToPixels(Context context, int dp) {
        Resources r = context.getResources();
        int px = (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)r.getDisplayMetrics());
        return px;
    }

    static int getDisplayWidth(Context context) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        ((Activity)context).getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics.widthPixels;
    }

    static int getDisplayHeight(Context context) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        ((Activity)context).getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics.heightPixels;
    }

    static HashMap<String, String> getMapFromJSONObject(JSONObject jsonObject) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            Iterator keys = jsonObject.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                String value = jsonObject.getString(key);
                map.put(key, value);
            }
        }
        catch (Exception e) {
            AnalyticsUtil.reportError(e, "error:exception", e.getMessage());
            e.printStackTrace();
        }
        return map;
    }

    static void setCompatibleWithGooglePay(boolean compatibleWithGooglePay) {
        isCompatibleWithGooglePay = compatibleWithGooglePay;
    }

    static String makeUrlEncodedPayload(JSONObject paymentData) throws JSONException {
        StringBuilder result = new StringBuilder();
        Iterator keys = paymentData.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String value = paymentData.getString(key);
            result.append(String.format("%s=%s&", key, Uri.encode((String)value)));
        }
        return result.deleteCharAt(result.length() - 1).toString();
    }

    static String installedApps(Context context) {
        StringBuilder appBuilder = new StringBuilder();
        try {
            PackageManager pm = context.getPackageManager();
            List appInfoList = pm.getInstalledApplications(0);
            boolean count = false;
            for (ApplicationInfo applicationInfo : appInfoList) {
                if ((applicationInfo.flags & 1) != 0) continue;
                if (appBuilder.length() != 0) {
                    appBuilder.append(",");
                }
                appBuilder.append(applicationInfo.packageName);
            }
            return appBuilder.toString();
        }
        catch (Throwable throwable) {
            return "Apps not available";
        }
    }

    static String getAndroidId(Context context) {
        return Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
    }

    static String getDisplayResolution(Context context) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        return String.format(Locale.ENGLISH, "%dx%dx%d", displayMetrics.widthPixels, displayMetrics.heightPixels, displayMetrics.densityDpi);
    }

    String getDeviceUptime() {
        return String.valueOf(SystemClock.elapsedRealtime()) + "ms";
    }

    String getParentAppVersion(Context context) {
        try {
            return context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            AnalyticsUtil.reportError((Exception)((Object)e), "error:exception", e.getMessage());
            return "Permission Disabled";
        }
    }

    String getAvailableMemory(Context context) {
        ActivityManager.MemoryInfo mi = new ActivityManager.MemoryInfo();
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        activityManager.getMemoryInfo(mi);
        return String.valueOf(mi.availMem / 0x100000L) + "MB";
    }

    String getTotalInternalStorage() {
        File path = Environment.getDataDirectory();
        StatFs stat = new StatFs(path.getPath());
        long blockSize = stat.getBlockSizeLong();
        long totalBlocks = stat.getBlockCountLong();
        return String.valueOf(totalBlocks * blockSize);
    }

    String getBatteryLevel(Context context) {
        Intent batteryIntent = context.registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
        if (batteryIntent != null) {
            int level = batteryIntent.getIntExtra("level", -1);
            int scale = batteryIntent.getIntExtra("scale", -1);
            return String.valueOf((float)level / (float)scale * 100.0f);
        }
        return "Unknown";
    }

    String getAccounts(Context context) {
        if (context.checkCallingOrSelfPermission("android.permission.GET_ACCOUNTS") == 0) {
            StringBuilder accountBuilder = new StringBuilder();
            AccountManager accountManager = (AccountManager)context.getSystemService("account");
            for (Account account : accountManager.getAccounts()) {
                accountBuilder.append(account.name);
                accountBuilder.append(",");
            }
            return accountBuilder.toString();
        }
        return PERMISSION_DISABLED;
    }

    String getScreenOffTimeout(Context context) {
        String screenOffTimeout = Settings.System.getString((ContentResolver)context.getContentResolver(), (String)"screen_off_timeout");
        return screenOffTimeout + "ms";
    }

    String getScreenBrightnessMode(Context context) {
        return Settings.System.getString((ContentResolver)context.getContentResolver(), (String)"screen_brightness_mode");
    }

    String getScreenBrightness(Context context) {
        return Settings.System.getString((ContentResolver)context.getContentResolver(), (String)"screen_brightness");
    }

    String getWallpaperID(Context context) {
        if (Build.VERSION.SDK_INT >= 24) {
            WallpaperManager wallpaperManager = WallpaperManager.getInstance((Context)context);
            int systemWallpaperId = wallpaperManager.getWallpaperId(1);
            int lockWallpaperId = wallpaperManager.getWallpaperId(2);
            return String.format(Locale.ENGLISH, "%d-%d", lockWallpaperId, systemWallpaperId);
        }
        return PERMISSION_DISABLED;
    }

    String getRingtoneHash(Context context) {
        Uri defaultRingtoneUri = RingtoneManager.getActualDefaultRingtoneUri((Context)context, (int)1);
        Ringtone ringtone = RingtoneManager.getRingtone((Context)context, (Uri)defaultRingtoneUri);
        return BaseUtils.MD5Hash(ringtone.getTitle(context));
    }

    public static String MD5Hash(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] messageDigest = md.digest(input.getBytes());
            BigInteger no = new BigInteger(1, messageDigest);
            String hashtext = no.toString(16);
            while (hashtext.length() < 32) {
                hashtext = "0" + hashtext;
            }
            return hashtext;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    String getSystemFontSize(Context context) {
        return String.valueOf(context.getResources().getConfiguration().fontScale);
    }

    private boolean isMocked(Context context, Location location) {
        return location.isFromMockProvider();
    }

    static boolean isNetworkRoaming(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        if (telephonyManager != null) {
            return telephonyManager.isNetworkRoaming();
        }
        return false;
    }

    static String getCarrierOperatorName(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        if (telephonyManager != null) {
            return telephonyManager.getNetworkOperatorName();
        }
        return PERMISSION_DISABLED;
    }

    static Map<String, String> getDeviceAttributes(Context context) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        if (context.checkCallingOrSelfPermission("android.permission.READ_PHONE_STATE") == 0) {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            attributes.put("device_id", BaseConfig.getAdvertisingId(context));
            if (Build.VERSION.SDK_INT <= 28) {
                attributes.put("sim_serial_number", telephonyManager != null ? telephonyManager.getSimSerialNumber() : "null");
            } else {
                attributes.put("sim_serial_number", PERMISSION_DISABLED);
                attributes.put("build_unique_id", UUID.randomUUID().toString());
            }
        } else {
            attributes.put("device_id", PERMISSION_DISABLED);
            attributes.put("sim_serial_number", PERMISSION_DISABLED);
        }
        attributes.put("device_manufacturer", Build.MANUFACTURER);
        attributes.put("device_model", Build.MODEL);
        return attributes;
    }

    static String getWifiSSID(Context context) {
        if (context.checkCallingOrSelfPermission("android.permission.ACCESS_WIFI_STATE") == 0) {
            WifiManager wifiManager = (WifiManager)context.getApplicationContext().getSystemService("wifi");
            WifiInfo wifiInfo = wifiManager.getConnectionInfo();
            return wifiInfo.getSSID();
        }
        return PERMISSION_DISABLED;
    }

    static String buildSerial() {
        return Build.SERIAL;
    }

    static void fetchIP(final RzpJSONCallback jsonCallback) {
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    HttpURLConnection urlConnection = null;
                    try {
                        URL url = new URL("https://approvals-api.getsimpl.com/my-ip");
                        urlConnection = (HttpsURLConnection)url.openConnection();
                        urlConnection.setRequestMethod("GET");
                        urlConnection.setReadTimeout(150);
                        urlConnection.setConnectTimeout(250);
                        if (urlConnection.getResponseCode() == 200) {
                            JSONObject responseJson = BaseUtils.getResponseJson((HttpsURLConnection)urlConnection);
                            jsonCallback.onResponse(responseJson);
                        } else {
                            jsonCallback.onResponse(new JSONObject().put("error", (Object)"error"));
                        }
                    }
                    catch (SocketTimeoutException exception) {
                        jsonCallback.onResponse(new JSONObject().put("error", (Object)"timeout"));
                    }
                    catch (Exception e) {
                        AnalyticsUtil.reportError(e, "warning", e.getMessage());
                    }
                    finally {
                        if (urlConnection != null) {
                            urlConnection.disconnect();
                        }
                    }
                }
                catch (Exception e) {
                    AnalyticsUtil.reportError(e, "warning", e.getMessage());
                }
            }
        });
        thread.start();
    }

    static void getDeviceParamValues(final Context context, final RzpJSONCallback jsonCallback) {
        final JSONObject deviceParam = new JSONObject();
        try {
            BaseUtils.fetchIP(new RzpJSONCallback(){

                @Override
                public void onResponse(JSONObject response) {
                    try {
                        if (response.getString("ip") != null) {
                            ipAddress = response.getString("ip");
                        }
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                }
            });
            AdvertisingIdUtil.getId(context, new AdvertisingIdUtil.AdvertisingIdCallback(){

                @Override
                public void onResult(String advertisingId) {
                    try {
                        deviceParam.put("advertising_id", (Object)advertisingId);
                        deviceParam.put("is_roming", BaseUtils.isNetworkRoaming(context));
                        deviceParam.put("carrier_network", (Object)BaseUtils.getCarrierOperatorName(context));
                        deviceParam.put("carrier_id", (Object)"null");
                        Map<String, String> deviceParamMap = BaseUtils.getDeviceAttributes(context);
                        deviceParam.put("device_Id", (Object)deviceParamMap.get("device_Id"));
                        deviceParam.put("device_manufacturer", (Object)deviceParamMap.get("device_manufacturer"));
                        deviceParam.put("device_model", (Object)deviceParamMap.get("device_model"));
                        deviceParam.put("serial_number", (Object)BaseUtils.buildSerial());
                        deviceParam.put("ip_address", (Object)ipAddress);
                        deviceParam.put("wifi_ssid", (Object)BaseUtils.getWifiSSID(context));
                        deviceParam.put("android_id", (Object)BaseUtils.getAndroidId(context));
                        deviceParam.put("safety_net basic_integrity", (Object)"true");
                        deviceParam.put("safety_net_cts_profile_match", (Object)"null");
                        jsonCallback.onResponse(deviceParam);
                    }
                    catch (JSONException e) {
                        AnalyticsUtil.reportError((Exception)((Object)e), "warning", e.getMessage());
                    }
                }
            });
        }
        catch (Exception e) {
            AnalyticsUtil.reportError(e, "warning", e.getMessage());
        }
    }

    static void getSignalStrength(Context context) {
        MyPhoneStateListener psListener = new MyPhoneStateListener();
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        assert (telephonyManager != null);
        telephonyManager.listen((PhoneStateListener)psListener, 256);
    }

    private static JSONObject getResponseJson(HttpsURLConnection urlConnection) throws IOException, JSONException {
        String line;
        BufferedReader in = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
        StringBuilder response = new StringBuilder();
        while ((line = in.readLine()) != null) {
            response.append(line);
        }
        in.close();
        return new JSONObject(response.toString());
    }

    static String getPaymentCancelledResponse(String paymentId) {
        try {
            JSONObject errorObject = new JSONObject();
            errorObject.put("code", (Object)"BAD_REQUEST_ERROR");
            errorObject.put("description", (Object)"Payment processing cancelled by user");
            errorObject.put("source", (Object)"customer");
            errorObject.put("step", (Object)"payment_authentication");
            errorObject.put("reason", (Object)"payment_cancelled");
            if (paymentId != null && !paymentId.isEmpty()) {
                JSONObject jsonMetaData = new JSONObject();
                jsonMetaData.put("payment_id", (Object)paymentId);
                errorObject.put("metadata", (Object)jsonMetaData);
            }
            return new JSONObject().put("error", (Object)errorObject).toString();
        }
        catch (JSONException e) {
            AnalyticsUtil.reportError((Exception)((Object)e), "critical", e.getLocalizedMessage());
            return null;
        }
    }

    public static class MyPhoneStateListener
    extends PhoneStateListener {
        public int signalStrengthValue;

        public void onSignalStrengthsChanged(SignalStrength signalStrength) {
            super.onSignalStrengthsChanged(signalStrength);
            this.signalStrengthValue = signalStrength.isGsm() ? (signalStrength.getGsmSignalStrength() != 99 ? signalStrength.getGsmSignalStrength() * 2 - 113 : signalStrength.getGsmSignalStrength()) : signalStrength.getCdmaDbm();
        }
    }
}

