/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.content.Context;
import com.razorpay.AnalyticsUtil;

class RazorpayExceptionHandler
implements Thread.UncaughtExceptionHandler {
    Thread.UncaughtExceptionHandler existingHandler;
    Context context;

    RazorpayExceptionHandler(Context context, Thread.UncaughtExceptionHandler handler) {
        this.existingHandler = handler;
        this.context = context;
    }

    static void register(Context context) {
        Thread.UncaughtExceptionHandler existingHandler = Thread.getDefaultUncaughtExceptionHandler();
        if (!(existingHandler instanceof RazorpayExceptionHandler)) {
            Thread.setDefaultUncaughtExceptionHandler(new RazorpayExceptionHandler(context, existingHandler));
        }
    }

    static void unregister() {
        Thread.UncaughtExceptionHandler currentHandler = Thread.getDefaultUncaughtExceptionHandler();
        if (currentHandler instanceof RazorpayExceptionHandler) {
            RazorpayExceptionHandler razorpayExceptionHandler = (RazorpayExceptionHandler)currentHandler;
            Thread.setDefaultUncaughtExceptionHandler(razorpayExceptionHandler.existingHandler);
        }
    }

    @Override
    public void uncaughtException(Thread thread, final Throwable throwable) {
        new Thread(){

            @Override
            public void run() {
                AnalyticsUtil.reportUncaughtException(throwable);
                AnalyticsUtil.saveEventsToPreferences(RazorpayExceptionHandler.this.context);
            }
        }.start();
        if (this.existingHandler != null) {
            this.existingHandler.uncaughtException(thread, throwable);
        }
    }
}

