/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.app.Activity;
import com.razorpay.AnalyticsUtil;
import com.razorpay.BaseUtils;
import com.razorpay.Callback;
import com.razorpay.Config;
import com.razorpay.Owl;
import com.razorpay.ResponseObject;

class MagicData {
    Activity activity;
    private String magicJs;
    public static String versionKey = "magic_version";

    MagicData(Activity activity) {
        this.activity = activity;
    }

    void checkForUpdates() {
        Owl.get(Config.getInstance().getMagicVersionUrl(), new Callback(){

            @Override
            public void run(ResponseObject data) {
                if (data.getResponseResult() == null) {
                    return;
                }
                try {
                    String serverVersion = BaseUtils.getVersionFromJsonString(data.getResponseResult(), versionKey);
                    String localVersion = BaseUtils.getLocalVersion(MagicData.this.activity, versionKey);
                    if (!localVersion.equals(serverVersion)) {
                        MagicData.this.updateMagic(serverVersion);
                    }
                }
                catch (Exception e) {
                    AnalyticsUtil.reportError(e, "error", "Could not extract version from server json");
                }
            }
        });
    }

    private void updateMagic(String serverVersion) {
        final String version = serverVersion;
        Owl.get(Config.getInstance().getMagicJsUrl(), new Callback(){

            @Override
            public void run(ResponseObject data) {
                String fileName;
                String decryptedFile;
                if (data.getResponseResult() != null && (decryptedFile = BaseUtils.decryptFile(data.getResponseResult())) != null && BaseUtils.storeFileInInternal(MagicData.this.activity, fileName = BaseUtils.getVersionedAssetName(version, Config.getInstance().getMagicJsFileName()), data.getResponseResult())) {
                    MagicData.this.magicJs = decryptedFile;
                    BaseUtils.updateLocalVersion(MagicData.this.activity, versionKey, version);
                }
            }
        });
    }

    String getMagicJs() {
        if (this.magicJs == null) {
            String version = BaseUtils.getLocalVersion(this.activity, versionKey);
            if (version.equals(BaseUtils.getVersionFromJsonString(Config.getVersionJSON(), versionKey))) {
                this.magicJs = Config.getMagicJs();
            } else {
                try {
                    this.magicJs = BaseUtils.getFileFromInternal(this.activity, Config.getInstance().getMagicJsFileName(), versionKey);
                }
                catch (Exception e) {
                    this.magicJs = Config.getMagicJs();
                }
            }
        }
        return this.magicJs;
    }
}

