/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.os.Bundle;
import com.razorpay.AnalyticsEvent;
import com.razorpay.AnalyticsProperty;
import com.razorpay.AnalyticsUtil;
import com.razorpay.BaseUtils;
import com.razorpay.Config;
import com.razorpay.Logger;
import com.razorpay.SharedPreferenceUtil;
import java.util.HashMap;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

class CardSaving {
    CardSaving() {
    }

    static void sendBroadcastForFetchingDeviceToken(Context context) {
        Intent intent = new Intent();
        intent.setAction("rzp.device_token.share");
        context.sendOrderedBroadcast(intent, null, new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String listString;
                Bundle result = this.getResultExtras(true);
                if (result != null && (listString = result.getString("device_token_info_list")) != null) {
                    try {
                        JSONArray jsonArray = new JSONArray(listString);
                        CardSaving.getCorrectDeviceTokenFromInfoListAndSave(context, jsonArray);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }, null, -1, null, null);
    }

    static String getCorrectDeviceTokenFromInfoListAndSave(Context context, JSONArray deviceTokenInfoList) {
        JSONObject selectedApp = null;
        if (deviceTokenInfoList == null || deviceTokenInfoList.length() == 0) {
            return null;
        }
        if (deviceTokenInfoList.length() == 1) {
            try {
                selectedApp = deviceTokenInfoList.getJSONObject(0);
            }
            catch (Exception exception) {}
        } else if (deviceTokenInfoList.length() != 1) {
            String token = null;
            boolean multipleTokens = false;
            String jsonPayload = "{";
            boolean isFirstPair = true;
            for (int i = 0; i < deviceTokenInfoList.length(); ++i) {
                try {
                    JSONObject app = deviceTokenInfoList.getJSONObject(i);
                    if (!isFirstPair) {
                        jsonPayload = jsonPayload + ",";
                    } else {
                        isFirstPair = false;
                    }
                    jsonPayload = jsonPayload + "'" + app.getString("card_saving_token_source") + "': '" + app.getString("rzp_device_token") + "'";
                    if (token == null) {
                        token = app.getString("rzp_device_token");
                        continue;
                    }
                    if (token.equals(app.getString("rzp_device_token"))) continue;
                    multipleTokens = true;
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            jsonPayload = jsonPayload + "}";
            if (multipleTokens) {
                HashMap<String, Object> props = new HashMap<String, Object>();
                props.put("packages", jsonPayload);
                AnalyticsUtil.trackEvent(AnalyticsEvent.MULTIPLE_TOKEN_EVENT, props);
                return null;
            }
            try {
                selectedApp = deviceTokenInfoList.getJSONObject(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (selectedApp != null) {
            String deviceToken = "";
            String sourcePackageName = "";
            try {
                deviceToken = selectedApp.getString("rzp_device_token");
                sourcePackageName = selectedApp.getString("card_saving_token_source");
            }
            catch (Exception exception) {
                // empty catch block
            }
            CardSaving.setDeviceToken(context, deviceToken);
            AnalyticsUtil.addProperty("device_token_source_single", new AnalyticsProperty(sourcePackageName, AnalyticsProperty.Scope.ORDER));
            return deviceToken;
        }
        return null;
    }

    static void fetchDeviceTokenFromOtherAppsIfRequired(Context context) throws IllegalStateException {
        String deviceToken;
        if (Config.getInstance().isCardSavingLocalEnabled() && (deviceToken = CardSaving.getDeviceToken(context)) != null) {
            AnalyticsUtil.addProperty("device_token_source_single", new AnalyticsProperty(context.getPackageName(), AnalyticsProperty.Scope.ORDER));
            return;
        }
        if (Build.VERSION.SDK_INT >= 24 && Config.getInstance().isCardSavingBroadcastReceiverFlowEnabled()) {
            CardSaving.sendBroadcastForFetchingDeviceToken(context);
        } else if (Config.getInstance().isCardSavingSharedPreferencesFlowEnabled()) {
            JSONArray appList = CardSaving.getListOfRazorpayPackages(context);
            CardSaving.getCorrectDeviceTokenFromInfoListAndSave(context, appList);
        }
    }

    private static JSONArray getListOfRazorpayPackages(Context context) {
        JSONArray list = new JSONArray();
        List<ResolveInfo> resolveInfoList = BaseUtils.getListOfAppsWhichHandleDeepLink(context, "io.rzp://rzp.io");
        int sdkCount = 0;
        for (ResolveInfo resolveInfo : resolveInfoList) {
            String packageName = resolveInfo.activityInfo.taskAffinity;
            ++sdkCount;
            try {
                Context cxt = context.createPackageContext(packageName, 2);
                String deviceToken = CardSaving.getDeviceToken(cxt);
                if (deviceToken == null) continue;
                JSONObject deviceTokenInfo = new JSONObject();
                deviceTokenInfo.put("rzp_device_token", (Object)deviceToken);
                deviceTokenInfo.put("card_saving_token_source", (Object)packageName);
                list.put((Object)deviceTokenInfo);
            }
            catch (Exception e) {
                if (e instanceof SecurityException && Build.VERSION.SDK_INT >= 24) {
                    AnalyticsUtil.trackEvent(AnalyticsEvent.SHARE_PREFERENCES_SECURITY_EXCEPTION);
                } else {
                    AnalyticsUtil.reportError(e, "critical", e.getMessage());
                }
                Logger.e("Error fetching global device token", e);
            }
        }
        AnalyticsUtil.addProperty("sdk_count", new AnalyticsProperty(sdkCount, AnalyticsProperty.Scope.ORDER));
        AnalyticsUtil.addProperty("sdk_count_with_token", new AnalyticsProperty(list.length(), AnalyticsProperty.Scope.ORDER));
        return list;
    }

    static String getAppToken(Context context) {
        SharedPreferences sharedPref = SharedPreferenceUtil.getPrivatePrefs(context);
        return sharedPref.getString("rzp_app_token", null);
    }

    static void setAppToken(Context context, String appToken) {
        SharedPreferences.Editor editor = SharedPreferenceUtil.getPrivateEditor(context);
        editor.putString("rzp_app_token", appToken).apply();
    }

    static String getDeviceToken(Context context) {
        SharedPreferences sharedPref = SharedPreferenceUtil.getPublicPrefs(context);
        return sharedPref.getString("rzp_device_token", null);
    }

    static void setDeviceToken(Context context, String deviceToken) {
        SharedPreferences.Editor editor = SharedPreferenceUtil.getPublicEditor(context);
        editor.putString("rzp_device_token", deviceToken).apply();
    }

    static void clearDeviceToken(Context context) {
        SharedPreferenceUtil.getPublicEditor(context).remove("rzp_device_token").apply();
    }
}

