/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Color;
import android.net.Uri;
import android.os.Bundle;
import android.os.ParcelFileDescriptor;
import android.text.TextUtils;
import android.util.Base64;
import android.webkit.WebView;
import com.google.android.gms.auth.api.phone.SmsRetriever;
import com.google.android.gms.tasks.Task;
import com.razorpay.AnalyticsEvent;
import com.razorpay.AnalyticsProperty;
import com.razorpay.AnalyticsProperty$Scope;
import com.razorpay.AnalyticsUtil;
import com.razorpay.AppSignatureHelper;
import com.razorpay.B$$Z_;
import com.razorpay.BaseUtils;
import com.razorpay.CheckoutBridge$WebViewSafeCheckCallback;
import com.razorpay.CheckoutInteractor;
import com.razorpay.CheckoutPresenter;
import com.razorpay.CheckoutPresenterImpl$CheckoutView;
import com.razorpay.CheckoutUtils;
import com.razorpay.E__a_;
import com.razorpay.G$_X_;
import com.razorpay.G_$8_;
import com.razorpay.H$$i_;
import com.razorpay.J__A$;
import com.razorpay.J__n_;
import com.razorpay.K_$q$;
import com.razorpay.L_$k$;
import com.razorpay.L__R$;
import com.razorpay.M$_J_;
import com.razorpay.N_$R$;
import com.razorpay.O$_M$;
import com.razorpay.R;
import com.razorpay.T_$Z$;
import com.razorpay.b$_f_;
import com.razorpay.b__J_;
import com.razorpay.c__h$;
import com.razorpay.d__1_;
import com.razorpay.d__w$;
import com.razorpay.e;
import com.razorpay.h;
import com.razorpay.k__c$;
import com.razorpay.l__9_;
import com.razorpay.p$_5$;
import com.razorpay.q$_Y$;
import com.razorpay.q_$J$;
import com.razorpay.r;
import com.razorpay.t$$1$;
import com.razorpay.z$_w$;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.json.JSONException;
import org.json.JSONObject;

class CheckoutPresenterImpl
implements CheckoutInteractor,
CheckoutPresenter {
    protected Activity activity;
    protected CheckoutPresenterImpl$CheckoutView view;
    String merchantKey;
    J__A$ checkoutOptions;
    private String dashOptions;
    private JSONObject dashOptionsJSON;
    private String checkoutUrl;
    private String checkoutContent = "{}";
    private int paymentAttempts = 0;
    private boolean clearHistory;
    private boolean isPaymentSuccessful = false;
    private boolean isSmsReceiverRegistered = false;
    private long preloadCompleteDuration;
    private long preloadAbortDuration;
    private long checkoutLoadStartAt;
    private boolean isTwoWebViewFlow = false;
    private boolean isMagic = false;
    private int merchantLogoResourceId = 0;
    private boolean isActivityCreated = false;
    private Task<Void> loginOtpSmsTask;
    private b__J_ autoReadOtpHelper;
    private boolean sendSmsHash = false;
    private boolean allowRotation = false;
    private String sanitizedChallanEncodedString = "";
    private String payment_id = null;
    private p$_5$ magicBase = null;
    private boolean nameNotFound_retryStatus = false;
    private Task<Void> automaticRetrievalTask;
    private Task<Void> userConsentTask;
    BroadcastReceiver otpAutoReadBroadcast = new L_$k$(this);
    Queue<String> checkoutMessageQueue = new LinkedList<String>();
    private boolean isCheckoutLoaded = false;

    void enableCheckoutLoaded() {
        this.isCheckoutLoaded = true;
    }

    void enableTwoViewFlow() {
        this.isTwoWebViewFlow = true;
    }

    public CheckoutPresenterImpl(Activity activity, CheckoutPresenterImpl$CheckoutView checkoutPresenterImpl$CheckoutView) {
        this.activity = activity;
        this.view = checkoutPresenterImpl$CheckoutView;
    }

    @Override
    public boolean setOptions(Bundle bundle, boolean bl) {
        this.isActivityCreated = bl;
        if (bundle == null) {
            this.destroyActivity(0, this.activity.getResources().getString(R.string.activity_result_invalid_parameters));
            return false;
        }
        this.checkoutOptions = new J__A$(bundle.getString("OPTIONS"));
        JSONObject object4 = this.checkoutOptions.d();
        if (object4.has("retry")) {
            M$_J_.a().a(object4);
        }
        this.merchantKey = this.checkoutOptions.a();
        this.sendSmsHash = this.checkoutOptions.b();
        this.allowRotation = this.checkoutOptions.c();
        this.merchantLogoResourceId = bundle.getInt("IMAGE", 0);
        this.checkoutOptions.a(this.activity, this.merchantLogoResourceId);
        String string2 = this.merchantKey;
        Object object = this.activity;
        AnalyticsUtil.setup((Context)object, string2, M$_J_.a, M$_J_.c, M$_J_.b);
        object4.has("ep");
        object = this.checkoutOptions;
        string2 = "https://api.razorpay.com/v1/checkout/public";
        string2 = CheckoutUtils.a("https://api.razorpay.com/v1/checkout/public", "version", M$_J_.b);
        Map<String, String> map = M$_J_.a().g();
        ArrayList<String> arrayList = map.keySet();
        for (String string3 : arrayList) {
            string2 = CheckoutUtils.a(string2, string3, map.get(string3));
        }
        arrayList = M$_J_.a().h();
        for (String string4 : arrayList) {
            if (!((J__A$)object).a(string4)) continue;
            string2 = CheckoutUtils.a(string2, string4, (String)((J__A$)object).c(string4));
        }
        new StringBuilder("Modified Url: ").append(string2);
        this.checkoutUrl = string2;
        if (this.checkoutUrl == null) {
            this.destroyActivity(3, this.activity.getResources().getString(R.string.activity_result_invalid_url));
        }
        if (!bl) {
            String string3;
            this.checkoutOptions.h();
            string2 = this.merchantKey;
            object = this.activity;
            this.dashOptions = r.a((Context)object, "pref_merchant_options_" + string2, null);
            if (this.dashOptions != null) {
                try {
                    this.dashOptionsJSON = new JSONObject(this.dashOptions);
                }
                catch (Exception exception) {
                    AnalyticsUtil.reportError("CxPsntrImpl", "S0", exception.getLocalizedMessage());
                }
            }
            if ((string3 = bundle.getString("FRAMEWORK")) != null) {
                AnalyticsUtil.addProperty("framework", new AnalyticsProperty(string3, AnalyticsProperty$Scope.ORDER));
            }
            AnalyticsUtil.setFramework(string3);
            string3 = bundle.getString("FRAMEWORK_VERSION");
            if (string3 != null) {
                AnalyticsUtil.addProperty("frameworkVersion", new AnalyticsProperty(string3, AnalyticsProperty$Scope.ORDER));
            }
            if (bundle.getBoolean("DISABLE_FULL_SCREEN", false)) {
                CheckoutUtils.a(this.activity);
            }
            if (bundle.containsKey("PRELOAD_COMPLETE_DURATION")) {
                this.preloadCompleteDuration = bundle.getLong("PRELOAD_COMPLETE_DURATION");
            }
            if (bundle.containsKey("PRELOAD_ABORT_DURATION")) {
                this.preloadAbortDuration = bundle.getLong("PRELOAD_ABORT_DURATION");
            }
        } else {
            this.dashOptions = bundle.getString("DASH_OPTIONS");
            if (bundle.getBoolean("DISABLE_FULL_SCREEN", false)) {
                CheckoutUtils.a(this.activity);
            }
        }
        return true;
    }

    private void injectJs(String string2) {
        this.view.loadUrl(1, String.format("javascript: %s", string2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onActivityResultReceived(int n2, int n3, Intent object) {
        if (n2 == 77) {
            IOException iOException;
            if (n3 != -1) return;
            if (object.getData() == null) return;
            Uri uri = object.getData();
            try {
                ParcelFileDescriptor parcelFileDescriptor = this.activity.getContentResolver().openFileDescriptor(uri, "w");
                object = new FileOutputStream(parcelFileDescriptor.getFileDescriptor());
                byte[] byArray = Base64.decode((String)this.sanitizedChallanEncodedString, (int)0);
                ((FileOutputStream)object).write(byArray);
                ((FileOutputStream)object).close();
                parcelFileDescriptor.close();
                return;
            }
            catch (IOException iOException2) {
                iOException = iOException2;
                iOException2.printStackTrace();
                return;
            }
            finally {
                iOException = new Intent("android.intent.action.VIEW");
                iOException.setDataAndType(uri, "application/pdf");
                iOException.addFlags(1);
                this.activity.startActivity((Intent)iOException);
            }
        } else {
            if (n2 == 1001) {
                if (n3 == -1) {
                    AnalyticsUtil.trackEvent(AnalyticsEvent.AUTO_READ_OTP_SMS_RETRIEVER_API_RECEIVED_SMS);
                    String string2 = object.getStringExtra("com.google.android.gms.auth.api.phone.EXTRA_SMS_MESSAGE");
                    if (this.isCheckoutLoaded) {
                        try {
                            JSONObject jSONObject = new JSONObject();
                            jSONObject.put("sender", (Object)"razorpay");
                            jSONObject.put("message", (Object)string2);
                            this.injectJs(String.format("OTPElf.showOTP('%s','%s')", string2, "razorpay"));
                            AnalyticsUtil.trackEvent(AnalyticsEvent.AUTO_READ_OTP_SMS_RETRIEVER_API_OTP_POPULATION_JS);
                        }
                        catch (JSONException jSONException) {
                            AnalyticsUtil.reportError("CxPsntrImpl", "S0", jSONException.getLocalizedMessage());
                            jSONException.printStackTrace();
                        }
                    }
                } else {
                    AnalyticsUtil.trackEvent(AnalyticsEvent.AUTO_READ_OTP_SMS_RETRIEVER_API_CONSENT_DECLINED);
                }
                if (this.userConsentTask == null || this.userConsentTask.isSuccessful()) return;
                this.startSmsRetrievers();
                return;
            }
            if (n2 == 99) {
                JSONObject jSONObject = BaseUtils.getJSONFromIntentData((Intent)object);
                String string3 = String.format("javascript: upiIntentResponse(%s)", jSONObject.toString());
                this.loadResultToWebView(jSONObject, string3);
                return;
            }
            if (n2 != 20) return;
            try {
                JSONObject jSONObject = new JSONObject("{'data':" + n3 + "}");
                jSONObject.put("provider", (Object)"CRED");
                String string4 = String.format("javascript:externalAppResponse(%s)", jSONObject.toString());
                this.loadResultToWebView(jSONObject, string4);
                return;
            }
            catch (JSONException jSONException) {
                AnalyticsUtil.reportError("CxPsntrImpl", "S0", jSONException.getMessage());
            }
        }
    }

    private void loadResultToWebView(JSONObject jSONObject, String string2) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("result", jSONObject);
        AnalyticsUtil.trackEvent(AnalyticsEvent.NATIVE_INTENT_ONACTIVITY_RESULT, AnalyticsUtil.getJSONResponse(hashMap));
        if (this.isCheckoutLoaded) {
            this.view.loadUrl(1, string2);
            return;
        }
        if (this.checkoutMessageQueue == null) {
            this.checkoutMessageQueue = new LinkedList<String>();
        }
        this.checkoutMessageQueue.add(string2);
    }

    @Override
    public void verifyGPaySdkResponse(String string2) {
        string2 = String.format("javascript: window.externalSDKResponse(%s)", string2);
        if (this.isCheckoutLoaded) {
            this.view.loadUrl(1, string2);
            return;
        }
        if (this.checkoutMessageQueue == null) {
            this.checkoutMessageQueue = new LinkedList<String>();
        }
        this.checkoutMessageQueue.add(string2);
    }

    @Override
    public void unregisterReceivers() {
        try {
            if (this.otpAutoReadBroadcast != null) {
                this.activity.unregisterReceiver(this.otpAutoReadBroadcast);
                this.isSmsReceiverRegistered = false;
            }
            return;
        }
        catch (Exception exception) {
            this.isSmsReceiverRegistered = false;
            AnalyticsUtil.reportError("CxPrntrImpl", "S2", exception.getMessage());
            return;
        }
    }

    @Override
    public String getSdkPlugins() {
        HashMap<String, String> hashMap = BaseUtils.getAllPluginsFromManifest((Context)this.activity);
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("isAmazonPluginIntegrated", false);
            jSONObject.put("isGooglePayPluginIntegrated", false);
            if (hashMap == null || hashMap.size() == 0) {
                return jSONObject.toString();
            }
            for (String string2 : hashMap.values()) {
                if (hashMap.size() > 0 && string2.equalsIgnoreCase("com.razorpay.RazorpayAmazon")) {
                    jSONObject.put("isAmazonPluginIntegrated", true);
                }
                if (hashMap.size() <= 0 || !string2.equalsIgnoreCase("com.razorpay.RzpGpayMerged")) continue;
                jSONObject.put("isGooglePayPluginIntegrated", true);
            }
        }
        catch (JSONException jSONException) {
            AnalyticsUtil.reportError("CxPsntrImpl", "S0", jSONException.getLocalizedMessage());
        }
        return jSONObject.toString();
    }

    @Override
    public void onCheckoutRendered() {
        AnalyticsUtil.trackEvent(AnalyticsEvent.CHECKOUT_RENDERED_COMPLETE);
    }

    @Override
    public void getPdfString(String string2, String string3) {
        if (!TextUtils.isEmpty((CharSequence)string3) && string3.contains("base64,")) {
            this.sanitizedChallanEncodedString = string3.split("base64,")[1];
            BaseUtils.pdfDownloadHelper(this.activity, string2, this.sanitizedChallanEncodedString);
        }
    }

    @Override
    public void registerSmsListener() {
        try {
            IntentFilter intentFilter = new IntentFilter("com.google.android.gms.auth.api.phone.SMS_RETRIEVED");
            this.activity.registerReceiver(this.otpAutoReadBroadcast, intentFilter, "com.google.android.gms.auth.api.phone.permission.SEND", null);
            this.isSmsReceiverRegistered = true;
            return;
        }
        catch (Exception exception) {
            this.isSmsReceiverRegistered = false;
            return;
        }
    }

    @Override
    public void unregisterSmsListener() {
        this.unregisterReceivers();
    }

    @Override
    public J__A$ getCheckoutOptions() {
        return this.checkoutOptions;
    }

    @Override
    public void setUpAddOn() {
        this.magicBase = new p$_5$(this.activity, this.view.getWebView(2));
    }

    @Override
    public void loadForm(String string2) {
        if (this.paymentAttempts != 0) {
            AnalyticsUtil.postData();
        }
        ++this.paymentAttempts;
        AnalyticsUtil.addProperty("payment_attempt", new AnalyticsProperty(this.paymentAttempts, AnalyticsProperty$Scope.ORDER));
        this.clearHistory = true;
        string2 = this.checkoutUrl + string2;
        string2 = string2.replace(" ", "%20");
        this.view.loadUrl(1, string2);
    }

    @Override
    public void showRetryDialog(int n2, String string2) {
        this.view.loadUrl(1, "about:blank");
        AlertDialog alertDialog = new AlertDialog.Builder((Context)this.activity).create();
        alertDialog.setTitle((CharSequence)"Trouble Connecting");
        alertDialog.setMessage((CharSequence)"Please check your internet connection & restart the payment process.\n\nRetrying in 5 seconds");
        alertDialog.setButton(-2, (CharSequence)"Cancel Payment", (DialogInterface.OnClickListener)new G$_X_(this, alertDialog, n2, string2));
        alertDialog.show();
        new K_$q$(this, 5000L, 1000L, alertDialog).start();
    }

    @Override
    public void showLoaderDialog(int n2, String string2) {
        this.view.loadUrl(1, "about:blank");
        if (!this.activity.isFinishing()) {
            AlertDialog alertDialog = new AlertDialog.Builder((Context)this.activity).create();
            alertDialog.setCancelable(false);
            alertDialog.setTitle((CharSequence)"Trouble Connecting");
            alertDialog.setMessage((CharSequence)"Unable to connect to Razorpay.\n\nPlease check your internet connection and/or disconnect from VPN if connected and hit Try Again");
            alertDialog.setButton(-1, (CharSequence)"Try again", (DialogInterface.OnClickListener)new E__a_(this));
            alertDialog.setButton(-2, (CharSequence)"Cancel Payment", (DialogInterface.OnClickListener)new t$$1$(this, alertDialog, n2, string2));
            alertDialog.show();
        }
    }

    @Override
    public void passPrefillToSegment() {
        String string2 = this.checkoutOptions.k();
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            AnalyticsUtil.addProperty("email", new AnalyticsProperty(string2, AnalyticsProperty$Scope.ORDER));
        }
        if (!TextUtils.isEmpty((CharSequence)(string2 = this.checkoutOptions.j()))) {
            AnalyticsUtil.addProperty("contact", new AnalyticsProperty(string2, AnalyticsProperty$Scope.ORDER));
        }
    }

    @Override
    public void handleCardSaving() {
        AnalyticsUtil.trackEvent(AnalyticsEvent.CARD_SAVING_START);
        L__R$.a(this.activity.getApplicationContext());
    }

    @Override
    public void saveInstanceState(Bundle bundle) {
        if (this.merchantLogoResourceId != 0) {
            bundle.putString("OPTIONS", this.checkoutOptions.i());
            bundle.putInt("IMAGE", this.merchantLogoResourceId);
        } else {
            bundle.putString("OPTIONS", this.checkoutOptions.e());
        }
        bundle.putString("DASH_OPTIONS", this.dashOptions);
        if (this.activity.getIntent() != null) {
            bundle.putBoolean("DISABLE_FULL_SCREEN", this.activity.getIntent().getBooleanExtra("DISABLE_FULL_SCREEN", false));
        }
    }

    @Override
    public void setCheckoutLoadStartAt() {
        this.checkoutLoadStartAt = System.nanoTime();
    }

    @Override
    public void destroyActivity(int n2, String string2) {
        AnalyticsUtil.addProperty("destroy_resultCode", new AnalyticsProperty(String.valueOf(n2), AnalyticsProperty$Scope.ORDER));
        AnalyticsUtil.addProperty("destroy_result", new AnalyticsProperty(string2, AnalyticsProperty$Scope.ORDER));
        AnalyticsUtil.trackEvent(AnalyticsEvent.INTERNAL_DESTROY_METHOD_CALLED);
        this.cleanUpOnDestroy();
        this.view.destroy(n2, string2);
    }

    @Override
    public void onCheckoutBackPress() {
        AnalyticsUtil.trackEvent(AnalyticsEvent.CHECKOUT_SOFT_BACK_PRESSED);
        this.destroyActivity(0, BaseUtils.getPaymentCancelledResponse(BaseUtils.getInstance().getMetadata()));
    }

    protected void enableAddon(JSONObject object) {
        try {
            if (object.has("magic")) {
                this.isMagic = object.getBoolean("magic");
                if (this.magicBase != null) {
                    boolean bl = this.isMagic;
                    object = this.magicBase;
                    this.magicBase.c = bl;
                }
                AnalyticsUtil.addProperty("is_magic", new AnalyticsProperty(this.isMagic, AnalyticsProperty$Scope.PAYMENT));
            }
            return;
        }
        catch (JSONException jSONException) {
            AnalyticsUtil.reportError("CxPsntrImpl", "S0", jSONException.getLocalizedMessage());
            jSONException.printStackTrace();
            return;
        }
    }

    @Override
    public void invokePopup(String string2) {
        this.isTwoWebViewFlow = true;
        try {
            this.activity.runOnUiThread((Runnable)new l__9_(this, string2));
            return;
        }
        catch (Exception exception) {
            AnalyticsUtil.reportError("CxPsntrImpl", "S0", exception.getLocalizedMessage());
            exception.printStackTrace();
            return;
        }
    }

    @Override
    public void fetchCondfig() {
        M$_J_.d = this.isMagicPresent();
        M$_J_.a((Context)this.activity, this.merchantKey);
    }

    @Override
    public boolean isMagicPresent() {
        return false;
    }

    @Override
    public void onProgressChanges(int n2, int n3) {
        switch (n2) {
            case 1: {
                this.view.showProgressBar(n3);
            }
        }
    }

    @Override
    public void onPageStarted(int n2, WebView webView, String string2) {
        switch (n2) {
            case 1: {
                CheckoutUtils.c((Context)this.activity);
                return;
            }
            case 2: {
                if (this.magicBase == null || !this.isMagic) break;
                p$_5$ p$_5$2 = this.magicBase;
                this.magicBase.d = false;
            }
        }
    }

    @Override
    public void onPageFinished(int n2, WebView webView, String string2) {
        switch (n2) {
            case 1: {
                this.primaryWebviewPageFinished(string2, webView);
                return;
            }
            case 2: {
                if (this.magicBase == null || !this.isMagic) break;
                this.magicBase.a();
            }
        }
    }

    private void sendQueuedMessagesToCheckout() {
        if (this.checkoutMessageQueue != null && !this.checkoutMessageQueue.isEmpty()) {
            for (String string2 : this.checkoutMessageQueue) {
                this.view.loadUrl(1, string2);
            }
            this.checkoutMessageQueue.clear();
        }
    }

    protected void primaryWebviewPageFinished(String object, WebView webView) {
        long l2 = System.nanoTime();
        CheckoutUtils.a();
        this.view.hideProgressBar();
        if (((String)object).contains("https://api.razorpay.com") && ((String)object).contains("android") && ((String)object).contains("1.6.35")) {
            if (this.paymentAttempts == 1) {
                this.isCheckoutLoaded = true;
                this.sendQueuedMessagesToCheckout();
                object = new HashMap();
                long l3 = l2 - this.checkoutLoadStartAt;
                object.put("checkout_load_duration", l3);
                new StringBuilder("Checkout loaded in ").append(BaseUtils.nanoTimeToSecondsString(l3, 2)).append(" sec.");
                if (this.preloadCompleteDuration > 0L) {
                    object.put("preload_finish_duration", this.preloadCompleteDuration);
                    new StringBuilder("Preload was completed in ").append(BaseUtils.nanoTimeToSecondsString(this.preloadCompleteDuration, 2)).append(" sec.");
                } else if (this.preloadAbortDuration > 0L) {
                    object.put("preload_abort_duration", this.preloadAbortDuration);
                    new StringBuilder("Preload was aborted in ").append(BaseUtils.nanoTimeToSecondsString(this.preloadAbortDuration, 2)).append(" sec.");
                }
                long l4 = this.preloadCompleteDuration - l3;
                if (l4 > 0L) {
                    object.put("time_shaved_off", l4);
                    new StringBuilder("Load time shaved is ").append(BaseUtils.nanoTimeToSecondsString(l4, 2)).append(" sec.");
                }
                AnalyticsUtil.trackEvent(AnalyticsEvent.CHECKOUT_LOADED, AnalyticsUtil.getJSONResponse((Map<String, Object>)object));
            }
            if (this.clearHistory) {
                this.view.clearWebViewHistory(1);
                this.clearHistory = false;
            }
        }
    }

    @Override
    public String getProgressBarColor() {
        String string2 = null;
        try {
            if (this.checkoutOptions.d() == null) {
                throw new Exception("No options defined");
            }
            JSONObject jSONObject = this.checkoutOptions.d();
            JSONObject jSONObject2 = jSONObject.getJSONObject("theme");
            string2 = jSONObject2.getString("color");
            Color.parseColor((String)string2);
        }
        catch (Exception exception) {
            try {
                if (this.dashOptionsJSON == null) {
                    throw new Exception("No dash options defined");
                }
                JSONObject jSONObject = this.dashOptionsJSON.getJSONObject("theme");
                string2 = jSONObject.getString("color");
                Color.parseColor((String)string2);
            }
            catch (Exception exception2) {
                AnalyticsUtil.reportError("CxPsntrImpl", "S2", exception2.getMessage());
            }
            AnalyticsUtil.reportError("CxPsntrImpl", "S2", exception.getMessage());
        }
        return string2;
    }

    @Override
    public void onRequestPermissionsResult(int n2, String[] stringArray, int[] nArray) {
    }

    @Override
    public void sendOtpPermissionCallback(boolean bl) {
        this.activity.runOnUiThread((Runnable)new B$$Z_(this, bl));
    }

    protected void addOnFlowEnd() {
        if (this.magicBase != null) {
            p$_5$ p$_5$2 = this.magicBase;
            p$_5$2.b.a((Activity)p$_5$2.a);
        }
    }

    @Override
    public void cleanUpOnDestroy() {
        try {
            this.markPaymentCancelled();
            this.unregisterReceivers();
            e.a();
            return;
        }
        catch (Exception exception) {
            AnalyticsUtil.reportError("CxPsntrImpl", "S2", exception.getLocalizedMessage());
            return;
        }
    }

    private void markPaymentCancelled() {
        if (this.payment_id == null || this.isPaymentSuccessful) {
            return;
        }
        try {
            String string2 = BaseUtils.constructBasicAuth(this.merchantKey);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("Authorization", "Basic " + string2);
            string2 = "https://api.razorpay.com/v1/payments/" + this.payment_id + "/cancel?platform=android_sdk";
            G_$8_.a(string2, hashMap, new q$_Y$(this));
            this.payment_id = null;
            return;
        }
        catch (Exception exception) {
            AnalyticsUtil.reportError("CxPsntrImpl", "S0", exception.getLocalizedMessage());
            return;
        }
    }

    @Override
    public void backPressed(Map<String, Object> map) {
        AnalyticsUtil.trackEvent(AnalyticsEvent.CHECKOUT_HARD_BACK_PRESSED, AnalyticsUtil.getJSONResponse(map));
        Object object = this.view.getWebView(1);
        object = object.getTag() == null ? "" : object.getTag().toString();
        if (object.contains(M$_J_.a().getCheckoutEndpoint()) && !this.view.isWebViewVisible(2)) {
            this.view.loadUrl(1, "javascript: window.backPressed ? window.backPressed('onCheckoutBackPress') : CheckoutBridge.onCheckoutBackPress();");
            map.put("in_checkout", "true");
            return;
        }
        if (!M$_J_.a().k()) {
            this.destroyActivity(0, "BackPressed");
            return;
        }
        CheckoutUtils.a((Context)this.activity, M$_J_.a().l(), M$_J_.a().j(), M$_J_.a().i(), new q_$J$(this, map));
    }

    @Override
    public void onLoad() {
        this.activity.runOnUiThread((Runnable)new T_$Z$(this));
        this.startSmsRetrievers();
    }

    private void startSmsRetrievers() {
        this.automaticRetrievalTask = SmsRetriever.getClient((Activity)this.activity).startSmsRetriever();
        this.userConsentTask = SmsRetriever.getClient((Activity)this.activity).startSmsUserConsent(null);
    }

    protected JSONObject getOptionsForHandleMessage() {
        JSONObject jSONObject = new JSONObject();
        try {
            Object object;
            jSONObject.put("options", (Object)this.checkoutOptions.d());
            jSONObject.put("data", (Object)this.checkoutContent);
            jSONObject.put("id", (Object)AnalyticsUtil.getLocalOrderId());
            jSONObject.put("pdf_download_supported", true);
            jSONObject.put("key_id", (Object)this.merchantKey);
            jSONObject.put("externalSDKs", (Object)new JSONObject());
            if (this.checkoutOptions.b()) {
                object = new AppSignatureHelper((Context)this.activity);
                jSONObject.put("sms_hash", (Object)object.getAppSignatures().get(0));
            }
            jSONObject.put("upi_intents_data", (Object)CheckoutUtils.a((Context)this.activity));
            jSONObject.put("uri_data", (Object)CheckoutUtils.b((Context)this.activity));
            object = new JSONObject();
            object.put("openedAt", System.currentTimeMillis());
            jSONObject.put("metadata", object);
            object = new JSONObject();
            object.put("framework", AnalyticsUtil.getFramework());
            object.put("type", M$_J_.a);
            object.put("name", M$_J_.a + "_android_" + AnalyticsUtil.getFramework());
            object.put("version", "1.6.35");
            object.put("platform", "android");
            object.put("package_name", this.activity.getCallingPackage());
            jSONObject.put("sdk", object);
            object = L__R$.b(this.activity.getApplicationContext());
            if (!TextUtils.isEmpty((CharSequence)object)) {
                jSONObject.put("device_token", object);
            }
            jSONObject.put("sdk_popup", true);
            jSONObject.put("magic", true);
            jSONObject.put("network_type", BaseUtils.getNetworkType((Context)this.activity));
            jSONObject.put("activity_recreated", this.isActivityCreated);
        }
        catch (JSONException jSONException) {
            AnalyticsUtil.reportError("CxPsntrImpl", "S2", jSONException.getLocalizedMessage());
        }
        return jSONObject;
    }

    private String getHandleMessageFormattedString() {
        return String.format("javascript: handleMessage(%s)", this.getOptionsForHandleMessage().toString());
    }

    @Override
    public void setAppToken(String string2) {
        String string3 = string2;
        string2 = this.activity;
        string2 = r.b((Context)string2);
        string2.putString("rzp_app_token", string3).apply();
    }

    @Override
    public void setDeviceToken(String string2) {
        L__R$.a((Context)this.activity, string2);
    }

    @Override
    public void callNativeIntent(String string2, String string3) {
        BaseUtils.startActivityForResult(string2, string3, this.activity);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("url", string2 == null ? "null" : string2);
        hashMap.put("package_name", string3 == null ? "null" : string3);
        AnalyticsUtil.trackEvent(AnalyticsEvent.NATIVE_INTENT_CALLED, AnalyticsUtil.getJSONResponse(hashMap));
    }

    @Override
    public void setPaymentID(String string2) {
        new StringBuilder("setPaymentID called: ").append(string2);
        this.payment_id = string2;
        BaseUtils.getInstance().setPaymentId(string2);
        if (this.checkoutOptions.f() != null) {
            BaseUtils.getInstance().setOrderId(this.checkoutOptions.f());
        }
        AnalyticsUtil.addProperty("payment_id", new AnalyticsProperty(string2, AnalyticsProperty$Scope.PAYMENT));
        AnalyticsUtil.trackEvent(AnalyticsEvent.PAYMENT_ID_ATTACHED);
    }

    @Override
    public void setMerchantOptions(String string2) {
        this.dashOptions = string2;
        try {
            this.dashOptionsJSON = this.dashOptions == null || this.dashOptions.equalsIgnoreCase("undefined") ? null : new JSONObject(this.dashOptions);
        }
        catch (Exception exception) {
            d__1_.a("Error parsing merchant dash options JSON", exception);
            this.dashOptionsJSON = null;
            AnalyticsUtil.reportError("CxPsntrImpl", "S0", exception.getMessage());
        }
        if (this.dashOptionsJSON == null) {
            CheckoutUtils.a((Context)this.activity, this.merchantKey, null);
            return;
        }
        CheckoutUtils.a((Context)this.activity, this.merchantKey, string2);
    }

    protected void addAnalyticsData(JSONObject jSONObject) {
        AnalyticsUtil.addFilteredPropertiesFromPayload(jSONObject);
    }

    @Override
    public void onSubmit(String string2) {
        if (this.paymentAttempts > 1) {
            AnalyticsUtil.refreshPaymentSession();
        }
        try {
            JSONObject jSONObject = new JSONObject(string2);
            this.checkoutContent = string2;
            this.addAnalyticsData(jSONObject);
            this.savePrefillData(jSONObject);
            if (jSONObject.has("method")) {
                string2 = jSONObject.getString("method");
                if (string2.equalsIgnoreCase("netbanking") || string2.equalsIgnoreCase("card")) {
                    if (!this.isSmsReceiverRegistered) {
                        this.registerSmsListener();
                    }
                } else {
                    this.unregisterSmsListener();
                }
                if (string2.equals("wallet") && jSONObject.has("wallet") && this.checkoutOptions.b(string2 = jSONObject.getString("wallet"))) {
                    jSONObject = new JSONObject();
                    jSONObject.put("external_wallet", (Object)string2);
                    AnalyticsUtil.addProperty("external_wallet", new AnalyticsProperty(string2, AnalyticsProperty$Scope.ORDER));
                    AnalyticsUtil.trackEvent(AnalyticsEvent.EXTERNAL_WALLET_SELECTED);
                    this.onComplete(jSONObject);
                }
            }
            AnalyticsUtil.trackEvent(AnalyticsEvent.CHECKOUT_SUBMIT);
            AnalyticsUtil.postData();
            return;
        }
        catch (Exception exception) {
            AnalyticsUtil.reportError("CxPsntrImpl", "S0", exception.getMessage());
            d__1_.a("Error in submit", exception);
            return;
        }
    }

    protected void onComplete(JSONObject jSONObject) {
        try {
            if (jSONObject.has("error")) {
                AnalyticsUtil.addProperty("payment_status", new AnalyticsProperty("fail", AnalyticsProperty$Scope.PAYMENT));
                AnalyticsUtil.addProperty("payload", new AnalyticsProperty(jSONObject.toString(), AnalyticsProperty$Scope.PAYMENT));
                AnalyticsUtil.trackEvent(AnalyticsEvent.CHECKOUT_PAYMENT_COMPLETE);
                if (this.isTwoWebViewFlow) {
                    this.view.makeWebViewVisible(1);
                }
                this.onError(jSONObject);
            } else if (jSONObject.has("razorpay_fund_account_id")) {
                this.destroyActivity(1, jSONObject.toString());
            } else if (jSONObject.has("razorpay_payment_id")) {
                String string2;
                this.payment_id = string2 = jSONObject.getString("razorpay_payment_id");
                AnalyticsUtil.addProperty("payment_id", new AnalyticsProperty(string2, AnalyticsProperty$Scope.PAYMENT));
                AnalyticsUtil.addProperty("payment_status", new AnalyticsProperty("success", AnalyticsProperty$Scope.PAYMENT));
                AnalyticsUtil.addProperty("payload", new AnalyticsProperty(jSONObject.toString(), AnalyticsProperty$Scope.PAYMENT));
                AnalyticsUtil.trackEvent(AnalyticsEvent.CHECKOUT_PAYMENT_COMPLETE);
                this.isPaymentSuccessful = true;
                this.destroyActivity(1, jSONObject.toString());
            } else if (jSONObject.has("external_wallet")) {
                this.destroyActivity(4, jSONObject.toString());
            } else {
                this.destroyActivity(0, "Post payment parsing error");
            }
        }
        catch (Exception exception) {
            AnalyticsUtil.reportError("CxPsntrImpl", "S0", exception.getMessage());
            this.destroyActivity(0, exception.getMessage());
        }
        this.isTwoWebViewFlow = false;
    }

    protected void onError(JSONObject object) {
        if (this.isTwoWebViewFlow) {
            object = String.format("javascript: window.onComplete(%s)", object.toString());
            this.view.loadUrl(1, (String)object);
            return;
        }
        this.activity.runOnUiThread((Runnable)new H$$i_(this, object));
    }

    private void handleRetry(String string2) {
        int n2 = this.paymentAttempts;
        int n3 = M$_J_.a().f();
        if (M$_J_.a().e() && (n3 == -1 || n3 >= n2)) {
            try {
                if (string2 != null) {
                    JSONObject jSONObject = new JSONObject(string2);
                    if (jSONObject.has("error")) {
                        string2 = string2 + (this.checkoutUrl.contains("?") ? "&" : "?");
                        if (jSONObject.get("error") instanceof JSONObject) {
                            jSONObject = (JSONObject)jSONObject.get("error");
                            string2 = string2 + "error=" + jSONObject.toString();
                        }
                    }
                } else {
                    this.destroyActivity(0, "");
                    return;
                }
                this.helpersReset();
                this.loadForm(string2);
            }
            catch (Exception exception) {
                this.destroyActivity(0, "");
                AnalyticsUtil.reportError("CxPsntrImpl", "S0", exception.getMessage());
                return;
            }
        } else {
            this.destroyActivity(0, string2);
        }
    }

    protected void helpersReset() {
    }

    private void savePrefillData(JSONObject jSONObject) {
        try {
            if (jSONObject.has("contact")) {
                CheckoutUtils.b((Context)this.activity, jSONObject.getString("contact"));
                this.checkoutOptions.a("contact", jSONObject.getString("contact"));
            }
            if (jSONObject.has("email")) {
                CheckoutUtils.a((Context)this.activity, jSONObject.getString("email"));
                this.checkoutOptions.a("email", jSONObject.getString("email"));
            }
            return;
        }
        catch (JSONException jSONException) {
            d__1_.a("Error parsing JSON", jSONException);
            return;
        }
    }

    @Override
    public void onFault(String string2) {
        try {
            JSONObject jSONObject = new JSONObject(string2);
            this.destroyActivity(3, jSONObject.toString());
            return;
        }
        catch (JSONException jSONException) {
            this.destroyActivity(3, BaseUtils.getGenericPaymentErrorResponse(string2, BaseUtils.getInstance().getMetadata()));
            return;
        }
    }

    @Override
    public void onComplete(String string2) {
        this.activity.runOnUiThread((Runnable)new J__n_(this, string2));
    }

    @Override
    public void setDimensions(int n2, int n3) {
        if (h.a((Context)this.activity)) {
            this.activity.runOnUiThread((Runnable)new z$_w$(this, n3, n2));
        }
    }

    @Override
    public void onDismiss() {
        this.destroyActivity(0, BaseUtils.getPaymentCancelledResponse(BaseUtils.getInstance().getMetadata()));
    }

    @Override
    public void onDismiss(String string2) {
        try {
            JSONObject jSONObject = new JSONObject(string2);
            this.destroyActivity(0, jSONObject.toString());
            return;
        }
        catch (JSONException jSONException) {
            this.destroyActivity(0, BaseUtils.getGenericPaymentErrorResponse(string2, BaseUtils.getInstance().getMetadata()));
            return;
        }
    }

    @Override
    public void requestExtraAnalyticsData() {
        JSONObject jSONObject = AnalyticsUtil.getExtraAnalyticsPayload();
        this.activity.runOnUiThread((Runnable)new b$_f_(this, jSONObject));
    }

    @Override
    public void onError(String string2) {
        try {
            this.onError(new JSONObject(string2));
            return;
        }
        catch (Exception exception) {
            AnalyticsUtil.reportError("CxPsntrImpl", "S0", exception.getMessage());
            this.activity.runOnUiThread((Runnable)new k__c$(this));
            return;
        }
    }

    @Override
    public void relay(String string2) {
    }

    @Override
    public void requestOtpPermission() {
    }

    @Override
    public void toast(String string2, int n2) {
        this.activity.runOnUiThread((Runnable)new N_$R$(this, string2, n2));
    }

    @Override
    public void showAlertDialog(String string2, String string3, String string4) {
        this.activity.runOnUiThread((Runnable)new c__h$(this, string2, string4, string3));
    }

    @Override
    public void sendDataToWebView(int n2, String string2) {
        this.activity.runOnUiThread((Runnable)new d__w$(this, n2, string2));
    }

    @Override
    public void checkSmsPermission() {
        this.view.checkSmsPermission();
    }

    @Override
    public void isWebViewSafeOnUI(int n2, CheckoutBridge$WebViewSafeCheckCallback checkoutBridge$WebViewSafeCheckCallback) {
        this.activity.runOnUiThread((Runnable)new O$_M$(this, n2, checkoutBridge$WebViewSafeCheckCallback));
    }

    private void executeWebViewCallback(int n2, CheckoutBridge$WebViewSafeCheckCallback checkoutBridge$WebViewSafeCheckCallback) {
        Object object = n2 == 1 ? this.view.getWebView(1) : this.view.getWebView(2);
        object = object.getTag().toString();
        try {
            object = new URL((String)object);
            object = ((URL)object).getHost();
            if (object == null || !((String)object).endsWith("razorpay.com") && !((String)object).endsWith("razorpay.in")) {
                checkoutBridge$WebViewSafeCheckCallback.unSecure();
                return;
            }
            checkoutBridge$WebViewSafeCheckCallback.secure();
        }
        catch (Exception exception) {
            AnalyticsUtil.reportError("CxPsntrImpl", "S0", exception.getLocalizedMessage());
            checkoutBridge$WebViewSafeCheckCallback.unSecure();
        }
    }

    @Override
    public void isWebViewSafe(int n2, CheckoutBridge$WebViewSafeCheckCallback checkoutBridge$WebViewSafeCheckCallback) {
        this.executeWebViewCallback(n2, checkoutBridge$WebViewSafeCheckCallback);
    }

    @Override
    public boolean isUserRegisteredOnUPI(String string2) {
        return BaseUtils.checkUpiRegisteredApp((Context)this.activity, string2);
    }

    @Override
    public boolean isUserRegistered(String string2) {
        return BaseUtils.checkGpayCardsUpiRegistered(this.activity, string2);
    }

    @Override
    public boolean isAllowRotation() {
        return this.allowRotation;
    }

    static /* synthetic */ boolean access$000(CheckoutPresenterImpl checkoutPresenterImpl) {
        return checkoutPresenterImpl.isTwoWebViewFlow;
    }

    static /* synthetic */ void access$100(CheckoutPresenterImpl checkoutPresenterImpl, String string) {
        checkoutPresenterImpl.handleRetry(string);
    }

    static /* synthetic */ void access$200(CheckoutPresenterImpl checkoutPresenterImpl) {
        checkoutPresenterImpl.markPaymentCancelled();
    }

    static /* synthetic */ boolean access$002(CheckoutPresenterImpl checkoutPresenterImpl, boolean bl) {
        checkoutPresenterImpl.isTwoWebViewFlow = bl;
        return checkoutPresenterImpl.isTwoWebViewFlow;
    }

    static /* synthetic */ boolean access$302(CheckoutPresenterImpl checkoutPresenterImpl, boolean bl) {
        checkoutPresenterImpl.nameNotFound_retryStatus = bl;
        return checkoutPresenterImpl.nameNotFound_retryStatus;
    }

    static /* synthetic */ String access$400(CheckoutPresenterImpl checkoutPresenterImpl) {
        return checkoutPresenterImpl.getHandleMessageFormattedString();
    }

    static /* synthetic */ void access$500(CheckoutPresenterImpl checkoutPresenterImpl, int n2, CheckoutBridge$WebViewSafeCheckCallback checkoutBridge$WebViewSafeCheckCallback) {
        checkoutPresenterImpl.executeWebViewCallback(n2, checkoutBridge$WebViewSafeCheckCallback);
    }
}

