/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.WallpaperManager;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageItemInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.location.Location;
import android.media.RingtoneManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.net.http.SslCertificate;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.os.SystemClock;
import android.provider.Settings;
import android.telephony.PhoneStateListener;
import android.telephony.SignalStrength;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Base64;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.webkit.CookieManager;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.widget.Toast;
import com.razorpay.AdvertisingIdUtil;
import com.razorpay.AdvertisingIdUtil$a_$P$;
import com.razorpay.AnalyticsUtil;
import com.razorpay.B_$q$;
import com.razorpay.L__R$;
import com.razorpay.RzpJSONCallback;
import com.razorpay.U$_z$;
import com.razorpay.g__v_;
import com.razorpay.l__d$;
import com.razorpay.y$_O_;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.KeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import proguard.annotation.Keep;
import proguard.annotation.KeepClassMembers;

@Keep
@KeepClassMembers
public class BaseUtils {
    private static String PERMISSION_DISABLED = "permission disabled";
    private static boolean sWebViewDebuggingEnabled = g__v_.d__1_;
    private static boolean isCompatibleWithGooglePay = true;
    public static String ipAddress;

    BaseUtils() {
    }

    static String constructBasicAuth(String string2) throws UnsupportedEncodingException {
        return Base64.encodeToString((byte[])(string2 + ":").getBytes("UTF-8"), (int)2);
    }

    static boolean hasPermission(Context object, String string2) {
        try {
            return 0 == object.checkCallingOrSelfPermission(string2);
        }
        catch (Exception exception) {
            object = exception;
            AnalyticsUtil.reportError(exception, "critical", ((Throwable)object).getMessage());
            return false;
        }
    }

    static String getKeyId(Context object) {
        try {
            object = object.getPackageManager().getApplicationInfo(object.getPackageName(), 128);
            if (((PackageItemInfo)object).metaData == null) {
                return null;
            }
            object = ((PackageItemInfo)object).metaData.getString("com.razorpay.ApiKey");
            String string2 = object;
            Log.d((String)"com.razorpay.checkout", (String)string2);
            return object;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            object = nameNotFoundException;
            AnalyticsUtil.reportError((Exception)((Object)nameNotFoundException), "critical", ((Throwable)object).getMessage());
            return null;
        }
    }

    static HashMap<String, String> getAllPluginsFromManifest(Context object) {
        try {
            object = object.getPackageManager().getApplicationInfo(object.getPackageName(), 128);
            if (((PackageItemInfo)object).metaData == null) {
                return null;
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (String string2 : ((PackageItemInfo)object).metaData.keySet()) {
                if (!string2.contains("com.razorpay.plugin.") || ((PackageItemInfo)object).metaData.getString(string2) == null) continue;
                ((AbstractMap)hashMap).put(string2, ((PackageItemInfo)object).metaData.getString(string2));
            }
            return hashMap;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            object = nameNotFoundException;
            AnalyticsUtil.reportError((Exception)((Object)nameNotFoundException), "critical", ((Throwable)object).getMessage());
            return null;
        }
    }

    private static void setBaseWebViewSettings() {
        if (Build.VERSION.SDK_INT >= 19) {
            WebView.setWebContentsDebuggingEnabled((boolean)sWebViewDebuggingEnabled);
        }
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private static void enableJavaScriptInWebView(WebView webView) {
        webView.getSettings().setJavaScriptEnabled(true);
    }

    static void setWebViewSettings(Context context, WebView webView, boolean bl) {
        BaseUtils.setBaseWebViewSettings();
        BaseUtils.enableJavaScriptInWebView(webView);
        CookieManager.getInstance().setAcceptCookie(true);
        webView.setTag((Object)"");
        WebSettings webSettings = webView.getSettings();
        webSettings.setDomStorageEnabled(true);
        webSettings.setDatabaseEnabled(true);
        webSettings.setTextZoom(100);
        String string2 = context.getApplicationContext().getDir("database", 0).getPath();
        if (Build.VERSION.SDK_INT < 19) {
            webSettings.setDatabasePath(string2);
        }
        if (Build.VERSION.SDK_INT < 24) {
            webSettings.setGeolocationDatabasePath(string2);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            CookieManager.getInstance().setAcceptThirdPartyCookies(webView, true);
        }
        if (bl) {
            webSettings.setCacheMode(2);
        }
        webSettings.setSaveFormData(false);
        webView.addJavascriptInterface((Object)new y$_O_(context), "StorageBridge");
    }

    static boolean hasFeature(Context context, String string2) {
        return context.getPackageManager().hasSystemFeature(string2);
    }

    public static <T> T getSystemService(Context context, String string2) {
        return (T)context.getApplicationContext().getSystemService(string2);
    }

    public static int getNetworkType(Context object) {
        B_$q$ b_$q$ = BaseUtils.getDataNetworkType((Context)object);
        if (b_$q$ == B_$q$.R$$r_) {
            return 0;
        }
        if (b_$q$ == B_$q$.Q_$2$) {
            return 1;
        }
        if (b_$q$ == B_$q$.d__1_) {
            if (((String)(object = BaseUtils.getCellularNetworkType((Context)object))).equalsIgnoreCase("2G")) {
                return 2;
            }
            if (((String)object).equalsIgnoreCase("3G")) {
                return 3;
            }
            if (((String)object).equalsIgnoreCase("4G")) {
                return 4;
            }
        }
        return -1;
    }

    public static String getCellularNetworkType(Context object) {
        try {
            switch (((TelephonyManager)object.getSystemService("phone")).getNetworkType()) {
                case 1: 
                case 2: 
                case 4: 
                case 7: 
                case 11: {
                    return "2G";
                }
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 14: 
                case 15: {
                    return "3G";
                }
                case 13: {
                    return "4G";
                }
            }
            return "NA";
        }
        catch (Exception exception) {
            object = exception;
            AnalyticsUtil.reportError(exception, "warning", ((Throwable)object).getLocalizedMessage());
            return "NA";
        }
    }

    public static String getCellularNetworkProviderName(Context context) {
        if ((context = (TelephonyManager)BaseUtils.getSystemService(context, "phone")) != null) {
            return context.getNetworkOperatorName();
        }
        return "unknown";
    }

    public static B_$q$ getDataNetworkType(Context context) {
        if (BaseUtils.hasPermission(context, "android.permission.ACCESS_NETWORK_STATE") && (context = (ConnectivityManager)BaseUtils.getSystemService(context, "connectivity")) != null) {
            NetworkInfo networkInfo = context.getNetworkInfo(1);
            if (networkInfo != null && networkInfo.isConnected()) {
                return B_$q$.R$$r_;
            }
            networkInfo = context.getNetworkInfo(7);
            if (networkInfo != null && networkInfo.isConnected()) {
                return B_$q$.Q_$2$;
            }
            if ((context = context.getNetworkInfo(0)) != null && context.isConnected()) {
                return B_$q$.d__1_;
            }
        }
        return B_$q$.a_$P$;
    }

    public static String getLocale() {
        return Locale.getDefault().getLanguage() + "-" + Locale.getDefault().getCountry();
    }

    static ArrayList<String> jsonStringArrayToArrayList(JSONArray jSONArray) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < jSONArray.length(); ++i) {
            ((AbstractCollection)arrayList).add(jSONArray.getString(i));
        }
        return arrayList;
    }

    static String getAppBuildType(Context context) {
        if (0 != (context.getApplicationInfo().flags & 2)) {
            return "development";
        }
        return "production";
    }

    public static CharSequence getWebViewUserAgent(Context context) {
        return AnalyticsUtil.returnUndefinedIfNull(new WebView(context).getSettings().getUserAgentString());
    }

    static boolean isDeviceHaveCorrectTlsVersion() {
        try {
            String[] stringArray = SSLContext.getDefault().getDefaultSSLParameters().getProtocols();
            if (stringArray == null) {
                return false;
            }
            for (String string2 : stringArray) {
                if (!string2.startsWith("TLS") || string2.equalsIgnoreCase("TLSv1")) continue;
                return true;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            NoSuchAlgorithmException noSuchAlgorithmException2 = noSuchAlgorithmException;
            AnalyticsUtil.reportError(noSuchAlgorithmException, "critical", noSuchAlgorithmException2.getMessage());
        }
        return false;
    }

    static void setup() {
        AnalyticsUtil.reset();
    }

    public static double round(double d, int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        return ((Number)new BigDecimal(d).setScale(n, RoundingMode.HALF_UP)).doubleValue();
    }

    public static String nanoTimeToSecondsString(long l, int n) {
        return String.valueOf(BaseUtils.round((double)l / 1.0E9, n));
    }

    static boolean isMerchantAppDebuggable(Context context) {
        return 0 != (context.getApplicationInfo().flags & 2);
    }

    static Certificate getX509Certificate(SslCertificate object) {
        byte[] byArray = SslCertificate.saveState((SslCertificate)object).getByteArray("x509-certificate");
        object = byArray;
        if (byArray == null) {
            return null;
        }
        try {
            return CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream((byte[])object));
        }
        catch (CertificateException certificateException) {
            object = certificateException;
            AnalyticsUtil.reportError(certificateException, "critical", ((Throwable)object).getLocalizedMessage());
            return null;
        }
    }

    static PublicKey constructPublicKey(String object) {
        try {
            object = Base64.decode((byte[])((String)object).getBytes(), (int)0);
            object = new X509EncodedKeySpec((byte[])object);
            return KeyFactory.getInstance("RSA").generatePublic((KeySpec)object);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Boolean isUserRegisteredOnTruePay(Context object) {
        try {
            return object.getPackageManager().getComponentEnabledSetting(new ComponentName("com.truecaller", "com.truecaller.truepay.UserRegistered")) == 1;
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
            AnalyticsUtil.reportError((Exception)object, "error", ((Throwable)object).getMessage());
            return Boolean.FALSE;
        }
    }

    static boolean checkUpiRegisteredApp(Context object, String string2) {
        switch (string2) {
            case "com.google.android.apps.nbu.paisa.user": {
                return isCompatibleWithGooglePay;
            }
        }
        return true;
    }

    static HashSet<String> getSetOfPackageNamesSupportingUpi(Context context) {
        Object object = BaseUtils.getListOfAppsWhichHandleDeepLink(context, "upi://pay");
        HashSet<String> hashSet = new HashSet<String>();
        if (object != null && object.size() > 0) {
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = (ResolveInfo)object.next();
                try {
                    ((AbstractCollection)hashSet).add(((ResolveInfo)object2).activityInfo.packageName);
                }
                catch (Exception exception) {
                    object2 = exception;
                    AnalyticsUtil.reportError(exception, "critical", ((Throwable)object2).getLocalizedMessage());
                }
            }
        }
        if (((AbstractCollection)hashSet).size() > 0 && !BaseUtils.checkUpiRegisteredApp(context, "com.google.android.apps.nbu.paisa.user")) {
            ((AbstractCollection)hashSet).remove("com.google.android.apps.nbu.paisa.user");
        }
        if (((AbstractCollection)hashSet).size() > 0 && !BaseUtils.checkUpiRegisteredApp(context, "com.truecaller")) {
            ((AbstractCollection)hashSet).remove("com.truecaller");
        }
        return hashSet;
    }

    static List<ResolveInfo> getListOfAppsWhichHandleDeepLink(Context context, String string2) {
        Intent intent = new Intent();
        intent.setData(Uri.parse((String)string2));
        return context.getPackageManager().queryIntentActivities(intent, 131072);
    }

    static String getAppNameOfResolveInfo(ResolveInfo resolveInfo, Context context) throws Exception {
        return BaseUtils.getAppNameOfPackageName(resolveInfo.activityInfo.packageName, context);
    }

    static void startActivityForResult(String string2, String string3, Activity activity) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setData(Uri.parse((String)string2));
        if (string3 != null && string3.length() > 0) {
            intent.setPackage(string3);
        }
        if (string2.startsWith("credpay")) {
            activity.startActivityForResult(intent, 20);
            return;
        }
        activity.startActivityForResult(intent, 99);
    }

    static JSONObject getJSONFromIntentData(Intent intent) {
        JSONObject jSONObject = new JSONObject();
        if (intent != null && (intent = intent.getExtras()) != null) {
            for (Object object : intent.keySet()) {
                try {
                    jSONObject.put((String)object, intent.get((String)object));
                }
                catch (JSONException jSONException) {
                    object = jSONException;
                    AnalyticsUtil.reportError((Exception)((Object)jSONException), "error:exception", ((Throwable)object).getLocalizedMessage());
                }
            }
        }
        return jSONObject;
    }

    static String getBase64FromOtherAppsResource(Context context, String object) {
        context = context.getPackageManager();
        try {
            object = context.getApplicationInfo((String)object, 128);
            context = context.getResourcesForApplication((ApplicationInfo)object);
            int n = ((PackageItemInfo)object).icon;
            return BaseUtils.getBase64FromResource((Resources)context, n);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            object = nameNotFoundException;
            AnalyticsUtil.reportError((Exception)((Object)nameNotFoundException), "critical", ((Throwable)object).getLocalizedMessage());
            ((Throwable)object).printStackTrace();
            return null;
        }
    }

    static String getAppNameOfPackageName(String string2, Context object) throws Exception {
        try {
            object = object.getPackageManager();
            string2 = object.getApplicationInfo(string2, 128);
            int n = ((PackageItemInfo)string2).labelRes;
            object = object.getResourcesForApplication((ApplicationInfo)string2);
            if (n == 0) {
                return ((PackageItemInfo)string2).nonLocalizedLabel.toString();
            }
            return object.getString(n);
        }
        catch (Exception exception) {
            object = exception;
            AnalyticsUtil.reportError(exception, "error:exception", ((Throwable)object).getLocalizedMessage());
            ((Throwable)object).printStackTrace();
            throw object;
        }
    }

    static String getBase64FromResource(Resources object, int n) {
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)object, (int)n);
        if (bitmap == null && (object = object.getDrawable(n)) != null) {
            if (object instanceof BitmapDrawable) {
                bitmap = ((BitmapDrawable)object).getBitmap();
            } else {
                bitmap = Bitmap.createBitmap((int)object.getIntrinsicWidth(), (int)object.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas = new Canvas(bitmap);
                object.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
                object.draw(canvas);
            }
        }
        if (bitmap != null) {
            object = "data:image/png;base64,";
            Object object2 = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)object2);
            object2 = ((ByteArrayOutputStream)object2).toByteArray();
            return (String)object + Base64.encodeToString((byte[])object2, (int)2);
        }
        return null;
    }

    static Object getJsonValue(String object, JSONObject jSONObject, Object object2) {
        if ((object = BaseUtils.getJsonValue(((String)object).split("\\."), (Object)jSONObject, 0)) != null) {
            return object;
        }
        return object2;
    }

    private static Object getJsonValue(String[] stringArray, Object object, int n) {
        while (true) {
            if (n == stringArray.length) {
                return object;
            }
            String string2 = stringArray[n];
            if (object instanceof JSONObject) {
                object = (JSONObject)object;
                ++n;
                object = object.opt(string2);
                continue;
            }
            if (!(object instanceof JSONArray)) break;
            object = (JSONArray)object;
            if (!TextUtils.isDigitsOnly((CharSequence)string2)) break;
            int n2 = Integer.parseInt(string2);
            ++n;
            object = object.opt(n2);
        }
        return null;
    }

    static String getRandomString() {
        SecureRandom secureRandom = new SecureRandom();
        return new BigInteger(130, secureRandom).toString(32);
    }

    public static String getFileFromInternal(Activity object, String string2, String charSequence) throws Exception {
        string2 = BaseUtils.getVersionedAssetName(BaseUtils.getLocalVersion((Activity)object, (String)charSequence).toString(), string2);
        object = object.openFileInput(string2);
        object = new BufferedReader(new InputStreamReader((InputStream)object, "UTF-8"));
        charSequence = new StringBuilder();
        while ((string2 = ((BufferedReader)object).readLine()) != null) {
            ((StringBuilder)charSequence).append(string2);
        }
        ((Reader)object).close();
        return BaseUtils.decryptFile(charSequence.toString());
    }

    static String decryptFile(String string2) {
        try {
            L__R$ l__R$ = new L__R$();
            Object object = "";
            Object object2 = MessageDigest.getInstance("SHA-256");
            ((MessageDigest)object2).update(((String)object).getBytes("UTF-8"));
            object = ((MessageDigest)object2).digest();
            object2 = new StringBuffer();
            for (Object object3 : object) {
                ((StringBuffer)object2).append(String.format("%02x", (byte)object3));
            }
            object = 32 > object2.toString().length() ? object2.toString() : object2.toString().substring(0, 32);
            return l__R$.Q_$2$(string2, (String)object, "");
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            AnalyticsUtil.reportError(exception, "error", "Unable to decrypt file");
            string2 = "Unable to decrypt file, " + exception2.getMessage();
            Log.d((String)"com.razorpay.checkout", (String)string2);
            return null;
        }
    }

    static String getVersionedAssetName(String string2, String string3) {
        string2 = string2.replaceAll("\\.", "-");
        return string2 + "-" + string3;
    }

    public static String getLocalVersion(Activity object, String string2) {
        if ((object = U$_z$.Q_$2$((Context)object, string2)) == null) {
            object = BaseUtils.getVersionFromJsonString("{\n  \"hash\" : \"9ee1052cde77d828ec522ab71d966d8d\",\n  \"magic_hash\": \"8082360e00c3117c97305f562403f237\"\n}\n", string2);
        }
        return object;
    }

    public static String getVersionFromJsonString(String string2, String string3) {
        try {
            string2 = new JSONObject(string2);
            if (string3.equalsIgnoreCase("otpelf_version")) {
                return string2.getString("hash");
            }
            if (string3.equalsIgnoreCase("magic_version")) {
                return string2.getString("magic_hash");
            }
        }
        catch (Exception exception) {}
        return null;
    }

    static void updateLocalVersion(Activity activity, String string2, String string3) {
        U$_z$.Q_$2$((Context)activity, string2, string3);
    }

    static boolean storeFileInInternal(Activity object, String string2, String string3) {
        try {
            object = object.openFileOutput(string2, 0);
            ((OutputStream)object).write(string3.getBytes());
            ((OutputStream)object).close();
            return true;
        }
        catch (Exception exception) {
            AnalyticsUtil.reportError(exception, "error", "Error in saving file: ".concat(String.valueOf(string2)));
            object = "Error in saving file: ".concat(String.valueOf(string2));
            Log.e((String)"com.razorpay.checkout", (String)object);
            return false;
        }
    }

    static void checkForLatestVersion(Context context, int n) {
        if (l__d$.L__R$().b__J_() && BaseUtils.isMerchantAppDebuggable(context) && n < l__d$.L__R$().B$$W$()) {
            String string2 = l__d$.L__R$().r$_Y_();
            Toast.makeText((Context)context, (CharSequence)string2, (int)1).show();
        }
    }

    static int dpToPixels(Context context, int n) {
        context = context.getResources();
        return (int)TypedValue.applyDimension((int)1, (float)n, (DisplayMetrics)context.getDisplayMetrics());
    }

    public static int getDisplayWidth(Context context) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        ((Activity)context).getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics.widthPixels;
    }

    public static int getDisplayHeight(Context context) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        ((Activity)context).getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics.heightPixels;
    }

    static HashMap<String, String> getMapFromJSONObject(JSONObject jSONObject) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                String string3 = jSONObject.getString(string2);
                ((AbstractMap)hashMap).put(string2, string3);
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            AnalyticsUtil.reportError(exception, "error:exception", exception2.getMessage());
            exception2.printStackTrace();
        }
        return hashMap;
    }

    static void setCompatibleWithGooglePay(boolean bl) {
        isCompatibleWithGooglePay = bl;
    }

    static String makeUrlEncodedPayload(JSONObject jSONObject) throws JSONException {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = jSONObject.getString(string2);
            stringBuilder.append(String.format("%s=%s&", string2, Uri.encode((String)string3)));
        }
        StringBuilder stringBuilder2 = stringBuilder;
        return ((Object)stringBuilder2.deleteCharAt(stringBuilder2.length() - 1)).toString();
    }

    static String installedApps(Context object) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            for (ApplicationInfo applicationInfo : object.getPackageManager().getInstalledApplications(0)) {
                if ((applicationInfo.flags & 1) != 0) continue;
                if (stringBuilder.length() != 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(applicationInfo.packageName);
            }
            return ((Object)stringBuilder).toString();
        }
        catch (Throwable throwable) {
            return "Apps not available";
        }
    }

    static String getAndroidId(Context context) {
        return Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
    }

    public static String getDisplayResolution(Context context) {
        context = context.getResources().getDisplayMetrics();
        return String.format(Locale.ENGLISH, "%dx%dx%d", context.widthPixels, context.heightPixels, context.densityDpi);
    }

    String getDeviceUptime() {
        return String.valueOf(SystemClock.elapsedRealtime()) + "ms";
    }

    String getParentAppVersion(Context object) {
        try {
            return object.getPackageManager().getPackageInfo((String)object.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            object = nameNotFoundException;
            AnalyticsUtil.reportError((Exception)((Object)nameNotFoundException), "error:exception", ((Throwable)object).getMessage());
            return "Permission Disabled";
        }
    }

    String getAvailableMemory(Context context) {
        ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
        ((ActivityManager)context.getSystemService("activity")).getMemoryInfo(memoryInfo);
        return String.valueOf(memoryInfo.availMem / 0x100000L) + "MB";
    }

    String getTotalInternalStorage() {
        File file = Environment.getDataDirectory();
        file = new StatFs(file.getPath());
        long l = file.getBlockSizeLong();
        return String.valueOf(file.getBlockCountLong() * l);
    }

    String getBatteryLevel(Context context) {
        if ((context = context.registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"))) != null) {
            int n = context.getIntExtra("level", -1);
            int n2 = context.getIntExtra("scale", -1);
            return String.valueOf((float)n / (float)n2 * 100.0f);
        }
        return "Unknown";
    }

    String getAccounts(Context accountArray) {
        if (accountArray.checkCallingOrSelfPermission("android.permission.GET_ACCOUNTS") == 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Account account : ((AccountManager)accountArray.getSystemService("account")).getAccounts()) {
                stringBuilder.append(account.name);
                stringBuilder.append(",");
            }
            return ((Object)stringBuilder).toString();
        }
        return PERMISSION_DISABLED;
    }

    String getScreenOffTimeout(Context object) {
        object = Settings.System.getString((ContentResolver)object.getContentResolver(), (String)"screen_off_timeout");
        return (String)object + "ms";
    }

    String getScreenBrightnessMode(Context context) {
        return Settings.System.getString((ContentResolver)context.getContentResolver(), (String)"screen_brightness_mode");
    }

    String getScreenBrightness(Context context) {
        return Settings.System.getString((ContentResolver)context.getContentResolver(), (String)"screen_brightness");
    }

    String getWallpaperID(Context context) {
        if (Build.VERSION.SDK_INT >= 24) {
            context = WallpaperManager.getInstance((Context)context);
            int n = context.getWallpaperId(1);
            int n2 = context.getWallpaperId(2);
            return String.format(Locale.ENGLISH, "%d-%d", n2, n);
        }
        return PERMISSION_DISABLED;
    }

    String getRingtoneHash(Context context) {
        Uri uri = RingtoneManager.getActualDefaultRingtoneUri((Context)context, (int)1);
        return BaseUtils.MD5Hash(RingtoneManager.getRingtone((Context)context, (Uri)uri).getTitle(context));
    }

    public static String MD5Hash(String object) {
        try {
            object = MessageDigest.getInstance("MD5").digest(((String)object).getBytes());
            object = new BigInteger(1, (byte[])object).toString(16);
            while (((String)object).length() < 32) {
                object = "0".concat(String.valueOf(object));
            }
            return object;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
    }

    String getSystemFontSize(Context context) {
        return String.valueOf(context.getResources().getConfiguration().fontScale);
    }

    private boolean isMocked(Context context, Location location) {
        return location.isFromMockProvider();
    }

    public static boolean isNetworkRoaming(Context context) {
        if ((context = (TelephonyManager)context.getSystemService("phone")) != null) {
            return context.isNetworkRoaming();
        }
        return false;
    }

    public static String getCarrierOperatorName(Context context) {
        if ((context = (TelephonyManager)context.getSystemService("phone")) != null) {
            return context.getNetworkOperatorName();
        }
        return PERMISSION_DISABLED;
    }

    public static Map<String, String> getDeviceAttributes(Context context) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (context.checkCallingOrSelfPermission("android.permission.READ_PHONE_STATE") == 0) {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            ((AbstractMap)hashMap).put("device_id", U$_z$.a_$P$(context).getString("advertising_id", null));
            if (Build.VERSION.SDK_INT <= 28) {
                ((AbstractMap)hashMap).put("sim_serial_number", telephonyManager != null ? telephonyManager.getSimSerialNumber() : "null");
            } else {
                ((AbstractMap)hashMap).put("sim_serial_number", PERMISSION_DISABLED);
                ((AbstractMap)hashMap).put("build_unique_id", ((Object)UUID.randomUUID()).toString());
            }
        } else {
            ((AbstractMap)hashMap).put("device_id", PERMISSION_DISABLED);
            ((AbstractMap)hashMap).put("sim_serial_number", PERMISSION_DISABLED);
        }
        ((AbstractMap)hashMap).put("device_manufacturer", Build.MANUFACTURER);
        ((AbstractMap)hashMap).put("device_model", Build.MODEL);
        return hashMap;
    }

    static String getWifiSSID(Context context) {
        if (context.checkCallingOrSelfPermission("android.permission.ACCESS_WIFI_STATE") == 0) {
            return ((WifiManager)context.getApplicationContext().getSystemService("wifi")).getConnectionInfo().getSSID();
        }
        return PERMISSION_DISABLED;
    }

    static String buildSerial() {
        return Build.SERIAL;
    }

    static void fetchIP(RzpJSONCallback rzpJSONCallback) {
        new Thread(new Runnable(rzpJSONCallback){
            private /* synthetic */ RzpJSONCallback R$$r_;
            {
                this.R$$r_ = rzpJSONCallback;
            }

            /*
             * Loose catch block
             */
            @Override
            public final void run() {
                try {
                    block12: {
                        HttpURLConnection httpURLConnection = null;
                        try {
                            httpURLConnection = (HttpsURLConnection)new URL("https://approvals-api.getsimpl.com/my-ip").openConnection();
                            httpURLConnection.setRequestMethod("GET");
                            httpURLConnection.setReadTimeout(150);
                            httpURLConnection.setConnectTimeout(250);
                            if (httpURLConnection.getResponseCode() == 200) {
                                JSONObject jSONObject = BaseUtils.getResponseJson((HttpsURLConnection)httpURLConnection);
                                this.R$$r_.onResponse(jSONObject);
                            } else {
                                this.R$$r_.onResponse(new JSONObject().put("error", (Object)"error"));
                            }
                            if (httpURLConnection != null) {
                                httpURLConnection.disconnect();
                                return;
                            }
                        }
                        catch (SocketTimeoutException socketTimeoutException) {
                            this.R$$r_.onResponse(new JSONObject().put("error", (Object)"timeout"));
                            return;
                        }
                        catch (Exception exception) {
                            Exception exception2 = exception;
                            AnalyticsUtil.reportError(exception, "warning", exception2.getMessage());
                            return;
                            {
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                            }
                        }
                        finally {
                            if (httpURLConnection == null) break block12;
                            httpURLConnection.disconnect();
                        }
                    }
                    return;
                }
                catch (Exception exception) {
                    Exception exception3 = exception;
                    AnalyticsUtil.reportError(exception, "warning", exception3.getMessage());
                    return;
                }
            }
        }).start();
    }

    static void getDeviceParamValues(Context object, RzpJSONCallback rzpJSONCallback) {
        JSONObject jSONObject = new JSONObject();
        try {
            BaseUtils.fetchIP(new RzpJSONCallback(){

                @Override
                public final void onResponse(JSONObject jSONObject) {
                    try {
                        if (jSONObject.getString("ip") != null) {
                            ipAddress = jSONObject.getString("ip");
                        }
                        return;
                    }
                    catch (JSONException jSONException) {
                        return;
                    }
                }
            });
            AdvertisingIdUtil.d__1_((Context)object, new AdvertisingIdUtil$a_$P$(jSONObject, (Context)object, rzpJSONCallback){
                private /* synthetic */ JSONObject R$$r_;
                private /* synthetic */ Context d__1_;
                private /* synthetic */ RzpJSONCallback Q_$2$;
                {
                    this.R$$r_ = jSONObject;
                    this.d__1_ = context;
                    this.Q_$2$ = rzpJSONCallback;
                }

                @Override
                public final void a_$P$(String object) {
                    try {
                        this.R$$r_.put("advertising_id", object);
                        this.R$$r_.put("is_roming", BaseUtils.isNetworkRoaming(this.d__1_));
                        this.R$$r_.put("carrier_network", (Object)BaseUtils.getCarrierOperatorName(this.d__1_));
                        this.R$$r_.put("carrier_id", (Object)"null");
                        object = BaseUtils.getDeviceAttributes(this.d__1_);
                        this.R$$r_.put("device_Id", object.get("device_Id"));
                        this.R$$r_.put("device_manufacturer", object.get("device_manufacturer"));
                        this.R$$r_.put("device_model", object.get("device_model"));
                        this.R$$r_.put("serial_number", (Object)BaseUtils.buildSerial());
                        this.R$$r_.put("ip_address", (Object)ipAddress);
                        this.R$$r_.put("wifi_ssid", (Object)BaseUtils.getWifiSSID(this.d__1_));
                        this.R$$r_.put("android_id", (Object)BaseUtils.getAndroidId(this.d__1_));
                        this.R$$r_.put("safety_net basic_integrity", (Object)"true");
                        this.R$$r_.put("safety_net_cts_profile_match", (Object)"null");
                        this.Q_$2$.onResponse(this.R$$r_);
                        return;
                    }
                    catch (JSONException jSONException) {
                        object = jSONException;
                        AnalyticsUtil.reportError((Exception)((Object)jSONException), "warning", ((Throwable)object).getMessage());
                        return;
                    }
                }
            });
            return;
        }
        catch (Exception exception) {
            object = exception;
            AnalyticsUtil.reportError(exception, "warning", ((Throwable)object).getMessage());
            return;
        }
    }

    static void getSignalStrength(Context context) {
        MyPhoneStateListener myPhoneStateListener = new MyPhoneStateListener();
        context = (TelephonyManager)context.getSystemService("phone");
        assert (context != null);
        context.listen((PhoneStateListener)myPhoneStateListener, 256);
    }

    private static JSONObject getResponseJson(HttpsURLConnection object) throws IOException, JSONException {
        String string2;
        object = new BufferedReader(new InputStreamReader(((URLConnection)object).getInputStream()));
        StringBuilder stringBuilder = new StringBuilder();
        while ((string2 = ((BufferedReader)object).readLine()) != null) {
            stringBuilder.append(string2);
        }
        ((Reader)object).close();
        return new JSONObject(((Object)stringBuilder).toString());
    }

    static String getPaymentCancelledResponse(String string2) {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("code", (Object)"BAD_REQUEST_ERROR");
            jSONObject.put("description", (Object)"Payment processing cancelled by user");
            jSONObject.put("source", (Object)"customer");
            jSONObject.put("step", (Object)"payment_authentication");
            jSONObject.put("reason", (Object)"payment_cancelled");
            if (string2 != null && !string2.isEmpty()) {
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put("payment_id", (Object)string2);
                jSONObject.put("metadata", (Object)jSONObject2);
            }
            return new JSONObject().put("error", (Object)jSONObject).toString();
        }
        catch (JSONException jSONException) {
            JSONException jSONException2 = jSONException;
            AnalyticsUtil.reportError((Exception)((Object)jSONException), "critical", jSONException2.getLocalizedMessage());
            return null;
        }
    }

    public static class MyPhoneStateListener
    extends PhoneStateListener {
        public int signalStrengthValue;

        public void onSignalStrengthsChanged(SignalStrength signalStrength) {
            super.onSignalStrengthsChanged(signalStrength);
            if (signalStrength.isGsm()) {
                if (signalStrength.getGsmSignalStrength() != 99) {
                    this.signalStrengthValue = (signalStrength.getGsmSignalStrength() << 1) - 113;
                    return;
                }
                this.signalStrengthValue = signalStrength.getGsmSignalStrength();
                return;
            }
            this.signalStrengthValue = signalStrength.getCdmaDbm();
        }
    }
}

