/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.net.Uri;
import android.text.TextUtils;
import com.razorpay.AnalyticsUtil;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RzpGpayUtilMerged {
    private static final String GOOGLE_PAY = "GOOGLE_PAY";
    private static final String GPAY_INAPP = "gpay_inapp";
    private static final String GPAY_MERGED = "gpay_merged";

    static JSONObject getIsReadyToPayRequest() {
        try {
            JSONObject jSONObject = RzpGpayUtilMerged.getBaseRequest();
            jSONObject.put("allowedPaymentMethods", (Object)new JSONArray().put((Object)RzpGpayUtilMerged.getBaseUPIPaymentMethod()));
            return jSONObject;
        }
        catch (JSONException jSONException) {
            JSONException jSONException2 = jSONException;
            jSONException.printStackTrace();
            AnalyticsUtil.reportError((Exception)((Object)jSONException2), "error:exception", jSONException2.getMessage());
            return null;
        }
    }

    static JSONObject getCardsIsReadyToPayRequest() {
        try {
            JSONObject jSONObject = RzpGpayUtilMerged.getBaseRequest();
            jSONObject.put("allowedPaymentMethods", (Object)new JSONArray().put((Object)RzpGpayUtilMerged.getBaseCardPaymentMethod()));
            return jSONObject;
        }
        catch (JSONException jSONException) {
            JSONException jSONException2 = jSONException;
            jSONException.printStackTrace();
            AnalyticsUtil.reportError((Exception)((Object)jSONException2), "error:exception", jSONException2.getMessage());
            return null;
        }
    }

    private static JSONObject getBaseRequest() {
        try {
            return new JSONObject().put("apiVersion", 2).put("apiVersionMinor", 0);
        }
        catch (JSONException jSONException) {
            JSONException jSONException2 = jSONException;
            AnalyticsUtil.reportError((Exception)((Object)jSONException), "error:exception", jSONException2.getMessage());
            jSONException2.printStackTrace();
            return null;
        }
    }

    private static JSONObject getBaseCardPaymentMethod() {
        Object object = new JSONObject();
        try {
            object.put("type", (Object)"CARD");
            object.put("parameters", (Object)new JSONObject().put("allowedCardNetworks", (Object)RzpGpayUtilMerged.getAllowedCardNetworks()));
            return object;
        }
        catch (JSONException jSONException) {
            object = jSONException;
            AnalyticsUtil.reportError((Exception)((Object)jSONException), "error:exception", object.getLocalizedMessage());
            object.printStackTrace();
            return null;
        }
    }

    private static JSONArray getAllowedCardNetworks() {
        return new JSONArray().put((Object)"MASTERCARD").put((Object)"VISA");
    }

    private static JSONObject getBaseUPIPaymentMethod() {
        Object object = new JSONObject();
        try {
            object.put("type", (Object)"UPI");
            return object;
        }
        catch (JSONException jSONException) {
            object = jSONException;
            AnalyticsUtil.reportError((Exception)((Object)jSONException), "error:exception", object.getMessage());
            object.printStackTrace();
            return null;
        }
    }

    public static String getPaymentRequestData(String object, JSONObject object2) {
        try {
            object = RzpGpayUtilMerged.getUpiData(object);
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("apiVersion", 2);
            jSONObject.put("apiVersionMinor", 0);
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("totalPriceStatus", (Object)"FINAL");
            long l = object2.getLong("amount");
            BigDecimal bigDecimal = new BigDecimal(String.valueOf(l));
            BigDecimal bigDecimal2 = new BigDecimal(100);
            bigDecimal = bigDecimal.divide(bigDecimal2);
            jSONObject2.put("totalPrice", (Object)bigDecimal.toPlainString());
            object2 = object2.getString("currency");
            jSONObject2.put("currencyCode", object2);
            jSONObject2.put("transactionNote", object.get("description"));
            jSONObject.put("transactionInfo", (Object)jSONObject2);
            object2 = new JSONArray();
            jSONObject2 = new JSONObject();
            jSONObject2.put("type", (Object)"UPI");
            bigDecimal = new JSONObject();
            bigDecimal.put("payeeVpa", object.get("address"));
            bigDecimal.put("payeeName", object.get("name"));
            bigDecimal.put("mcc", object.get("mc"));
            bigDecimal.put("transactionReferenceId", object.get("transactionRefId"));
            jSONObject2.put("parameters", (Object)bigDecimal);
            object = new JSONObject();
            object.put("type", (Object)"DIRECT");
            jSONObject2.put("tokenizationSpecification", object);
            object2.put((Object)jSONObject2);
            jSONObject.put("allowedPaymentMethods", object2);
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            object = jSONException;
            AnalyticsUtil.reportError((Exception)((Object)jSONException), "error:exception", object.getMessage());
            object.printStackTrace();
            return null;
        }
    }

    static JSONObject getUpiData(String object) {
        JSONObject jSONObject;
        block12: {
            jSONObject = new JSONObject();
            try {
                if (!((String)object).startsWith("upi://")) {
                    object = new JSONObject((String)object);
                    object = new JSONObject(object.getString("data"));
                    object = object.getString("intent_url");
                }
                if (!((String)object).contains("//")) break block12;
                object = ((String)object).replaceFirst("upi://", "http://");
                try {
                    object = RzpGpayUtilMerged.splitQuery(new URL((String)object));
                    if (!TextUtils.isEmpty((CharSequence)object.get("pa"))) {
                        jSONObject.put("address", object.get("pa"));
                    }
                    if (!TextUtils.isEmpty((CharSequence)((CharSequence)object.get("pn")))) {
                        jSONObject.put("name", object.get("pn"));
                    }
                    if (!TextUtils.isEmpty((CharSequence)((CharSequence)object.get("am")))) {
                        jSONObject.put("amount", object.get("am"));
                    }
                    if (!TextUtils.isEmpty((CharSequence)((CharSequence)object.get("tn")))) {
                        jSONObject.put("description", object.get("tn"));
                    }
                    if (!TextUtils.isEmpty((CharSequence)((CharSequence)object.get("tr")))) {
                        jSONObject.put("transactionRefId", object.get("tr"));
                    }
                    if (!TextUtils.isEmpty((CharSequence)((CharSequence)object.get("mc")))) {
                        jSONObject.put("mc", object.get("mc"));
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    object = unsupportedEncodingException;
                    AnalyticsUtil.reportError(unsupportedEncodingException, "critical", ((Throwable)object).getLocalizedMessage());
                    ((Throwable)object).printStackTrace();
                }
                catch (MalformedURLException malformedURLException) {
                    object = malformedURLException;
                    AnalyticsUtil.reportError(malformedURLException, "warning", ((Throwable)object).getLocalizedMessage());
                    ((Throwable)object).printStackTrace();
                }
            }
            catch (JSONException jSONException) {
                object = jSONException;
                AnalyticsUtil.reportError((Exception)((Object)jSONException), "error:exception", object.getMessage());
                object.printStackTrace();
            }
        }
        return jSONObject;
    }

    private static Map<String, String> splitQuery(URL stringArray) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        stringArray = stringArray.getQuery();
        String[] stringArray2 = stringArray.split("&");
        stringArray = stringArray2;
        stringArray = stringArray2;
        int n = stringArray2.length;
        for (int k = 0; k < n; ++k) {
            String string = stringArray[k];
            int n2 = string.indexOf("=");
            linkedHashMap.put(URLDecoder.decode(string.substring(0, n2), "UTF-8"), URLDecoder.decode(string.substring(n2 + 1), "UTF-8"));
        }
        return linkedHashMap;
    }

    static String makeExternalSDKPayload(JSONObject jSONObject) {
        try {
            JSONObject jSONObject2 = new JSONObject();
            jSONObject.put("type", (Object)GPAY_INAPP);
            jSONObject2.put("apiResponse", (Object)jSONObject);
            jSONObject = new JSONObject();
            jSONObject.put("provider", (Object)GOOGLE_PAY);
            jSONObject.put("data", (Object)jSONObject2);
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            JSONException jSONException2 = jSONException;
            AnalyticsUtil.reportError((Exception)((Object)jSONException), "error:exception", jSONException2.getMessage());
            jSONException2.printStackTrace();
            return "";
        }
    }

    static String makeMergedExternalSDKPayload(JSONObject jSONObject) {
        try {
            JSONObject jSONObject2 = new JSONObject();
            jSONObject.put("type", (Object)GPAY_MERGED);
            jSONObject2.put("apiResponse", (Object)jSONObject);
            jSONObject = new JSONObject();
            jSONObject.put("provider", (Object)GOOGLE_PAY);
            jSONObject.put("data", (Object)jSONObject2);
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            JSONException jSONException2 = jSONException;
            AnalyticsUtil.reportError((Exception)((Object)jSONException), "error:exception", jSONException2.getMessage());
            jSONException2.printStackTrace();
            return "";
        }
    }

    static String makeApiPayload(JSONObject jSONObject) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = jSONObject.getString(string);
            stringBuilder.append(String.format("%s=%s&", string, Uri.encode((String)string2)));
        }
        StringBuilder stringBuilder2 = stringBuilder;
        return stringBuilder2.deleteCharAt(stringBuilder2.length() - 1).toString();
    }

    static String makeErrorPayload(String string, String string2) {
        try {
            JSONObject jSONObject = new JSONObject();
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("code", (Object)string);
            jSONObject2.put("description", (Object)string2);
            jSONObject.put("error", (Object)jSONObject2);
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            JSONException jSONException2 = jSONException;
            AnalyticsUtil.reportError((Exception)((Object)jSONException), "error:exception", jSONException2.getMessage());
            jSONException2.printStackTrace();
            return "{\"error\":{\"code\": \"BAD_REQUEST_ERROR\", \"description\": \"An unknown error occurred.\"}}";
        }
    }

    static String makeMergedExternalSDKErrorPayload(JSONObject jSONObject, int n, String object) {
        JSONObject jSONObject2 = new JSONObject();
        JSONObject jSONObject3 = new JSONObject();
        try {
            jSONObject3.put("type", (Object)GPAY_MERGED);
            jSONObject3.put("description", object);
            jSONObject2.put("apiResponse", (Object)jSONObject3);
            object = new JSONObject();
            object.put("provider", (Object)GOOGLE_PAY);
            object.put("resultCode", n);
            object.put("data", (Object)jSONObject2);
            return object.toString();
        }
        catch (JSONException jSONException) {
            object = jSONException;
            AnalyticsUtil.reportError((Exception)((Object)jSONException), "error:exception", object.getMessage());
            return RzpGpayUtilMerged.makeExceptionErrorPayload(jSONObject.has("bundle"));
        }
    }

    static String makeExceptionErrorPayload(boolean bl) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("provider", (Object)GOOGLE_PAY);
            jSONObject.put("resultCode", (Object)"1");
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("type", (Object)GPAY_MERGED);
            jSONObject2.put("description", (Object)"Something went wrong please try again.");
            jSONObject.put("data", (Object)jSONObject2);
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            JSONException jSONException2 = jSONException;
            jSONException.printStackTrace();
            return "{\"provider\":\"GOOGLE_PAY\",\"resultCode\":\"1\",\"data\":{\"apiResponse\":{\"type\":\"gpay_merged\",\"description\":\"Something went wrong. Please try again\"}}}";
        }
    }
}

