/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.app.Activity;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.util.Log;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import com.razorpay.AnalyticsEvent;
import com.razorpay.AnalyticsProperty;
import com.razorpay.AnalyticsProperty$Scope;
import com.razorpay.AnalyticsUtil;
import com.razorpay.BaseUtils;
import com.razorpay.E$_j$;
import com.razorpay.J$_M_;
import com.razorpay.OtpElfData;
import com.razorpay.SmsAgentInterface;
import com.razorpay.U_$B$;
import com.razorpay.a;
import com.razorpay.b;
import com.razorpay.c;
import com.razorpay.d__1_;
import com.razorpay.g$_H$;
import com.razorpay.i;
import com.razorpay.n$_B$;
import com.razorpay.p$_5$;
import java.util.HashMap;
import org.json.JSONObject;

public final class RzpAssist
implements SmsAgentInterface {
    private WebView webview;
    private boolean hasOtpPermission = false;
    private String lastURL = "";
    private String currentLoadingUrl = "";
    private long pageStartTime;
    private boolean isMagic = false;
    private boolean isRazorpayOtpReceived = false;
    private Activity activity;
    private String merchantKey;
    private i smsAgent;
    private OtpElfData elfData;
    private JSONObject otpElfPreferences = new JSONObject();
    private JSONObject paymentData = new JSONObject();
    private String paymentId;
    private boolean isRzpAssistEnabled = false;
    private boolean otpRead = false;
    private String sdkType = "standalone";
    private int sdkVersionCode;
    String lastSms;
    String message;
    String sender;
    private boolean jsInsertedInCurrentPage = false;

    public RzpAssist(String string, Activity activity, WebView webView, String string2, int n, String string3) {
        if (!n$_B$.a().isOTPElfEnabled().booleanValue()) {
            return;
        }
        if (string == null || string.isEmpty()) {
            throw new RuntimeException("merchantKey cannot be null or empty");
        }
        this.sdkType = string2;
        this.sdkVersionCode = n;
        String string4 = "OTPElf Constructor";
        Log.d((String)"com.razorpay.checkout", (String)string4);
        if (string2.equals("standalone")) {
            AnalyticsUtil.setup((Context)activity, string, string2, n, string3);
        }
        this.webview = webView;
        this.merchantKey = string;
        this.activity = activity;
        this.elfData = new OtpElfData(activity);
        this.elfData.checkForUpdates();
        this.setup();
        AnalyticsUtil.addProperty("OTPElf Version", new AnalyticsProperty(BaseUtils.getLocalVersion(activity, OtpElfData.versionKey), AnalyticsProperty$Scope.ORDER));
    }

    private void setup() {
        this.smsAgent = i.a();
        this.smsAgent.a(this);
        this.smsAgent.a(this.activity);
        this.webview.addJavascriptInterface((Object)this, "OTPElfBridge");
        this.webview.getSettings().setUseWideViewPort(true);
    }

    final void enableMagic() {
        this.isMagic = true;
    }

    final void setPaymentData(JSONObject jSONObject) {
        this.paymentData = jSONObject;
    }

    public final void setOtpElfPreferences(JSONObject jSONObject) {
        this.otpElfPreferences = jSONObject;
    }

    public final void onPageFinished(WebView webView, String string) {
        long l = System.nanoTime() - this.pageStartTime;
        AnalyticsUtil.trackPageLoadEnd(string, l);
        this.lastURL = string;
        this.currentLoadingUrl = "";
        if (!n$_B$.a().isOTPElfEnabled().booleanValue()) {
            return;
        }
        if (!this.jsInsertedInCurrentPage) {
            this.handleJsInsertion();
            this.jsInsertedInCurrentPage = true;
        }
    }

    private void handleJsInsertion() {
        try {
            JSONObject jSONObject = n$_B$.a().getOTPElfSettings();
            jSONObject.put("merchant_key", (Object)this.merchantKey);
            jSONObject.put("otp_permission", this.hasOtpPermission);
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("type", (Object)this.sdkType);
            jSONObject2.put("version_code", this.sdkVersionCode);
            jSONObject.put("sdk", (Object)jSONObject2);
            jSONObject2 = new JSONObject();
            if (!this.isMagic) {
                String string = "not magic";
                Log.d((String)"com.razorpay.checkout", (String)string);
                jSONObject2.put("type", (Object)"rzpassist");
                jSONObject2.put("version_code", g$_H$.b.intValue());
            } else {
                String string = "This is Magic";
                Log.d((String)"com.razorpay.checkout", (String)string);
                jSONObject2.put("type", (Object)"magic");
                jSONObject2.put("version_code", g$_H$.c.intValue());
            }
            jSONObject.put("plugin", (Object)jSONObject2);
            jSONObject.put("payment_data", (Object)this.paymentData);
            jSONObject.put("preferences", (Object)this.otpElfPreferences);
            this.injectJs("window.__rzp_options = " + jSONObject.toString());
        }
        catch (Exception exception) {
            d__1_.a("Unable to load otpelf settings", exception);
        }
        RzpAssist rzpAssist = this;
        rzpAssist.injectJs(rzpAssist.elfData.getOtpElfJs());
        if (this.lastSms != null) {
            this.injectJs(String.format("OTPElf.showOTP('%s','%s')", this.lastSms, this.sender));
            this.lastSms = null;
        }
    }

    public final void onProgressChanged(int n) {
        if (!n$_B$.a().isOTPElfEnabled().booleanValue()) {
            return;
        }
    }

    public final void onPageStarted(WebView object, String string) {
        object = "RzpAssist onPageStarted: " + string;
        Log.d((String)"com.razorpay.checkout", (String)object);
        AnalyticsUtil.trackPageLoadStart(string);
        this.pageStartTime = System.nanoTime();
        this.currentLoadingUrl = string;
        this.jsInsertedInCurrentPage = false;
    }

    public final void paymentFlowEnd() {
        if (this.sdkType.equals("standalone")) {
            AnalyticsUtil.postData();
        }
        if (!n$_B$.a().isOTPElfEnabled().booleanValue()) {
            return;
        }
        this.smsAgent.c(this.activity);
        this.smsAgent.b(this);
    }

    @Override
    public final void postSms(String string, String string2) {
        if (!this.isRzpAssistEnabled) {
            return;
        }
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("sender", (Object)string);
            jSONObject.put("message", (Object)string2);
            this.sender = string;
            this.message = string2;
            this.lastSms = jSONObject.toString();
            this.injectJs(String.format("OTPElf.showOTP('%s','%s')", string2, string));
            return;
        }
        catch (Exception exception) {
            d__1_.a("Exception", exception);
            return;
        }
    }

    @Override
    public final void setSmsPermission(boolean bl) {
        this.setOTPEnabled(bl);
    }

    final void setPaymentId(String string) {
        this.paymentId = string;
    }

    private void postStatsToAPI() {
        try {
            String string = BaseUtils.constructBasicAuth(this.merchantKey);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("Authorization", "Basic " + string);
            hashMap.put("Content-Type", "application/json");
            if (this.paymentId == null) {
                return;
            }
            string = "https://api.razorpay.com/v1/payments/" + this.paymentId + "/metadata";
            String string2 = "Sending Stats Request";
            Log.d((String)"com.razorpay.checkout", (String)string2);
            JSONObject jSONObject = E$_j$.a(this.otpRead);
            string2 = "PAYLOAD";
            Log.d((String)"com.razorpay.checkout", (String)string2);
            string2 = jSONObject.toString();
            Log.d((String)"com.razorpay.checkout", (String)string2);
            string2 = string;
            Log.d((String)"com.razorpay.checkout", (String)string2);
            p$_5$.a(string, jSONObject.toString(), hashMap, new J$_M_(this));
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            AnalyticsUtil.reportError(exception, "critical", exception2.getMessage());
            return;
        }
    }

    private void injectJs(String string) {
        this.webview.loadUrl(String.format("javascript: %s", string));
    }

    final void onRequestPermissionsResult(int n, String[] activity, int[] nArray) {
        int[] nArray2 = nArray;
        int n2 = n;
        activity = this.activity;
        i i2 = this.smsAgent;
        switch (n2) {
            case 1: {
                if (nArray2.length > 0 && nArray2[0] == 0) {
                    i2.a(true);
                    i2.b(activity);
                    AnalyticsUtil.trackEvent(AnalyticsEvent.SMS_PERMISSION_NOW_GRANTED);
                    return;
                }
                i2.a(false);
                AnalyticsUtil.trackEvent(AnalyticsEvent.SMS_PERMISSION_NOW_DENIED);
            }
        }
    }

    final String getLastLoadedUrl() {
        return this.lastURL;
    }

    final String getCurrentLoadingUrl() {
        return this.currentLoadingUrl;
    }

    public final void reset() {
        this.postStatsToAPI();
        this.lastURL = "";
        this.currentLoadingUrl = "";
        this.otpRead = false;
    }

    final boolean isRazorpayOtpReceived() {
        return this.isRazorpayOtpReceived;
    }

    final void setOTPEnabled(boolean bl) {
        this.hasOtpPermission = bl;
        AnalyticsUtil.addProperty("otp_autoreading_access", new AnalyticsProperty(bl, AnalyticsProperty$Scope.ORDER));
    }

    final void setRzpAssistEnabled(boolean bl) {
        this.isRzpAssistEnabled = bl;
    }

    @JavascriptInterface
    public final void setUseWideViewPort(boolean bl) {
        this.activity.runOnUiThread((Runnable)new U_$B$(this, bl));
    }

    @JavascriptInterface
    public final void openKeyboard() {
        this.activity.runOnUiThread((Runnable)new a(this));
    }

    @JavascriptInterface
    public final void toast(String string) {
        this.activity.runOnUiThread((Runnable)new b(this, string));
    }

    @JavascriptInterface
    public final void trackEvent(String string, String string2) {
        try {
            AnalyticsEvent analyticsEvent = AnalyticsEvent.JS_EVENT;
            analyticsEvent.setEventName(string);
            string = new JSONObject(string2);
            AnalyticsUtil.trackEvent(analyticsEvent, (JSONObject)string);
            return;
        }
        catch (Exception exception) {
            d__1_.a("Error in tracking JS Event", exception);
            return;
        }
    }

    @JavascriptInterface
    public final void trackEvent(String string) {
        AnalyticsEvent analyticsEvent = AnalyticsEvent.JS_EVENT;
        analyticsEvent.setEventName(string);
        AnalyticsUtil.trackEvent(analyticsEvent);
    }

    @JavascriptInterface
    public final void onOtpParsed(String string) {
        this.activity.runOnUiThread((Runnable)new c(this, string));
    }

    @JavascriptInterface
    public final void copyToClipboard(String string) {
        ClipboardManager clipboardManager = (ClipboardManager)this.activity.getSystemService("clipboard");
        string = ClipData.newPlainText((CharSequence)"rzp_clip_data", (CharSequence)string);
        clipboardManager.setPrimaryClip((ClipData)string);
    }

    static /* synthetic */ WebView access$000(RzpAssist rzpAssist) {
        return rzpAssist.webview;
    }

    static /* synthetic */ Activity access$100(RzpAssist rzpAssist) {
        return rzpAssist.activity;
    }

    static /* synthetic */ boolean access$202(RzpAssist rzpAssist, boolean bl) {
        rzpAssist.isRazorpayOtpReceived = bl;
        return rzpAssist.isRazorpayOtpReceived;
    }

    static /* synthetic */ boolean access$302(RzpAssist rzpAssist, boolean bl) {
        rzpAssist.otpRead = bl;
        return rzpAssist.otpRead;
    }
}

