/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Fragment;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.CookieManager;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Toast;
import com.razorpay.AnalyticsEvent;
import com.razorpay.AnalyticsProperty;
import com.razorpay.AnalyticsProperty$Scope;
import com.razorpay.AnalyticsUtil;
import com.razorpay.BaseUtils;
import com.razorpay.Checkout$1;
import com.razorpay.CheckoutUtils;
import com.razorpay.ExternalWalletListener;
import com.razorpay.PaymentData;
import com.razorpay.PaymentResultListener;
import com.razorpay.PaymentResultWithDataListener;
import com.razorpay.Y_$H_;
import com.razorpay.f$_G$;
import com.razorpay.g__v_;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class Checkout
extends Fragment {
    public static final int NETWORK_ERROR = 2;
    public static final int INVALID_OPTIONS = 3;
    public static final int PAYMENT_CANCELED = 0;
    public static final int TLS_ERROR = 6;
    public static final int INCOMPATIBLE_PLUGIN = 7;
    public static final int RZP_REQUEST_CODE = 62442;
    static final int PAYMENT_SUCCESS = 1;
    static final int EXTERNAL_WALLET = 4;
    static final int INTEGRATION_ONE = 1;
    static final int INTEGRATION_TWO = 2;
    static final int INTEGRATION_THREE = 3;
    static final String EVENT_CALLBACK_DNE = "dne";
    static final String EVENT_CALLBACK_THREW_ERROR = "threw_error";
    @SuppressLint(value={"StaticFieldLeak"})
    private static WebView sPreloadView;
    private static long sPreloadCompleteDuration;
    private static long sPreloadAbortDuration;
    private static boolean sPreloadFailed;
    private String key;
    private JSONObject options;
    private Activity merchantActivity;
    private String merchantClassName;
    private boolean disableFullScreen;
    private int checkoutImage;
    private static PaymentData paymentData;
    private boolean isMethodOverridden;

    @Deprecated
    public final void setPublicKey(String string) {
        this.key = string;
    }

    public final void setImage(int n) {
        this.checkoutImage = n;
    }

    public final void setKeyID(String string) {
        this.setPublicKey(string);
    }

    public final void setFullScreenDisable(boolean bl) {
        this.disableFullScreen = bl;
    }

    public final void open(Activity activity, JSONObject jSONObject) {
        if (TextUtils.isEmpty((CharSequence)this.key)) {
            this.key = BaseUtils.getKeyId((Context)activity);
        }
        Y_$H_.getAdvertisingIdFromUtil((Context)activity);
        if (TextUtils.isEmpty((CharSequence)this.key)) {
            throw new RuntimeException("Please set your Razorpay API key in AndroidManifest.xml");
        }
        if (jSONObject == null || jSONObject.length() == 0) {
            throw new RuntimeException("Checkout options cannot be null or empty");
        }
        try {
            jSONObject.put("key", (Object)this.key);
        }
        catch (JSONException jSONException) {
            JSONException jSONException2 = jSONException;
            AnalyticsUtil.reportError((Exception)((Object)jSONException), "warning", jSONException2.getMessage());
        }
        Checkout.abortPreloadIfRequired();
        this.options = jSONObject;
        this.merchantClassName = activity.getClass().getName();
        this.merchantActivity = activity;
        activity.getFragmentManager().beginTransaction().add((Fragment)this, null).commitAllowingStateLoss();
    }

    public static void preload(Context context) {
        sPreloadCompleteDuration = 0L;
        sPreloadAbortDuration = 0L;
        sPreloadFailed = false;
        context = context.getApplicationContext();
        sPreloadView = new WebView(context);
        BaseUtils.setWebViewSettings(context, sPreloadView, false);
        sPreloadView.setWebViewClient((WebViewClient)new Checkout$1());
        sPreloadView.setWebChromeClient((WebChromeClient)new g__v_());
        sPreloadView.loadUrl("https://api.razorpay.com/v1/checkout/public");
    }

    private static void failPreload() {
        sPreloadFailed = true;
    }

    private static void destroyPreloadView() {
        try {
            sPreloadView.stopLoading();
        }
        catch (Exception exception) {}
        sPreloadView = null;
    }

    private static void abortPreloadIfRequired() {
        long l = System.nanoTime();
        try {
            if (sPreloadView != null) {
                long l2 = (Long)sPreloadView.getTag();
                sPreloadAbortDuration = l - l2;
                String string = "Preload aborted in " + BaseUtils.nanoTimeToSecondsString(sPreloadAbortDuration, 2) + " sec.";
                Log.d((String)"com.razorpay.checkout", (String)string);
            }
        }
        catch (Exception exception) {}
        Checkout.destroyPreloadView();
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        if (this.options != null) {
            bundle = new Intent();
            bundle.setComponent(new ComponentName(this.getActivity().getPackageName(), "com.razorpay.CheckoutActivity"));
            if (sPreloadCompleteDuration > 0L) {
                bundle.putExtra("PRELOAD_COMPLETE_DURATION", sPreloadCompleteDuration);
            } else if (sPreloadAbortDuration > 0L) {
                bundle.putExtra("PRELOAD_ABORT_DURATION", sPreloadAbortDuration);
            }
            bundle.putExtra("OPTIONS", this.options.toString());
            bundle.putExtra("IMAGE", this.checkoutImage);
            bundle.putExtra("DISABLE_FULL_SCREEN", this.disableFullScreen);
            this.options = null;
            this.startActivityForResult((Intent)bundle, 62442);
        }
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        if (n != 62442) {
            return;
        }
        this.merchantActivity = this.getActivity();
        this.merchantClassName = this.merchantActivity.getClass().getName();
        Object object = Checkout.getPaymentResult(intent);
        if (object == null) {
            object = "Payment Error";
        } else if (((String)object).contains("cancelled")) {
            object = BaseUtils.getPaymentCancelledResponse("");
        }
        Checkout.trackOnActivityResultEvent(n2, (String)object);
        if (n2 == 1) {
            Checkout.createPaymentData(this.merchantActivity, (String)object);
            this.handleOnSuccess();
        } else if (n2 == 4) {
            this.handleExternalWalletSelected();
        } else {
            this.handleOnError(n2, (String)object);
        }
        try {
            this.getActivity().getFragmentManager().beginTransaction().remove((Fragment)this).commit();
            return;
        }
        catch (Exception exception) {
            object = exception;
            AnalyticsUtil.reportError(exception, "error", ((Throwable)object).getMessage());
            return;
        }
    }

    private void handleExternalWalletSelected() {
        if (this.getActivity() instanceof ExternalWalletListener) {
            try {
                ExternalWalletListener externalWalletListener = (ExternalWalletListener)this.getActivity();
                String string = paymentData.getExternalWallet();
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    externalWalletListener.onExternalWalletSelected(string, paymentData);
                    AnalyticsUtil.trackEvent(AnalyticsEvent.MERCHANT_EXTERNAL_WALLET_SELECTED_CALLED);
                    AnalyticsUtil.postData();
                }
                return;
            }
            catch (Exception exception) {
                Checkout.handleMerchantCallbackError(this.merchantActivity, 4, EVENT_CALLBACK_THREW_ERROR, exception);
                return;
            }
        }
        Checkout.handleMerchantCallbackError(this.merchantActivity, 4, EVENT_CALLBACK_DNE, new Exception());
    }

    private void handleOnError(int n, String string) {
        this.isMethodOverridden = true;
        this.onError(n, string);
        if (this.isMethodOverridden) {
            Checkout.trackIntegrationType(n, 1);
        }
    }

    private void handleOnSuccess() {
        String string = paymentData.getPaymentId();
        if (string != null) {
            this.isMethodOverridden = true;
            this.onSuccess(string);
        }
        if (this.isMethodOverridden) {
            Checkout.trackIntegrationType(1, 1);
        }
    }

    public void onSuccess(String string) {
        this.isMethodOverridden = false;
        boolean bl = this.handleOnSuccessViaInterface(string);
        if (!bl) {
            this.handleOnSuccessViaReflection(string);
        }
    }

    public void onError(int n, String string) {
        this.isMethodOverridden = false;
        boolean bl = this.handleOnErrorViaInterface(n, string);
        if (!bl) {
            this.handleOnErrorViaReflection(n, string);
        }
    }

    private void handleOnErrorViaReflection(int n, String string) {
        Method method = null;
        try {
            method = this.getMerchantClassMethod("onPaymentError", Integer.TYPE, String.class);
        }
        catch (Exception exception) {
            Checkout.handleMerchantCallbackError(this.merchantActivity, n, EVENT_CALLBACK_DNE, exception);
        }
        try {
            this.invokeMethod(method, n, string);
            Checkout.trackIntegrationType(n, 2);
            return;
        }
        catch (Exception exception) {
            Checkout.handleMerchantCallbackError(this.merchantActivity, n, EVENT_CALLBACK_THREW_ERROR, exception);
            return;
        }
    }

    private boolean handleOnErrorViaInterface(int n, String string) {
        if (this.getActivity() instanceof PaymentResultListener) {
            try {
                PaymentResultListener paymentResultListener = (PaymentResultListener)this.getActivity();
                paymentResultListener.onPaymentError(n, string);
                Checkout.trackIntegrationType(n, 3);
            }
            catch (Exception exception) {
                Checkout.handleMerchantCallbackError(this.merchantActivity, n, EVENT_CALLBACK_THREW_ERROR, exception);
            }
            return true;
        }
        if (this.getActivity() instanceof PaymentResultWithDataListener) {
            try {
                PaymentResultWithDataListener paymentResultWithDataListener = (PaymentResultWithDataListener)this.getActivity();
                paymentResultWithDataListener.onPaymentError(n, string, paymentData);
                Checkout.trackIntegrationType(n, 3);
            }
            catch (Exception exception) {
                Checkout.handleMerchantCallbackError(this.merchantActivity, n, EVENT_CALLBACK_THREW_ERROR, exception);
            }
            return true;
        }
        return false;
    }

    private boolean handleOnSuccessViaInterface(String string) {
        if (this.getActivity() instanceof PaymentResultListener) {
            try {
                PaymentResultListener paymentResultListener = (PaymentResultListener)this.getActivity();
                paymentResultListener.onPaymentSuccess(string);
                Checkout.trackIntegrationType(1, 3);
            }
            catch (Exception exception) {
                Checkout.handleMerchantCallbackError(this.merchantActivity, 1, EVENT_CALLBACK_THREW_ERROR, exception);
            }
            return true;
        }
        if (this.getActivity() instanceof PaymentResultWithDataListener) {
            try {
                PaymentResultWithDataListener paymentResultWithDataListener = (PaymentResultWithDataListener)this.getActivity();
                paymentResultWithDataListener.onPaymentSuccess(string, paymentData);
                Checkout.trackIntegrationType(1, 3);
            }
            catch (Exception exception) {
                Checkout.handleMerchantCallbackError(this.merchantActivity, 1, EVENT_CALLBACK_THREW_ERROR, exception);
            }
            return true;
        }
        return false;
    }

    private void handleOnSuccessViaReflection(String string) {
        Method method = null;
        try {
            method = this.getMerchantClassMethod("onPaymentSuccess", String.class);
        }
        catch (Exception exception) {
            Checkout.handleMerchantCallbackError(this.merchantActivity, 1, EVENT_CALLBACK_DNE, exception);
        }
        try {
            this.invokeMethod(method, string);
            Checkout.trackIntegrationType(1, 2);
            return;
        }
        catch (Exception exception) {
            Checkout.handleMerchantCallbackError(this.merchantActivity, 1, EVENT_CALLBACK_THREW_ERROR, exception);
            return;
        }
    }

    private void invokeMethod(Method method, Object ... objectArray) {
        if (method == null) {
            return;
        }
        method.invoke((Object)this.merchantActivity, objectArray);
    }

    private Method getMerchantClassMethod(String object, Class ... classArray) {
        Class<?> clazz = Class.forName(this.merchantClassName);
        object = clazz.getMethod((String)object, classArray);
        return object;
    }

    private static void trackIntegrationType(int n, int n2) {
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("integration_type", Integer.toString(n2));
            if (n == 1) {
                AnalyticsUtil.trackEvent(AnalyticsEvent.MERCHANT_ON_SUCCESS_CALLED, hashMap);
            } else {
                AnalyticsUtil.trackEvent(AnalyticsEvent.MERCHANT_ON_ERROR_CALLED, hashMap);
            }
            AnalyticsUtil.postData();
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            AnalyticsUtil.reportError(exception, "warning", exception2.getMessage());
            return;
        }
    }

    private static void trackOnActivityResultEvent(int n, String string) {
        try {
            AnalyticsUtil.addProperty("onActivityResult result", new AnalyticsProperty(string, AnalyticsProperty$Scope.ORDER));
            AnalyticsUtil.addProperty("onActivityResult resultCode", new AnalyticsProperty(String.valueOf(n), AnalyticsProperty$Scope.ORDER));
            if (n == 1) {
                AnalyticsUtil.trackEvent(AnalyticsEvent.CALLING_ON_SUCCESS);
            } else if (n == 4) {
                AnalyticsUtil.trackEvent(AnalyticsEvent.CALLING_EXTERNAL_WALLET_SELECTED);
            } else {
                AnalyticsUtil.trackEvent(AnalyticsEvent.CALLING_ON_ERROR);
            }
            AnalyticsUtil.postData();
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            AnalyticsUtil.reportError(exception, "warning", exception2.getMessage());
            return;
        }
    }

    private static void handleMerchantCallbackError(Activity activity, int n, String string, Exception exception) {
        String string2;
        String string3;
        if (n == 1) {
            string3 = "onPaymentSuccess";
            string2 = "success";
        } else if (n == 4) {
            string3 = "onExternalWalletSelected";
            string2 = "redirected";
        } else {
            string3 = "onPaymentError";
            string2 = "error";
        }
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("event_details", exception.getMessage());
            hashMap.put("event_type", exception.getMessage());
            hashMap.put("payment_status", string2);
            AnalyticsUtil.trackEvent(AnalyticsEvent.HANDOVER_ERROR, hashMap);
            AnalyticsUtil.postData();
        }
        catch (Exception exception2) {
            Exception exception3 = exception2;
            AnalyticsUtil.reportError(exception2, "error", exception3.getMessage());
        }
        if (string.equals(EVENT_CALLBACK_DNE)) {
            if (n == 4) {
                Toast.makeText((Context)activity, (CharSequence)"Error: ExternalWalletListener probably not implemented in your activity", (int)0).show();
            } else {
                Toast.makeText((Context)activity, (CharSequence)("Error: " + string3 + " probably not implemented in your activity"), (int)0).show();
            }
        } else if (string.equals(EVENT_CALLBACK_THREW_ERROR)) {
            Toast.makeText((Context)activity, (CharSequence)("Your " + string3 + " method is throwing an error. Wrap the entire code of the method inside a try catch."), (int)0).show();
        }
        AnalyticsUtil.reportError(exception, "error", exception.getMessage());
    }

    private static void createPaymentData(Activity object, String string) {
        paymentData = new PaymentData();
        paymentData.setUserContact(CheckoutUtils.b((Context)object));
        paymentData.setUserEmail(CheckoutUtils.a((Context)object));
        try {
            object = new JSONObject(string);
            paymentData.setData((JSONObject)object);
            if (object.has("razorpay_payment_id")) {
                paymentData.setPaymentId(object.getString("razorpay_payment_id"));
            }
            if (object.has("razorpay_order_id")) {
                paymentData.setOrderId(object.getString("razorpay_order_id"));
            }
            if (object.has("razorpay_signature")) {
                paymentData.setSignature(object.getString("razorpay_signature"));
            }
            if (object.has("external_wallet")) {
                paymentData.setExternalWallet(object.getString("external_wallet"));
            }
            return;
        }
        catch (JSONException jSONException) {
            object = jSONException;
            AnalyticsUtil.reportError((Exception)((Object)jSONException), "error", object.getMessage());
            return;
        }
    }

    public static void handleActivityResult(Activity activity, int n, int n2, Intent intent, PaymentResultWithDataListener paymentResultWithDataListener, ExternalWalletListener externalWalletListener) {
        if (n != 62442) {
            return;
        }
        String string = Checkout.getPaymentResult(intent);
        if (string.contains("cancelled")) {
            string = BaseUtils.getPaymentCancelledResponse("");
        }
        Checkout.createPaymentData(activity, string);
        Checkout.trackOnActivityResultEvent(n2, string);
        if (n2 == 1) {
            try {
                string = paymentData.getPaymentId();
                paymentResultWithDataListener.onPaymentSuccess(string, paymentData);
                return;
            }
            catch (Exception exception) {
                Checkout.handleMerchantCallbackError(activity, n2, EVENT_CALLBACK_THREW_ERROR, exception);
                return;
            }
        }
        if (n2 == 4) {
            if (externalWalletListener != null) {
                try {
                    externalWalletListener.onExternalWalletSelected(paymentData.getExternalWallet(), paymentData);
                    return;
                }
                catch (Exception exception) {
                    Checkout.handleMerchantCallbackError(activity, n2, EVENT_CALLBACK_THREW_ERROR, exception);
                    return;
                }
            }
        } else {
            try {
                paymentResultWithDataListener.onPaymentError(n2, string, paymentData);
                return;
            }
            catch (Exception exception) {
                Checkout.handleMerchantCallbackError(activity, n2, EVENT_CALLBACK_THREW_ERROR, exception);
            }
        }
    }

    public static void clearUserData(Context context) {
        CheckoutUtils.b(context, null);
        CheckoutUtils.a(context, null);
        f$_G$.a(context, null);
        context = CookieManager.getInstance();
        context.setCookie("https://api.razorpay.com", "razorpay_api_session=");
    }

    private static String getPaymentResult(Intent intent) {
        if (intent != null && (intent = intent.getExtras()) != null) {
            return intent.getString("RESULT");
        }
        return null;
    }

    static /* synthetic */ WebView access$000() {
        return sPreloadView;
    }

    static /* synthetic */ void access$100() {
        Checkout.failPreload();
    }

    static /* synthetic */ boolean access$200() {
        return sPreloadFailed;
    }

    static /* synthetic */ long access$302(long l) {
        sPreloadCompleteDuration = l;
        return sPreloadCompleteDuration;
    }

    static /* synthetic */ long access$300() {
        return sPreloadCompleteDuration;
    }

    static /* synthetic */ void access$400() {
        Checkout.destroyPreloadView();
    }
}

