/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.LinearInterpolator;

class CircularProgressView
extends View {
    private static final float INDETERMINANT_MIN_SWEEP = 15.0f;
    private Context context;
    private Paint paint;
    private int size = 0;
    private RectF bounds;
    private boolean isIndeterminate;
    private boolean autostartAnimation;
    private float currentProgress;
    private float maxProgress;
    private float indeterminateSweep;
    private float indeterminateRotateOffset;
    private int thickness;
    private int color;
    private int animDuration;
    private int animSwoopDuration;
    private int animSyncDuration;
    private int animSteps;
    private float startAngle;
    private float actualProgress;
    private ValueAnimator startAngleRotate;
    private ValueAnimator progressAnimator;
    private AnimatorSet indeterminateAnimator;
    private float initialStartAngle;

    public CircularProgressView(Context context) {
        super(context);
        this.init(null, 0, context);
    }

    public CircularProgressView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init(attributeSet, 0, context);
    }

    public CircularProgressView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.init(attributeSet, n, context);
    }

    protected void init(AttributeSet attributeSet, int n, Context context) {
        this.initAttributes(attributeSet, n, context);
        this.paint = new Paint(1);
        this.updatePaint();
        this.bounds = new RectF();
    }

    private void initAttributes(AttributeSet attributeSet, int n, Context context) {
        Resources resources = this.getResources();
        this.currentProgress = 0.0f;
        this.maxProgress = 100.0f;
        this.thickness = this.convertDPtoInt(context, 3);
        this.isIndeterminate = true;
        this.autostartAnimation = true;
        this.startAngle = this.initialStartAngle = -90.0f;
        this.color = Color.parseColor((String)"#4aa3df");
        this.animDuration = 4000;
        this.animSwoopDuration = 5000;
        this.animSyncDuration = 500;
        this.animSteps = 3;
    }

    protected void onMeasure(int n, int n2) {
        super.onMeasure(n, n2);
        int n3 = this.getPaddingLeft() + this.getPaddingRight();
        int n4 = this.getPaddingTop() + this.getPaddingBottom();
        int n5 = this.getMeasuredWidth() - n3;
        int n6 = this.getMeasuredHeight() - n4;
        this.size = n5 < n6 ? n5 : n6;
        this.setMeasuredDimension(this.size + n3, this.size + n4);
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        this.size = n < n2 ? n : n2;
        this.updateBounds();
    }

    private void updateBounds() {
        int n = this.getPaddingLeft();
        int n2 = this.getPaddingTop();
        this.bounds.set((float)(n + this.thickness), (float)(n2 + this.thickness), (float)(this.size - n - this.thickness), (float)(this.size - n2 - this.thickness));
    }

    private void updatePaint() {
        this.paint.setColor(this.color);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setStrokeWidth((float)this.thickness);
        this.paint.setStrokeCap(Paint.Cap.BUTT);
    }

    protected void onDraw(Canvas canvas) {
        float f;
        super.onDraw(canvas);
        float f2 = f = this.isInEditMode() ? this.currentProgress / this.maxProgress * 360.0f : this.actualProgress / this.maxProgress * 360.0f;
        if (!this.isIndeterminate) {
            canvas.drawArc(this.bounds, this.startAngle, f, false, this.paint);
        } else {
            canvas.drawArc(this.bounds, this.startAngle + this.indeterminateRotateOffset, this.indeterminateSweep, false, this.paint);
        }
    }

    public boolean isIndeterminate() {
        return this.isIndeterminate;
    }

    public void setIndeterminate(boolean bl) {
        boolean bl2 = this.isIndeterminate;
        boolean bl3 = this.isIndeterminate == bl;
        this.isIndeterminate = bl;
        if (bl3) {
            this.resetAnimation();
        }
    }

    public int getThickness() {
        return this.thickness;
    }

    public void setThickness(int n) {
        this.thickness = n;
        this.updatePaint();
        this.updateBounds();
        this.invalidate();
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int n) {
        this.color = n;
        this.updatePaint();
        this.invalidate();
    }

    public float getMaxProgress() {
        return this.maxProgress;
    }

    public void setMaxProgress(float f) {
        this.maxProgress = f;
        this.invalidate();
    }

    public float getProgress() {
        return this.currentProgress;
    }

    public void setProgress(float f) {
        this.currentProgress = f;
        if (!this.isIndeterminate) {
            if (this.progressAnimator != null && this.progressAnimator.isRunning()) {
                this.progressAnimator.cancel();
            }
            this.progressAnimator = ValueAnimator.ofFloat((float[])new float[]{this.actualProgress, f});
            this.progressAnimator.setDuration((long)this.animSyncDuration);
            this.progressAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
            this.progressAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator valueAnimator) {
                    CircularProgressView.this.actualProgress = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                    CircularProgressView.this.invalidate();
                }
            });
            this.progressAnimator.start();
        }
        this.invalidate();
    }

    public void startAnimation() {
        this.resetAnimation();
    }

    public void resetAnimation() {
        if (this.startAngleRotate != null && this.startAngleRotate.isRunning()) {
            this.startAngleRotate.cancel();
        }
        if (this.progressAnimator != null && this.progressAnimator.isRunning()) {
            this.progressAnimator.cancel();
        }
        if (this.indeterminateAnimator != null && this.indeterminateAnimator.isRunning()) {
            this.indeterminateAnimator.cancel();
        }
        if (!this.isIndeterminate) {
            this.startAngle = this.initialStartAngle;
            this.startAngleRotate = ValueAnimator.ofFloat((float[])new float[]{this.startAngle, this.startAngle + 360.0f});
            this.startAngleRotate.setDuration((long)this.animSwoopDuration);
            this.startAngleRotate.setInterpolator((TimeInterpolator)new DecelerateInterpolator(2.0f));
            this.startAngleRotate.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator valueAnimator) {
                    CircularProgressView.this.startAngle = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                    CircularProgressView.this.invalidate();
                }
            });
            this.startAngleRotate.start();
            this.actualProgress = 0.0f;
            this.progressAnimator = ValueAnimator.ofFloat((float[])new float[]{this.actualProgress, this.currentProgress});
            this.progressAnimator.setDuration((long)this.animSyncDuration);
            this.progressAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
            this.progressAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator valueAnimator) {
                    CircularProgressView.this.actualProgress = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                    CircularProgressView.this.invalidate();
                }
            });
            this.progressAnimator.start();
        } else {
            this.indeterminateSweep = 15.0f;
            this.indeterminateAnimator = new AnimatorSet();
            AnimatorSet animatorSet = null;
            for (int i = 0; i < this.animSteps; ++i) {
                AnimatorSet animatorSet2 = this.createIndeterminateAnimator(i);
                AnimatorSet.Builder builder = this.indeterminateAnimator.play((Animator)animatorSet2);
                if (animatorSet != null) {
                    builder.after((Animator)animatorSet);
                }
                animatorSet = animatorSet2;
            }
            this.indeterminateAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){
                boolean a = false;

                public void onAnimationCancel(Animator animator) {
                    this.a = true;
                }

                public void onAnimationEnd(Animator animator) {
                    if (!this.a) {
                        CircularProgressView.this.resetAnimation();
                    }
                }
            });
            this.indeterminateAnimator.start();
        }
    }

    public void stopAnimation() {
        if (this.startAngleRotate != null) {
            this.startAngleRotate.cancel();
            this.startAngleRotate = null;
        }
        if (this.progressAnimator != null) {
            this.progressAnimator.cancel();
            this.progressAnimator = null;
        }
        if (this.indeterminateAnimator != null) {
            this.indeterminateAnimator.cancel();
            this.indeterminateAnimator = null;
        }
    }

    private AnimatorSet createIndeterminateAnimator(float f) {
        final float f2 = 360.0f * (float)(this.animSteps - 1) / (float)this.animSteps + 15.0f;
        final float f3 = -90.0f + f * (f2 - 15.0f);
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{15.0f, f2});
        valueAnimator.setDuration((long)(this.animDuration / this.animSteps / 2));
        valueAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator(1.0f));
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                CircularProgressView.this.indeterminateSweep = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                CircularProgressView.this.invalidate();
            }
        });
        ValueAnimator valueAnimator2 = ValueAnimator.ofFloat((float[])new float[]{f * 720.0f / (float)this.animSteps, (f + 0.5f) * 720.0f / (float)this.animSteps});
        valueAnimator2.setDuration((long)(this.animDuration / this.animSteps / 2));
        valueAnimator2.setInterpolator((TimeInterpolator)new LinearInterpolator());
        valueAnimator2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                CircularProgressView.this.indeterminateRotateOffset = ((Float)valueAnimator.getAnimatedValue()).floatValue();
            }
        });
        ValueAnimator valueAnimator3 = ValueAnimator.ofFloat((float[])new float[]{f3, f3 + f2 - 15.0f});
        valueAnimator3.setDuration((long)(this.animDuration / this.animSteps / 2));
        valueAnimator3.setInterpolator((TimeInterpolator)new DecelerateInterpolator(1.0f));
        valueAnimator3.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                CircularProgressView.this.startAngle = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                CircularProgressView.this.indeterminateSweep = f2 - CircularProgressView.this.startAngle + f3;
                CircularProgressView.this.invalidate();
            }
        });
        ValueAnimator valueAnimator4 = ValueAnimator.ofFloat((float[])new float[]{(f + 0.5f) * 720.0f / (float)this.animSteps, (f + 1.0f) * 720.0f / (float)this.animSteps});
        valueAnimator4.setDuration((long)(this.animDuration / this.animSteps / 2));
        valueAnimator4.setInterpolator((TimeInterpolator)new LinearInterpolator());
        valueAnimator4.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                CircularProgressView.this.indeterminateRotateOffset = ((Float)valueAnimator.getAnimatedValue()).floatValue();
            }
        });
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.play((Animator)valueAnimator).with((Animator)valueAnimator2);
        animatorSet.play((Animator)valueAnimator3).with((Animator)valueAnimator4).after((Animator)valueAnimator2);
        return animatorSet;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.autostartAnimation) {
            this.startAnimation();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.stopAnimation();
    }

    public void setVisibility(int n) {
        int n2 = this.getVisibility();
        super.setVisibility(n);
        if (n != n2) {
            if (n == 0) {
                this.resetAnimation();
            } else if (n == 8 || n == 4) {
                this.stopAnimation();
            }
        }
    }

    private int convertDPtoInt(Context context, int n) {
        return (int)TypedValue.applyDimension((int)1, (float)n, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }
}

