/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.WallpaperManager;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.location.Location;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.net.http.SslCertificate;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.StatFs;
import android.os.SystemClock;
import android.provider.Settings;
import android.telephony.PhoneStateListener;
import android.telephony.SignalStrength;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Base64;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.webkit.CookieManager;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.widget.Toast;
import com.razorpay.AdvertisingIdUtil;
import com.razorpay.AnalyticsUtil;
import com.razorpay.B$$W$;
import com.razorpay.B_$q$;
import com.razorpay.BaseConfig;
import com.razorpay.CryptLib;
import com.razorpay.E$_j$;
import com.razorpay.NetworkType;
import com.razorpay.RzpJSONCallback;
import com.razorpay.b__J_;
import com.razorpay.h__y_;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import proguard.annotation.Keep;
import proguard.annotation.KeepClassMembers;

@Keep
@KeepClassMembers
class BaseUtils {
    private static String PERMISSION_DISABLED = "permission disabled";
    private static boolean sWebViewDebuggingEnabled = E$_j$.a;
    private static boolean isCompatibleWithGooglePay = true;
    static String ipAddress;

    BaseUtils() {
    }

    static String constructBasicAuth(String string2) {
        String string3 = string2;
        String string4 = string3 + ":";
        byte[] byArray = string4.getBytes("UTF-8");
        String string5 = Base64.encodeToString((byte[])byArray, (int)2);
        return string5;
    }

    static boolean hasPermission(Context context, String string2) {
        try {
            return 0 == context.checkCallingOrSelfPermission(string2);
        }
        catch (Exception exception) {
            AnalyticsUtil.reportError(exception, "critical", exception.getMessage());
            return false;
        }
    }

    static String getKeyId(Context context) {
        try {
            ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            if (applicationInfo.metaData == null) {
                return null;
            }
            String string2 = applicationInfo.metaData.getString("com.razorpay.ApiKey");
            B$$W$.b(string2);
            return string2;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            AnalyticsUtil.reportError((Exception)((Object)nameNotFoundException), "critical", nameNotFoundException.getMessage());
            return null;
        }
    }

    static HashMap<String, String> getAllPluginsFromManifest(Context context) {
        try {
            ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            if (applicationInfo.metaData == null) {
                return null;
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Set set = applicationInfo.metaData.keySet();
            for (String string2 : set) {
                if (!string2.contains("com.razorpay.plugin.") || applicationInfo.metaData.getString(string2) == null) continue;
                hashMap.put(string2, applicationInfo.metaData.getString(string2));
            }
            return hashMap;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            AnalyticsUtil.reportError((Exception)((Object)nameNotFoundException), "critical", nameNotFoundException.getMessage());
            return null;
        }
    }

    private static void setBaseWebViewSettings() {
        if (Build.VERSION.SDK_INT >= 19) {
            WebView.setWebContentsDebuggingEnabled((boolean)false);
        }
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private static void enableJavaScriptInWebView(WebView webView) {
        WebSettings webSettings = webView.getSettings();
        webSettings.setJavaScriptEnabled(true);
    }

    static void setWebViewSettings(Context context, WebView webView, boolean bl) {
        BaseUtils.setBaseWebViewSettings();
        BaseUtils.enableJavaScriptInWebView(webView);
        CookieManager.getInstance().setAcceptCookie(true);
        webView.setTag((Object)"");
        WebSettings webSettings = webView.getSettings();
        webSettings.setDomStorageEnabled(true);
        webSettings.setDatabaseEnabled(true);
        webSettings.setTextZoom(100);
        String string2 = context.getApplicationContext().getDir("database", 0).getPath();
        if (Build.VERSION.SDK_INT < 19) {
            webSettings.setDatabasePath(string2);
        }
        if (Build.VERSION.SDK_INT < 24) {
            webSettings.setGeolocationDatabasePath(string2);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            CookieManager cookieManager = CookieManager.getInstance();
            cookieManager.setAcceptThirdPartyCookies(webView, true);
        }
        if (bl) {
            webSettings.setCacheMode(2);
        }
        webSettings.setSaveFormData(false);
        webView.addJavascriptInterface((Object)new B_$q$(context), "StorageBridge");
    }

    static boolean hasFeature(Context context, String string2) {
        return context.getPackageManager().hasSystemFeature(string2);
    }

    static <T> T getSystemService(Context context, String string2) {
        return (T)context.getApplicationContext().getSystemService(string2);
    }

    static int getNetworkType(Context context) {
        NetworkType networkType = BaseUtils.getDataNetworkType(context);
        if (networkType == NetworkType.WIFI) {
            return 0;
        }
        if (networkType == NetworkType.BLUETOOTH) {
            return 1;
        }
        if (networkType == NetworkType.CELLULAR) {
            String string2 = BaseUtils.getCellularNetworkType(context);
            if (string2.equalsIgnoreCase("2G")) {
                return 2;
            }
            if (string2.equalsIgnoreCase("3G")) {
                return 3;
            }
            if (string2.equalsIgnoreCase("4G")) {
                return 4;
            }
        }
        return -1;
    }

    static String getCellularNetworkType(Context context) {
        try {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            int n = telephonyManager.getNetworkType();
            switch (n) {
                case 1: 
                case 2: 
                case 4: 
                case 7: 
                case 11: {
                    return "2G";
                }
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 14: 
                case 15: {
                    return "3G";
                }
                case 13: {
                    return "4G";
                }
            }
            return "NA";
        }
        catch (Exception exception) {
            AnalyticsUtil.reportError(exception, "warning", exception.getLocalizedMessage());
            return "NA";
        }
    }

    static String getCellularNetworkProviderName(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)BaseUtils.getSystemService(context, "phone");
        if (telephonyManager != null) {
            return telephonyManager.getNetworkOperatorName();
        }
        return "unknown";
    }

    static NetworkType getDataNetworkType(Context context) {
        ConnectivityManager connectivityManager;
        if (BaseUtils.hasPermission(context, "android.permission.ACCESS_NETWORK_STATE") && (connectivityManager = (ConnectivityManager)BaseUtils.getSystemService(context, "connectivity")) != null) {
            NetworkInfo networkInfo = connectivityManager.getNetworkInfo(1);
            if (networkInfo != null && networkInfo.isConnected()) {
                return NetworkType.WIFI;
            }
            NetworkInfo networkInfo2 = connectivityManager.getNetworkInfo(7);
            if (networkInfo2 != null && networkInfo2.isConnected()) {
                return NetworkType.BLUETOOTH;
            }
            NetworkInfo networkInfo3 = connectivityManager.getNetworkInfo(0);
            if (networkInfo3 != null && networkInfo3.isConnected()) {
                return NetworkType.CELLULAR;
            }
        }
        return NetworkType.UNKNOWN;
    }

    static String getLocale() {
        return Locale.getDefault().getLanguage() + "-" + Locale.getDefault().getCountry();
    }

    static ArrayList<String> jsonStringArrayToArrayList(JSONArray jSONArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < jSONArray.length(); ++i) {
            arrayList.add(jSONArray.getString(i));
        }
        return arrayList;
    }

    static String getAppBuildType(Context context) {
        if (0 != (context.getApplicationInfo().flags & 2)) {
            return "development";
        }
        return "production";
    }

    static CharSequence getWebViewUserAgent(Context context) {
        return AnalyticsUtil.returnUndefinedIfNull(new WebView(context).getSettings().getUserAgentString());
    }

    static boolean isDeviceHaveCorrectTlsVersion() {
        try {
            SSLParameters sSLParameters = SSLContext.getDefault().getDefaultSSLParameters();
            String[] stringArray = sSLParameters.getProtocols();
            if (stringArray == null) {
                return false;
            }
            for (String string2 : stringArray) {
                if (!string2.startsWith("TLS") || string2.equalsIgnoreCase("TLSv1")) continue;
                return true;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            AnalyticsUtil.reportError(noSuchAlgorithmException, "critical", noSuchAlgorithmException.getMessage());
        }
        return false;
    }

    static void setup() {
        AnalyticsUtil.reset();
    }

    public static double round(double d, int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        BigDecimal bigDecimal = new BigDecimal(d);
        bigDecimal = bigDecimal.setScale(n, RoundingMode.HALF_UP);
        return bigDecimal.doubleValue();
    }

    public static String nanoTimeToSecondsString(long l, int n) {
        double d = (double)l / 1.0E9;
        d = BaseUtils.round(d, n);
        return "" + d;
    }

    static boolean isMerchantAppDebuggable(Context context) {
        return 0 != (context.getApplicationInfo().flags & 2);
    }

    static Certificate getX509Certificate(SslCertificate sslCertificate) {
        Bundle bundle = SslCertificate.saveState((SslCertificate)sslCertificate);
        byte[] byArray = bundle.getByteArray("x509-certificate");
        if (byArray == null) {
            return null;
        }
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            return certificateFactory.generateCertificate(new ByteArrayInputStream(byArray));
        }
        catch (CertificateException certificateException) {
            AnalyticsUtil.reportError(certificateException, "critical", certificateException.getLocalizedMessage());
            return null;
        }
    }

    static String makeErrorPayload(String string2, String string3) {
        try {
            JSONObject jSONObject = new JSONObject();
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("code", (Object)string2);
            jSONObject2.put("description", (Object)string3);
            jSONObject.put("error", (Object)jSONObject2);
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            AnalyticsUtil.reportError((Exception)((Object)jSONException), "error:exception", jSONException.getMessage());
            jSONException.printStackTrace();
            return "{\"error\":{\"code\": \"BAD_REQUEST_ERROR\", \"description\": \"An unknown error occurred.\"}}";
        }
    }

    static PublicKey constructPublicKey(String string2) {
        try {
            byte[] byArray = Base64.decode((byte[])string2.getBytes(), (int)0);
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePublic(x509EncodedKeySpec);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Boolean isUserRegisteredOnTruePay(Context context) {
        try {
            int n = context.getPackageManager().getComponentEnabledSetting(new ComponentName("com.truecaller", "com.truecaller.truepay.UserRegistered"));
            return n == 1;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            AnalyticsUtil.reportError(exception, "error", exception.getMessage());
            return false;
        }
    }

    static boolean checkUpiRegisteredApp(Context context, String string2) {
        switch (string2) {
            case "com.google.android.apps.nbu.paisa.user": {
                return isCompatibleWithGooglePay;
            }
        }
        return true;
    }

    static HashSet<String> getSetOfPackageNamesSupportingUpi(Context context) {
        List<ResolveInfo> list = BaseUtils.getListOfAppsWhichHandleDeepLink(context, "upi://pay");
        HashSet<String> hashSet = new HashSet<String>();
        if (list != null && list.size() > 0) {
            for (ResolveInfo resolveInfo : list) {
                try {
                    hashSet.add(resolveInfo.activityInfo.packageName);
                }
                catch (Exception exception) {
                    AnalyticsUtil.reportError(exception, "critical", exception.getLocalizedMessage());
                }
            }
        }
        if (hashSet.size() > 0 && !BaseUtils.checkUpiRegisteredApp(context, "com.google.android.apps.nbu.paisa.user")) {
            hashSet.remove("com.google.android.apps.nbu.paisa.user");
        }
        if (hashSet.size() > 0 && !BaseUtils.checkUpiRegisteredApp(context, "com.truecaller")) {
            hashSet.remove("com.truecaller");
        }
        return hashSet;
    }

    static List<ResolveInfo> getListOfAppsWhichHandleDeepLink(Context context, String string2) {
        Intent intent = new Intent();
        intent.setData(Uri.parse((String)string2));
        return context.getPackageManager().queryIntentActivities(intent, 131072);
    }

    static String getAppNameOfResolveInfo(ResolveInfo resolveInfo, Context context) {
        return BaseUtils.getAppNameOfPackageName(resolveInfo.activityInfo.packageName, context);
    }

    static void startActivityForResult(String string2, String string3, Activity activity) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setData(Uri.parse((String)string2));
        if (string3 != null && string3.length() > 0) {
            intent.setPackage(string3);
        }
        if (string2.startsWith("credpay")) {
            activity.startActivityForResult(intent, 20);
        } else {
            activity.startActivityForResult(intent, 99);
        }
    }

    static JSONObject getJSONFromIntentData(Intent intent) {
        Bundle bundle;
        JSONObject jSONObject = new JSONObject();
        if (intent != null && (bundle = intent.getExtras()) != null) {
            Set set = bundle.keySet();
            for (String string2 : set) {
                try {
                    jSONObject.put(string2, bundle.get(string2));
                }
                catch (JSONException jSONException) {
                    AnalyticsUtil.reportError((Exception)((Object)jSONException), "error:exception", jSONException.getLocalizedMessage());
                }
            }
        }
        return jSONObject;
    }

    static String getBase64FromOtherAppsResource(Context context, String string2) {
        PackageManager packageManager = context.getPackageManager();
        try {
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(string2, 128);
            Resources resources = packageManager.getResourcesForApplication(applicationInfo);
            int n = applicationInfo.icon;
            return BaseUtils.getBase64FromResource(resources, n);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            AnalyticsUtil.reportError((Exception)((Object)nameNotFoundException), "critical", nameNotFoundException.getLocalizedMessage());
            nameNotFoundException.printStackTrace();
            return null;
        }
    }

    static String getAppNameOfPackageName(String string2, Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(string2, 128);
            int n = applicationInfo.labelRes;
            Resources resources = packageManager.getResourcesForApplication(applicationInfo);
            String string3 = n == 0 ? applicationInfo.nonLocalizedLabel.toString() : resources.getString(n);
            return string3;
        }
        catch (Exception exception) {
            AnalyticsUtil.reportError(exception, "error:exception", exception.getLocalizedMessage());
            exception.printStackTrace();
            throw exception;
        }
    }

    static String getBase64FromResource(Resources resources, int n) {
        ByteArrayOutputStream byteArrayOutputStream;
        Object object;
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)resources, (int)n);
        if (bitmap == null && (object = resources.getDrawable(n)) != null) {
            if (object instanceof BitmapDrawable) {
                bitmap = ((BitmapDrawable)object).getBitmap();
            } else {
                bitmap = Bitmap.createBitmap((int)object.getIntrinsicWidth(), (int)object.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                byteArrayOutputStream = new Canvas(bitmap);
                object.setBounds(0, 0, byteArrayOutputStream.getWidth(), byteArrayOutputStream.getHeight());
                object.draw((Canvas)byteArrayOutputStream);
            }
        }
        if (bitmap != null) {
            object = "data:image/png;base64,";
            byteArrayOutputStream = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            object = (String)object + Base64.encodeToString((byte[])byArray, (int)2);
            return object;
        }
        return null;
    }

    static Object getJsonValue(String string2, JSONObject jSONObject, Object object) {
        Object object2 = BaseUtils.getJsonValue(string2.split("\\."), (Object)jSONObject, 0);
        if (object2 != null) {
            return object2;
        }
        return object;
    }

    private static Object getJsonValue(String[] stringArray, Object object, int n) {
        if (n == stringArray.length) {
            return object;
        }
        String string2 = stringArray[n];
        if (object instanceof JSONObject) {
            JSONObject jSONObject = (JSONObject)object;
            return BaseUtils.getJsonValue(stringArray, jSONObject.opt(string2), n + 1);
        }
        if (object instanceof JSONArray) {
            JSONArray jSONArray = (JSONArray)object;
            if (TextUtils.isDigitsOnly((CharSequence)string2)) {
                int n2 = Integer.parseInt(string2);
                return BaseUtils.getJsonValue(stringArray, jSONArray.opt(n2), n + 1);
            }
        }
        return null;
    }

    static String getRandomString() {
        SecureRandom secureRandom = new SecureRandom();
        return new BigInteger(130, secureRandom).toString(32);
    }

    static String getFileFromInternal(Activity activity, String string2, String string3) {
        String string4;
        String string5 = BaseUtils.getLocalVersion(activity, string3).toString();
        string2 = BaseUtils.getVersionedAssetName(string5, string2);
        FileInputStream fileInputStream = activity.openFileInput(string2);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "UTF-8"));
        StringBuilder stringBuilder = new StringBuilder();
        while ((string4 = bufferedReader.readLine()) != null) {
            stringBuilder.append(string4);
        }
        bufferedReader.close();
        return BaseUtils.decryptFile(stringBuilder.toString());
    }

    static String decryptFile(String string2) {
        try {
            CryptLib cryptLib = new CryptLib();
            String string3 = "";
            String string4 = CryptLib.a("", 32);
            string3 = cryptLib.b(string2, string4, "");
            return string3;
        }
        catch (Exception exception) {
            AnalyticsUtil.reportError(exception, "error", "Unable to decrypt file");
            B$$W$.b("Unable to decrypt file, " + exception.getMessage());
            return null;
        }
    }

    static String getVersionedAssetName(String string2, String string3) {
        string2 = string2.replaceAll("\\.", "-");
        return string2 + "-" + string3;
    }

    static String getLocalVersion(Activity activity, String string2) {
        String string3 = h__y_.b((Context)activity, string2);
        if (string3 == null) {
            String string4 = "{\n  \"hash\" : \"\",\n  \"magic_hash\": \"\"\n}\n";
            string3 = BaseUtils.getVersionFromJsonString(string4, string2);
        }
        return string3;
    }

    static String getVersionFromJsonString(String string2, String string3) {
        try {
            JSONObject jSONObject = new JSONObject(string2);
            if (string3.equalsIgnoreCase("otpelf_version")) {
                return jSONObject.getString("hash");
            }
            if (string3.equalsIgnoreCase("magic_version")) {
                return jSONObject.getString("magic_hash");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static void updateLocalVersion(Activity activity, String string2, String string3) {
        h__y_.b((Context)activity, string2, string3);
    }

    static boolean storeFileInInternal(Activity activity, String string2, String string3) {
        try {
            FileOutputStream fileOutputStream = activity.openFileOutput(string2, 0);
            fileOutputStream.write(string3.getBytes());
            fileOutputStream.close();
            return true;
        }
        catch (Exception exception) {
            AnalyticsUtil.reportError(exception, "error", "Error in saving file: " + string2);
            B$$W$.c("Error in saving file: " + string2);
            return false;
        }
    }

    static void checkForLatestVersion(Context context, int n) {
        if (b__J_.a().isSDKUpdateAlertEnabled() && BaseUtils.isMerchantAppDebuggable(context) && n < b__J_.a().getLatestSDKVersionCode()) {
            String string2 = b__J_.a().getUpdateSDKMsg();
            Toast.makeText((Context)context, (CharSequence)string2, (int)1).show();
        }
    }

    static int dpToPixels(Context context, int n) {
        Resources resources = context.getResources();
        int n2 = (int)TypedValue.applyDimension((int)1, (float)n, (DisplayMetrics)resources.getDisplayMetrics());
        return n2;
    }

    static int getDisplayWidth(Context context) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        ((Activity)context).getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics.widthPixels;
    }

    static int getDisplayHeight(Context context) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        ((Activity)context).getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics.heightPixels;
    }

    static HashMap<String, String> getMapFromJSONObject(JSONObject jSONObject) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                String string3 = jSONObject.getString(string2);
                hashMap.put(string2, string3);
            }
        }
        catch (Exception exception) {
            AnalyticsUtil.reportError(exception, "error:exception", exception.getMessage());
            exception.printStackTrace();
        }
        return hashMap;
    }

    static void setCompatibleWithGooglePay(boolean bl) {
        isCompatibleWithGooglePay = bl;
    }

    static String makeUrlEncodedPayload(JSONObject jSONObject) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = jSONObject.getString(string2);
            stringBuilder.append(String.format("%s=%s&", string2, Uri.encode((String)string3)));
        }
        return stringBuilder.deleteCharAt(stringBuilder.length() - 1).toString();
    }

    static String installedApps(Context context) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            PackageManager packageManager = context.getPackageManager();
            List list = packageManager.getInstalledApplications(0);
            boolean bl = false;
            for (ApplicationInfo applicationInfo : list) {
                if ((applicationInfo.flags & 1) != 0) continue;
                if (stringBuilder.length() != 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(applicationInfo.packageName);
            }
            return stringBuilder.toString();
        }
        catch (Throwable throwable) {
            return "Apps not available";
        }
    }

    static String getAndroidId(Context context) {
        return Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
    }

    static String getDisplayResolution(Context context) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        return String.format(Locale.ENGLISH, "%dx%dx%d", displayMetrics.widthPixels, displayMetrics.heightPixels, displayMetrics.densityDpi);
    }

    String getDeviceUptime() {
        return String.valueOf(SystemClock.elapsedRealtime()) + "ms";
    }

    String getParentAppVersion(Context context) {
        try {
            return context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            AnalyticsUtil.reportError((Exception)((Object)nameNotFoundException), "error:exception", nameNotFoundException.getMessage());
            return "Permission Disabled";
        }
    }

    String getAvailableMemory(Context context) {
        ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        activityManager.getMemoryInfo(memoryInfo);
        return String.valueOf(memoryInfo.availMem / 0x100000L) + "MB";
    }

    String getTotalInternalStorage() {
        File file = Environment.getDataDirectory();
        StatFs statFs = new StatFs(file.getPath());
        long l = statFs.getBlockSizeLong();
        long l2 = statFs.getBlockCountLong();
        return String.valueOf(l2 * l);
    }

    String getBatteryLevel(Context context) {
        Intent intent = context.registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
        if (intent != null) {
            int n = intent.getIntExtra("level", -1);
            int n2 = intent.getIntExtra("scale", -1);
            return String.valueOf((float)n / (float)n2 * 100.0f);
        }
        return "Unknown";
    }

    String getAccounts(Context context) {
        if (context.checkCallingOrSelfPermission("android.permission.GET_ACCOUNTS") == 0) {
            StringBuilder stringBuilder = new StringBuilder();
            AccountManager accountManager = (AccountManager)context.getSystemService("account");
            for (Account account : accountManager.getAccounts()) {
                stringBuilder.append(account.name);
                stringBuilder.append(",");
            }
            return stringBuilder.toString();
        }
        return PERMISSION_DISABLED;
    }

    String getScreenOffTimeout(Context context) {
        String string2 = Settings.System.getString((ContentResolver)context.getContentResolver(), (String)"screen_off_timeout");
        return string2 + "ms";
    }

    String getScreenBrightnessMode(Context context) {
        return Settings.System.getString((ContentResolver)context.getContentResolver(), (String)"screen_brightness_mode");
    }

    String getScreenBrightness(Context context) {
        return Settings.System.getString((ContentResolver)context.getContentResolver(), (String)"screen_brightness");
    }

    String getWallpaperID(Context context) {
        if (Build.VERSION.SDK_INT >= 24) {
            WallpaperManager wallpaperManager = WallpaperManager.getInstance((Context)context);
            int n = wallpaperManager.getWallpaperId(1);
            int n2 = wallpaperManager.getWallpaperId(2);
            return String.format(Locale.ENGLISH, "%d-%d", n2, n);
        }
        return PERMISSION_DISABLED;
    }

    String getRingtoneHash(Context context) {
        Uri uri = RingtoneManager.getActualDefaultRingtoneUri((Context)context, (int)1);
        Ringtone ringtone = RingtoneManager.getRingtone((Context)context, (Uri)uri);
        return BaseUtils.MD5Hash(ringtone.getTitle(context));
    }

    public static String MD5Hash(String string2) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] byArray = messageDigest.digest(string2.getBytes());
            BigInteger bigInteger = new BigInteger(1, byArray);
            String string3 = bigInteger.toString(16);
            while (string3.length() < 32) {
                string3 = "0" + string3;
            }
            return string3;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
    }

    String getSystemFontSize(Context context) {
        return String.valueOf(context.getResources().getConfiguration().fontScale);
    }

    private boolean isMocked(Context context, Location location) {
        return location.isFromMockProvider();
    }

    static boolean isNetworkRoaming(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        if (telephonyManager != null) {
            return telephonyManager.isNetworkRoaming();
        }
        return false;
    }

    static String getCarrierOperatorName(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        if (telephonyManager != null) {
            return telephonyManager.getNetworkOperatorName();
        }
        return PERMISSION_DISABLED;
    }

    static Map<String, String> getDeviceAttributes(Context context) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (context.checkCallingOrSelfPermission("android.permission.READ_PHONE_STATE") == 0) {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            hashMap.put("device_id", BaseConfig.getAdvertisingId(context));
            if (Build.VERSION.SDK_INT <= 28) {
                hashMap.put("sim_serial_number", telephonyManager != null ? telephonyManager.getSimSerialNumber() : "null");
            } else {
                hashMap.put("sim_serial_number", PERMISSION_DISABLED);
                hashMap.put("build_unique_id", UUID.randomUUID().toString());
            }
        } else {
            hashMap.put("device_id", PERMISSION_DISABLED);
            hashMap.put("sim_serial_number", PERMISSION_DISABLED);
        }
        hashMap.put("device_manufacturer", Build.MANUFACTURER);
        hashMap.put("device_model", Build.MODEL);
        return hashMap;
    }

    static String getWifiSSID(Context context) {
        if (context.checkCallingOrSelfPermission("android.permission.ACCESS_WIFI_STATE") == 0) {
            WifiManager wifiManager = (WifiManager)context.getApplicationContext().getSystemService("wifi");
            WifiInfo wifiInfo = wifiManager.getConnectionInfo();
            return wifiInfo.getSSID();
        }
        return PERMISSION_DISABLED;
    }

    static String buildSerial() {
        return Build.SERIAL;
    }

    static void fetchIP(final RzpJSONCallback rzpJSONCallback) {
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    HttpURLConnection httpURLConnection = null;
                    try {
                        URL uRL = new URL("https://approvals-api.getsimpl.com/my-ip");
                        httpURLConnection = (HttpsURLConnection)uRL.openConnection();
                        httpURLConnection.setRequestMethod("GET");
                        httpURLConnection.setReadTimeout(150);
                        httpURLConnection.setConnectTimeout(250);
                        if (httpURLConnection.getResponseCode() == 200) {
                            JSONObject jSONObject = BaseUtils.getResponseJson((HttpsURLConnection)httpURLConnection);
                            rzpJSONCallback.onResponse(jSONObject);
                        } else {
                            rzpJSONCallback.onResponse(new JSONObject().put("error", (Object)"error"));
                        }
                    }
                    catch (SocketTimeoutException socketTimeoutException) {
                        rzpJSONCallback.onResponse(new JSONObject().put("error", (Object)"timeout"));
                    }
                    catch (Exception exception) {
                        AnalyticsUtil.reportError(exception, "warning", exception.getMessage());
                    }
                    finally {
                        if (httpURLConnection != null) {
                            httpURLConnection.disconnect();
                        }
                    }
                }
                catch (Exception exception) {
                    AnalyticsUtil.reportError(exception, "warning", exception.getMessage());
                }
            }
        });
        thread.start();
    }

    static void getDeviceParamValues(final Context context, final RzpJSONCallback rzpJSONCallback) {
        final JSONObject jSONObject = new JSONObject();
        try {
            BaseUtils.fetchIP(new RzpJSONCallback(){

                @Override
                public void onResponse(JSONObject jSONObject) {
                    try {
                        if (jSONObject.getString("ip") != null) {
                            ipAddress = jSONObject.getString("ip");
                        }
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                }
            });
            AdvertisingIdUtil.getId(context, new AdvertisingIdUtil.AdvertisingIdCallback(){

                @Override
                public void onResult(String string2) {
                    try {
                        jSONObject.put("advertising_id", (Object)string2);
                        jSONObject.put("is_roming", BaseUtils.isNetworkRoaming(context));
                        jSONObject.put("carrier_network", (Object)BaseUtils.getCarrierOperatorName(context));
                        jSONObject.put("carrier_id", (Object)"null");
                        Map<String, String> map = BaseUtils.getDeviceAttributes(context);
                        jSONObject.put("device_Id", (Object)map.get("device_Id"));
                        jSONObject.put("device_manufacturer", (Object)map.get("device_manufacturer"));
                        jSONObject.put("device_model", (Object)map.get("device_model"));
                        jSONObject.put("serial_number", (Object)BaseUtils.buildSerial());
                        jSONObject.put("ip_address", (Object)ipAddress);
                        jSONObject.put("wifi_ssid", (Object)BaseUtils.getWifiSSID(context));
                        jSONObject.put("android_id", (Object)BaseUtils.getAndroidId(context));
                        jSONObject.put("safety_net basic_integrity", (Object)"true");
                        jSONObject.put("safety_net_cts_profile_match", (Object)"null");
                        rzpJSONCallback.onResponse(jSONObject);
                    }
                    catch (JSONException jSONException) {
                        AnalyticsUtil.reportError((Exception)((Object)jSONException), "warning", jSONException.getMessage());
                    }
                }
            });
        }
        catch (Exception exception) {
            AnalyticsUtil.reportError(exception, "warning", exception.getMessage());
        }
    }

    static void getSignalStrength(Context context) {
        d__1_ d__1_2 = new d__1_();
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        assert (telephonyManager != null);
        telephonyManager.listen((PhoneStateListener)d__1_2, 256);
    }

    private static JSONObject getResponseJson(HttpsURLConnection httpsURLConnection) {
        String string2;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpsURLConnection.getInputStream()));
        StringBuilder stringBuilder = new StringBuilder();
        while ((string2 = bufferedReader.readLine()) != null) {
            stringBuilder.append(string2);
        }
        bufferedReader.close();
        return new JSONObject(stringBuilder.toString());
    }

    static String getPaymentCancelledResponse(String string2) {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("code", (Object)"BAD_REQUEST_ERROR");
            jSONObject.put("description", (Object)"Payment processing cancelled by user");
            jSONObject.put("source", (Object)"customer");
            jSONObject.put("step", (Object)"payment_authentication");
            jSONObject.put("reason", (Object)"payment_cancelled");
            if (string2 != null && !string2.isEmpty()) {
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put("payment_id", (Object)string2);
                jSONObject.put("metadata", (Object)jSONObject2);
            }
            return new JSONObject().put("error", (Object)jSONObject).toString();
        }
        catch (JSONException jSONException) {
            AnalyticsUtil.reportError((Exception)((Object)jSONException), "critical", jSONException.getLocalizedMessage());
            return null;
        }
    }

    public static class d__1_
    extends PhoneStateListener {
        public int a;

        public void onSignalStrengthsChanged(SignalStrength signalStrength) {
            super.onSignalStrengthsChanged(signalStrength);
            this.a = signalStrength.isGsm() ? (signalStrength.getGsmSignalStrength() != 99 ? signalStrength.getGsmSignalStrength() * 2 - 113 : signalStrength.getGsmSignalStrength()) : signalStrength.getCdmaDbm();
        }
    }
}

