/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.content.Context;
import android.content.ContextWrapper;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.util.Base64;
import android.util.Log;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;

public class AppSignatureHelper
extends ContextWrapper {
    public static final String TAG = AppSignatureHelper.class.getSimpleName();
    private static final String HASH_TYPE = "SHA-256";
    public static final int NUM_HASHED_BYTES = 9;
    public static final int NUM_BASE64_CHAR = 11;

    public AppSignatureHelper(Context context) {
        super(context);
    }

    public ArrayList<String> getAppSignatures() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Signature[] signatureArray;
            String string2 = this.getPackageName();
            PackageManager packageManager = this.getPackageManager();
            for (Signature signature : signatureArray = packageManager.getPackageInfo((String)string2, (int)64).signatures) {
                String string3 = AppSignatureHelper.hash(string2, signature.toCharsString());
                if (string3 == null) continue;
                arrayList.add(String.format("%s", string3));
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.e((String)TAG, (String)"Unable to find package to obtain hash.", (Throwable)nameNotFoundException);
        }
        return arrayList;
    }

    private static String hash(String string2, String string3) {
        String string4 = string2 + " " + string3;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(HASH_TYPE);
            messageDigest.update(string4.getBytes(StandardCharsets.UTF_8));
            byte[] byArray = messageDigest.digest();
            byArray = Arrays.copyOfRange(byArray, 0, 9);
            String string5 = Base64.encodeToString((byte[])byArray, (int)3);
            string5 = string5.substring(0, 11);
            Log.d((String)TAG, (String)String.format("pkg: %s -- hash: %s", string2, string5));
            return string5;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Log.e((String)TAG, (String)"hash:NoSuchAlgorithm", (Throwable)noSuchAlgorithmException);
            return null;
        }
    }
}

