/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.text.TextUtils;
import com.razorpay.AnalyticsEvent;
import com.razorpay.AnalyticsProperty;
import com.razorpay.B$$W$;
import com.razorpay.BaseUtils;
import com.razorpay.J$_0_;
import com.razorpay.b__J_;
import com.razorpay.g__v_;
import com.razorpay.r$_Y_;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;
import proguard.annotation.Keep;
import proguard.annotation.KeepClassMembers;

@Keep
@KeepClassMembers
class AnalyticsUtil {
    private static boolean isAnalyticsInitialized = false;
    static CharSequence MERCHANT_APP_NAME;
    static int MERCHANT_APP_BUILD;
    static CharSequence MERCHANT_APP_VERSION;
    static CharSequence MERCHANT_APP_NAMESPACE;
    static String KEY_TYPE;
    static String BUILD_TYPE;
    private static String localPaymentId;
    private static String localOrderId;
    private static String sdkType;
    private static int sdkVersionCode;
    private static String sdkVersion;
    static String libraryType;

    AnalyticsUtil() {
    }

    static void setup(Context context, String string, String string2, int n, String string3) {
        sdkType = string2;
        sdkVersionCode = n;
        sdkVersion = string3;
        AnalyticsUtil.setAppDetails(context, string);
        AnalyticsUtil.init(context, string);
    }

    private static void init(Context context, String string) {
        if (context == null) {
            throw new RuntimeException("Context not set");
        }
        if (string == null) {
            throw new RuntimeException("Merchant key not set");
        }
        r$_Y_.a(context, sdkType, sdkVersion);
        r$_Y_.b("merchant_key", (Object)string);
        r$_Y_.b("merchant_package", (Object)context.getPackageName());
        g__v_.a(context);
        isAnalyticsInitialized = true;
    }

    static String getBuildType() {
        return BUILD_TYPE;
    }

    static String getKeyType() {
        return KEY_TYPE;
    }

    static void trackEvent(AnalyticsEvent analyticsEvent) {
        r$_Y_.b(analyticsEvent.getEventName());
    }

    static void postData() {
        if (isAnalyticsInitialized) {
            r$_Y_.a();
        }
    }

    static void trackEvent(AnalyticsEvent analyticsEvent, Map<String, Object> map) {
        r$_Y_.a(analyticsEvent.getEventName(), map);
    }

    static void trackEvent(AnalyticsEvent analyticsEvent, JSONObject jSONObject) {
        r$_Y_.a(analyticsEvent.getEventName(), jSONObject);
    }

    static void addProperty(String string, AnalyticsProperty analyticsProperty) {
        if (analyticsProperty.scope == AnalyticsProperty.Scope.PAYMENT) {
            r$_Y_.a(string, analyticsProperty.value);
        } else if (analyticsProperty.scope == AnalyticsProperty.Scope.ORDER) {
            r$_Y_.b(string, analyticsProperty.value);
        }
    }

    static void addFilteredPropertiesFromPayload(JSONObject jSONObject) {
        r$_Y_.c(jSONObject);
    }

    static String getAppDetail() {
        if (isAnalyticsInitialized) {
            return MERCHANT_APP_NAME + "-" + MERCHANT_APP_VERSION + "-" + MERCHANT_APP_BUILD;
        }
        return null;
    }

    static void trackPage(String string, String string2) {
        r$_Y_.a(string, string2);
    }

    static void reportError(Exception exception, String string, String string2) {
        AnalyticsUtil.trackEvent(AnalyticsEvent.ERROR_LOGGED, AnalyticsUtil.getErrorProperties(string, string2));
        exception.printStackTrace();
    }

    static void reportError(AbstractMethodError abstractMethodError, String string, String string2) {
        AnalyticsUtil.trackEvent(AnalyticsEvent.ERROR_LOGGED, AnalyticsUtil.getErrorProperties(string, string2));
        abstractMethodError.printStackTrace();
    }

    static Map<String, Object> getErrorProperties(String string, String string2) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("error_level", string);
        hashMap.put("error_message", string2);
        return hashMap;
    }

    static JSONObject getAnalyticsDataForCheckout(Context context) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("platform", (Object)"mobile_sdk");
            jSONObject.put("platform_version", (Object)sdkVersion);
            jSONObject.put("os", (Object)"android");
            jSONObject.put("os_version", (Object)Build.VERSION.RELEASE);
            if (J$_0_.a(context)) {
                jSONObject.put("device", (Object)"tablet");
            } else {
                jSONObject.put("device", (Object)"mobile");
            }
        }
        catch (Exception exception) {
            AnalyticsUtil.reportError(exception, "critical", exception.getMessage());
        }
        return jSONObject;
    }

    static void trackPageLoadStart(String string) {
        AnalyticsEvent analyticsEvent = AnalyticsUtil.isCheckoutUrl(string) ? AnalyticsEvent.CHECKOUT_PAGE_LOAD_START : AnalyticsEvent.PAGE_LOAD_START;
        AnalyticsUtil.trackEvent(analyticsEvent, AnalyticsUtil.getPageLoadStartProperties(string));
    }

    static Map<String, Object> getPageLoadStartProperties(String string) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("url", string);
        return hashMap;
    }

    static void trackPageLoadEnd(String string, long l) {
        AnalyticsEvent analyticsEvent = AnalyticsUtil.isCheckoutUrl(string) ? AnalyticsEvent.CHECKOUT_PAGE_LOAD_FINISH : AnalyticsEvent.PAGE_LOAD_FINISH;
        AnalyticsUtil.trackEvent(analyticsEvent, AnalyticsUtil.getPageLoadEndProperties(string, l));
    }

    static boolean isCheckoutUrl(String string) {
        return string.indexOf(b__J_.a().getCheckoutEndpoint()) == 0;
    }

    static Map<String, Object> getPageLoadEndProperties(String string, long l) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("url", string);
        hashMap.put("page_load_time", (double)l / 1.0E9);
        return hashMap;
    }

    static void reset() {
        isAnalyticsInitialized = false;
        localPaymentId = null;
        localOrderId = null;
        r$_Y_.b();
    }

    static void setAppDetails(Context context, String string) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            MERCHANT_APP_NAME = AnalyticsUtil.returnUndefinedIfNull(packageInfo.applicationInfo.loadLabel(packageManager));
            MERCHANT_APP_VERSION = AnalyticsUtil.returnUndefinedIfNull(packageInfo.versionName);
            MERCHANT_APP_NAMESPACE = AnalyticsUtil.returnUndefinedIfNull(packageInfo.packageName);
            MERCHANT_APP_BUILD = packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            AnalyticsUtil.reportError((Exception)((Object)nameNotFoundException), "critical", nameNotFoundException.getMessage());
        }
        BUILD_TYPE = BaseUtils.getAppBuildType(context);
        KEY_TYPE = AnalyticsUtil.getKeyType(string);
    }

    static String getKeyType(String string) {
        if (AnalyticsUtil.isNullOrEmpty(string)) {
            return null;
        }
        String string2 = string.substring(0, 8);
        if (string2.equals("rzp_live")) {
            return "live";
        }
        if (string2.equals("rzp_test")) {
            return "test";
        }
        return null;
    }

    static boolean isNullOrEmpty(CharSequence charSequence) {
        return TextUtils.isEmpty((CharSequence)charSequence) || TextUtils.getTrimmedLength((CharSequence)charSequence) == 0;
    }

    static CharSequence returnUndefinedIfNull(CharSequence charSequence) {
        if (AnalyticsUtil.isNullOrEmpty(charSequence)) {
            return "undefined";
        }
        return charSequence;
    }

    static String getLocalPaymentId() {
        if (localPaymentId == null) {
            localPaymentId = AnalyticsUtil.getUniqueId();
        }
        return localPaymentId;
    }

    static String getLocalOrderId() {
        if (localOrderId == null) {
            localOrderId = AnalyticsUtil.getUniqueId();
        }
        return localOrderId;
    }

    static void refreshPaymentSession() {
        localPaymentId = AnalyticsUtil.getUniqueId();
        r$_Y_.c();
    }

    static void refreshOrderSession() {
        localOrderId = AnalyticsUtil.getUniqueId();
        localPaymentId = AnalyticsUtil.getUniqueId();
        r$_Y_.d();
        r$_Y_.c();
    }

    static void setLocalOrderId(String string) {
        localOrderId = string;
    }

    static String getUniqueId() {
        long l = (System.currentTimeMillis() - 1388534400000L) * 1000000L;
        long l2 = (long)Math.floor(1.4776336E7 * Math.random());
        return AnalyticsUtil.tobase62(l) + AnalyticsUtil.tobase62(l2);
    }

    static String tobase62(long l) {
        String[] stringArray = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".split("");
        String string = "";
        while (l > 0L) {
            int n = (int)(l % 62L);
            string = String.valueOf(stringArray[n]) + string;
            l = (long)Math.floor(l / 62L);
        }
        return string;
    }

    static void reportUncaughtException(Throwable throwable) {
        String string = AnalyticsUtil.getStackTrace(throwable);
        B$$W$.b(string);
        AnalyticsUtil.trackEvent(AnalyticsEvent.ERROR_LOGGED, AnalyticsUtil.getErrorProperties("uncaught", string));
    }

    static String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        throwable.printStackTrace(printWriter);
        return stringWriter.getBuffer().toString();
    }

    public static void saveEventsToPreferences(Context context) {
        r$_Y_.b(context);
    }

    public static JSONObject getExtraAnalyticsPayload() {
        return r$_Y_.e();
    }

    static {
        sdkType = "standealone";
    }
}

