/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.AsyncTask;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.razorpay.AnalyticsUtil;
import java.util.concurrent.LinkedBlockingQueue;

public class AdvertisingIdUtil {
    static void getId(Context context, AdvertisingIdCallback callback) {
        new AdvertisingIdAsyncTask(context, callback).execute(new Void[0]);
    }

    private static final class AdvertisingInterface
    implements IInterface {
        private IBinder binder;

        AdvertisingInterface(IBinder pBinder) {
            this.binder = pBinder;
        }

        public IBinder asBinder() {
            return this.binder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getId() throws RemoteException {
            String id2;
            Parcel data = Parcel.obtain();
            Parcel reply = Parcel.obtain();
            try {
                data.writeInterfaceToken("com.google.android.gms.ads.identifier.internal.IAdvertisingIdService");
                this.binder.transact(1, data, reply, 0);
                reply.readException();
                id2 = reply.readString();
            }
            finally {
                reply.recycle();
                data.recycle();
            }
            return id2;
        }
    }

    private static final class AdvertisingConnection
    implements ServiceConnection {
        boolean retrieved = false;
        private final LinkedBlockingQueue<IBinder> queue = new LinkedBlockingQueue(1);

        private AdvertisingConnection() {
        }

        public void onServiceConnected(ComponentName name, IBinder service) {
            try {
                this.queue.put(service);
            }
            catch (Exception e) {
                AnalyticsUtil.reportError(e, "error", e.getMessage());
            }
        }

        public void onServiceDisconnected(ComponentName name) {
        }

        IBinder getBinder() throws InterruptedException {
            if (!this.retrieved) {
                this.retrieved = true;
            }
            return this.queue.take();
        }
    }

    private static class AdvertisingIdAsyncTask
    extends AsyncTask<Void, Void, String> {
        private AdvertisingIdCallback callback;
        @SuppressLint(value={"StaticFieldLeak"})
        private Context context;

        AdvertisingIdAsyncTask(Context context, AdvertisingIdCallback callback) {
            this.context = context;
            this.callback = callback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected String doInBackground(Void ... voids) {
            AdvertisingConnection connection = new AdvertisingConnection();
            Intent intent = new Intent("com.google.android.gms.ads.identifier.service.START");
            intent.setPackage("com.google.android.gms");
            if (this.context.bindService(intent, (ServiceConnection)connection, 1)) {
                try {
                    AdvertisingInterface adInterface = new AdvertisingInterface(connection.getBinder());
                    String string2 = adInterface.getId();
                    return string2;
                }
                catch (Exception exception) {
                    String string3 = exception.getMessage();
                    return string3;
                }
                finally {
                    this.context.unbindService((ServiceConnection)connection);
                }
            }
            return "permission disabled";
        }

        protected void onPostExecute(String s) {
            super.onPostExecute((Object)s);
            this.callback.onResult(s);
        }
    }

    static interface AdvertisingIdCallback {
        public void onResult(String var1);
    }
}

