/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.android;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import com.rollbar.android.RollbarExceptionHandler;
import com.rollbar.android.RollbarThread;
import com.rollbar.android.http.HttpRequestManager;
import com.rollbar.android.http.HttpResponse;
import com.rollbar.android.http.HttpResponseHandler;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Notifier {
    private static int \u0971 = 0;
    private volatile boolean \u02ce;
    private ScheduledExecutorService \u02cb = Executors.newSingleThreadScheduledExecutor();
    private String \u02ca;
    private String \u02cf;
    private JSONObject \u141d;
    private String \u02bb;
    private boolean \u02bd;
    private boolean \u02bc;
    private String \u02ca\u0971;
    private String \u02cb\u0971;
    private boolean \u02cf\u0971;
    private int \u037a;
    private String \u0971\u02ca;
    private File \u0971\u02cb;
    private RollbarThread \u1fbe;

    public Notifier(Context object, String string2, String string3, boolean bl) {
        this.\u02ca = string2;
        this.\u02cf = string3;
        try {
            string2 = object.getPackageName();
            string2 = object.getPackageManager().getPackageInfo(string2, 0);
            this.\u037a = ((PackageInfo)string2).versionCode;
            this.\u0971\u02ca = ((PackageInfo)string2).versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.e((String)"Rollbar", (String)"Error getting package info.");
        }
        this.\u02bb = "https://api.rollbar.com/api/1/items/";
        this.\u02bd = true;
        this.\u02ca\u0971 = "warning";
        this.\u02cb\u0971 = "error";
        this.\u02cf\u0971 = false;
        this.\u02ce = false;
        this.\u0971\u02cb = new File(object.getCacheDir(), "rollbar-items");
        this.\u0971\u02cb.mkdirs();
        if (bl) {
            RollbarExceptionHandler.register(this);
        }
        this.\u1fbe = new RollbarThread(this);
        this.\u1fbe.start();
        object = this;
        if (!object.\u02ce) {
            object.\u02ce = true;
            Log.d((String)"Rollbar", (String)"Scheheduling item file handler...");
            object.\u02cb.schedule(new Runnable((Notifier)object){
                private /* synthetic */ Notifier \u02ca;
                {
                    this.\u02ca = notifier;
                }

                @Override
                public final void run() {
                    Log.d((String)"Rollbar", (String)"Item file handler running...");
                    for (File file : this.\u02ca.\u0971\u02cb.listFiles()) {
                        JSONArray jSONArray = Notifier.\u02ca(file);
                        this.\u02ca.postItems(jSONArray, file);
                    }
                    Notifier.\u02ce(this.\u02ca);
                    Log.d((String)"Rollbar", (String)"Item file handler finished.");
                }
            }, 1L, TimeUnit.SECONDS);
        }
    }

    private static JSONArray \u02ca() {
        JSONArray jSONArray = null;
        int n = android.os.Process.myPid();
        try {
            String string2;
            Object object = Runtime.getRuntime().exec("logcat -d");
            object = new InputStreamReader(((Process)object).getInputStream());
            object = new BufferedReader((Reader)object, 8192);
            ArrayList<String> arrayList = new ArrayList<String>();
            while ((string2 = ((BufferedReader)object).readLine()) != null) {
                if (!string2.contains(String.valueOf(n))) continue;
                arrayList.add(string2);
                if (arrayList.size() <= 100) continue;
                arrayList.remove(0);
            }
            jSONArray = new JSONArray(arrayList);
        }
        catch (IOException iOException) {
            Log.e((String)"Rollbar", (String)"Unable to collect logcat info.", (Throwable)iOException);
        }
        return jSONArray;
    }

    private JSONObject \u02cb(String object, JSONObject jSONObject) throws JSONException {
        JSONObject jSONObject2 = new JSONObject();
        jSONObject2.put("environment", (Object)this.\u02cf);
        jSONObject2.put("level", object);
        jSONObject2.put("platform", (Object)"android");
        jSONObject2.put("framework", (Object)"android");
        jSONObject2.put("language", (Object)"java");
        jSONObject2.put("body", (Object)jSONObject);
        if (this.\u141d != null) {
            jSONObject2.put("person", (Object)this.\u141d);
        }
        object = this;
        jSONObject = new JSONObject();
        jSONObject.put("timestamp", System.currentTimeMillis() / 1000L);
        JSONObject jSONObject3 = new JSONObject();
        jSONObject3.put("phone_model", (Object)Build.MODEL);
        jSONObject3.put("android_version", (Object)Build.VERSION.RELEASE);
        jSONObject3.put("code_version", (Object)((Notifier)object).\u0971\u02ca);
        jSONObject3.put("version_code", ((Notifier)object).\u037a);
        jSONObject3.put("version_name", (Object)((Notifier)object).\u0971\u02ca);
        if (((Notifier)object).\u02bc) {
            jSONObject3.put("logs", (Object)Notifier.\u02ca());
        }
        jSONObject.put("android", (Object)jSONObject3);
        jSONObject.put("user_ip", (Object)"$remote_ip");
        jSONObject2.put("client", (Object)jSONObject);
        jSONObject = new JSONObject();
        jSONObject.put("name", (Object)"rollbar-android");
        jSONObject.put("version", (Object)"0.1.2");
        jSONObject2.put("notifier", (Object)jSONObject);
        return jSONObject2;
    }

    private static JSONArray \u02ca(File file) {
        Log.d((String)"Rollbar", (String)"Loading items...");
        JSONArray jSONArray = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            StringBuilder stringBuilder = new StringBuilder();
            byte[] byArray = new byte[1024];
            while (fileInputStream.read(byArray) != -1) {
                stringBuilder.append(new String(byArray));
            }
            fileInputStream.close();
            jSONArray = new JSONArray(stringBuilder.toString());
            Log.d((String)"Rollbar", (String)"Items loaded.");
        }
        catch (FileNotFoundException fileNotFoundException) {
            Log.e((String)"Rollbar", (String)"Unable to read item file.", (Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            Log.e((String)"Rollbar", (String)"Unable to read item file.", (Throwable)iOException);
        }
        catch (JSONException jSONException) {
            Log.e((String)"Rollbar", (String)"Invalid item data. Deleting file.", (Throwable)jSONException);
            file.delete();
        }
        return jSONArray;
    }

    public File writeItems(JSONArray jSONArray) {
        Log.d((String)"Rollbar", (String)"Writing items...");
        try {
            Object object = \u0971++ + "." + System.currentTimeMillis();
            object = new File(this.\u0971\u02cb, (String)object);
            FileWriter fileWriter = new FileWriter((File)object);
            fileWriter.write(jSONArray.toString());
            fileWriter.close();
            Log.d((String)"Rollbar", (String)"Items written");
            return object;
        }
        catch (IOException iOException) {
            Log.e((String)"Rollbar", (String)"Unable to write items.", (Throwable)iOException);
            return null;
        }
    }

    public void postItems(JSONArray jSONArray, File file) {
        Notifier notifier;
        Log.i((String)"Rollbar", (String)"Sending item batch...");
        try {
            JSONArray jSONArray2 = jSONArray;
            notifier = this;
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("access_token", (Object)notifier.\u02ca);
            jSONObject.put("data", (Object)jSONArray2);
            notifier = jSONObject;
        }
        catch (JSONException jSONException) {
            Log.e((String)"Rollbar", (String)"There was an error constructing the JSON payload.", (Throwable)jSONException);
            return;
        }
        HttpRequestManager.getInstance().postJson(this.\u02bb, (JSONObject)notifier, false, new HttpResponseHandler(this, file, jSONArray){
            private /* synthetic */ File \u02ca;
            private /* synthetic */ JSONArray \u02cb;
            private /* synthetic */ Notifier \u02ce;
            {
                this.\u02ce = notifier;
                this.\u02ca = file;
                this.\u02cb = jSONArray;
            }

            @Override
            public final void onSuccess(HttpResponse httpResponse) {
                Log.i((String)"Rollbar", (String)"Success");
                if (this.\u02ca != null) {
                    this.\u02ca.delete();
                }
            }

            @Override
            public final void onFailure(HttpResponse httpResponse) {
                Log.e((String)"Rollbar", (String)"There was a problem reporting to Rollbar.");
                Log.e((String)"Rollbar", (String)("Response: " + httpResponse));
                if (this.\u02ca == null) {
                    if (!httpResponse.hasStatusCode()) {
                        this.\u02ce.writeItems(this.\u02cb);
                        return;
                    }
                } else if (httpResponse.hasStatusCode()) {
                    this.\u02ca.delete();
                }
            }
        });
    }

    private static JSONObject \u02cf(Throwable throwable, String string2) throws JSONException {
        ByteArrayOutputStream byteArrayOutputStream;
        Object object;
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        for (int i = stackTraceElementArray.length - 1; i >= 0; --i) {
            object = stackTraceElementArray[i];
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("class_name", (Object)((StackTraceElement)object).getClassName());
            jSONObject2.put("filename", (Object)((StackTraceElement)object).getFileName());
            jSONObject2.put("method", (Object)((StackTraceElement)object).getMethodName());
            if (((StackTraceElement)object).getLineNumber() > 0) {
                jSONObject2.put("lineno", ((StackTraceElement)object).getLineNumber());
            }
            jSONArray.put((Object)jSONObject2);
        }
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            object = new PrintStream(byteArrayOutputStream);
            throwable.printStackTrace((PrintStream)object);
            ((PrintStream)object).close();
            byteArrayOutputStream.close();
            jSONObject.put("raw", (Object)byteArrayOutputStream.toString("UTF-8"));
        }
        catch (Exception exception) {
            Log.e((String)"Rollbar", (String)"Exception printing stack trace.", (Throwable)exception);
        }
        byteArrayOutputStream = new JSONObject();
        byteArrayOutputStream.put("class", throwable.getClass().getName());
        byteArrayOutputStream.put("message", throwable.getMessage());
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            byteArrayOutputStream.put("description", string2);
        }
        jSONObject.put("frames", (Object)jSONArray);
        jSONObject.put("exception", (Object)byteArrayOutputStream);
        return jSONObject;
    }

    public void uncaughtException(Throwable throwable) {
        if (this.\u02bd) {
            Log.d((String)"Rollbar", (String)"Handling uncaught exception...");
            this.\u1fbe.interrupt();
            throwable = this.\u02cb(throwable, this.\u02cb\u0971, null);
            if (throwable != null) {
                JSONArray jSONArray = new JSONArray();
                jSONArray.put((Object)throwable);
                if (this.\u02cf\u0971) {
                    this.postItems(jSONArray, null);
                } else {
                    this.writeItems(jSONArray);
                }
            }
            try {
                this.\u1fbe.join();
                return;
            }
            catch (InterruptedException interruptedException) {
                Log.d((String)"Rollbar", (String)"Couldn't join rollbar thread", (Throwable)interruptedException);
            }
        }
    }

    private JSONObject \u02cb(Throwable throwable, String string2, String string3) {
        try {
            JSONObject jSONObject = new JSONObject();
            ArrayList<JSONObject> arrayList = new ArrayList<JSONObject>();
            do {
                arrayList.add(0, Notifier.\u02cf(throwable, string3));
            } while ((throwable = throwable.getCause()) != null);
            jSONObject.put("trace_chain", (Object)new JSONArray(arrayList));
            if (string2 == null) {
                string2 = this.\u02ca\u0971;
            }
            return this.\u02cb(string2, jSONObject);
        }
        catch (JSONException jSONException) {
            Log.e((String)"Rollbar", (String)"There was an error constructing the JSON payload.", (Throwable)jSONException);
            return null;
        }
    }

    private JSONObject \u02ce(String string2, String string3) {
        try {
            JSONObject jSONObject = new JSONObject();
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("body", (Object)string2);
            jSONObject.put("message", (Object)jSONObject2);
            return this.\u02cb(string3, jSONObject);
        }
        catch (JSONException jSONException) {
            Log.e((String)"Rollbar", (String)"There was an error constructing the JSON payload.", (Throwable)jSONException);
            return null;
        }
    }

    private JSONObject \u02ca(String object, String string2, Map<String, String> map) {
        try {
            JSONObject jSONObject = new JSONObject();
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("body", object);
            jSONObject.put("message", (Object)jSONObject2);
            for (String string3 : map.keySet()) {
                jSONObject2.put(string3, (Object)map.get(string3));
            }
            return this.\u02cb(string2, jSONObject);
        }
        catch (JSONException jSONException) {
            Log.e((String)"Rollbar", (String)"There was an error constructing the JSON payload.", (Throwable)jSONException);
            return null;
        }
    }

    public void reportException(Throwable throwable, String string2, String string3) {
        if ((throwable = this.\u02cb(throwable, string2, string3)) != null) {
            this.\u1fbe.queueItem((JSONObject)throwable);
        }
    }

    public void reportMessage(String string2, String string3) {
        if ((string2 = this.\u02ce(string2, string3)) != null) {
            this.\u1fbe.queueItem((JSONObject)string2);
        }
    }

    public void reportMessage(String string2, String string3, Map<String, String> map) {
        if ((string2 = this.\u02ca(string2, string3, map)) != null) {
            this.\u1fbe.queueItem((JSONObject)string2);
        }
    }

    public void setPersonData(JSONObject jSONObject) {
        this.\u141d = jSONObject;
    }

    public void setPersonData(String string2, String string3, String string4) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("id", (Object)string2);
            if (string3 != null) {
                jSONObject.put("username", (Object)string3);
            }
            if (string4 != null) {
                jSONObject.put("email", (Object)string4);
            }
            this.\u141d = jSONObject;
            return;
        }
        catch (JSONException jSONException) {
            Log.e((String)"Rollbar", (String)"JSON error creating person data.", (Throwable)jSONException);
            return;
        }
    }

    public void setEndpoint(String string2) {
        this.\u02bb = string2;
    }

    public void setReportUncaughtExceptions(boolean bl) {
        this.\u02bd = bl;
    }

    public void setIncludeLogcat(boolean bl) {
        this.\u02bc = bl;
    }

    public void setDefaultCaughtExceptionLevel(String string2) {
        this.\u02ca\u0971 = string2;
    }

    public void setUncaughtExceptionLevel(String string2) {
        this.\u02cb\u0971 = string2;
    }

    public void setSendOnUncaughtException(boolean bl) {
        this.\u02cf\u0971 = bl;
    }

    static /* synthetic */ boolean \u02ce(Notifier notifier) {
        notifier.\u02ce = false;
        return false;
    }
}

