/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.net;

import com.rapid7.net.Utils;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class InsightOpsClient {
    private static final int IOPS_PORT = 80;
    private static final int IOPS_SSL_PORT = 443;
    final SSLSocketFactory ssl_factory;
    private boolean ssl_choice;
    private boolean http_choice = false;
    private Socket socket;
    private OutputStream stream;
    private int port;
    private String dataEndpoint;

    public InsightOpsClient(boolean httpPut, boolean ssl, boolean isUsingDataHub, String server, int port, String region) {
        if (isUsingDataHub) {
            this.ssl_factory = null;
            this.ssl_choice = false;
        } else {
            this.ssl_factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            this.ssl_choice = ssl;
            this.http_choice = httpPut;
        }
        this.setPort(port, ssl);
        this.setAddress(server, region);
    }

    private void setPort(int port, boolean ssl_choice) {
        this.port = port > 0 ? port : (ssl_choice ? 443 : 80);
    }

    private void setAddress(String server, String region) {
        this.dataEndpoint = Utils.isNullOrEmpty(server) ? String.format("%s.data.logs.insight.rapid7.com", region) : server;
    }

    public int getPort() {
        return this.port;
    }

    public String getAddress() {
        return this.dataEndpoint;
    }

    public void connect() throws IOException {
        if (this.ssl_choice) {
            if (this.http_choice) {
                SSLSocket s = (SSLSocket)this.ssl_factory.createSocket(this.getAddress(), this.getPort());
                s.setTcpNoDelay(true);
                s.startHandshake();
                this.socket = s;
            } else {
                this.socket = SSLSocketFactory.getDefault().createSocket(this.getAddress(), this.getPort());
            }
        } else {
            this.socket = new Socket(this.getAddress(), this.getPort());
        }
        this.stream = this.socket.getOutputStream();
    }

    public void write(byte[] buffer, int offset, int length) throws IOException {
        if (this.stream == null) {
            throw new IOException();
        }
        this.stream.write(buffer, offset, length);
        this.stream.flush();
    }

    public void close() {
        try {
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

