/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.log4j2;

import com.rapid7.log4j2.LogentriesManager;
import com.rapid7.net.LoggerConfiguration;
import java.io.Serializable;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;

@Plugin(name="Logentries", category="Core", elementType="appender", printObject=true)
public final class LogentriesAppender
extends AbstractAppender {
    private final LogentriesManager manager;

    protected LogentriesAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions, LogentriesManager manager) {
        super(name, filter, layout, ignoreExceptions);
        this.manager = manager;
    }

    @PluginFactory
    public static LogentriesAppender createAppender(@PluginAttribute(value="name") String name, @PluginAttribute(value="token") String token, @PluginAttribute(value="region") String region, @PluginAttribute(value="key") String key, @PluginAttribute(value="location") String location, @PluginAttribute(value="httpPut") boolean httpPut, @PluginAttribute(value="useSsl") boolean ssl, @PluginAttribute(value="debug") boolean debug, @PluginAttribute(value="useDataHub") boolean useDataHub, @PluginAttribute(value="dataHubAddr") String dataHubAddr, @PluginAttribute(value="dataHubPort") int dataHubPort, @PluginAttribute(value="logHostName") boolean logHostName, @PluginAttribute(value="hostName") String hostName, @PluginAttribute(value="logID") String logID, @PluginAttribute(value="ignoreExceptions") boolean ignoreExceptions, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginElement(value="Filters") Filter filter) {
        if (name == null) {
            LOGGER.error("No name provided for LogentriesAppender");
            return null;
        }
        if (token == null) {
            LOGGER.error("No token provided for LogentriesAppender");
            return null;
        }
        if (region == null) {
            LOGGER.error("No region provided for LogentriesAppender");
            return null;
        }
        LoggerConfiguration data = new LoggerConfiguration.Builder().inRegion(region).toServerAddress(dataHubAddr).toServerPort(dataHubPort).useToken(token).useDataHub(useDataHub).useHttpPut(httpPut).useAccountKey(key).httpPutLocation(location).runInDebugMode(debug).logHostNameAsPrefix(logHostName).useAsHostName(hostName).setLogIdPrefix(logID).useSSL(ssl).build();
        LogentriesManager manager = LogentriesManager.getManager(name, data);
        if (manager == null) {
            return null;
        }
        if (layout == null) {
            layout = PatternLayout.createDefaultLayout();
        }
        return new LogentriesAppender(name, filter, (Layout<? extends Serializable>)layout, ignoreExceptions, manager);
    }

    public void append(LogEvent event) {
        Layout layout = this.getLayout();
        String line = new String(layout.toByteArray(event));
        this.manager.writeLine(line);
    }
}

