/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.jul;

import com.rapid7.net.AsyncLogger;
import com.rapid7.net.LoggerConfiguration;
import java.text.MessageFormat;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

public class LogentriesHandler
extends Handler {
    final AsyncLogger iopsAsync;

    public LogentriesHandler() {
        this(null);
    }

    public LogentriesHandler(String prefix) {
        this.iopsAsync = new AsyncLogger(this.loadConfiguration(prefix));
    }

    private LoggerConfiguration loadConfiguration(String prefix) {
        String cname = this.getClass().getName();
        String propsPrefix = prefix == null ? cname : prefix + "." + cname;
        this.setLevel(this.getLevelProperty(propsPrefix + ".level", Level.INFO));
        this.setFormatter(this.getFormatterProperty(propsPrefix + ".formatter", new SimpleFormatter()));
        return new LoggerConfiguration.Builder().inRegion(this.getStringProperty(propsPrefix + ".region", "")).toServerAddress(this.getStringProperty(propsPrefix + ".host", null)).toServerPort(this.getIntProperty(propsPrefix + ".port", 0)).useToken(this.getStringProperty(propsPrefix + ".token", "")).useDataHub(this.getBooleanProperty(propsPrefix + ".useDataHub", false)).useHttpPut(this.getBooleanProperty(propsPrefix + ".httpPut", false)).useAccountKey(this.getStringProperty(propsPrefix + ".key", "")).httpPutLocation(this.getStringProperty(propsPrefix + ".location", "")).runInDebugMode(this.getBooleanProperty(propsPrefix + ".debug", false)).logHostNameAsPrefix(this.getBooleanProperty(propsPrefix + ".logHostName", false)).useAsHostName(this.getStringProperty(propsPrefix + ".hostNameToLog", "")).setLogIdPrefix(this.getStringProperty(propsPrefix + ".logId", "")).useSSL(this.getBooleanProperty(propsPrefix + ".ssl", true)).build();
    }

    @Override
    public synchronized void publish(LogRecord record) {
        if (this.isLoggable(record)) {
            this.iopsAsync.addLineToQueue(this.formatMessage(record));
        }
    }

    String formatMessage(LogRecord record) {
        String msg = "";
        try {
            msg = this.getFormatter().format(record);
            msg = msg.replace(System.getProperty("line.separator"), "\u2028");
        }
        catch (Exception e) {
            this.reportError("Error while formatting.", e, 5);
        }
        return msg;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        this.iopsAsync.close();
    }

    Level getLevelProperty(String name, Level defaultValue) {
        LogManager manager = LogManager.getLogManager();
        String val = manager.getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        Level l = Level.parse(val.trim());
        return l != null ? l : defaultValue;
    }

    Formatter getFormatterProperty(String name, Formatter defaultValue) {
        LogManager manager = LogManager.getLogManager();
        String val = manager.getProperty(name);
        try {
            if (val != null) {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                Class<?> clz = cl.loadClass(val);
                return (Formatter)clz.newInstance();
            }
        }
        catch (ClassNotFoundException e) {
            this.reportError(MessageFormat.format("Error reading property ''{0}''", name), e, 0);
        }
        catch (InstantiationException e) {
            this.reportError(MessageFormat.format("Error reading property ''{0}''", name), e, 0);
        }
        catch (IllegalAccessException e) {
            this.reportError(MessageFormat.format("Error reading property ''{0}''", name), e, 0);
        }
        return defaultValue;
    }

    String getStringProperty(String name, String defaultValue) {
        LogManager manager = LogManager.getLogManager();
        String val = manager.getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        return val.trim();
    }

    boolean getBooleanProperty(String name, boolean defaultValue) {
        LogManager manager = LogManager.getLogManager();
        String val = manager.getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        if ("false".equalsIgnoreCase(val.trim())) {
            return false;
        }
        if ("true".equalsIgnoreCase(val.trim())) {
            return true;
        }
        this.reportError(MessageFormat.format("Error reading property ''{0}''", name), null, 0);
        return defaultValue;
    }

    int getIntProperty(String name, int defaultValue) {
        LogManager manager = LogManager.getLogManager();
        String val = manager.getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(val.trim());
        }
        catch (NumberFormatException e) {
            this.reportError(MessageFormat.format("Error reading property ''{0}''", name), e, 0);
            return defaultValue;
        }
    }
}

