/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.widgets.waitingdots;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Handler;
import android.os.Looper;
import android.text.SpannableString;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;
import org.tcshare.androidutils.R;
import org.tcshare.widgets.waitingdots.InvalidateViewOnUpdate;
import org.tcshare.widgets.waitingdots.JumpingSpan;
import org.tcshare.widgets.waitingdots.SinTypeEvaluator;

public class DotsTextView
extends TextView {
    private JumpingSpan dotOne;
    private JumpingSpan dotTwo;
    private JumpingSpan dotThree;
    private int showSpeed = 700;
    private int jumpHeight;
    private boolean autoPlay;
    private boolean isPlaying;
    private boolean isHide;
    private int period;
    private long startTime;
    private boolean lockDotOne;
    private boolean lockDotTwo;
    private boolean lockDotThree;
    private Handler handler;
    private AnimatorSet mAnimatorSet = new AnimatorSet();
    private float textWidth;

    public DotsTextView(Context context) {
        super(context);
        this.init(context, null);
    }

    public DotsTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public DotsTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.handler = new Handler(Looper.getMainLooper());
        if (attrs != null) {
            TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.WaitingDots);
            this.period = typedArray.getInt(R.styleable.WaitingDots_period, 6000);
            this.jumpHeight = typedArray.getInt(R.styleable.WaitingDots_jumpHeight, (int)(this.getTextSize() / 4.0f));
            this.autoPlay = typedArray.getBoolean(R.styleable.WaitingDots_autoplay, true);
            typedArray.recycle();
        }
        this.dotOne = new JumpingSpan();
        this.dotTwo = new JumpingSpan();
        this.dotThree = new JumpingSpan();
        SpannableString spannable = new SpannableString((CharSequence)"...\u200b");
        spannable.setSpan((Object)this.dotOne, 0, 1, 33);
        spannable.setSpan((Object)this.dotTwo, 1, 2, 33);
        spannable.setSpan((Object)this.dotThree, 2, 3, 33);
        this.setText((CharSequence)spannable, TextView.BufferType.SPANNABLE);
        this.textWidth = this.getPaint().measureText(".", 0, 1);
        ObjectAnimator dotOneJumpAnimator = this.createDotJumpAnimator(this.dotOne, 0L);
        dotOneJumpAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)new InvalidateViewOnUpdate((View)this));
        this.mAnimatorSet.playTogether(new Animator[]{dotOneJumpAnimator, this.createDotJumpAnimator(this.dotTwo, this.period / 6), this.createDotJumpAnimator(this.dotThree, this.period * 2 / 6)});
        this.isPlaying = this.autoPlay;
        if (this.autoPlay && !this.isInEditMode()) {
            this.start();
        }
    }

    public void start() {
        this.isPlaying = true;
        this.setAllAnimationsRepeatCount(-1);
        this.mAnimatorSet.start();
    }

    private ObjectAnimator createDotJumpAnimator(JumpingSpan jumpingSpan, long delay) {
        ObjectAnimator jumpAnimator = ObjectAnimator.ofFloat((Object)((Object)jumpingSpan), (String)"translationY", (float[])new float[]{0.0f, -this.jumpHeight});
        jumpAnimator.setEvaluator((TypeEvaluator)new SinTypeEvaluator());
        jumpAnimator.setDuration((long)this.period);
        jumpAnimator.setStartDelay(delay);
        jumpAnimator.setRepeatCount(-1);
        jumpAnimator.setRepeatMode(1);
        return jumpAnimator;
    }

    public void stop() {
        this.isPlaying = false;
        this.setAllAnimationsRepeatCount(0);
    }

    private void setAllAnimationsRepeatCount(int repeatCount) {
        for (Animator animator : this.mAnimatorSet.getChildAnimations()) {
            if (!(animator instanceof ObjectAnimator)) continue;
            ((ObjectAnimator)animator).setRepeatCount(repeatCount);
        }
    }

    public void hide() {
        this.createDotHideAnimator(this.dotThree, 2.0f).start();
        ObjectAnimator dotTwoMoveRightToLeft = this.createDotHideAnimator(this.dotTwo, 1.0f);
        dotTwoMoveRightToLeft.addUpdateListener((ValueAnimator.AnimatorUpdateListener)new InvalidateViewOnUpdate((View)this));
        dotTwoMoveRightToLeft.start();
        this.isHide = true;
    }

    public void show() {
        ObjectAnimator dotThreeMoveRightToLeft = this.createDotShowAnimator(this.dotThree, 2);
        dotThreeMoveRightToLeft.start();
        ObjectAnimator dotTwoMoveRightToLeft = this.createDotShowAnimator(this.dotTwo, 1);
        dotTwoMoveRightToLeft.addUpdateListener((ValueAnimator.AnimatorUpdateListener)new InvalidateViewOnUpdate((View)this));
        dotTwoMoveRightToLeft.start();
        this.isHide = false;
    }

    private ObjectAnimator createDotHideAnimator(JumpingSpan span, float widthMultiplier) {
        return this.createDotHorizontalAnimator(span, 0.0f, -this.textWidth * widthMultiplier);
    }

    private ObjectAnimator createDotShowAnimator(JumpingSpan span, int widthMultiplier) {
        return this.createDotHorizontalAnimator(span, -this.textWidth * (float)widthMultiplier, 0.0f);
    }

    private ObjectAnimator createDotHorizontalAnimator(JumpingSpan span, float from, float to) {
        ObjectAnimator dotThreeMoveRightToLeft = ObjectAnimator.ofFloat((Object)((Object)span), (String)"translationX", (float[])new float[]{from, to});
        dotThreeMoveRightToLeft.setDuration((long)this.showSpeed);
        return dotThreeMoveRightToLeft;
    }

    public void showAndPlay() {
        this.show();
        this.start();
    }

    public void hideAndStop() {
        this.hide();
        this.stop();
    }

    public boolean isHide() {
        return this.isHide;
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    public void setJumpHeight(int jumpHeight) {
        this.jumpHeight = jumpHeight;
    }

    public void setPeriod(int period) {
        this.period = period;
    }
}

