/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.widgets.swipetoloadlayout;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import org.tcshare.androidutils.R;
import org.tcshare.widgets.swipetoloadlayout.SwipeRefreshHeaderLayout;

public class RefreshHeaderView
extends SwipeRefreshHeaderLayout {
    private ImageView ivArrow;
    private TextView tvRefresh;
    private ProgressBar progressBar;
    private int mHeaderHeight = this.getResources().getDimensionPixelOffset(R.dimen.refresh_header_height_60);
    private Animation rotateUp;
    private Animation rotateDown;
    private boolean rotated = false;

    public RefreshHeaderView(Context context) {
        this(context, null);
    }

    public RefreshHeaderView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RefreshHeaderView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.rotateUp = AnimationUtils.loadAnimation((Context)context, (int)R.anim.rotate_up);
        this.rotateDown = AnimationUtils.loadAnimation((Context)context, (int)R.anim.rotate_down);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.tvRefresh = (TextView)this.findViewById(R.id.tvRefresh);
        this.ivArrow = (ImageView)this.findViewById(R.id.ivArrow);
        this.progressBar = (ProgressBar)this.findViewById(R.id.progressbar);
    }

    @Override
    public void onRefresh() {
        this.ivArrow.clearAnimation();
        this.ivArrow.setVisibility(8);
        this.progressBar.setVisibility(0);
        this.tvRefresh.setText((CharSequence)"\u6b63\u5728\u5237\u65b0...");
    }

    @Override
    public void onPrepare() {
        Log.d((String)"WeiboRefreshHeaderView", (String)"onPrepare()");
    }

    @Override
    public void onMove(int y, boolean isComplete, boolean automatic) {
        if (!isComplete) {
            this.ivArrow.setVisibility(0);
            this.progressBar.setVisibility(8);
            if (y > this.mHeaderHeight) {
                this.tvRefresh.setText((CharSequence)"\u91ca\u653e\u5237\u65b0");
                if (!this.rotated) {
                    this.ivArrow.clearAnimation();
                    this.ivArrow.startAnimation(this.rotateUp);
                    this.rotated = true;
                }
            } else if (y < this.mHeaderHeight) {
                if (this.rotated) {
                    this.ivArrow.clearAnimation();
                    this.ivArrow.startAnimation(this.rotateDown);
                    this.rotated = false;
                }
                this.tvRefresh.setText((CharSequence)"\u4e0b\u62c9\u5237\u65b0");
            }
        }
    }

    @Override
    public void onRelease() {
        Log.d((String)"WeiboRefreshHeaderView", (String)"onRelease()");
    }

    @Override
    public void onComplete() {
        this.rotated = false;
        this.ivArrow.clearAnimation();
        this.ivArrow.setVisibility(8);
        this.progressBar.setVisibility(8);
        this.tvRefresh.setText((CharSequence)"\u5237\u65b0\u5b8c\u6210");
    }

    @Override
    public void onReset() {
        this.rotated = false;
        this.ivArrow.clearAnimation();
        this.ivArrow.setVisibility(8);
        this.progressBar.setVisibility(8);
        this.tvRefresh.setText((CharSequence)"\u4e0b\u62c9\u5237\u65b0");
    }
}

