/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.widgets.swipetoloadlayout;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.widget.ProgressBar;
import android.widget.TextView;
import org.tcshare.androidutils.R;
import org.tcshare.widgets.swipetoloadlayout.SwipeLoadMoreFooterLayout;

public class LoadMoreFooterView
extends SwipeLoadMoreFooterLayout {
    private TextView tvLoadMore;
    private ProgressBar progressBar;
    private int mHeaderHeight;

    public LoadMoreFooterView(Context context) {
        super(context);
    }

    public LoadMoreFooterView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public LoadMoreFooterView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mHeaderHeight = this.getResources().getDimensionPixelOffset(R.dimen.refresh_header_height_60);
        this.tvLoadMore = (TextView)this.findViewById(R.id.tvLoadMore);
        this.progressBar = (ProgressBar)this.findViewById(R.id.progressbar);
    }

    @Override
    public void onLoadMore() {
        this.progressBar.setVisibility(0);
        this.tvLoadMore.setText((CharSequence)"\u6b63\u5728\u52a0\u8f7d...");
    }

    @Override
    public void onPrepare() {
        Log.d((String)"LoadMoreFooterView", (String)"onPrepare()");
    }

    @Override
    public void onMove(int y, boolean isComplete, boolean automatic) {
        if (!isComplete) {
            if (y <= this.mHeaderHeight) {
                this.progressBar.setVisibility(0);
                this.tvLoadMore.setText((CharSequence)"\u52a0\u8f7d\u66f4\u591a");
            } else if (y > this.mHeaderHeight) {
                this.progressBar.setVisibility(8);
                this.tvLoadMore.setText((CharSequence)"\u4e0a\u62c9\u52a0\u8f7d");
            }
        }
    }

    @Override
    public void onRelease() {
        super.onRelease();
    }

    @Override
    public void onComplete() {
        this.progressBar.setVisibility(8);
        this.tvLoadMore.setText((CharSequence)"\u52a0\u8f7d\u5b8c\u6210");
    }

    @Override
    public void onReset() {
        Log.d((String)"LoadMoreFooterView", (String)"onReset()");
    }
}

