/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.widgets.stepview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.View;
import java.util.HashMap;
import java.util.Map;
import org.tcshare.androidutils.R;
import org.tcshare.utils.DensityUtil;

public class FlowViewVertical
extends View {
    private Paint bgPaint;
    private Paint proPaint;
    private TextPaint textPaint;
    private float bgRadius;
    private float proRadius;
    private int lineBgWidth;
    private int bgColor;
    private int lineProWidth;
    private int proColor;
    private int interval;
    private int bgPositionX;
    private int maxStep;
    private int proStep;
    private int textPaddingLeft;
    private int timePaddingRight;
    private int textMoveTop;
    private int timeMoveTop;
    private int textsize;
    private float starY;
    private float stopY;
    private String[] titles;
    private String[] times;
    private int border;
    private final Map<Integer, String> mapPos = new HashMap<Integer, String>();

    public FlowViewVertical(Context context) {
        this(context, null);
    }

    public FlowViewVertical(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FlowViewVertical(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.FlowViewVertical);
        this.bgRadius = ta.getDimension(R.styleable.FlowViewVertical_v_bg_radius, 10.0f);
        this.proRadius = ta.getDimension(R.styleable.FlowViewVertical_v_pro_radius, 8.0f);
        this.lineBgWidth = (int)ta.getDimension(R.styleable.FlowViewVertical_v_bg_width, 3.0f);
        this.bgColor = ta.getColor(R.styleable.FlowViewVertical_v_bg_color, Color.parseColor((String)"#cdcbcc"));
        this.lineProWidth = (int)ta.getDimension(R.styleable.FlowViewVertical_v_pro_width, 2.0f);
        this.proColor = ta.getColor(R.styleable.FlowViewVertical_v_pro_color, Color.parseColor((String)"#029dd5"));
        this.interval = (int)ta.getDimension(R.styleable.FlowViewVertical_v_interval, 140.0f);
        this.maxStep = ta.getInt(R.styleable.FlowViewVertical_v_max_step, 5);
        this.proStep = ta.getInt(R.styleable.FlowViewVertical_v_pro_step, 3);
        this.bgPositionX = (int)ta.getDimension(R.styleable.FlowViewVertical_v_bgPositionX, 200.0f);
        this.textPaddingLeft = (int)ta.getDimension(R.styleable.FlowViewVertical_v_textPaddingLeft, 40.0f);
        this.timePaddingRight = (int)ta.getDimension(R.styleable.FlowViewVertical_v_timePaddingRight, 80.0f);
        this.textMoveTop = (int)ta.getDimension(R.styleable.FlowViewVertical_v_textMoveTop, 10.0f);
        this.timeMoveTop = (int)ta.getDimension(R.styleable.FlowViewVertical_v_timeMoveTop, 8.0f);
        this.textsize = (int)ta.getDimension(R.styleable.FlowViewVertical_v_textsize, 17.0f);
        ta.recycle();
        this.init();
    }

    private void init() {
        this.bgPaint = new Paint();
        this.bgPaint.setAntiAlias(true);
        this.bgPaint.setStyle(Paint.Style.FILL);
        this.bgPaint.setColor(this.bgColor);
        this.bgPaint.setStrokeWidth((float)this.lineBgWidth);
        this.proPaint = new Paint();
        this.proPaint.setAntiAlias(true);
        this.proPaint.setStyle(Paint.Style.FILL);
        this.proPaint.setColor(this.proColor);
        this.proPaint.setStrokeWidth((float)this.lineProWidth);
        this.textPaint = new TextPaint();
        this.textPaint.setTextSize((float)this.textsize);
        this.textPaint.setAntiAlias(true);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int bgWidth = widthMode == 0x40000000 ? View.MeasureSpec.getSize((int)widthMeasureSpec) - this.getPaddingLeft() - this.getPaddingRight() : DensityUtil.dp2px(this.getContext(), 311);
        this.starY = (float)this.getPaddingTop() + this.bgRadius;
        this.stopY = (float)this.getPaddingTop() + this.bgRadius + (float)((this.maxStep - 1) * this.interval);
        float bottom = this.stopY + this.bgRadius + (float)this.getPaddingBottom();
        this.border = bgWidth - (this.bgPositionX + this.textPaddingLeft);
        this.setMeasuredDimension(bgWidth, (int)bottom);
    }

    protected void onDraw(Canvas canvas) {
        this.drawBg(canvas);
        this.drawProgress(canvas);
        this.drawText(canvas);
    }

    private void drawText(Canvas canvas) {
        for (int i = 0; i < this.maxStep; ++i) {
            this.setPaintColor(i);
            if (null != this.times && i < this.proStep) {
                canvas.drawText(this.times[i], (float)(this.bgPositionX - this.timePaddingRight), this.stopY - (float)(i * this.interval) + (float)this.timeMoveTop, (Paint)this.textPaint);
            }
            if (null == this.titles) continue;
            canvas.save();
            canvas.translate((float)(this.bgPositionX + this.textPaddingLeft), this.stopY - (float)(i * this.interval) - (float)this.textMoveTop);
            StaticLayout sl = new StaticLayout((CharSequence)this.titles[i], this.textPaint, this.border, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false);
            sl.draw(canvas);
            canvas.restore();
        }
    }

    private void drawProgress(Canvas canvas) {
        float lastBottom = this.stopY;
        for (int i = 0; i < this.proStep; ++i) {
            this.setPaintColor(i);
            int linePro = i == 0 || i == this.maxStep - 1 ? this.interval / 2 : this.interval;
            canvas.drawLine((float)this.bgPositionX, lastBottom, (float)this.bgPositionX, lastBottom - (float)linePro, this.proPaint);
            lastBottom -= (float)linePro;
            canvas.drawCircle((float)this.bgPositionX, this.stopY - (float)(i * this.interval), this.proRadius, this.proPaint);
        }
    }

    private void setPaintColor(int index) {
        if (index < this.proStep) {
            this.textPaint.setColor(this.proColor);
        } else {
            this.textPaint.setColor(this.bgColor);
        }
        if (this.mapPos.get(index) != null) {
            int c = Color.parseColor((String)this.mapPos.get(index));
            this.proPaint.setColor(c);
            this.textPaint.setColor(c);
        } else {
            this.proPaint.setColor(this.proColor);
        }
    }

    private void drawBg(Canvas canvas) {
        canvas.drawLine((float)this.bgPositionX, this.stopY, (float)this.bgPositionX, this.starY, this.bgPaint);
        for (int i = 0; i < this.maxStep; ++i) {
            canvas.drawCircle((float)this.bgPositionX, this.stopY - (float)(i * this.interval), this.bgRadius, this.bgPaint);
        }
    }

    public void setKeyColorByName(Map<String, String> map, boolean reset) {
        for (int i = 0; i < this.titles.length; ++i) {
            if (reset) {
                this.mapPos.put(i, map.get(this.titles[i]));
                continue;
            }
            if (map.get(this.titles[i]) == null) continue;
            this.mapPos.put(i, map.get(this.titles[i]));
        }
    }

    public void setKeyColorByIndex(Map<Integer, String> map) {
        this.mapPos.putAll(map);
    }

    public void setProgress(int progress, int maxStep, String[] titles, String[] times) {
        this.proStep = progress;
        this.maxStep = maxStep;
        this.titles = titles;
        this.times = times;
        this.invalidate();
    }
}

