/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.widgets;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.View;
import androidx.annotation.DrawableRes;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import java.util.HashMap;
import org.tcshare.widgets.MyColorDrawable;

public class VerticalItemDecoration
extends RecyclerView.ItemDecoration {
    private static final int[] ATTRS = new int[]{16843284};
    private HashMap<Integer, Drawable> mDividerViewTypeMap;
    private Drawable mFirstDrawable;
    private Drawable mLastDrawable;

    public VerticalItemDecoration(HashMap<Integer, Drawable> dividerViewTypeMap, Drawable firstDrawable, Drawable lastDrawable) {
        this.mDividerViewTypeMap = dividerViewTypeMap;
        this.mFirstDrawable = firstDrawable;
        this.mLastDrawable = lastDrawable;
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        if (this.isLastPosition(view, parent)) {
            if (this.mLastDrawable != null) {
                outRect.bottom = this.mLastDrawable.getIntrinsicHeight();
            }
            return;
        }
        int childType = parent.getLayoutManager().getItemViewType(view);
        Drawable drawable2 = this.mDividerViewTypeMap.get(childType);
        if (drawable2 != null) {
            outRect.bottom = drawable2.getIntrinsicHeight();
        }
        if (this.isFirstPosition(view, parent) && this.mFirstDrawable != null) {
            outRect.top = this.mFirstDrawable.getIntrinsicHeight();
        }
    }

    public void onDraw(Canvas c, RecyclerView parent, RecyclerView.State state) {
        int left = parent.getPaddingLeft();
        int right = parent.getWidth() - parent.getPaddingRight();
        int childCount = parent.getChildCount();
        for (int i = 0; i <= childCount - 1; ++i) {
            int bottom;
            View child = parent.getChildAt(i);
            int childViewType = parent.getLayoutManager().getItemViewType(child);
            RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)child.getLayoutParams();
            if (this.isLastPosition(child, parent)) {
                if (this.mLastDrawable != null) {
                    int top = child.getBottom() + params.bottomMargin;
                    bottom = top + this.mLastDrawable.getIntrinsicHeight();
                    this.mLastDrawable.setBounds(left, top, right, bottom);
                    this.mLastDrawable.draw(c);
                }
                return;
            }
            Drawable drawable2 = this.mDividerViewTypeMap.get(childViewType);
            if (drawable2 != null) {
                int top = child.getBottom() + params.bottomMargin;
                int bottom2 = top + drawable2.getIntrinsicHeight();
                drawable2.setBounds(left, top, right, bottom2);
                drawable2.draw(c);
            }
            if (!this.isFirstPosition(child, parent) || this.mFirstDrawable == null) continue;
            bottom = child.getTop() - params.topMargin;
            int top = bottom - this.mFirstDrawable.getIntrinsicHeight();
            this.mFirstDrawable.setBounds(left, top, right, bottom);
            this.mFirstDrawable.draw(c);
        }
    }

    private boolean isFirstPosition(View view, RecyclerView parent) {
        return parent.getChildAdapterPosition(view) == 0;
    }

    private boolean isLastPosition(View view, RecyclerView parent) {
        return parent.getChildAdapterPosition(view) == parent.getAdapter().getItemCount() - 1;
    }

    public static class Builder {
        private Context mContext;
        private HashMap<Integer, Drawable> mDividerViewTypeMap = new HashMap();
        private Drawable mFirstDrawable;
        private Drawable mLastDrawable;

        Builder(Context context) {
            this.mContext = context;
        }

        public Builder type(int viewType) {
            TypedArray a = this.mContext.obtainStyledAttributes(ATTRS);
            Drawable divider = a.getDrawable(0);
            this.type(viewType, divider);
            a.recycle();
            return this;
        }

        public Builder typeColor(int viewType, int color2, int height) {
            MyColorDrawable transDrawable = new MyColorDrawable(height, height, color2);
            this.type(viewType, (Drawable)transDrawable);
            return this;
        }

        public Builder type(int viewType, @DrawableRes int drawableResId) {
            this.mDividerViewTypeMap.put(viewType, ContextCompat.getDrawable((Context)this.mContext, (int)drawableResId));
            return this;
        }

        public Builder type(int viewType, Drawable drawable2) {
            this.mDividerViewTypeMap.put(viewType, drawable2);
            return this;
        }

        public Builder first(@DrawableRes int drawableResId) {
            this.first(ContextCompat.getDrawable((Context)this.mContext, (int)drawableResId));
            return this;
        }

        public Builder first(Drawable drawable2) {
            this.mFirstDrawable = drawable2;
            return this;
        }

        public Builder last(@DrawableRes int drawableResId) {
            this.last(ContextCompat.getDrawable((Context)this.mContext, (int)drawableResId));
            return this;
        }

        public Builder last(Drawable drawable2) {
            this.mLastDrawable = drawable2;
            return this;
        }

        public VerticalItemDecoration create() {
            return new VerticalItemDecoration(this.mDividerViewTypeMap, this.mFirstDrawable, this.mLastDrawable);
        }
    }
}

