/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.widgets;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.animation.Interpolator;
import android.widget.FrameLayout;
import androidx.core.view.GestureDetectorCompat;
import androidx.core.widget.ScrollerCompat;
import org.tcshare.androidutils.R;

public class SwipeMenuLayout
extends FrameLayout {
    private static final int STATE_CLOSE = 0;
    private static final int STATE_OPEN = 1;
    private static final boolean OVER_API_11 = Build.VERSION.SDK_INT >= 11;
    private int mSwipeDirection;
    private View mContentView;
    private View mMenuView;
    private int mDownX;
    private int state = 0;
    private GestureDetectorCompat mGestureDetector;
    private GestureDetector.OnGestureListener mGestureListener;
    private boolean isFling;
    private ScrollerCompat mOpenScroller;
    private ScrollerCompat mCloseScroller;
    private int mBaseX;
    private Interpolator mCloseInterpolator;
    private Interpolator mOpenInterpolator;
    private ViewConfiguration mViewConfiguration;
    private boolean swipeEnable = true;
    private int animDuration;

    public SwipeMenuLayout(Context context) {
        this(context, null);
    }

    public SwipeMenuLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SwipeMenuLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        if (!this.isInEditMode()) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SwipeMenu, 0, defStyle);
            this.animDuration = a.getInteger(R.styleable.SwipeMenu_anim_duration, 500);
            a.recycle();
        }
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.setClickable(true);
        this.mContentView = this.findViewById(R.id.smContentView);
        if (this.mContentView == null) {
            throw new IllegalArgumentException("not find contentView by id smContentView");
        }
        this.mMenuView = this.findViewById(R.id.smMenuView);
        if (this.mMenuView == null) {
            throw new IllegalArgumentException("not find menuView by id smMenuView");
        }
        this.mViewConfiguration = ViewConfiguration.get((Context)this.getContext());
        this.init();
    }

    public void setSwipeDirection(int swipeDirection) {
        this.mSwipeDirection = swipeDirection;
    }

    public void init() {
        this.mGestureListener = new GestureDetector.SimpleOnGestureListener(){

            public boolean onDown(MotionEvent e) {
                SwipeMenuLayout.this.isFling = false;
                return true;
            }

            public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
                if (velocityX > (float)SwipeMenuLayout.this.mViewConfiguration.getScaledMinimumFlingVelocity() || velocityY > (float)SwipeMenuLayout.this.mViewConfiguration.getScaledMinimumFlingVelocity()) {
                    SwipeMenuLayout.this.isFling = true;
                }
                return SwipeMenuLayout.this.isFling;
            }
        };
        this.mGestureDetector = new GestureDetectorCompat(this.getContext(), this.mGestureListener);
        this.mCloseScroller = ScrollerCompat.create((Context)this.getContext());
        this.mOpenScroller = ScrollerCompat.create((Context)this.getContext());
    }

    public void setCloseInterpolator(Interpolator closeInterpolator) {
        this.mCloseInterpolator = closeInterpolator;
        if (this.mCloseInterpolator != null) {
            this.mCloseScroller = ScrollerCompat.create((Context)this.getContext(), (Interpolator)this.mCloseInterpolator);
        }
    }

    public void setOpenInterpolator(Interpolator openInterpolator) {
        this.mOpenInterpolator = openInterpolator;
        if (this.mOpenInterpolator != null) {
            this.mOpenScroller = ScrollerCompat.create((Context)this.getContext(), (Interpolator)this.mOpenInterpolator);
        }
    }

    public boolean onSwipe(MotionEvent event) {
        this.mGestureDetector.onTouchEvent(event);
        switch (event.getAction()) {
            case 0: {
                this.mDownX = (int)event.getX();
                this.isFling = false;
                break;
            }
            case 2: {
                int dis = (int)((float)this.mDownX - event.getX());
                if (this.state == 1) {
                    dis += this.mMenuView.getWidth() * this.mSwipeDirection;
                }
                this.swipe(dis);
                break;
            }
            case 1: {
                if ((this.isFling || Math.abs((float)this.mDownX - event.getX()) > (float)(this.mMenuView.getWidth() / 3)) && Math.signum((float)this.mDownX - event.getX()) == (float)this.mSwipeDirection) {
                    this.smoothOpenMenu();
                    break;
                }
                this.smoothCloseMenu();
                return false;
            }
        }
        return true;
    }

    public boolean isOpen() {
        return this.state == 1;
    }

    private void swipe(int dis) {
        if (Math.signum(dis) != (float)this.mSwipeDirection) {
            dis = 0;
        } else if (Math.abs(dis) > this.mMenuView.getWidth()) {
            dis = this.mMenuView.getWidth() * this.mSwipeDirection;
            this.state = 1;
        }
        FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)this.mContentView.getLayoutParams();
        int lGap = this.getPaddingLeft() + lp.leftMargin;
        this.mContentView.layout(lGap - dis, this.mContentView.getTop(), lGap + (OVER_API_11 ? this.mContentView.getMeasuredWidthAndState() : this.mContentView.getMeasuredWidth()) - dis, this.mContentView.getBottom());
        if (this.mSwipeDirection == 1) {
            this.mMenuView.layout(this.getMeasuredWidth() - dis, this.mMenuView.getTop(), this.getMeasuredWidth() + (OVER_API_11 ? this.mMenuView.getMeasuredWidthAndState() : this.mMenuView.getMeasuredWidth()) - dis, this.mMenuView.getBottom());
        } else {
            this.mMenuView.layout(-(OVER_API_11 ? this.mMenuView.getMeasuredWidthAndState() : this.mMenuView.getMeasuredWidth()) - dis, this.mMenuView.getTop(), -dis, this.mMenuView.getBottom());
        }
    }

    public void computeScroll() {
        if (this.state == 1) {
            if (this.mOpenScroller.computeScrollOffset()) {
                this.swipe(this.mOpenScroller.getCurrX() * this.mSwipeDirection);
                this.postInvalidate();
            }
        } else if (this.mCloseScroller.computeScrollOffset()) {
            this.swipe((this.mBaseX - this.mCloseScroller.getCurrX()) * this.mSwipeDirection);
            this.postInvalidate();
        }
    }

    public void smoothCloseMenu() {
        this.closeOpenedMenu();
    }

    public void closeOpenedMenu() {
        this.state = 0;
        if (this.mSwipeDirection == 1) {
            this.mBaseX = -this.mContentView.getLeft();
            this.mCloseScroller.startScroll(0, 0, this.mMenuView.getWidth(), 0, this.animDuration);
        } else {
            this.mBaseX = this.mMenuView.getRight();
            this.mCloseScroller.startScroll(0, 0, this.mMenuView.getWidth(), 0, this.animDuration);
        }
        this.postInvalidate();
    }

    public void smoothOpenMenu() {
        this.state = 1;
        if (this.mSwipeDirection == 1) {
            this.mOpenScroller.startScroll(-this.mContentView.getLeft(), 0, this.mMenuView.getWidth(), 0, this.animDuration);
        } else {
            this.mOpenScroller.startScroll(this.mContentView.getLeft(), 0, this.mMenuView.getWidth(), 0, this.animDuration);
        }
        this.postInvalidate();
    }

    public void closeMenu() {
        if (this.mCloseScroller.computeScrollOffset()) {
            this.mCloseScroller.abortAnimation();
        }
        if (this.state == 1) {
            this.state = 0;
            this.swipe(0);
        }
    }

    public void openMenu() {
        if (this.state == 0) {
            this.state = 1;
            this.swipe(this.mMenuView.getWidth() * this.mSwipeDirection);
        }
    }

    public View getMenuView() {
        return this.mMenuView;
    }

    public View getContentView() {
        return this.mContentView;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)this.mContentView.getLayoutParams();
        int lGap = this.getPaddingLeft() + lp.leftMargin;
        int tGap = this.getPaddingTop() + lp.topMargin;
        this.mContentView.layout(lGap, tGap, lGap + (OVER_API_11 ? this.mContentView.getMeasuredWidthAndState() : this.mContentView.getMeasuredWidth()), tGap + (OVER_API_11 ? this.mContentView.getMeasuredHeightAndState() : this.mContentView.getMeasuredHeight()));
        lp = (FrameLayout.LayoutParams)this.mMenuView.getLayoutParams();
        tGap = this.getPaddingTop() + lp.topMargin;
        if (this.mSwipeDirection == 1) {
            this.mMenuView.layout(this.getMeasuredWidth(), tGap, this.getMeasuredWidth() + (OVER_API_11 ? this.mMenuView.getMeasuredWidthAndState() : this.mMenuView.getMeasuredWidth()), tGap + (OVER_API_11 ? this.mContentView.getMeasuredHeightAndState() : this.mContentView.getMeasuredHeight()));
        } else {
            this.mMenuView.layout(-(OVER_API_11 ? this.mMenuView.getMeasuredWidthAndState() : this.mMenuView.getMeasuredWidth()), tGap, 0, tGap + (OVER_API_11 ? this.mContentView.getMeasuredHeightAndState() : this.mContentView.getMeasuredHeight()));
        }
    }

    public void setSwipeEnable(boolean swipeEnable) {
        this.swipeEnable = swipeEnable;
    }

    public boolean isSwipeEnable() {
        return this.swipeEnable;
    }
}

