/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.widgets;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RadioGroup;

public class FlowRadioGroup
extends RadioGroup {
    public FlowRadioGroup(Context context) {
        super(context);
    }

    public FlowRadioGroup(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        this.measureChildren(widthMeasureSpec, heightMeasureSpec);
        int maxWidth = 0;
        int totalHeight = 0;
        int lineWidth = 0;
        int maxLineHeight = 0;
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
            int oldHeight = maxLineHeight;
            int oldWidth = maxWidth;
            int deltaX = child.getMeasuredWidth() + params.leftMargin + params.rightMargin;
            if (lineWidth + deltaX + this.getPaddingLeft() + this.getPaddingRight() > widthSize) {
                maxWidth = Math.max(lineWidth, oldWidth);
                lineWidth = deltaX;
                totalHeight += oldHeight;
                maxLineHeight = child.getMeasuredHeight() + params.topMargin + params.bottomMargin;
            } else {
                lineWidth += deltaX;
                int deltaY = child.getMeasuredHeight() + params.topMargin + params.bottomMargin;
                maxLineHeight = Math.max(maxLineHeight, deltaY);
            }
            if (i != count - 1) continue;
            totalHeight += maxLineHeight;
            maxWidth = Math.max(lineWidth, oldWidth);
        }
        this.setMeasuredDimension(widthMode == 0x40000000 ? widthSize : (maxWidth += this.getPaddingLeft() + this.getPaddingRight()), heightMode == 0x40000000 ? heightSize : (totalHeight += this.getPaddingTop() + this.getPaddingBottom()));
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int count = this.getChildCount();
        int preLeft = this.getPaddingLeft();
        int preTop = this.getPaddingTop();
        int maxHeight = 0;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
            if (preLeft + params.leftMargin + child.getMeasuredWidth() + params.rightMargin + this.getPaddingRight() > r - l) {
                preLeft = this.getPaddingLeft();
                preTop += maxHeight;
                maxHeight = this.getChildAt(i).getMeasuredHeight() + params.topMargin + params.bottomMargin;
            } else {
                maxHeight = Math.max(maxHeight, child.getMeasuredHeight() + params.topMargin + params.bottomMargin);
            }
            int left = preLeft + params.leftMargin;
            int top = preTop + params.topMargin;
            int right = left + child.getMeasuredWidth();
            int bottom = top + child.getMeasuredHeight();
            child.layout(left, top, right, bottom);
            preLeft += params.leftMargin + child.getMeasuredWidth() + params.rightMargin;
        }
    }
}

