/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.widgets;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.core.view.GestureDetectorCompat;
import androidx.core.view.ViewCompat;
import androidx.customview.widget.ViewDragHelper;

public class DragLeft2RightExitFrameLayout
extends LinearLayout {
    private static final String TAG = DragLeft2RightExitFrameLayout.class.getSimpleName();
    private View view;
    private ViewDragHelper dragHelper;
    private DragExitListner listener;
    private GestureDetectorCompat gesture;

    public DragLeft2RightExitFrameLayout(Context context) {
        super(context);
        this.init(context);
    }

    public DragLeft2RightExitFrameLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    private void init(Context context) {
        this.dragHelper = ViewDragHelper.create((ViewGroup)this, (ViewDragHelper.Callback)new ViewDragHelper.Callback(){

            public boolean tryCaptureView(View child, int pointerId) {
                Log.d((String)TAG, (String)("captured View  :" + (child == DragLeft2RightExitFrameLayout.this.view)));
                return child == DragLeft2RightExitFrameLayout.this.view;
            }

            public int clampViewPositionHorizontal(View child, int left, int dx) {
                Log.d((String)TAG, (String)("clampViewPositionHorizontal left :" + left));
                return left > 0 ? left : super.clampViewPositionHorizontal(child, left, dx);
            }

            public void onViewReleased(View releasedChild, float xvel, float yvel) {
                int end;
                super.onViewReleased(releasedChild, xvel, yvel);
                int pWidth = DragLeft2RightExitFrameLayout.this.getWidth();
                float xPos = DragLeft2RightExitFrameLayout.this.view.getX();
                int n = end = xPos > (float)(pWidth / 2) ? pWidth : 0;
                if (DragLeft2RightExitFrameLayout.this.dragHelper.smoothSlideViewTo(releasedChild, end, 0)) {
                    ViewCompat.postInvalidateOnAnimation((View)DragLeft2RightExitFrameLayout.this);
                }
                Log.d((String)TAG, (String)String.format("xPos %f end %d pWidth %d", Float.valueOf(xPos), end, pWidth));
            }

            public void onViewDragStateChanged(int state) {
                super.onViewDragStateChanged(state);
                switch (state) {
                    case 1: {
                        break;
                    }
                    case 0: {
                        float xPos = ViewCompat.getX((View)DragLeft2RightExitFrameLayout.this.view);
                        int pWidth = DragLeft2RightExitFrameLayout.this.getWidth();
                        if (DragLeft2RightExitFrameLayout.this.listener == null || !(xPos > 0.99f * (float)pWidth) || !(xPos < 1.01f * (float)pWidth)) break;
                        DragLeft2RightExitFrameLayout.this.listener.onExit();
                        break;
                    }
                }
                Log.d((String)TAG, (String)String.format("viewDragStateChanged state %d", state));
            }
        });
        this.gesture = new GestureDetectorCompat(context, (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
                Log.d((String)TAG, (String)("X directory: " + (Math.abs(distanceX) > Math.abs(distanceY))));
                return Math.abs(distanceX) > Math.abs(distanceY);
            }
        });
    }

    public void setDragExitListner(DragExitListner listener) {
        this.listener = listener;
    }

    public void computeScroll() {
        if (this.dragHelper.continueSettling(true)) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        Log.v((String)TAG, (String)"dispatchTouchEvent");
        return super.dispatchTouchEvent(ev);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return this.dragHelper.shouldInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent event) {
        Log.v((String)TAG, (String)"onTouchEvent");
        this.dragHelper.processTouchEvent(event);
        return true;
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        if (this.getChildCount() != 1) {
            throw new ExceptionInInitializerError("Only support one child!");
        }
        this.view = this.getChildAt(0);
    }

    public static interface DragExitListner {
        public void onExit();
    }
}

