/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.widgets;

import android.animation.TypeEvaluator;
import android.graphics.PointF;

public class BezierEvaluator
implements TypeEvaluator<PointF> {
    private PointF pointF1;
    private PointF pointF2;

    public BezierEvaluator(PointF pointF1, PointF pointF2) {
        this.pointF1 = pointF1;
        this.pointF2 = pointF2;
    }

    public PointF evaluate(float time, PointF startValue, PointF endValue) {
        float timeLeft = 1.0f - time;
        PointF point = new PointF();
        PointF point0 = startValue;
        PointF point3 = endValue;
        point.x = timeLeft * timeLeft * timeLeft * point0.x + 3.0f * timeLeft * timeLeft * time * this.pointF1.x + 3.0f * timeLeft * time * time * this.pointF2.x + time * time * time * point3.x;
        point.y = timeLeft * timeLeft * timeLeft * point0.y + 3.0f * timeLeft * timeLeft * time * this.pointF1.y + 3.0f * timeLeft * time * time * this.pointF2.y + time * time * time * point3.y;
        return point;
    }
}

