/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.utils.websocket;

import android.os.Handler;
import android.util.Log;
import androidx.annotation.NonNull;
import com.orhanobut.logger.Logger;
import java.util.Observable;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.tcshare.utils.websocket.IReceiveMessage;

public final class WebSocketManager
extends Observable {
    private static final String TAG = WebSocketManager.class.getSimpleName();
    private static final int RE_CONNECT = 5000;
    private static volatile WebSocketManager mInstance = null;
    private OkHttpClient client;
    private Request request;
    private IReceiveMessage receiveMessage;
    private WebSocket mWebSocket;
    private boolean isConnect = false;
    private long sendTime = 0L;
    private final Handler mHandler = new Handler();
    private long heartRate = 30000L;
    private final Runnable heartBeatRunnable = new Runnable(){

        @Override
        public void run() {
            if (System.currentTimeMillis() - WebSocketManager.this.sendTime >= WebSocketManager.this.heartRate) {
                WebSocketManager.this.sendTime = System.currentTimeMillis();
                boolean isSend = WebSocketManager.this.sendMessage(WebSocketManager.this.getWSHeart());
                Log.d((String)TAG, (String)("\u5fc3\u8df3\u662f\u5426\u53d1\u9001\u6210\u529f" + isSend));
                Logger.d((Object)("\u5fc3\u8df3\u662f\u5426\u53d1\u9001\u6210\u529f" + isSend));
            }
            WebSocketManager.this.mHandler.postDelayed((Runnable)this, WebSocketManager.this.heartRate);
        }
    };

    private WebSocketManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WebSocketManager getInstance() {
        if (null != mInstance) return mInstance;
        Class<WebSocketManager> clazz = WebSocketManager.class;
        synchronized (WebSocketManager.class) {
            if (mInstance != null) return mInstance;
            mInstance = new WebSocketManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public void init(String wsUrl, long heartRate, IReceiveMessage message) {
        this.heartRate = heartRate < 1000L ? 1000L : heartRate;
        this.client = new OkHttpClient.Builder().writeTimeout(60L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).connectTimeout(60L, TimeUnit.SECONDS).build();
        Log.d((String)TAG, (String)("WebSocket prepare:" + wsUrl));
        this.request = new Request.Builder().url(wsUrl).build();
        this.receiveMessage = message;
        this.connect();
    }

    public void connect() {
        if (this.isConnected()) {
            Log.d((String)TAG, (String)"WebSocket \u5df2\u7ecf\u8fde\u63a5\uff01");
            Logger.d((Object)"WebSocket \u5df2\u7ecf\u8fde\u63a5\uff01");
            return;
        }
        Log.d((String)TAG, (String)"WebSocket connect...");
        this.client.newWebSocket(this.request, this.createListener());
    }

    public void reconnect() {
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                Log.d((String)TAG, (String)"WebSocket reconnect...");
                WebSocketManager.this.connect();
            }
        }, 5000L);
    }

    public boolean isConnected() {
        return this.mWebSocket != null && this.isConnect;
    }

    private String getWSHeart() {
        return "{\"heart\":" + System.currentTimeMillis() + "}";
    }

    public boolean sendMessage(String text) {
        if (!this.isConnected()) {
            return false;
        }
        return this.mWebSocket.send(text);
    }

    public boolean sendMessage(ByteString byteString) {
        if (!this.isConnected()) {
            return false;
        }
        return this.mWebSocket.send(byteString);
    }

    public void close() {
        Log.d((String)TAG, (String)"WebSocket close, \u4e3b\u52a8\u5173\u95ed");
        Logger.d((Object)"WebSocket close, \u4e3b\u52a8\u5173\u95ed");
        if (this.isConnected()) {
            this.mWebSocket.cancel();
            this.mWebSocket.close(1001, "\u5ba2\u6237\u7aef\u4e3b\u52a8\u5173\u95ed\u8fde\u63a5");
        }
        this.mHandler.removeCallbacksAndMessages(null);
    }

    private WebSocketListener createListener() {
        return new WebSocketListener(){

            public void onOpen(@NonNull WebSocket webSocket, @NonNull Response response) {
                super.onOpen(webSocket, response);
                Log.d((String)TAG, (String)("WebSocket \u6253\u5f00:" + response));
                Logger.d((Object)("WebSocket \u6253\u5f00:" + response));
                WebSocketManager.this.mWebSocket = webSocket;
                WebSocketManager.this.isConnect = response.code() == 101;
                if (!WebSocketManager.this.isConnect) {
                    WebSocketManager.this.reconnect();
                } else {
                    Log.d((String)TAG, (String)"WebSocket \u8fde\u63a5\u6210\u529f!");
                    Logger.d((Object)"WebSocket \u8fde\u63a5\u6210\u529f!");
                    if (WebSocketManager.this.receiveMessage != null) {
                        WebSocketManager.this.receiveMessage.onConnectSuccess();
                    }
                    if (WebSocketManager.this.sendMessage(WebSocketManager.this.getWSHeart())) {
                        WebSocketManager.this.mHandler.postDelayed(WebSocketManager.this.heartBeatRunnable, WebSocketManager.this.heartRate);
                    }
                }
            }

            public void onMessage(@NonNull WebSocket webSocket, @NonNull String text) {
                super.onMessage(webSocket, text);
                if (WebSocketManager.this.receiveMessage != null) {
                    WebSocketManager.this.receiveMessage.onMessage(text);
                }
            }

            public void onMessage(@NonNull WebSocket webSocket, @NonNull ByteString bytes) {
                super.onMessage(webSocket, bytes);
                if (WebSocketManager.this.receiveMessage != null) {
                    WebSocketManager.this.receiveMessage.onMessage(bytes.base64());
                }
            }

            public void onClosing(@NonNull WebSocket webSocket, int code, @NonNull String reason) {
                super.onClosing(webSocket, code, reason);
                Log.d((String)TAG, (String)"WebSocket onClosing!");
                Logger.d((Object)"WebSocket onClosing!");
                WebSocketManager.this.mWebSocket = null;
                WebSocketManager.this.isConnect = false;
                if (WebSocketManager.this.mHandler != null) {
                    WebSocketManager.this.mHandler.removeCallbacksAndMessages(null);
                }
                if (WebSocketManager.this.receiveMessage != null) {
                    WebSocketManager.this.receiveMessage.onClose();
                }
            }

            public void onClosed(@NonNull WebSocket webSocket, int code, @NonNull String reason) {
                super.onClosed(webSocket, code, reason);
                Log.d((String)TAG, (String)"WebSocket onClosed!");
                Logger.d((Object)"WebSocket onClosed!");
                WebSocketManager.this.mWebSocket = null;
                WebSocketManager.this.isConnect = false;
                if (WebSocketManager.this.mHandler != null) {
                    WebSocketManager.this.mHandler.removeCallbacksAndMessages(null);
                }
                if (WebSocketManager.this.receiveMessage != null) {
                    WebSocketManager.this.receiveMessage.onClose();
                }
            }

            public void onFailure(@NonNull WebSocket webSocket, @NonNull Throwable t, Response response) {
                super.onFailure(webSocket, t, response);
                if (response != null) {
                    Log.d((String)TAG, (String)("WebSocket \u8fde\u63a5\u5931\u8d25\uff1a" + response.message()));
                    Logger.d((Object)("WebSocket \u8fde\u63a5\u5931\u8d25\uff1a" + response.message()));
                }
                Log.d((String)TAG, (String)("WebSocket \u8fde\u63a5\u5931\u8d25\u5f02\u5e38\u539f\u56e0\uff1a" + t.getMessage()));
                Logger.d((Object)("WebSocket \u8fde\u63a5\u5931\u8d25\u5f02\u5e38\u539f\u56e0\uff1a" + t.getMessage()));
                WebSocketManager.this.isConnect = false;
                if (WebSocketManager.this.mHandler != null) {
                    WebSocketManager.this.mHandler.removeCallbacksAndMessages(null);
                }
                if (WebSocketManager.this.receiveMessage != null) {
                    WebSocketManager.this.receiveMessage.onConnectFailed();
                }
                if (t.getMessage() != null && !t.getMessage().equals("Socket closed")) {
                    WebSocketManager.this.reconnect();
                }
            }
        };
    }
}

