/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.utils.usbserial.driver;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.util.Log;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.tcshare.utils.usbserial.driver.CommonUsbSerialPort;
import org.tcshare.utils.usbserial.driver.UsbSerialDriver;
import org.tcshare.utils.usbserial.driver.UsbSerialPort;

public class ProlificSerialDriver
implements UsbSerialDriver {
    private final String TAG = ProlificSerialDriver.class.getSimpleName();
    private final UsbDevice mDevice;
    private final UsbSerialPort mPort;

    public ProlificSerialDriver(UsbDevice device) {
        this.mDevice = device;
        this.mPort = new ProlificSerialPort(this.mDevice, 0);
    }

    @Override
    public List<UsbSerialPort> getPorts() {
        return Collections.singletonList(this.mPort);
    }

    @Override
    public UsbDevice getDevice() {
        return this.mDevice;
    }

    public static Map<Integer, int[]> getSupportedDevices() {
        LinkedHashMap<Integer, int[]> supportedDevices = new LinkedHashMap<Integer, int[]>();
        supportedDevices.put(1659, new int[]{8963});
        return supportedDevices;
    }

    class ProlificSerialPort
    extends CommonUsbSerialPort {
        private static final int USB_READ_TIMEOUT_MILLIS = 1000;
        private static final int USB_WRITE_TIMEOUT_MILLIS = 5000;
        private static final int USB_RECIP_INTERFACE = 1;
        private static final int PROLIFIC_VENDOR_READ_REQUEST = 1;
        private static final int PROLIFIC_VENDOR_WRITE_REQUEST = 1;
        private static final int PROLIFIC_VENDOR_OUT_REQTYPE = 64;
        private static final int PROLIFIC_VENDOR_IN_REQTYPE = 192;
        private static final int PROLIFIC_CTRL_OUT_REQTYPE = 33;
        private static final int WRITE_ENDPOINT = 2;
        private static final int READ_ENDPOINT = 131;
        private static final int INTERRUPT_ENDPOINT = 129;
        private static final int FLUSH_RX_REQUEST = 8;
        private static final int FLUSH_TX_REQUEST = 9;
        private static final int SET_LINE_REQUEST = 32;
        private static final int SET_CONTROL_REQUEST = 34;
        private static final int CONTROL_DTR = 1;
        private static final int CONTROL_RTS = 2;
        private static final int STATUS_FLAG_CD = 1;
        private static final int STATUS_FLAG_DSR = 2;
        private static final int STATUS_FLAG_RI = 8;
        private static final int STATUS_FLAG_CTS = 128;
        private static final int STATUS_BUFFER_SIZE = 10;
        private static final int STATUS_BYTE_IDX = 8;
        private static final int DEVICE_TYPE_HX = 0;
        private static final int DEVICE_TYPE_0 = 1;
        private static final int DEVICE_TYPE_1 = 2;
        private int mDeviceType;
        private UsbEndpoint mInterruptEndpoint;
        private int mControlLinesValue;
        private int mBaudRate;
        private int mDataBits;
        private int mStopBits;
        private int mParity;
        private int mStatus;
        private volatile Thread mReadStatusThread;
        private final Object mReadStatusThreadLock;
        boolean mStopReadStatusThread;
        private IOException mReadStatusException;

        public ProlificSerialPort(UsbDevice device, int portNumber) {
            super(device, portNumber);
            this.mDeviceType = 0;
            this.mControlLinesValue = 0;
            this.mBaudRate = -1;
            this.mDataBits = -1;
            this.mStopBits = -1;
            this.mParity = -1;
            this.mStatus = 0;
            this.mReadStatusThread = null;
            this.mReadStatusThreadLock = new Object();
            this.mStopReadStatusThread = false;
            this.mReadStatusException = null;
        }

        @Override
        public UsbSerialDriver getDriver() {
            return ProlificSerialDriver.this;
        }

        private final byte[] inControlTransfer(int requestType, int request, int value, int index, int length) throws IOException {
            byte[] buffer = new byte[length];
            int result = this.mConnection.controlTransfer(requestType, request, value, index, buffer, length, 1000);
            if (result != length) {
                throw new IOException(String.format("ControlTransfer with value 0x%x failed: %d", value, result));
            }
            return buffer;
        }

        private final void outControlTransfer(int requestType, int request, int value, int index, byte[] data) throws IOException {
            int length = data == null ? 0 : data.length;
            int result = this.mConnection.controlTransfer(requestType, request, value, index, data, length, 5000);
            if (result != length) {
                throw new IOException(String.format("ControlTransfer with value 0x%x failed: %d", value, result));
            }
        }

        private final byte[] vendorIn(int value, int index, int length) throws IOException {
            return this.inControlTransfer(192, 1, value, index, length);
        }

        private final void vendorOut(int value, int index, byte[] data) throws IOException {
            this.outControlTransfer(64, 1, value, index, data);
        }

        private void resetDevice() throws IOException {
            this.purgeHwBuffers(true, true);
        }

        private final void ctrlOut(int request, int value, int index, byte[] data) throws IOException {
            this.outControlTransfer(33, request, value, index, data);
        }

        private void doBlackMagic() throws IOException {
            this.vendorIn(33924, 0, 1);
            this.vendorOut(1028, 0, null);
            this.vendorIn(33924, 0, 1);
            this.vendorIn(33667, 0, 1);
            this.vendorIn(33924, 0, 1);
            this.vendorOut(1028, 1, null);
            this.vendorIn(33924, 0, 1);
            this.vendorIn(33667, 0, 1);
            this.vendorOut(0, 1, null);
            this.vendorOut(1, 0, null);
            this.vendorOut(2, this.mDeviceType == 0 ? 68 : 36, null);
        }

        private void setControlLines(int newControlLinesValue) throws IOException {
            this.ctrlOut(34, newControlLinesValue, 0, null);
            this.mControlLinesValue = newControlLinesValue;
        }

        private final void readStatusThreadFunction() {
            try {
                while (!this.mStopReadStatusThread) {
                    byte[] buffer = new byte[10];
                    int readBytesCount = this.mConnection.bulkTransfer(this.mInterruptEndpoint, buffer, 10, 500);
                    if (readBytesCount <= 0) continue;
                    if (readBytesCount == 10) {
                        this.mStatus = buffer[8] & 0xFF;
                        continue;
                    }
                    throw new IOException(String.format("Invalid CTS / DSR / CD / RI status buffer received, expected %d bytes, but received %d", 10, readBytesCount));
                }
            }
            catch (IOException e) {
                this.mReadStatusException = e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final int getStatus() throws IOException {
            if (this.mReadStatusThread == null && this.mReadStatusException == null) {
                Object object = this.mReadStatusThreadLock;
                synchronized (object) {
                    if (this.mReadStatusThread == null) {
                        byte[] buffer = new byte[10];
                        int readBytes = this.mConnection.bulkTransfer(this.mInterruptEndpoint, buffer, 10, 100);
                        if (readBytes != 10) {
                            Log.w((String)ProlificSerialDriver.this.TAG, (String)"Could not read initial CTS / DSR / CD / RI status");
                        } else {
                            this.mStatus = buffer[8] & 0xFF;
                        }
                        this.mReadStatusThread = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                ProlificSerialPort.this.readStatusThreadFunction();
                            }
                        });
                        this.mReadStatusThread.setDaemon(true);
                        this.mReadStatusThread.start();
                    }
                }
            }
            IOException readStatusException = this.mReadStatusException;
            if (this.mReadStatusException != null) {
                this.mReadStatusException = null;
                throw readStatusException;
            }
            return this.mStatus;
        }

        private final boolean testStatusFlag(int flag) throws IOException {
            return (this.getStatus() & flag) == flag;
        }

        @Override
        public void openInt(UsbDeviceConnection connection) throws IOException {
            UsbInterface usbInterface = this.mDevice.getInterface(0);
            if (!connection.claimInterface(usbInterface, true)) {
                throw new IOException("Error claiming Prolific interface 0");
            }
            block8: for (int i = 0; i < usbInterface.getEndpointCount(); ++i) {
                UsbEndpoint currentEndpoint = usbInterface.getEndpoint(i);
                switch (currentEndpoint.getAddress()) {
                    case 131: {
                        this.mReadEndpoint = currentEndpoint;
                        continue block8;
                    }
                    case 2: {
                        this.mWriteEndpoint = currentEndpoint;
                        continue block8;
                    }
                    case 129: {
                        this.mInterruptEndpoint = currentEndpoint;
                    }
                }
            }
            if (this.mDevice.getDeviceClass() == 2) {
                this.mDeviceType = 1;
            } else {
                try {
                    Method getRawDescriptorsMethod = this.mConnection.getClass().getMethod("getRawDescriptors", new Class[0]);
                    byte[] rawDescriptors = (byte[])getRawDescriptorsMethod.invoke((Object)this.mConnection, new Object[0]);
                    byte maxPacketSize0 = rawDescriptors[7];
                    if (maxPacketSize0 == 64) {
                        this.mDeviceType = 0;
                    } else if (this.mDevice.getDeviceClass() == 0 || this.mDevice.getDeviceClass() == 255) {
                        this.mDeviceType = 2;
                    } else {
                        Log.w((String)ProlificSerialDriver.this.TAG, (String)"Could not detect PL2303 subtype, Assuming that it is a HX device");
                        this.mDeviceType = 0;
                    }
                }
                catch (NoSuchMethodException e) {
                    Log.w((String)ProlificSerialDriver.this.TAG, (String)"Method UsbDeviceConnection.getRawDescriptors, required for PL2303 subtype detection, not available! Assuming that it is a HX device");
                    this.mDeviceType = 0;
                }
                catch (Exception e) {
                    Log.e((String)ProlificSerialDriver.this.TAG, (String)"An unexpected exception occured while trying to detect PL2303 subtype", (Throwable)e);
                }
            }
            this.setControlLines(this.mControlLinesValue);
            this.resetDevice();
            this.doBlackMagic();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void closeInt() {
            try {
                this.mStopReadStatusThread = true;
                Object object = this.mReadStatusThreadLock;
                synchronized (object) {
                    if (this.mReadStatusThread != null) {
                        try {
                            this.mReadStatusThread.join();
                        }
                        catch (Exception e) {
                            Log.w((String)ProlificSerialDriver.this.TAG, (String)"An error occured while waiting for status read thread", (Throwable)e);
                        }
                    }
                }
                this.resetDevice();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.mConnection.releaseInterface(this.mDevice.getInterface(0));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void setParameters(int baudRate, int dataBits, int stopBits, int parity) throws IOException {
            if (this.mBaudRate == baudRate && this.mDataBits == dataBits && this.mStopBits == stopBits && this.mParity == parity) {
                return;
            }
            byte[] lineRequestData = new byte[7];
            if (baudRate <= 0) {
                throw new IllegalArgumentException("Invalid baud rate: " + baudRate);
            }
            lineRequestData[0] = (byte)(baudRate & 0xFF);
            lineRequestData[1] = (byte)(baudRate >> 8 & 0xFF);
            lineRequestData[2] = (byte)(baudRate >> 16 & 0xFF);
            lineRequestData[3] = (byte)(baudRate >> 24 & 0xFF);
            switch (stopBits) {
                case 1: {
                    lineRequestData[4] = 0;
                    break;
                }
                case 3: {
                    lineRequestData[4] = 1;
                    break;
                }
                case 2: {
                    lineRequestData[4] = 2;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid stop bits: " + stopBits);
                }
            }
            switch (parity) {
                case 0: {
                    lineRequestData[5] = 0;
                    break;
                }
                case 1: {
                    lineRequestData[5] = 1;
                    break;
                }
                case 2: {
                    lineRequestData[5] = 2;
                    break;
                }
                case 3: {
                    lineRequestData[5] = 3;
                    break;
                }
                case 4: {
                    lineRequestData[5] = 4;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid parity: " + parity);
                }
            }
            if (dataBits < 5 || dataBits > 8) {
                throw new IllegalArgumentException("Invalid data bits: " + dataBits);
            }
            lineRequestData[6] = (byte)dataBits;
            this.ctrlOut(32, 0, 0, lineRequestData);
            this.resetDevice();
            this.mBaudRate = baudRate;
            this.mDataBits = dataBits;
            this.mStopBits = stopBits;
            this.mParity = parity;
        }

        @Override
        public boolean getCD() throws IOException {
            return this.testStatusFlag(1);
        }

        @Override
        public boolean getCTS() throws IOException {
            return this.testStatusFlag(128);
        }

        @Override
        public boolean getDSR() throws IOException {
            return this.testStatusFlag(2);
        }

        @Override
        public boolean getDTR() throws IOException {
            return (this.mControlLinesValue & 1) == 1;
        }

        @Override
        public void setDTR(boolean value) throws IOException {
            int newControlLinesValue = value ? this.mControlLinesValue | 1 : this.mControlLinesValue & 0xFFFFFFFE;
            this.setControlLines(newControlLinesValue);
        }

        @Override
        public boolean getRI() throws IOException {
            return this.testStatusFlag(8);
        }

        @Override
        public boolean getRTS() throws IOException {
            return (this.mControlLinesValue & 2) == 2;
        }

        @Override
        public void setRTS(boolean value) throws IOException {
            int newControlLinesValue = value ? this.mControlLinesValue | 2 : this.mControlLinesValue & 0xFFFFFFFD;
            this.setControlLines(newControlLinesValue);
        }

        @Override
        public boolean purgeHwBuffers(boolean purgeWriteBuffers, boolean purgeReadBuffers) throws IOException {
            if (purgeWriteBuffers) {
                this.vendorOut(8, 0, null);
            }
            if (purgeReadBuffers) {
                this.vendorOut(9, 0, null);
            }
            return true;
        }
    }
}

