/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.utils.usbserial.driver;

import android.util.Pair;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import org.tcshare.utils.usbserial.driver.UsbSerialDriver;

public class ProbeTable {
    private final Map<Pair<Integer, Integer>, Class<? extends UsbSerialDriver>> mProbeTable = new LinkedHashMap<Pair<Integer, Integer>, Class<? extends UsbSerialDriver>>();

    public ProbeTable addProduct(int vendorId, int productId, Class<? extends UsbSerialDriver> driverClass) {
        this.mProbeTable.put((Pair<Integer, Integer>)Pair.create((Object)vendorId, (Object)productId), driverClass);
        return this;
    }

    ProbeTable addDriver(Class<? extends UsbSerialDriver> driverClass) {
        Map devices;
        Method method;
        try {
            method = driverClass.getMethod("getSupportedDevices", new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
        try {
            devices = (Map)method.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        for (Map.Entry entry : devices.entrySet()) {
            int vendorId = (Integer)entry.getKey();
            for (int productId : (int[])entry.getValue()) {
                this.addProduct(vendorId, productId, driverClass);
            }
        }
        return this;
    }

    public Class<? extends UsbSerialDriver> findDriver(int vendorId, int productId) {
        Pair pair = Pair.create((Object)vendorId, (Object)productId);
        return this.mProbeTable.get(pair);
    }
}

