/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.utils.packet;

import android.util.Log;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;

public class PacketUtil {
    private final byte header;
    private final byte subHeader;
    private final byte tail;
    public int FIX_PRE_LEN = 5;
    public int FIX_SUF_LEN = 3;
    private final String TAG = PacketUtil.class.getSimpleName();
    private final LinkedList<Byte> revBytesCache = new LinkedList();
    private final int maxLen;

    public PacketUtil(byte header, byte subHeader, byte tail, int maxLen) {
        this.header = header;
        this.subHeader = subHeader;
        this.tail = tail;
        this.maxLen = maxLen;
    }

    public byte[] gen(byte type, byte[] content) {
        int totalLen = this.FIX_PRE_LEN + this.FIX_SUF_LEN + content.length;
        ByteBuffer payload = ByteBuffer.allocate(this.FIX_PRE_LEN + content.length);
        payload.put(this.header);
        payload.putShort((short)totalLen);
        payload.put(this.subHeader);
        payload.put(type);
        payload.put(content);
        byte[] crc16 = PacketUtil.cal(payload.array());
        ByteBuffer bb = ByteBuffer.allocate(totalLen);
        bb.put(payload.array());
        bb.put(crc16);
        bb.put(this.tail);
        return bb.array();
    }

    public ValidPacket validPayload(byte[] recvBytes) {
        try {
            if (recvBytes == null || recvBytes.length < this.FIX_PRE_LEN + this.FIX_SUF_LEN) {
                return new ValidPacket(false, -1, new byte[0]);
            }
            if (!this.validCRC(recvBytes)) {
                Log.e((String)this.TAG, (String)"\u6821\u9a8c\u548c\u9519\u8bef");
                return new ValidPacket(false, -1, new byte[0]);
            }
            byte type = recvBytes[4];
            byte[] payload = PacketUtil.subBytes(recvBytes, 5, recvBytes.length - this.FIX_PRE_LEN - this.FIX_SUF_LEN);
            return new ValidPacket(true, recvBytes[4], payload);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ValidPacket(false, -1, new byte[0]);
        }
    }

    public static byte[] subBytes(byte[] src, int begin, int count) {
        byte[] bs = new byte[count];
        System.arraycopy(src, begin, bs, 0, count);
        return bs;
    }

    private boolean validCRC(byte[] recvBytes) {
        byte[] prefix = new byte[recvBytes.length - this.FIX_SUF_LEN];
        System.arraycopy(recvBytes, 0, prefix, 0, recvBytes.length - this.FIX_SUF_LEN);
        byte[] crc = new byte[2];
        System.arraycopy(recvBytes, recvBytes.length - this.FIX_SUF_LEN, crc, 0, 2);
        return Arrays.equals(PacketUtil.cal(prefix), crc);
    }

    private static byte[] cal(byte[] bytes) {
        int CRC = 65535;
        int POLYNOMIAL = 40961;
        for (int i = 0; i < bytes.length; ++i) {
            CRC ^= bytes[i] & 0xFF;
            for (int j = 0; j < 8; ++j) {
                if ((CRC & 1) != 0) {
                    CRC >>= 1;
                    CRC ^= POLYNOMIAL;
                    continue;
                }
                CRC >>= 1;
            }
        }
        return new byte[]{(byte)(CRC >> 8 & 0xFF), (byte)CRC};
    }

    private int alignPacketStart() {
        Iterator it = this.revBytesCache.iterator();
        while (it.hasNext()) {
            Byte b = (Byte)it.next();
            if (b == this.header) {
                if (!it.hasNext()) continue;
                byte highByte = (Byte)it.next();
                if (!it.hasNext()) continue;
                byte lowByte = (Byte)it.next();
                int packetSize = highByte << 8 & 0xFF00 | lowByte & 0xFF;
                if (packetSize > this.maxLen || packetSize < this.FIX_PRE_LEN + this.FIX_SUF_LEN) {
                    return -1;
                }
                if (!it.hasNext()) continue;
                if ((Byte)it.next() == this.subHeader) {
                    return 1;
                }
                return this.alignPacketStart();
            }
            it.remove();
        }
        return 0;
    }

    public synchronized void preparePacket(byte[] bytes, PacketReadyCallBack cb) {
        for (byte b : bytes) {
            this.revBytesCache.add(b);
        }
        int ret = this.alignPacketStart();
        while (ret == -1) {
            this.revBytesCache.removeFirst();
            ret = this.alignPacketStart();
        }
        if (this.revBytesCache.size() < this.FIX_PRE_LEN + this.FIX_SUF_LEN) {
            return;
        }
        int packetSize = this.revBytesCache.get(1) << 8 & 0xFF00 | this.revBytesCache.get(2) & 0xFF;
        if (this.revBytesCache.size() < packetSize) {
            return;
        }
        byte[] packet = PacketUtil.toPrimitives(this.revBytesCache.subList(0, packetSize).toArray(new Byte[0]));
        if (this.validCRC(packet)) {
            cb.onPacketReady(packet);
        }
        for (int i = 0; i < packet.length; ++i) {
            this.revBytesCache.removeFirst();
        }
    }

    private static byte[] toPrimitives(Byte[] oBytes) {
        byte[] bytes = new byte[oBytes.length];
        for (int i = 0; i < oBytes.length; ++i) {
            bytes[i] = oBytes[i];
        }
        return bytes;
    }

    public synchronized void resetPacket() {
        this.revBytesCache.clear();
    }

    public static class ValidPacket {
        public boolean valid;
        public byte type;
        public byte[] payload;

        public ValidPacket(boolean valid, byte type, byte[] payload) {
            this.valid = valid;
            this.type = type;
            this.payload = payload;
        }
    }

    public static interface PacketReadyCallBack {
        public void onPacketReady(byte[] var1);
    }
}

