/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.utils.packet;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import org.tcshare.utils.packet.IPacket;
import org.tcshare.utils.packet.IPacketCallback;

public class PacketSimpleUtil
implements IPacket {
    private final byte header;
    private final byte tail;
    private static final int FIX_PRE_LEN = 3;
    private static final int FIX_SUF_LEN = 3;
    private static final int FIX_MIN_LEN = 6;
    private final String TAG = PacketSimpleUtil.class.getSimpleName();
    private final LinkedList<Byte> revBytesCache = new LinkedList();
    private final int maxLen;
    private int packetLenType = 0;

    public PacketSimpleUtil(byte header, byte tail, int maxLen, int packetLenType) {
        this.header = header;
        this.tail = tail;
        this.maxLen = maxLen;
        this.packetLenType = packetLenType;
    }

    public PacketSimpleUtil(byte header, byte tail, int maxLen) {
        this.header = header;
        this.tail = tail;
        this.maxLen = maxLen;
        this.packetLenType = 0;
    }

    @Override
    public byte[] gen(byte[] content) {
        int totalLen = 6 + content.length;
        ByteBuffer payload = ByteBuffer.allocate(3 + content.length);
        payload.put(this.header);
        if (this.packetLenType == 0) {
            payload.putShort((short)totalLen);
        } else if (this.packetLenType == 1) {
            payload.putShort((short)content.length);
        } else if (this.packetLenType == 2) {
            payload.putShort((short)(content.length + 3));
        }
        payload.put(content);
        byte[] crc16 = PacketSimpleUtil.cal(payload.array());
        ByteBuffer bb = ByteBuffer.allocate(totalLen);
        bb.put(payload.array());
        bb.put(crc16);
        bb.put(this.tail);
        return bb.array();
    }

    public static byte[] subBytes(byte[] src, int begin, int count) {
        byte[] bs = new byte[count];
        System.arraycopy(src, begin, bs, 0, count);
        return bs;
    }

    private boolean validCRC(byte[] recvBytes) {
        byte[] prefix = new byte[recvBytes.length - 3];
        System.arraycopy(recvBytes, 0, prefix, 0, recvBytes.length - 3);
        byte[] crc = new byte[2];
        System.arraycopy(recvBytes, recvBytes.length - 3, crc, 0, 2);
        return Arrays.equals(PacketSimpleUtil.cal(prefix), crc);
    }

    private static byte[] cal(byte[] bytes) {
        int CRC = 65535;
        int POLYNOMIAL = 40961;
        for (int i = 0; i < bytes.length; ++i) {
            CRC ^= bytes[i] & 0xFF;
            for (int j = 0; j < 8; ++j) {
                if ((CRC & 1) != 0) {
                    CRC >>= 1;
                    CRC ^= POLYNOMIAL;
                    continue;
                }
                CRC >>= 1;
            }
        }
        return new byte[]{(byte)(CRC >> 8 & 0xFF), (byte)CRC};
    }

    private int alignPacketStart() {
        Iterator it = this.revBytesCache.iterator();
        while (it.hasNext()) {
            Byte b = (Byte)it.next();
            if (b == this.header) {
                if (!it.hasNext()) continue;
                byte highByte = (Byte)it.next();
                if (!it.hasNext()) continue;
                byte lowByte = (Byte)it.next();
                int packetSize = highByte << 8 & 0xFF00 | lowByte & 0xFF;
                if (packetSize > this.maxLen || packetSize < 6) {
                    return -1;
                }
                return 1;
            }
            it.remove();
        }
        return 0;
    }

    @Override
    public synchronized void preparePacket(byte[] bytes, IPacketCallback cb) {
        for (byte b : bytes) {
            this.revBytesCache.add(b);
        }
        int ret = this.alignPacketStart();
        while (ret == -1) {
            this.revBytesCache.removeFirst();
            ret = this.alignPacketStart();
        }
        if (this.revBytesCache.size() < 6) {
            return;
        }
        int bytesSize = this.revBytesCache.get(1) << 8 & 0xFF00 | this.revBytesCache.get(2) & 0xFF;
        int packetSize = 0;
        if (this.packetLenType == 0) {
            packetSize = bytesSize;
        } else if (this.packetLenType == 1) {
            packetSize = 6 + bytesSize;
        } else if (this.packetLenType == 2) {
            packetSize = 3 + bytesSize;
        }
        if (this.revBytesCache.size() < packetSize) {
            return;
        }
        byte[] packet = PacketSimpleUtil.toPrimitives(this.revBytesCache.subList(0, packetSize).toArray(new Byte[0]));
        if (this.validCRC(packet)) {
            byte[] payload = PacketSimpleUtil.subBytes(packet, 3, packet.length - 6);
            cb.onPacketReady(payload);
        }
        for (int i = 0; i < packet.length; ++i) {
            this.revBytesCache.removeFirst();
        }
    }

    private static byte[] toPrimitives(Byte[] oBytes) {
        byte[] bytes = new byte[oBytes.length];
        for (int i = 0; i < oBytes.length; ++i) {
            bytes[i] = oBytes[i];
        }
        return bytes;
    }

    public synchronized void resetPacket() {
        this.revBytesCache.clear();
    }
}

