/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.utils.packet;

import android.util.Log;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import org.tcshare.utils.HexDump;
import org.tcshare.utils.packet.IPacket;
import org.tcshare.utils.packet.IPacketCallback;
import org.tcshare.utils.packet.PacketSimpleUtil;

public class PacketCommonUtil
implements IPacket {
    private boolean DEBUG = false;
    private final String TAG = PacketSimpleUtil.class.getSimpleName();
    protected final byte[] header;
    protected final byte[] tail;
    protected final int lenBytes;
    protected final int FIX_PRE_LEN;
    protected final int FIX_SUF_LEN;
    protected final int FIX_MIN_LEN;
    protected final int maxLen;
    private final LinkedList<Byte> revBytesCache = new LinkedList();
    private boolean bigEndian = true;
    protected int packetLenType = 0;

    public PacketCommonUtil(byte[] header, byte[] tail, int lenBytes, int maxLen, int packetLenType, boolean bigEndian) {
        this.header = header;
        this.tail = tail;
        this.lenBytes = lenBytes;
        this.maxLen = maxLen;
        this.packetLenType = packetLenType;
        this.FIX_PRE_LEN = header.length + lenBytes;
        this.FIX_SUF_LEN = tail.length;
        this.FIX_MIN_LEN = this.FIX_PRE_LEN + this.FIX_SUF_LEN;
        this.bigEndian = bigEndian;
    }

    public PacketCommonUtil(byte[] header, byte[] tail, int lenBytes, int maxLen, int packetLenType) {
        this(header, tail, lenBytes, maxLen, packetLenType, true);
    }

    @Override
    public byte[] gen(byte[] content) {
        int totalLen = this.FIX_MIN_LEN + content.length;
        ByteBuffer pkBB = ByteBuffer.allocate(totalLen);
        pkBB.put(this.header);
        if (this.packetLenType == 0) {
            pkBB.put(this.calcLenBytes(totalLen));
        } else if (this.packetLenType == 1) {
            pkBB.put(this.calcLenBytes(content.length));
        } else if (this.packetLenType == 2) {
            pkBB.put(this.calcLenBytes(content.length + this.FIX_SUF_LEN));
        } else if (this.packetLenType == 3) {
            pkBB.put(this.calcLenBytes(content.length + this.lenBytes));
        }
        pkBB.put(content);
        pkBB.put(this.tail);
        return pkBB.array();
    }

    private byte[] calcLenBytes(int len) {
        ByteBuffer bb = ByteBuffer.allocate(this.lenBytes).order(this.bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
        if (this.lenBytes == 1) {
            bb.put((byte)(len & 0xFF));
        } else if (this.lenBytes == 2) {
            bb.putShort((short)len);
        } else {
            bb.putInt(len);
        }
        return bb.array();
    }

    private int calcLen(byte[] bytes) {
        ByteBuffer bb = ByteBuffer.wrap(bytes).order(this.bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
        if (this.lenBytes == 1) {
            return bb.get();
        }
        if (this.lenBytes == 2) {
            return bb.getShort();
        }
        return bb.getInt();
    }

    public static byte[] subBytes(byte[] src, int begin, int count) {
        byte[] bs = new byte[count];
        System.arraycopy(src, begin, bs, 0, count);
        return bs;
    }

    private int alignPacketStart() {
        Iterator it = this.revBytesCache.iterator();
        if (this.revBytesCache.size() < this.FIX_MIN_LEN) {
            return 0;
        }
        byte[] tmpHeader = new byte[this.header.length];
        for (int i = 0; i < tmpHeader.length; ++i) {
            tmpHeader[i] = (Byte)it.next();
        }
        if (!Arrays.equals(tmpHeader, this.header)) {
            return -1;
        }
        byte[] lengthBytes = new byte[this.lenBytes];
        for (int i = 0; i < this.lenBytes; ++i) {
            lengthBytes[i] = (Byte)it.next();
        }
        int totalLen = this.getTotalLen(lengthBytes);
        if (totalLen > this.maxLen || totalLen < this.FIX_MIN_LEN) {
            return -1;
        }
        if (this.revBytesCache.size() >= totalLen) {
            return 1;
        }
        return 0;
    }

    private int getTotalLen(byte[] lengthBytes) {
        int packetSize = this.calcLen(lengthBytes);
        int totalLen = 0;
        if (this.packetLenType == 0) {
            totalLen = packetSize;
        } else if (this.packetLenType == 1) {
            totalLen = this.FIX_MIN_LEN + packetSize;
        } else if (this.packetLenType == 2) {
            totalLen = this.FIX_PRE_LEN + packetSize;
        } else if (this.packetLenType == 3) {
            totalLen = this.header.length + this.tail.length + packetSize;
        }
        return totalLen;
    }

    @Override
    public synchronized void preparePacket(byte[] bytes, IPacketCallback cb) {
        if (this.DEBUG) {
            Log.e((String)this.TAG, (String)("recv bytes:" + HexDump.dumpHexString(bytes)));
        }
        for (byte b : bytes) {
            this.revBytesCache.add(b);
        }
        int ret = this.alignPacketStart();
        while (ret == -1) {
            this.revBytesCache.removeFirst();
            ret = this.alignPacketStart();
        }
        if (ret != 1) {
            return;
        }
        byte[] lengthBytes = new byte[this.lenBytes];
        for (int i = 0; i < this.lenBytes; ++i) {
            lengthBytes[i] = this.revBytesCache.get(this.header.length + i);
        }
        int packetSize = this.getTotalLen(lengthBytes);
        byte[] packet = PacketCommonUtil.getPacketAndRemove(this.revBytesCache, packetSize);
        if (this.tail.length > 0) {
            byte[] tmpTail = PacketCommonUtil.subBytes(packet, packetSize - this.tail.length, this.tail.length);
            if (Arrays.equals(this.tail, tmpTail)) {
                byte[] payload = PacketCommonUtil.subBytes(packet, this.FIX_PRE_LEN, packet.length - this.FIX_MIN_LEN);
                cb.onPacketReady(payload);
            }
        } else {
            byte[] payload = PacketCommonUtil.subBytes(packet, this.FIX_PRE_LEN, packet.length - this.FIX_MIN_LEN);
            cb.onPacketReady(payload);
        }
    }

    private static byte[] getPacketAndRemove(LinkedList<Byte> revBytesCache, int packetSize) {
        byte[] ret = new byte[packetSize];
        for (int i = 0; i < packetSize; ++i) {
            Byte b = revBytesCache.pop();
            ret[i] = b;
        }
        return ret;
    }

    public synchronized void resetPacket() {
        this.revBytesCache.clear();
    }

    public boolean isDEBUG() {
        return this.DEBUG;
    }

    public void setDEBUG(boolean DEBUG) {
        this.DEBUG = DEBUG;
    }
}

