/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.utils.bluetooth;

import android.app.Activity;
import android.app.Dialog;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Color;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import org.tcshare.adapter.DevAdapter;
import org.tcshare.androidutils.R;
import org.tcshare.dialog.MsgDialogUtil;
import org.tcshare.utils.DensityUtil;
import org.tcshare.utils.ToastUtil;
import org.tcshare.widgets.ItemDecorations;

public class BTSearchDialog
extends Dialog {
    private static final String TAG = BTSearchDialog.class.getSimpleName();
    private final OnDevSelectListener listener;
    private final BluetoothAdapter bluetoothAdapter;
    private final Activity ctx;
    private final DevAdapter adapter = new DevAdapter();
    private final BroadcastReceiver receiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.bluetooth.device.action.FOUND".equals(action)) {
                BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                Log.e((String)TAG, (String)("\u53d1\u73b0\u8bbe\u5907:" + device.getName() + ":" + device.getAddress() + ":" + (device.getBondState() == 10 ? "\u672a\u914d\u5bf9" : "\u5176\u4ed6")));
                BTSearchDialog.this.adapter.addItem(device);
            }
        }
    };

    public BTSearchDialog(@NonNull Activity context, BluetoothAdapter bluetoothAdapter, OnDevSelectListener listener) {
        super((Context)context);
        this.ctx = context;
        this.bluetoothAdapter = bluetoothAdapter;
        this.listener = listener;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.dialog_bt_search_layout);
        RecyclerView mRecyclerView = (RecyclerView)this.findViewById(R.id.rvDevList);
        mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this.ctx));
        mRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)ItemDecorations.vertical((Context)this.ctx).typeColor(0, Color.parseColor((String)"#efefef"), DensityUtil.dp2px((Context)this.ctx, 1)).create());
        mRecyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
        this.adapter.setOnItemClickLitener((view, item) -> this.listener.onConnect(item));
        this.findViewById(R.id.btnClose).setOnClickListener(v -> {
            this.bluetoothAdapter.cancelDiscovery();
            this.dismiss();
        });
        this.findViewById(R.id.btnSearch).setOnClickListener(v -> this.startSearchDialog());
    }

    protected void onStart() {
        super.onStart();
        IntentFilter filter = new IntentFilter("android.bluetooth.device.action.FOUND");
        this.ctx.registerReceiver(this.receiver, filter);
    }

    protected void onStop() {
        this.ctx.unregisterReceiver(this.receiver);
        super.onStop();
    }

    public void show() {
        this.adapter.clear();
        super.show();
    }

    private void startSearchDialog() {
        this.adapter.clear();
        this.bluetoothAdapter.cancelDiscovery();
        boolean ret = this.bluetoothAdapter.startDiscovery();
        if (!ret) {
            MsgDialogUtil.showMsg((Context)this.ctx, "\u542f\u52a8\u641c\u7d22\u84dd\u7259\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u3010\u84dd\u7259\u53caGPS\u3011\u662f\u5426\u5df2\u7ecf\u5f00\u542f\uff0c\u5e76\u4e14\u6388\u4e88\u4e86\u8be5APP\u4f7f\u7528\u84dd\u7259\u53caGPS\u7684\u6743\u9650\uff01");
        } else {
            ToastUtil.showToastShort((Context)this.ctx, "\u6b63\u5728\u641c\u7d22\u84dd\u7259...");
        }
    }

    public static interface OnDevSelectListener {
        public void onConnect(BluetoothDevice var1);
    }
}

