/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.utils;

import android.app.DownloadManager;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.appcompat.app.AlertDialog;
import androidx.core.content.FileProvider;
import java.io.File;
import org.tcshare.androidutils.R;
import org.tcshare.permission.SettingHelper;
import org.tcshare.utils.ToastUtil;

public class UpdateUtil {
    private static final String TAG = UpdateUtil.class.getSimpleName();
    private final Context ctx;
    private final String downURL;
    private final String notifyTitle;
    private final String notifyDesc;
    private final String apkName;
    private File apkFile;
    private DownloadManager mDownloadManager;
    private long downloadId;
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            UpdateUtil.this.checkStatus();
        }
    };

    public UpdateUtil(Context ctx, String downURL, String apkName, @Nullable String notifyTitle, @Nullable String notifyDesc) {
        this.ctx = ctx;
        this.apkName = apkName;
        this.downURL = downURL;
        this.notifyTitle = notifyTitle;
        this.notifyDesc = notifyDesc;
    }

    public void update() {
        String packageName = "com.android.providers.downloads";
        int state = this.ctx.getPackageManager().getApplicationEnabledSetting("com.android.providers.downloads");
        if (state == 2 || state == 3 || state == 4) {
            AlertDialog.Builder builder = new AlertDialog.Builder(this.ctx).setTitle(R.string.info).setMessage(R.string.warn_download_manager_disable).setPositiveButton(R.string.ok, (dialog, which) -> {
                dialog.dismiss();
                try {
                    Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
                    intent.setData(Uri.parse((String)"package:com.android.providers.downloads"));
                    this.ctx.startActivity(intent);
                }
                catch (ActivityNotFoundException e) {
                    Intent intent = new Intent("android.settings.MANAGE_APPLICATIONS_SETTINGS");
                    this.ctx.startActivity(intent);
                }
            }).setNegativeButton(R.string.cancel, (dialog, which) -> dialog.dismiss());
            builder.create().show();
        } else {
            DownloadManager.Request request = new DownloadManager.Request(Uri.parse((String)this.downURL));
            request.setAllowedOverRoaming(true);
            request.setNotificationVisibility(1);
            request.setTitle((CharSequence)(TextUtils.isEmpty((CharSequence)this.notifyTitle) ? this.ctx.getString(R.string.download) : this.notifyTitle));
            request.setDescription((CharSequence)(TextUtils.isEmpty((CharSequence)this.notifyDesc) ? this.ctx.getString(R.string.downloading) : this.notifyDesc));
            request.setVisibleInDownloadsUi(true);
            this.apkFile = new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS), this.apkName);
            request.setDestinationInExternalPublicDir(Environment.DIRECTORY_DOWNLOADS, this.apkName);
            this.mDownloadManager = (DownloadManager)this.ctx.getSystemService("download");
            this.ctx.registerReceiver(this.mReceiver, new IntentFilter("android.intent.action.DOWNLOAD_COMPLETE"));
            this.downloadId = this.mDownloadManager.enqueue(request);
        }
    }

    private void checkStatus() {
        DownloadManager.Query query = new DownloadManager.Query();
        query.setFilterById(new long[]{this.downloadId});
        Cursor cursor = this.mDownloadManager.query(query);
        if (cursor.moveToFirst()) {
            int status = cursor.getInt(cursor.getColumnIndex("status"));
            switch (status) {
                case 4: {
                    Log.e((String)TAG, (String)"DownloadManager.STATUS_PAUSED");
                    break;
                }
                case 1: {
                    Log.e((String)TAG, (String)"DownloadManager.STATUS_PENDING");
                    break;
                }
                case 2: {
                    Log.e((String)TAG, (String)"DownloadManager.STATUS_RUNNING");
                    break;
                }
                case 8: {
                    if (Build.VERSION.SDK_INT >= 26 && !this.ctx.getPackageManager().canRequestPackageInstalls()) {
                        new AlertDialog.Builder(this.ctx).setTitle((CharSequence)"\u8bbe\u7f6e").setMessage((CharSequence)"\u8bf7\u6253\u5f00\u5141\u8bb8\u5f53\u524dAPP\u5b89\u88c5apk\u7684\u8bbe\u7f6e\uff0c\u5426\u5219\u65e0\u6cd5\u5b89\u88c5\uff0c\u662f\u5426\u53bb\u8bbe\u7f6e\uff1f").setPositiveButton((CharSequence)"\u53bb\u8bbe\u7f6e", (dialog, which) -> this.requestSettings()).setNegativeButton((CharSequence)"\u653e\u5f03\u5b89\u88c5", (dialog, which) -> dialog.dismiss()).show();
                        return;
                    }
                    this.installAPK();
                    break;
                }
                case 16: {
                    Log.e((String)TAG, (String)"DownloadManager.STATUS_FAILED");
                    ToastUtil.showToastShort(this.ctx, R.string.download_failed);
                }
            }
        }
        cursor.close();
    }

    @RequiresApi(api=26)
    private void requestSettings() {
        SettingHelper.request(this.ctx, "android.settings.MANAGE_UNKNOWN_APP_SOURCES", 5869, new SettingHelper.Callback(){

            @Override
            public void onResult(int requestCode, String action, int resultCode) {
                if (UpdateUtil.this.ctx.getPackageManager().canRequestPackageInstalls()) {
                    UpdateUtil.this.installAPK();
                } else {
                    new AlertDialog.Builder(UpdateUtil.this.ctx).setTitle((CharSequence)"\u8bbe\u7f6e").setMessage((CharSequence)"\u8bf7\u6253\u5f00\u5141\u8bb8\u5f53\u524dAPP\u5b89\u88c5apk\u6587\u4ef6\u7684\u8bbe\u7f6e\uff0c\u5426\u5219\u65e0\u6cd5\u5b89\u88c5\uff0c\u662f\u5426\u53bb\u8bbe\u7f6e\uff1f").setPositiveButton((CharSequence)"\u53bb\u8bbe\u7f6e", (dialog, which) -> UpdateUtil.this.requestSettings()).setNegativeButton((CharSequence)"\u653e\u5f03\u5b89\u88c5", (dialog, which) -> dialog.dismiss()).show();
                }
            }
        });
    }

    private void installAPK() {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setFlags(0x10000000);
        if (Build.VERSION.SDK_INT >= 24) {
            Uri apkUri = FileProvider.getUriForFile((Context)this.ctx, (String)(this.ctx.getPackageName() + ".provider"), (File)this.apkFile);
            intent.addFlags(1);
            intent.setDataAndType(apkUri, "application/vnd.android.package-archive");
        } else {
            intent.setDataAndType(Uri.fromFile((File)this.apkFile), "application/vnd.android.package-archive");
        }
        this.ctx.startActivity(intent);
    }
}

