/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.utils;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.view.View;
import com.google.android.material.bottomsheet.BottomSheetDialog;
import org.tcshare.activity.TCSelectOnePictureActivity;
import org.tcshare.permission.PermissionHelper;
import org.tcshare.utils.ToastUtil;
import org.tcshare.widgets.BottomListDialog;

public class SelectOnePicture {
    public static void doSelect(final Context ctx, final CallBack callBack) {
        PermissionHelper.request(ctx, new String[]{"android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.CAMERA"}, 9999, new PermissionHelper.Callback(){

            @Override
            public void onResult(int requestCode, String[] permissions, int[] grantResult) {
                for (int result : grantResult) {
                    if (0 == result) continue;
                    ToastUtil.showToastLong(ctx, "\u8bf7\u6388\u4e88\u9009\u62e9\u7167\u7247\u3001\u62cd\u7167\u7684\u6743\u9650");
                    return;
                }
                SelectOnePicture.showSelectPic(ctx, callBack);
            }
        });
    }

    private static void showSelectPic(final Context ctx, final CallBack callBack) {
        BottomListDialog.showSimpleDialog(ctx, new BottomListDialog.OnItemClickListener(){

            @Override
            public void onClick(View view, int pos, BottomSheetDialog dialog) {
                if (pos == 0 || pos == 1) {
                    Intent intent = new Intent();
                    intent.putExtra("result_receiver", (Parcelable)new ResultReceiver(new Handler()){

                        protected void onReceiveResult(int resultCode, Bundle resultData) {
                            super.onReceiveResult(resultCode, resultData);
                            String pic = resultData.getString("select_pic");
                            callBack.onResult(resultCode, pic);
                        }
                    });
                    intent.setFlags(65536);
                    intent.setClass(ctx, TCSelectOnePictureActivity.class);
                    intent.putExtra("action_type", pos);
                    ctx.startActivity(intent);
                }
                dialog.dismiss();
            }
        }, new String[][]{{"\u62cd\u7167", "\u4ece\u76f8\u518c\u9009\u62e9", "\u53d6\u6d88"}});
    }

    public static interface CallBack {
        public void onResult(int var1, String var2);
    }
}

