/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.utils;

import android.content.Context;
import android.media.AudioAttributes;
import android.media.SoundPool;

public class AudioPlayUtil {
    private static final int MAX_ALLOWED_MUSIC = 100;
    private final SoundPool soundPool;
    private static AudioPlayUtil instance;
    private int[] musicIDs = new int[0];

    private AudioPlayUtil() {
        AudioAttributes attr2 = new AudioAttributes.Builder().setUsage(14).setContentType(2).build();
        this.soundPool = new SoundPool.Builder().setAudioAttributes(attr2).setMaxStreams(100).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AudioPlayUtil getInstance() {
        Class<AudioPlayUtil> clazz = AudioPlayUtil.class;
        synchronized (AudioPlayUtil.class) {
            if (instance != null) return instance;
            Class<AudioPlayUtil> clazz2 = AudioPlayUtil.class;
            synchronized (AudioPlayUtil.class) {
                instance = new AudioPlayUtil();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return instance;
            }
        }
    }

    public void loadAudiosFromRes(Context context, int[] resIDs) {
        if (resIDs == null || resIDs.length > 100) {
            throw new IllegalArgumentException("\u6700\u5927\u5141\u8bb8 100\u6761\u97f3\u9891\u7f13\u5b58");
        }
        this.musicIDs = new int[resIDs.length];
        for (int i = 0; i < resIDs.length; ++i) {
            this.musicIDs[i] = this.soundPool.load(context, resIDs[i], 1);
        }
    }

    public int playOnce(int pos) {
        if (pos > this.musicIDs.length) {
            return -1;
        }
        this.soundPool.play(this.musicIDs[pos], 1.0f, 1.0f, 0, 0, 1.0f);
        return 1;
    }

    public int playOnceFist() {
        if (this.musicIDs.length < 1) {
            return -1;
        }
        this.soundPool.play(this.musicIDs[0], 1.0f, 1.0f, 0, 0, 1.0f);
        return 1;
    }

    public int play(int pos, int loop, int rate) {
        if (pos > this.musicIDs.length) {
            return -1;
        }
        this.soundPool.play(this.musicIDs[pos], 1.0f, 1.0f, 0, loop, (float)rate);
        return 1;
    }
}

