/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.permission;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.os.ResultReceiver;
import androidx.core.content.ContextCompat;
import java.util.Arrays;
import java.util.Observable;
import org.tcshare.activity.TCRequestPermissionActivity;

public class PermissionHelper
extends Observable {
    public static void request(Context ctx, String[] permissions, int requestCode, final Callback callback) {
        if (PermissionHelper.hasPermissions(ctx, permissions)) {
            int[] result = new int[permissions.length];
            Arrays.fill(result, 0);
            callback.onResult(requestCode, permissions, result);
        } else {
            Intent intent = new Intent();
            intent.putExtra("result_receiver", (Parcelable)new ResultReceiver(new Handler()){

                protected void onReceiveResult(int resultCode, Bundle resultData) {
                    super.onReceiveResult(resultCode, resultData);
                    int[] grantResult = resultData.getIntArray("grunt_result");
                    String[] permissions = resultData.getStringArray("permission_array");
                    callback.onResult(resultCode, permissions, grantResult);
                }
            });
            intent.putExtra("req_code", requestCode);
            intent.putExtra("permission_array", permissions);
            intent.setClass(ctx, TCRequestPermissionActivity.class);
            intent.setFlags(65536);
            ctx.startActivity(intent);
        }
    }

    public static boolean hasPermissions(Context context, String[] permissions) {
        boolean result = true;
        if (Build.VERSION.SDK_INT >= 23) {
            for (String permission2 : permissions) {
                if (ContextCompat.checkSelfPermission((Context)context, (String)permission2) == 0) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public static interface Callback {
        public void onResult(int var1, String[] var2, int[] var3);
    }
}

