/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.network;

import android.util.Log;
import com.google.gson.Gson;
import java.io.IOException;
import java.nio.charset.Charset;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;

public class HttpLogInterceptor
implements Interceptor {
    private static final String TAG = HttpLogInterceptor.class.getSimpleName();
    public boolean debug;

    public HttpLogInterceptor() {
        this(false);
    }

    public HttpLogInterceptor(boolean debug) {
        this.debug = debug;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request req = chain.request();
        Response res = chain.proceed(req);
        if (this.debug) {
            try {
                Log.d((String)TAG, (String)String.format("...\n\u8bf7\u6c42\u94fe\u63a5\uff1a%s\n\u8bf7\u6c42\u5934\uff1a%s\n\u8bf7\u6c42\u53c2\u6570\uff1a%s\n\u54cd\u5e94\u5934\uff1a%s\n\u8bf7\u6c42\u54cd\u5e94\uff1a%s", req.url(), new Gson().toJson((Object)req.headers()), this.getRequestInfo(req), new Gson().toJson((Object)res.headers()), this.getResponseInfo(res)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return res;
    }

    private String getRequestInfo(Request request) {
        String str = "";
        if (request == null) {
            return str;
        }
        RequestBody requestBody = request.body();
        if (requestBody == null) {
            return str;
        }
        try {
            Buffer bufferedSink = new Buffer();
            requestBody.writeTo((BufferedSink)bufferedSink);
            Charset charset = Charset.forName("utf-8");
            str = bufferedSink.readString(charset);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return str;
    }

    private String getResponseInfo(Response response) {
        String str = "";
        if (response == null || !response.isSuccessful()) {
            return str;
        }
        ResponseBody responseBody = response.body();
        long contentLength = responseBody.contentLength();
        BufferedSource source = responseBody.source();
        try {
            source.request(Long.MAX_VALUE);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Buffer buffer = source.buffer();
        Charset charset = Charset.forName("utf-8");
        if (contentLength != 0L) {
            str = buffer.clone().readString(charset);
        }
        return str;
    }
}

