/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.logview.logcatviewer.service;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.net.Uri;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.SparseBooleanArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.RadioGroup;
import android.widget.Toast;
import java.io.File;
import java.util.ArrayList;
import org.tcshare.androidutils.R;
import org.tcshare.logcatviewer.service.ILogcatViewerService;
import org.tcshare.logview.logcatviewer.service.LogcatViewerService;
import org.tcshare.logview.logcatviewer.ui.adapter.LogRecordsListAdapter;
import org.tcshare.logview.logcatviewer.ui.adapter.LogcatViewerListAdapter;
import org.tcshare.logview.standout.StandOutWindow;
import org.tcshare.logview.standout.constants.StandOutFlags;
import org.tcshare.logview.standout.ui.Window;

public class LogcatViewerFloatingView
extends StandOutWindow {
    private static final String LOG_TAG = "LogcatFloatingView";
    private ListView mListView;
    private LogcatViewerListAdapter mAdapter;
    private LinearLayout mMenuOptionLayout;
    private LinearLayout mFilterLayout;
    private RadioGroup mPriorityLevelRadioGroup;
    private ListView mRecordsListView;
    private LinearLayout mNormalBottombarLayout;
    private LinearLayout mRecordsBottombarLayout;
    private ILogcatViewerService mLogcatViewerService;
    private ServiceConnection mLogcatViewerServiceConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName className, IBinder service) {
            LogcatViewerFloatingView.this.mLogcatViewerService = ILogcatViewerService.Stub.asInterface(service);
            LogcatViewerService.setHandler(LogcatViewerFloatingView.this.mHandler);
            try {
                LogcatViewerFloatingView.this.mLogcatViewerService.restart();
            }
            catch (RemoteException e) {
                Log.e((String)LogcatViewerFloatingView.LOG_TAG, (String)"Could not start LogcatViewerService service");
            }
        }

        public void onServiceDisconnected(ComponentName className) {
            Log.i((String)LogcatViewerFloatingView.LOG_TAG, (String)"onServiceDisconnected has been called");
            LogcatViewerFloatingView.this.mLogcatViewerService = null;
        }
    };
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 2: {
                    Log.d((String)LogcatViewerFloatingView.LOG_TAG, (String)"Reading logs for logcat is failed.");
                    break;
                }
                case 1: {
                    Log.d((String)LogcatViewerFloatingView.LOG_TAG, (String)"Executing logcat command is failed.");
                    break;
                }
                case 3: {
                    LogcatViewerFloatingView.this.mAdapter.addLogEntry((String)msg.obj);
                    break;
                }
                default: {
                    super.handleMessage(msg);
                }
            }
        }
    };

    @Override
    public String getAppName() {
        return this.getString(this.getApplicationInfo().labelRes);
    }

    @Override
    public int getAppIcon() {
        return this.getApplicationInfo().icon;
    }

    @Override
    public void onCreate() {
        super.onCreate();
        this.bindService(new Intent((Context)this, LogcatViewerService.class), this.mLogcatViewerServiceConnection, 1);
    }

    @Override
    public void onDestroy() {
        try {
            if (this.mLogcatViewerService != null && this.mLogcatViewerService.isRecording()) {
                this.stopRecording();
            }
        }
        catch (RemoteException e) {
            Log.e((String)LOG_TAG, (String)"isRecording() failed");
        }
        this.unbindService(this.mLogcatViewerServiceConnection);
        super.onDestroy();
    }

    @Override
    public void createAndAttachView(int id2, FrameLayout frame) {
        LayoutInflater inflater = (LayoutInflater)this.getSystemService("layout_inflater");
        View rootView = inflater.inflate(R.layout.logview_main, (ViewGroup)frame, true);
        this.mMenuOptionLayout = (LinearLayout)rootView.findViewById(R.id.menuOptionsLayout);
        this.mFilterLayout = (LinearLayout)rootView.findViewById(R.id.filterLayout);
        this.mPriorityLevelRadioGroup = (RadioGroup)rootView.findViewById(R.id.rgPriorityLevels);
        this.mRecordsListView = (ListView)this.mMenuOptionLayout.findViewById(R.id.recordList);
        this.mRecordsListView.setChoiceMode(2);
        this.mNormalBottombarLayout = (LinearLayout)rootView.findViewById(R.id.normalbottombar);
        this.mRecordsBottombarLayout = (LinearLayout)rootView.findViewById(R.id.recordsbottombar);
        this.setupLogListView(rootView);
        this.setupBottomBarView(rootView);
        this.setupRecordListView();
        this.setupFilterTextView(rootView);
        this.setupPriorityLevelView();
    }

    @Override
    public StandOutWindow.StandOutLayoutParams getParams(int id2, Window window) {
        DisplayMetrics displayMetrics = this.getApplicationContext().getResources().getDisplayMetrics();
        return new StandOutWindow.StandOutLayoutParams(this, id2, displayMetrics.widthPixels * 5 / 6, displayMetrics.heightPixels / 2, Integer.MAX_VALUE, Integer.MAX_VALUE, 400, 300);
    }

    @Override
    public int getFlags(int id2) {
        return StandOutFlags.FLAG_DECORATION_SYSTEM | StandOutFlags.FLAG_BODY_MOVE_ENABLE | StandOutFlags.FLAG_WINDOW_HIDE_ENABLE | StandOutFlags.FLAG_WINDOW_BRING_TO_FRONT_ON_TAP | StandOutFlags.FLAG_WINDOW_EDGE_LIMITS_ENABLE | StandOutFlags.FLAG_WINDOW_PINCH_RESIZE_ENABLE;
    }

    @Override
    public String getPersistentNotificationMessage(int id2) {
        return "Show LogcatViewer floating view.";
    }

    @Override
    public Intent getPersistentNotificationIntent(int id2) {
        return StandOutWindow.getShowIntent((Context)this, LogcatViewerFloatingView.class, id2);
    }

    private void stopRecording() {
        try {
            this.mLogcatViewerService.stopRecording();
        }
        catch (RemoteException e) {
            Log.e((String)LOG_TAG, (String)"StopRecording:Trouble writing the log to a file");
        }
    }

    private void pauseLogging() {
        try {
            this.mLogcatViewerService.pause();
        }
        catch (RemoteException e) {
            Log.e((String)LOG_TAG, (String)"Pausing logcat failed");
        }
    }

    private void resumeLogging() {
        try {
            this.mLogcatViewerService.resume();
        }
        catch (RemoteException e) {
            Log.e((String)LOG_TAG, (String)"Resuming logcat failed");
        }
    }

    private void resetMenuOptionLayout() {
        this.mFilterLayout.setVisibility(8);
        this.mPriorityLevelRadioGroup.setVisibility(8);
        this.mRecordsListView.setVisibility(8);
        this.mMenuOptionLayout.setVisibility(8);
    }

    private void setupLogListView(View rootView) {
        this.mListView = (ListView)rootView.findViewById(R.id.list);
        this.mListView.setStackFromBottom(true);
        this.mListView.setTranscriptMode(1);
        this.mAdapter = new LogcatViewerListAdapter(this.getApplicationContext());
        this.mListView.setAdapter((ListAdapter)this.mAdapter);
    }

    private void setupBottomBarView(final View rootView) {
        rootView.findViewById(R.id.pause).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                LogcatViewerFloatingView.this.pauseLogging();
                view.setVisibility(8);
                rootView.findViewById(R.id.play).setVisibility(0);
            }
        });
        rootView.findViewById(R.id.play).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                LogcatViewerFloatingView.this.resumeLogging();
                view.setVisibility(8);
                rootView.findViewById(R.id.pause).setVisibility(0);
            }
        });
        rootView.findViewById(R.id.record).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                view.setVisibility(8);
                rootView.findViewById(R.id.recordOn).setVisibility(0);
                try {
                    String logFilename = "log_" + System.currentTimeMillis() + ".txt";
                    LogcatViewerFloatingView.this.mLogcatViewerService.startRecording(logFilename, LogcatViewerFloatingView.this.mAdapter.getLogFilterText());
                }
                catch (RemoteException e) {
                    Log.e((String)LogcatViewerFloatingView.LOG_TAG, (String)"StartRecording:Trouble writing the log to a file");
                }
            }
        });
        rootView.findViewById(R.id.recordOn).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                view.setVisibility(8);
                rootView.findViewById(R.id.record).setVisibility(0);
                try {
                    LogcatViewerFloatingView.this.mLogcatViewerService.stopRecording();
                }
                catch (RemoteException e) {
                    Log.e((String)LogcatViewerFloatingView.LOG_TAG, (String)"StopRecording:Trouble writing the log to a file");
                }
            }
        });
        rootView.findViewById(R.id.btnRecordList).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                int recordsViewVisibility = LogcatViewerFloatingView.this.mRecordsListView.getVisibility();
                LogcatViewerFloatingView.this.resetMenuOptionLayout();
                if (recordsViewVisibility == 8) {
                    if (LogcatViewerFloatingView.this.mRecordsListView.getAdapter() == null) {
                        LogcatViewerFloatingView.this.mRecordsListView.setAdapter((ListAdapter)new LogRecordsListAdapter(LogcatViewerFloatingView.this.getApplicationContext()));
                    } else {
                        ((LogRecordsListAdapter)LogcatViewerFloatingView.this.mRecordsListView.getAdapter()).notifyDataSetChanged();
                    }
                    if (!LogcatViewerFloatingView.this.mRecordsListView.getAdapter().isEmpty()) {
                        LogcatViewerFloatingView.this.mMenuOptionLayout.setVisibility(0);
                        LogcatViewerFloatingView.this.mRecordsListView.setVisibility(0);
                        LogcatViewerFloatingView.this.mNormalBottombarLayout.setVisibility(8);
                        LogcatViewerFloatingView.this.mRecordsBottombarLayout.setVisibility(0);
                    } else {
                        Toast.makeText((Context)LogcatViewerFloatingView.this.getApplicationContext(), (CharSequence)"Empty Logs directory! Save logs first.", (int)1).show();
                    }
                }
            }
        });
        rootView.findViewById(R.id.find).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                int filterLayoutVisibility = LogcatViewerFloatingView.this.mFilterLayout.getVisibility();
                LogcatViewerFloatingView.this.resetMenuOptionLayout();
                if (filterLayoutVisibility == 8) {
                    LogcatViewerFloatingView.this.mFilterLayout.setVisibility(0);
                    LogcatViewerFloatingView.this.mMenuOptionLayout.setVisibility(0);
                }
            }
        });
        rootView.findViewById(R.id.btnPriorityLevel).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                int priorityLevelRadioGroupVisibility = LogcatViewerFloatingView.this.mPriorityLevelRadioGroup.getVisibility();
                LogcatViewerFloatingView.this.resetMenuOptionLayout();
                if (priorityLevelRadioGroupVisibility == 8) {
                    LogcatViewerFloatingView.this.mPriorityLevelRadioGroup.setVisibility(0);
                    LogcatViewerFloatingView.this.mMenuOptionLayout.setVisibility(0);
                }
            }
        });
        rootView.findViewById(R.id.btnReset).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                LogcatViewerFloatingView.this.pauseLogging();
                LogcatViewerFloatingView.this.mAdapter.reset();
                LogcatViewerFloatingView.this.resumeLogging();
                LogcatViewerFloatingView.this.resetMenuOptionLayout();
            }
        });
    }

    private void setupRecordListView() {
        this.mRecordsListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                if (LogcatViewerFloatingView.this.mRecordsListView.getCheckedItemPositions().get(i, false)) {
                    view.setBackgroundColor(-3355444);
                } else {
                    view.setBackgroundColor(-1);
                }
            }
        });
        this.mRecordsBottombarLayout.findViewById(R.id.btnBack).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                int cnt = LogcatViewerFloatingView.this.mRecordsListView.getAdapter().getCount();
                for (int index = 0; index < cnt; ++index) {
                    LogcatViewerFloatingView.this.mRecordsListView.setItemChecked(index, false);
                    LogcatViewerFloatingView.this.getViewByPosition(index, LogcatViewerFloatingView.this.mRecordsListView).setBackgroundColor(-1);
                }
                LogcatViewerFloatingView.this.resetMenuOptionLayout();
                LogcatViewerFloatingView.this.mNormalBottombarLayout.setVisibility(0);
                LogcatViewerFloatingView.this.mRecordsBottombarLayout.setVisibility(8);
            }
        });
        this.mRecordsBottombarLayout.findViewById(R.id.btnSelectAll).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                boolean isSelectingAll = LogcatViewerFloatingView.this.mRecordsListView.getCheckedItemCount() != LogcatViewerFloatingView.this.mRecordsListView.getAdapter().getCount();
                int color = isSelectingAll ? -3355444 : -1;
                int cnt = LogcatViewerFloatingView.this.mRecordsListView.getAdapter().getCount();
                for (int index = 0; index < cnt; ++index) {
                    LogcatViewerFloatingView.this.mRecordsListView.setItemChecked(index, isSelectingAll);
                    LogcatViewerFloatingView.this.getViewByPosition(index, LogcatViewerFloatingView.this.mRecordsListView).setBackgroundColor(color);
                }
            }
        });
        this.mRecordsBottombarLayout.findViewById(R.id.btnDelete).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                LogcatViewerFloatingView.this.deleteRecordedLogFiles();
                if (LogcatViewerFloatingView.this.mRecordsListView.getCount() == 0) {
                    LogcatViewerFloatingView.this.resetMenuOptionLayout();
                    LogcatViewerFloatingView.this.mNormalBottombarLayout.setVisibility(0);
                    LogcatViewerFloatingView.this.mRecordsBottombarLayout.setVisibility(8);
                }
            }
        });
        this.mRecordsBottombarLayout.findViewById(R.id.btnShare).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                LogcatViewerFloatingView.this.shareRecordedLogFiles();
            }
        });
    }

    private void setupFilterTextView(final View rootView) {
        rootView.findViewById(R.id.btnLogFilter).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                String filterText = ((EditText)rootView.findViewById(R.id.etLogFilter)).getText().toString().trim();
                LogcatViewerFloatingView.this.resetMenuOptionLayout();
                LogcatViewerFloatingView.this.pauseLogging();
                LogcatViewerFloatingView.this.mAdapter.setLogFilterText(filterText);
                LogcatViewerFloatingView.this.resumeLogging();
            }
        });
    }

    private void setupPriorityLevelView() {
        this.mPriorityLevelRadioGroup.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener(){

            public void onCheckedChanged(RadioGroup radioGroup, int checkedId) {
                String priorityLevel = checkedId == R.id.radioDebug ? " D " : (checkedId == R.id.radioInfo ? " I " : (checkedId == R.id.radioWarning ? " W " : (checkedId == R.id.radioError ? " E " : "")));
                LogcatViewerFloatingView.this.mAdapter.setLogPriorityLevel(priorityLevel);
                LogcatViewerFloatingView.this.resetMenuOptionLayout();
            }
        });
    }

    private void shareRecordedLogFiles() {
        if (this.mRecordsListView.getCheckedItemCount() == 0) {
            Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"First select log entry!", (int)1).show();
            return;
        }
        Intent emailIntent = new Intent("android.intent.action.SEND_MULTIPLE");
        emailIntent.setData(Uri.parse((String)"mailto:"));
        emailIntent.putExtra("android.intent.extra.SUBJECT", "[" + this.getAppName() + "] Logcat Logs");
        emailIntent.setType("text/plain");
        emailIntent.putExtra("android.intent.extra.TEXT", "Please find attached logcat logs file.");
        SparseBooleanArray checkedItemPositions = this.mRecordsListView.getCheckedItemPositions();
        int cnt = checkedItemPositions.size();
        LogRecordsListAdapter logRecordsListAdapter = (LogRecordsListAdapter)this.mRecordsListView.getAdapter();
        ArrayList<Uri> uris = new ArrayList<Uri>();
        for (int index = 0; index < cnt; ++index) {
            if (!checkedItemPositions.valueAt(index)) continue;
            File file = (File)logRecordsListAdapter.getItem(checkedItemPositions.keyAt(index));
            uris.add(Uri.fromFile((File)file));
        }
        emailIntent.putParcelableArrayListExtra("android.intent.extra.STREAM", uris);
        emailIntent.addFlags(0x10000000);
        this.hide(0);
        this.startActivity(emailIntent);
    }

    private void deleteRecordedLogFiles() {
        if (this.mListView.getCheckedItemCount() == 0) {
            Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"First select log entry!", (int)1).show();
            return;
        }
        SparseBooleanArray checkedItemPositions = this.mRecordsListView.getCheckedItemPositions();
        int cnt = checkedItemPositions.size();
        LogRecordsListAdapter logRecordsListAdapter = (LogRecordsListAdapter)this.mRecordsListView.getAdapter();
        for (int index = 0; index < cnt; ++index) {
            File file;
            if (!checkedItemPositions.valueAt(index) || !(file = (File)logRecordsListAdapter.getItem(checkedItemPositions.keyAt(index))).delete()) continue;
            Toast.makeText((Context)this.getApplicationContext(), (CharSequence)("File " + file.getName() + " deleted!"), (int)0).show();
        }
        logRecordsListAdapter.notifyDataSetChanged();
    }

    private View getViewByPosition(int pos, ListView listView) {
        int firstListItemPosition = listView.getFirstVisiblePosition();
        int lastListItemPosition = firstListItemPosition + listView.getChildCount() - 1;
        if (pos < firstListItemPosition || pos > lastListItemPosition) {
            return listView.getAdapter().getView(pos, null, (ViewGroup)listView);
        }
        int childIndex = pos - firstListItemPosition;
        return listView.getChildAt(childIndex);
    }
}

